/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.log.handlers;

import com.sun.identity.log.LogManager;
import com.sun.identity.log.LogManagerUtil;
import com.sun.identity.log.LogRecord;
import com.sun.identity.log.spi.Debug;
import com.sun.identity.log.spi.ITimestampGenerator;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Formatter;
import java.util.logging.Handler;

public class DBFormatter
extends Formatter {
    private java.util.logging.LogManager lmanager = (LogManager)LogManagerUtil.getLogManager();
    private String[] allFields;
    private ITimestampGenerator secureTimestampGenerator;

    public DBFormatter() {
        String string = this.lmanager.getProperty("iplanet-am-logging-secure-timestamp-generator");
        try {
            Class<?> clazz = Class.forName(string);
            this.secureTimestampGenerator = (ITimestampGenerator)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            Debug.error("DBFormatter: TimeStamp Generator Class not found", classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            Debug.error("DBFormatter: Timestamp Generator Couldnot be Instantiated", instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            Debug.error("DBFormatter: Timestamp Generator Couldnot be Instantiated", illegalAccessException);
        }
    }

    public String getHead(Handler handler) {
        String string = this.lmanager.getProperty("iplanet-am-logging-allfields");
        if (Debug.messageEnabled()) {
            Debug.message("DBFormatter: Returned String from getHead is " + string);
        }
        return string;
    }

    public String getTail(Handler handler) {
        return "";
    }

    public String format(java.util.logging.LogRecord logRecord) {
        this.getAllFields();
        StringBuffer stringBuffer = new StringBuffer();
        Map map = ((LogRecord)logRecord).getLogInfoMap();
        Set set = this.getSelectedFieldSet();
        String string = "";
        if (this.secureTimestampGenerator != null) {
            string = this.secureTimestampGenerator.getTimestamp();
        }
        stringBuffer.append("'").append(string).append("', ");
        stringBuffer.append("'").append(this.formatMessage(logRecord)).append("', ");
        int n = this.allFields.length;
        int n2 = 2;
        while (n2 < n - 1) {
            if (map != null && set != null && set.contains(this.allFields[n2])) {
                stringBuffer.append("'").append(map.get(this.allFields[n2])).append("', ");
            } else {
                stringBuffer.append("'NULL'").append(", ");
            }
            ++n2;
        }
        if (set.contains(this.allFields[n - 1])) {
            stringBuffer.append("'").append(map.get(this.allFields[n - 1])).append("'");
        } else {
            stringBuffer.append("'Null'");
        }
        return stringBuffer.toString();
    }

    private void getAllFields() {
        String string = this.lmanager.getProperty("iplanet-am-logging-allfields");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        int n = stringTokenizer.countTokens();
        this.allFields = new String[n];
        n = 0;
        while (stringTokenizer.hasMoreElements()) {
            this.allFields[n++] = stringTokenizer.nextToken().trim();
        }
        String string2 = "";
        int n2 = 0;
        while (n2 < n) {
            string2 = string2 + this.allFields[n2] + "\t";
            ++n2;
        }
    }

    private Set getSelectedFieldSet() {
        HashSet<String> hashSet = new HashSet<String>();
        String string = this.lmanager.getProperty("iplanet-am-logging-logfields");
        StringTokenizer stringTokenizer = new StringTokenizer(string, ", ");
        String string2 = "";
        String string3 = "";
        while (stringTokenizer.hasMoreElements()) {
            string3 = stringTokenizer.nextToken();
            hashSet.add(string3);
            string2 = string2 + string3 + "\t";
        }
        return hashSet;
    }
}

