/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.um;

import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.um.AssignableDynamicGroup;
import com.sun.identity.um.Common;
import com.sun.identity.um.DynamicGroup;
import com.sun.identity.um.Organization;
import com.sun.identity.um.Role;
import com.sun.identity.um.SDKUtils;
import com.sun.identity.um.StaticGroup;
import com.sun.identity.um.StoreConnectionIF;
import com.sun.identity.um.StoreConnectionImpl;
import com.sun.identity.um.UMException;
import com.sun.identity.um.User;
import com.sun.identity.um.UserManagementService_Impl;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Enumeration;
import javax.xml.rpc.Stub;

public final class StoreConnection {
    private static StoreConnectionIF stub;
    private static final String SERVICE_NAME = "StoreConnectionIF";
    private SSOToken token;
    private String tokenString;
    private static boolean checkedForLocal;
    private static boolean isLocal;
    private boolean useLocal;

    public StoreConnection(SSOToken sSOToken) throws UMException {
        this.token = sSOToken;
        this.tokenString = this.token.getTokenID().toString();
        if (!checkedForLocal) {
            try {
                stub = (StoreConnectionIF)Common.getRemoteStub(SERVICE_NAME);
                stub.checkForLocal();
                if (StoreConnectionImpl.isLocal) {
                    isLocal = true;
                    SDKUtils.debug.warning("AMC(): Using local service");
                    stub = new StoreConnectionImpl();
                }
                checkedForLocal = true;
            }
            catch (Exception exception) {
                checkedForLocal = true;
                if (SDKUtils.debug.warningEnabled()) {
                    SDKUtils.debug.warning("StoreConnection()Exception", (Throwable)exception);
                }
                throw new UMException(exception.getMessage(), "1000");
            }
        }
    }

    public String getUserNamingAttribute() throws SSOException {
        try {
            return stub.getUserNamingAttribute(this.tokenString);
        }
        catch (RemoteException remoteException) {
            if (SDKUtils.debug.warningEnabled()) {
                SDKUtils.debug.warning("StoreConnection: RemoteException: " + remoteException);
            }
            return "uid";
        }
    }

    public String getGroupNamingAttribute() throws SSOException {
        try {
            return stub.getGroupNamingAttribute(this.tokenString);
        }
        catch (RemoteException remoteException) {
            if (SDKUtils.debug.warningEnabled()) {
                SDKUtils.debug.warning("StoreConnection: RemoteException: " + remoteException);
            }
            return "cn";
        }
    }

    public String getRoleNamingAttribute() throws SSOException {
        try {
            return stub.getRoleNamingAttribute(this.tokenString);
        }
        catch (RemoteException remoteException) {
            if (SDKUtils.debug.warningEnabled()) {
                SDKUtils.debug.warning("StoreConnection: RemoteException: " + remoteException);
            }
            return "cn";
        }
    }

    public String getFilteredRoleNamingAttribute() throws SSOException {
        try {
            return stub.getFilteredRoleNamingAttribute(this.tokenString);
        }
        catch (RemoteException remoteException) {
            if (SDKUtils.debug.warningEnabled()) {
                SDKUtils.debug.warning("StoreConnection: RemoteException: " + remoteException);
            }
            return "cn";
        }
    }

    public String getOrganizationNamingAttribute() throws SSOException {
        try {
            return stub.getOrganizationNamingAttribute(this.tokenString);
        }
        catch (RemoteException remoteException) {
            if (SDKUtils.debug.warningEnabled()) {
                SDKUtils.debug.warning("StoreConnection: RemoteException: " + remoteException);
            }
            return "o";
        }
    }

    public String getOrganizationalUnitNamingAttribute() throws SSOException {
        try {
            return stub.getOrganizationalUnitNamingAttribute(this.tokenString);
        }
        catch (RemoteException remoteException) {
            if (SDKUtils.debug.warningEnabled()) {
                SDKUtils.debug.warning("StoreConnection: RemoteException: " + remoteException);
            }
            return "ou";
        }
    }

    public User getUser(String string) throws UMException, SSOException {
        return new User(this.token, string);
    }

    public String getOrganizationDN(String string, String string2) throws UMException, SSOException {
        try {
            return stub.getOrganizationDN(this.tokenString, string, string2);
        }
        catch (RemoteException remoteException) {
            SDKUtils.debug.error("StoreConnection:getOrganizationDN", (Throwable)remoteException);
            throw new UMException(remoteException.getMessage(), "1000");
        }
    }

    public Organization getOrganization(String string) throws UMException {
        return new Organization(this.token, string);
    }

    public Role getRole(String string) throws UMException {
        return new Role(this.token, string);
    }

    public StaticGroup getStaticGroup(String string) throws UMException {
        return new StaticGroup(this.token, string);
    }

    public AssignableDynamicGroup getAssignableDynamicGroup(String string) throws UMException {
        return new AssignableDynamicGroup(this.token, string);
    }

    public DynamicGroup getDynamicGroup(String string) throws UMException {
        return new DynamicGroup(this.token, string);
    }

    private static StoreConnectionIF getRemoteStub() throws UMException {
        StoreConnectionIF storeConnectionIF;
        Exception exception;
        boolean bl;
        block8: {
            bl = false;
            exception = null;
            storeConnectionIF = null;
            try {
                Enumeration enumeration = WebtopNaming.getPlatformServerList().elements();
                while (enumeration.hasMoreElements() && !bl) {
                    URL uRL = new URL((String)enumeration.nextElement());
                    SDKUtils.debug.error("Getting serviceendpoint from: " + uRL.getProtocol() + " : " + uRL.getHost() + " : " + uRL.getPort());
                    storeConnectionIF = StoreConnection.getServiceEndPoint(uRL.getProtocol(), uRL.getHost(), Integer.toString(uRL.getPort()));
                    try {
                        storeConnectionIF.checkForLocal();
                        if (SDKUtils.debug.messageEnabled()) {
                            SDKUtils.debug.message("StoreConnection(): Using the remote URL: " + uRL.toString());
                        }
                        bl = true;
                        if (!SDKUtils.debug.warningEnabled()) continue;
                        SDKUtils.debug.warning("AMC:getRemoteStub: remote server being used: " + uRL.toString());
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                        if (!SDKUtils.debug.warningEnabled()) continue;
                        SDKUtils.debug.warning("AMC:getRemoteStub: server (" + uRL.toString() + ") error: ", (Throwable)exception2);
                    }
                }
            }
            catch (Exception exception3) {
                exception = exception3;
                if (!SDKUtils.debug.warningEnabled()) break block8;
                SDKUtils.debug.warning("AMC:getRemoteStub: generic error: ", (Throwable)exception3);
            }
        }
        if (!bl) {
            if (exception != null) {
                throw new UMException(exception.getMessage(), "1000");
            }
            throw new UMException("serverNotFound", "1000");
        }
        return storeConnectionIF;
    }

    private static StoreConnectionIF getServiceEndPoint(String string, String string2, String string3) throws Exception {
        URL uRL = WebtopNaming.getServiceURL((String)"umservice", (String)string, (String)string2, (String)string3);
        String string4 = uRL.toString() + SERVICE_NAME;
        SDKUtils.debug.error("URL: " + string4);
        if (SDKUtils.debug.messageEnabled()) {
            SDKUtils.debug.message("StoreConnection with URL: " + string4);
        }
        Stub stub = (Stub)new UserManagementService_Impl().getStoreConnectionIFPort();
        stub._setProperty("javax.xml.rpc.service.endpoint.address", (Object)string4);
        return (StoreConnectionIF)stub;
    }
}

