/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.Cache;
import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.sm.CachedSMSEntry;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.DNMapper;
import com.sun.identity.sm.PluginConfigImpl;
import com.sun.identity.sm.PluginSchemaImpl;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSEventListenerManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.SchemaType;
import com.sun.identity.sm.ServiceConfigImpl;
import com.sun.identity.sm.ServiceInstanceImpl;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchemaImpl;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

class ServiceConfigManagerImpl {
    private String serviceName;
    private String version;
    private ServiceSchemaManagerImpl ssm;
    private HashMap listenerObjects;
    private String orgNotificationSearchString;
    private String glbNotificationSearchString;
    private CachedSubEntries instances;
    private CachedSubEntries groups;
    Cache globalConfigs;
    Cache orgConfigs;
    private static Map configMgrImpls = new HashMap();
    private static final String configMgrMutex = "ConfigMgrMutex";
    private static Map userPrincipals = new HashMap();
    private static Debug debug = SMSEntry.debug;

    private ServiceConfigManagerImpl(String string, String string2) throws SMSException {
        this.serviceName = string;
        this.version = string2;
        String string3 = ServiceManager.getServiceNameDN(string, string2);
        this.ssm = ServiceSchemaManagerImpl.getInstance(string, string2);
        this.listenerObjects = new HashMap();
        SMSEventListenerManager.notifyAllNodeChanges(this);
        DN dN = new DN("ou=" + string2 + ",ou=" + string + "," + "ou=services");
        String string4 = dN.toRFCString().toLowerCase();
        this.orgNotificationSearchString = "ou=OrganizationConfig,".toLowerCase() + string4;
        this.glbNotificationSearchString = "ou=GlobalConfig,".toLowerCase() + string4;
        String string5 = "ou=Instances," + string3;
        this.instances = CachedSubEntries.getInstance(string5);
        string5 = "ou=GlobalConfig," + string3;
        this.groups = CachedSubEntries.getInstance(string5);
        if (SMSEntry.cacheSMSEntries) {
            this.globalConfigs = new Cache(1000);
            this.orgConfigs = new Cache(1000);
        }
    }

    ServiceSchemaManagerImpl getServiceSchemaManagerImpl() {
        return this.ssm;
    }

    String getName() {
        return this.serviceName;
    }

    String getVersion() {
        return this.version;
    }

    Set getInstanceNames() throws SMSException {
        return this.instances.getSubEntries();
    }

    Set getGroupNames() throws SMSException {
        return this.groups.getSubEntries();
    }

    ServiceInstanceImpl getInstance(SSOToken sSOToken, String string) throws SMSException, SSOException {
        return ServiceInstanceImpl.getInstance(sSOToken, this.serviceName, this.version, string);
    }

    ServiceConfigImpl getGlobalConfig(SSOToken sSOToken, String string) throws SMSException, SSOException {
        CharSequence charSequence;
        ServiceSchemaImpl serviceSchemaImpl = this.ssm.getSchema(SchemaType.GLOBAL);
        if (serviceSchemaImpl == null) {
            return null;
        }
        String string2 = string == null ? "default" : this.getInstance(sSOToken, string).getGroup();
        String string3 = null;
        ServiceConfigImpl serviceConfigImpl = null;
        if (SMSEntry.cacheSMSEntries && (serviceConfigImpl = (ServiceConfigImpl)this.globalConfigs.get((Object)(string3 = (charSequence = new StringBuffer(50)).append(sSOToken.getPrincipal().getName()).append(string2).toString().toLowerCase()))) != null) {
            return serviceConfigImpl;
        }
        charSequence = this.constructServiceConfigDN(string2, "ou=GlobalConfig,", null);
        serviceConfigImpl = ServiceConfigImpl.getInstance(sSOToken, this, serviceSchemaImpl, (String)charSequence, null, string2, "", true);
        if (SMSEntry.cacheSMSEntries) {
            this.globalConfigs.put((Object)string3, (Object)serviceConfigImpl);
        }
        return serviceConfigImpl;
    }

    ServiceConfigImpl getOrganizationConfig(SSOToken sSOToken, String string, String string2) throws SMSException, SSOException {
        CharSequence charSequence;
        ServiceSchemaImpl serviceSchemaImpl = this.ssm.getSchema(SchemaType.ORGANIZATION);
        if (serviceSchemaImpl == null) {
            return null;
        }
        String string3 = string2 == null ? "default" : this.getInstance(sSOToken, string2).getGroup();
        String string4 = null;
        ServiceConfigImpl serviceConfigImpl = null;
        if (SMSEntry.cacheSMSEntries && (serviceConfigImpl = (ServiceConfigImpl)this.orgConfigs.get((Object)(string4 = (charSequence = new StringBuffer(50)).append(sSOToken.getPrincipal().getName()).append(string3).append(DNMapper.orgNameToDN(string)).toString().toLowerCase()))) != null) {
            return serviceConfigImpl;
        }
        charSequence = this.constructServiceConfigDN(string3, "ou=OrganizationConfig,", string);
        serviceConfigImpl = ServiceConfigImpl.getInstance(sSOToken, this, serviceSchemaImpl, (String)charSequence, string, string3, "", false);
        if (serviceConfigImpl == null) {
            return null;
        }
        if (SMSEntry.cacheSMSEntries) {
            this.orgConfigs.put((Object)string4, (Object)serviceConfigImpl);
        }
        return serviceConfigImpl;
    }

    PluginConfigImpl getPluginConfig(SSOToken sSOToken, String string, String string2, String string3, String string4) throws SMSException, SSOException {
        PluginSchemaImpl pluginSchemaImpl = PluginSchemaImpl.getInstance(this.serviceName, this.version, string2, string3, string4);
        if (pluginSchemaImpl == null) {
            throw new SMSException("amSDK", "sms-invalid-plugin-schema-name", null);
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(string).append(",ou=").append(string2).append(",ou=").append(string3);
        String string5 = this.constructServiceConfigDN(stringBuffer.toString(), "ou=PluginConfig,", string4);
        return PluginConfigImpl.getInstance(sSOToken, pluginSchemaImpl, string5, string4);
    }

    synchronized String addListener(ServiceListener serviceListener) {
        String string = SMSUtils.getUniqueID();
        this.listenerObjects.put(string, serviceListener);
        return string;
    }

    synchronized void removeListener(String string) {
        this.listenerObjects.remove(string);
    }

    boolean containsGroup(String string) throws SMSException {
        return this.groups.contains(string);
    }

    void entryChanged(String string, int n) {
        if (this.listenerObjects.size() == 0) {
            return;
        }
        boolean bl = true;
        int n2 = 0;
        int n3 = this.glbNotificationSearchString.length();
        n2 = string.indexOf(this.orgNotificationSearchString);
        if (n2 != -1) {
            bl = false;
            n3 = this.orgNotificationSearchString.length();
        } else {
            n2 = string.indexOf(this.glbNotificationSearchString);
            if (n2 == -1) {
                return;
            }
        }
        String[] stringArray = new DN(string.substring(0, n2 - 1)).explodeDN(true);
        String string2 = stringArray[stringArray.length - 1];
        String string3 = "";
        int n4 = stringArray.length - 2;
        while (n4 > -1) {
            string3 = string3 + "/" + stringArray[n4];
            --n4;
        }
        if (string3.equals("")) {
            string3 = "/";
        }
        String string4 = string.substring(n2 + n3 + 1);
        if (bl) {
            this.notifyGlobalConfigChange(string2, string3, n);
        } else {
            this.notifyOrgConfigChange(string4, string2, string3, n);
        }
    }

    void notifyGlobalConfigChange(String string, String string2, int n) {
        HashMap hashMap = (HashMap)this.listenerObjects.clone();
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            ServiceListener serviceListener = (ServiceListener)iterator.next();
            serviceListener.globalConfigChanged(this.serviceName, this.version, string, string2, n);
        }
    }

    void notifyOrgConfigChange(String string, String string2, String string3, int n) {
        HashMap hashMap = (HashMap)this.listenerObjects.clone();
        Iterator iterator = hashMap.values().iterator();
        while (iterator.hasNext()) {
            ServiceListener serviceListener = (ServiceListener)iterator.next();
            serviceListener.organizationConfigChanged(this.serviceName, this.version, string, string2, string3, n);
        }
    }

    String constructServiceConfigDN(String string, String string2, String string3) throws SMSException {
        StringBuffer stringBuffer = new StringBuffer(50);
        stringBuffer.append("ou=").append(string).append(",").append(string2).append("ou=").append(this.version).append(",").append("ou=").append(this.serviceName).append(",").append("ou=services").append(",");
        if (string3 == null || string3.equals("")) {
            string3 = SMSEntry.baseDN;
        } else if (!DN.isDN(string3)) {
            if (string3.startsWith("/")) {
                string3 = DNMapper.orgNameToDN(string3);
            } else {
                Object[] objectArray = new String[]{string3};
                throw new SMSException("amSDK", "sms-invalid-org-name", objectArray);
            }
        }
        stringBuffer.append(string3);
        return stringBuffer.toString();
    }

    protected static ServiceConfigManagerImpl getInstance(SSOToken sSOToken, String string, String string2) throws SSOException, SMSException {
        Principal principal;
        String string3;
        ServiceConfigManagerImpl serviceConfigManagerImpl;
        if (debug.messageEnabled()) {
            debug.message("ServiceConfigMgrImpl::getInstance: called: " + string + "(" + string2 + ")");
        }
        if ((serviceConfigManagerImpl = ServiceConfigManagerImpl.getFromCache(string3 = ServiceManager.getCacheIndex(string, string2), string, string2, principal = sSOToken.getPrincipal())) != null) {
            return serviceConfigManagerImpl;
        }
        String string4 = configMgrMutex;
        synchronized (string4) {
            serviceConfigManagerImpl = ServiceConfigManagerImpl.getFromCache(string3, string, string2, principal);
            if (serviceConfigManagerImpl == null) {
                ServiceConfigManagerImpl.checkAndUpdatePermission(string3, string, string2, principal);
                serviceConfigManagerImpl = new ServiceConfigManagerImpl(string, string2);
                HashMap<String, ServiceConfigManagerImpl> hashMap = new HashMap<String, ServiceConfigManagerImpl>(configMgrImpls);
                hashMap.put(string3, serviceConfigManagerImpl);
                configMgrImpls = hashMap;
            }
        }
        if (debug.messageEnabled()) {
            debug.message("ServiceConfigMgrImpl::getInstance: success: " + string + "(" + string2 + ")");
        }
        return serviceConfigManagerImpl;
    }

    static ServiceConfigManagerImpl getFromCache(String string, String string2, String string3, Principal principal) throws SMSException, SSOException {
        Set set;
        ServiceConfigManagerImpl serviceConfigManagerImpl = (ServiceConfigManagerImpl)configMgrImpls.get(string);
        if (serviceConfigManagerImpl != null && !(set = (Set)userPrincipals.get(string)).contains(principal.getName())) {
            ServiceConfigManagerImpl.checkAndUpdatePermission(string, string2, string3, principal);
        }
        return serviceConfigManagerImpl;
    }

    static synchronized void checkAndUpdatePermission(String string, String string2, String string3, Principal principal) throws SMSException, SSOException {
        String string4 = ServiceManager.getServiceNameDN(string2, string3);
        CachedSMSEntry cachedSMSEntry = CachedSMSEntry.getInstance(principal, string4, null);
        HashSet<String> hashSet = (HashSet<String>)userPrincipals.get(string);
        hashSet = hashSet == null ? new HashSet<String>() : new HashSet(hashSet);
        hashSet.add(principal.getName());
        HashMap<String, HashSet<String>> hashMap = new HashMap<String, HashSet<String>>(userPrincipals);
        hashMap.put(string, hashSet);
        userPrincipals = hashMap;
    }
}

