/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.services.ldap.event.DSEvent;
import com.iplanet.services.ldap.event.IDSEventListener;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.providers.dpro.SSOProviderBundle;
import com.sun.identity.authentication.internal.AuthContext;
import com.sun.identity.authentication.internal.AuthPrincipal;
import com.sun.identity.security.ServerInstanceAction;
import com.sun.identity.sm.CachedSubEntries;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSUtils;
import com.sun.identity.sm.ServiceConfigManagerImpl;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

public class SMSEventListenerManager
implements IDSEventListener {
    protected static ServerInstance serInstance;
    protected static String listenerID;
    protected static Principal principal;
    protected static HashMap notificationObjects;
    protected static HashMap allChanges;
    protected static HashMap nodeChanges;
    protected static HashMap subNodeChanges;
    protected int OPERATIONS = 15;
    protected String SEARCH_FILTER = "(|(objectclass=sunService)(objectclass=sunServiceComponent))";

    public void entryChanged(DSEvent dSEvent) {
        int n = dSEvent.getEventType();
        String string = new DN(dSEvent.getID()).toRFCString().toLowerCase();
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("SMSEventListener::entry changed for: " + string + " sending object changed notifications");
        }
        SMSEventListenerManager.sendNotifications((Set)nodeChanges.get(string), null, n);
        if (n == 1 || n == 2) {
            if (SMSEntry.debug.messageEnabled()) {
                SMSEntry.debug.message("SMSEventListener::entry changed for: " + string + " sending notifications to its parents");
            }
            SMSEventListenerManager.sendNotifications((Set)subNodeChanges.get(new DN(string).getParent().toRFCString().toLowerCase()), dSEvent.getID(), n);
        }
        SMSEventListenerManager.sendAllChangesNotification(string, dSEvent.getEventType());
    }

    public void eventError(String string) {
        SMSEntry.debug.error("SMSEventListener.eventError(): " + string);
    }

    public String getBase() {
        return serInstance.getBaseDN();
    }

    public String getFilter() {
        return this.SEARCH_FILTER;
    }

    public int getOperations() {
        return this.OPERATIONS;
    }

    public int getScope() {
        return 2;
    }

    protected static String notifyAllNodeChanges(ServiceConfigManagerImpl serviceConfigManagerImpl) {
        String string = SMSUtils.getUniqueID();
        allChanges.put(string, serviceConfigManagerImpl);
        return string;
    }

    protected static String notifyChangesToNode(String string, Method method, Object object, Object[] objectArray) {
        return SMSEventListenerManager.addNotificationObject(nodeChanges, string, method, object, objectArray);
    }

    protected static String notifyChangesToSubNodes(String string, Method method, Object object, Object[] objectArray) {
        return SMSEventListenerManager.addNotificationObject(subNodeChanges, string, method, object, objectArray);
    }

    protected static void removeNotification(String string) {
        NotificationObject notificationObject = (NotificationObject)notificationObjects.get(string);
        if (notificationObject != null) {
            notificationObject.set.remove(notificationObject);
        }
        allChanges.remove(string);
    }

    private static String addNotificationObject(Map map, String string, Method method, Object object, Object[] objectArray) {
        String string2 = new DN(string).toRFCString().toLowerCase();
        HashSet<NotificationObject> hashSet = (HashSet<NotificationObject>)map.get(string2);
        if (hashSet == null) {
            hashSet = new HashSet<NotificationObject>();
            map.put(string2, hashSet);
        }
        NotificationObject notificationObject = new NotificationObject(method, object, objectArray, hashSet);
        hashSet.add(notificationObject);
        notificationObjects.put(notificationObject.getID(), notificationObject);
        return notificationObject.getID();
    }

    private static void sendAllChangesNotification(String string, int n) {
        Iterator iterator = allChanges.values().iterator();
        while (iterator.hasNext()) {
            ServiceConfigManagerImpl serviceConfigManagerImpl = (ServiceConfigManagerImpl)iterator.next();
            serviceConfigManagerImpl.entryChanged(string, n);
        }
    }

    private static void sendNotifications(Set set, String string, int n) {
        if (set == null || set.isEmpty()) {
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            try {
                NotificationObject notificationObject = (NotificationObject)iterator.next();
                if (string != null && notificationObject.object instanceof CachedSubEntries) {
                    CachedSubEntries cachedSubEntries = (CachedSubEntries)notificationObject.object;
                    if (n == 1) {
                        cachedSubEntries.add(new DN(string).explodeDN(true)[0]);
                        continue;
                    }
                    cachedSubEntries.remove(new DN(string).explodeDN(true)[0]);
                    continue;
                }
                notificationObject.method.invoke(notificationObject.object, notificationObject.args);
            }
            catch (Exception exception) {
                SMSEntry.debug.error("SMSEvent notification: Unable to send notification: ", (Throwable)exception);
            }
        }
    }

    protected static SSOToken getSSOToken() throws SSOException {
        try {
            DSConfigMgr dSConfigMgr = DSConfigMgr.getDSConfigMgr();
            serInstance = dSConfigMgr.getServerInstance(LDAPUser.Type.AUTH_ADMIN);
            AuthPrincipal authPrincipal = new AuthPrincipal(serInstance.getAuthID());
            String string = (String)AccessController.doPrivileged(new ServerInstanceAction(serInstance));
            AuthContext authContext = new AuthContext(authPrincipal, string.toCharArray());
            return authContext.getSSOToken();
        }
        catch (Exception exception) {
            throw new SSOException(SSOProviderBundle.rbName, "invalidadmin", null);
        }
    }

    static {
        notificationObjects = new HashMap();
        allChanges = new HashMap();
        nodeChanges = new HashMap();
        subNodeChanges = new HashMap();
        try {
            SSOToken sSOToken = SMSEventListenerManager.getSSOToken();
            principal = sSOToken.getPrincipal();
        }
        catch (Exception exception) {
            SMSEntry.debug.error("Unable to intialize admin token: " + exception);
        }
    }

    private static class NotificationObject {
        String id;
        Method method;
        Object object;
        Object[] args;
        Set set;

        NotificationObject(Method method, Object object, Object[] objectArray, Set set) {
            this.method = method;
            this.object = object;
            this.args = objectArray;
            this.set = set;
        }

        String getID() {
            if (this.id == null) {
                this.id = SMSUtils.getUniqueID();
            }
            return this.id;
        }

        public boolean equals(Object object) {
            if (object instanceof NotificationObject) {
                NotificationObject notificationObject = (NotificationObject)object;
                if (this.id == notificationObject.id) {
                    return true;
                }
            }
            return false;
        }
    }
}

