/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.am.util.AMResourceBundleCache;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.OrderedSet;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.ums.DataLayer;
import com.sun.identity.sm.SMSEventListenerManager;
import com.sun.identity.sm.SMSException;
import java.security.Principal;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Set;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPCompareAttrNames;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPModificationSet;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.DN;

public class SMSEntry
implements Cloneable {
    protected static DataLayer dlayer;
    protected static ResourceBundle bundle;
    protected static Debug debug;
    protected static boolean cacheSMSEntries;
    protected static SMSException initializationException;
    protected static String baseDN;
    protected static int connNumRetry;
    protected static int connRetryInterval;
    protected static HashSet retryErrorCodes;
    private String dn;
    private LDAPAttributeSet attrSet;
    private LDAPModificationSet modSet;
    private Principal principal;
    boolean readOnly;
    boolean newEntry;
    protected static final int ADD = 0;
    protected static final int REPLACE = 2;
    protected static final int DELETE = 1;
    protected static final String PLACEHOLDER_RDN = "ou";
    protected static final String ORGANIZATION_RDN = "o";
    protected static final String DC_RDN = "dc";
    static final String SERVICES_NODE = "services";
    static final String SERVICES_RDN = "ou=services";
    static final String COMMA = ",";
    static final String EQUALS = "=";
    static final int ORG_UNIT_OBJECT = 1;
    static final int SERVICE_OBJECT = 2;
    static final int SERVICE_COMP_OBJECT = 3;
    protected static final String ATTR_SCHEMA = "sunServiceSchema";
    protected static final String ATTR_PLUGIN_SCHEMA = "sunPluginSchema";
    protected static final String ATTR_KEYVAL = "sunKeyValue";
    protected static final String ATTR_OBJECTCLASS = "objectclass";
    protected static final String ATTR_PRIORITY = "sunsmspriority";
    protected static final String ATTR_SERVICE_ID = "sunserviceID";
    protected static final String ATTR_LABELED_URI = "labeleduri";
    protected static final String[] SMS_ATTRIBUTES;
    protected static final String OC_TOP = "top";
    protected static final String OC_ORG_UNIT = "organizationalunit";
    protected static final String OC_SERVICE = "sunService";
    protected static final String OC_SERVICE_COMP = "sunServiceComponent";
    protected static final String FILTER_PATTERN_ALL = "(&(objectclass=top)(ou={0}))";
    protected static final String FILTER_PATTERN_SERVICE = "(&(objectclass=sunService)(ou={0})(ou={1}))";
    protected static final String FILTER_SERVICE_COMPONENTS = "(|(objectclass=sunService)(objectclass=sunServiceComponent))";

    SMSEntry(Principal principal, String string) throws SMSException {
        if (initializationException != null) {
            throw initializationException;
        }
        this.principal = principal;
        this.dn = string;
        this.read();
        if (debug.messageEnabled()) {
            debug.message("SMSEntry: Constructed entry for dn: " + string);
        }
    }

    SMSEntry(Principal principal, String string, LDAPAttributeSet lDAPAttributeSet) {
        this.principal = principal;
        this.dn = string;
        if (lDAPAttributeSet != null) {
            this.attrSet = (LDAPAttributeSet)lDAPAttributeSet.clone();
        }
        if (debug.messageEnabled()) {
            debug.message("SMSEntry: Init entry for dn with attrset: " + string);
        }
    }

    String[] getAttributeValues(String string) {
        if (!cacheSMSEntries) {
            try {
                this.read();
            }
            catch (SMSException sMSException) {
                debug.error("SMSEntry: Error in reading attrs: " + sMSException);
            }
        }
        LDAPAttribute lDAPAttribute = this.attrSet == null ? null : this.attrSet.getAttribute(string);
        return lDAPAttribute == null ? null : lDAPAttribute.getStringValueArray();
    }

    void addAttribute(String string, String string2) throws SMSException {
        if (this.attrSet == null) {
            this.attrSet = new LDAPAttributeSet();
        } else if (this.containsAttrValue(string, string2)) {
            if (debug.messageEnabled()) {
                debug.message("SMSEntry: Duplicate value for addition");
            }
            throw new SMSException(new LDAPException(bundle.getString("sms-ATTR_OR_VAL_EXISTS"), 20));
        }
        if (this.modSet == null) {
            this.modSet = new LDAPModificationSet();
        }
        this.modSet.add(0, new LDAPAttribute(string, string2));
        LDAPAttribute lDAPAttribute = this.attrSet.getAttribute(string);
        if (lDAPAttribute == null) {
            lDAPAttribute = new LDAPAttribute(string, string2);
        } else {
            lDAPAttribute.addValue(string2);
            this.attrSet.remove(string);
        }
        this.attrSet.add(lDAPAttribute);
    }

    void setAttribute(String string, String[] stringArray) {
        LDAPAttribute lDAPAttribute = stringArray == null ? new LDAPAttribute(string) : new LDAPAttribute(string, stringArray);
        this.attrSet = this.attrSet == null ? new LDAPAttributeSet() : this.attrSet;
        this.modSet = this.modSet == null ? new LDAPModificationSet() : this.modSet;
        LDAPAttribute lDAPAttribute2 = null;
        lDAPAttribute2 = this.attrSet.getAttribute(string);
        if (lDAPAttribute2 == null) {
            this.attrSet.add(lDAPAttribute);
            this.modSet.add(0, lDAPAttribute);
        } else {
            this.attrSet.remove(string);
            this.attrSet.add(lDAPAttribute);
            this.modSet.add(2, lDAPAttribute);
        }
    }

    void removeAttribute(String string, String string2) throws SMSException {
        LDAPAttribute lDAPAttribute = null;
        if (this.attrSet == null || (lDAPAttribute = this.attrSet.getAttribute(string)) == null || !this.containsAttrValue(string, string2)) {
            throw new SMSException(new LDAPException(bundle.getString("sms-ATTR_OR_VAL_EXISTS"), 20));
        }
        lDAPAttribute.removeValue(string2);
        this.attrSet.remove(string);
        this.attrSet.add(lDAPAttribute);
        if (this.modSet == null) {
            this.modSet = new LDAPModificationSet();
        }
        this.modSet.add(1, new LDAPAttribute(string, string2));
    }

    void removeAttribute(String string) throws SMSException {
        LDAPAttribute lDAPAttribute = this.attrSet.getAttribute(string);
        if (lDAPAttribute == null) {
            throw new SMSException(new LDAPException(bundle.getString("sms-ATTR_OR_VAL_EXISTS"), 20));
        }
        this.attrSet.remove(string);
        if (this.modSet == null) {
            this.modSet = new LDAPModificationSet();
        }
        this.modSet.add(1, lDAPAttribute);
    }

    boolean containsAttrValue(String string, String string2) {
        LDAPAttribute lDAPAttribute = this.attrSet.getAttribute(string);
        if (lDAPAttribute != null) {
            String[] stringArray = lDAPAttribute.getStringValueArray();
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equalsIgnoreCase(string2)) {
                    return true;
                }
                ++n;
            }
        }
        return false;
    }

    void read() throws SMSException {
        if (this.dn == null || this.dn.length() == 0 || !DN.isDN(this.dn)) {
            debug.error("SMSEntry: Invalid DN=" + this.dn);
            throw new SMSException(new LDAPException(bundle.getString("sms-INVALID_DN") + this.dn, 32));
        }
        LDAPConnection lDAPConnection = this.getConnection();
        try {
            try {
                LDAPEntry lDAPEntry = null;
                int n = 0;
                while (n <= connNumRetry) {
                    if (debug.messageEnabled()) {
                        debug.message("SMSEntry.read() retry: " + n);
                    }
                    try {
                        lDAPEntry = lDAPConnection.read(this.dn, SMS_ATTRIBUTES);
                        break;
                    }
                    catch (LDAPException lDAPException) {
                        if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n == connNumRetry) {
                            throw lDAPException;
                        }
                        ++n;
                        try {
                            Thread.currentThread();
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (lDAPEntry == null) {
                    if (debug.warningEnabled()) {
                        debug.warning("SMSEntry: insufficient access rights to access DN=" + this.dn);
                    }
                    throw new SMSException("amSDK", "sms-INSUFFICIENT_ACCESS_RIGHTS", null);
                }
                this.attrSet = lDAPEntry.getAttributeSet();
                if (debug.messageEnabled()) {
                    debug.message("SMSEntry: reading entry: " + this.dn);
                }
                this.newEntry = false;
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 32) {
                    this.newEntry = true;
                    this.attrSet = null;
                    this.modSet = null;
                    if (debug.messageEnabled()) {
                        debug.message("SMSEntry: entry not present (marked as new): " + this.dn);
                    }
                } else {
                    if (debug.warningEnabled()) {
                        debug.warning("SMSEntry: Error in accessing entry DN: " + this.dn, (Throwable)lDAPException);
                    }
                    throw new SMSException(lDAPException);
                }
                Object var7_8 = null;
                dlayer.releaseConnection(lDAPConnection);
            }
            Object var7_7 = null;
            dlayer.releaseConnection(lDAPConnection);
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            dlayer.releaseConnection(lDAPConnection);
            throw throwable;
        }
    }

    void save() throws SMSException {
        if (this.readOnly) {
            if (debug.warningEnabled()) {
                debug.warning("SMSEntry: Attempted to save an entry that is marked as read-only: " + this.dn);
            }
            throw new SMSException(SMSException.STATUS_NO_PERMISSION);
        }
        this.save(this.principal);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void save(Principal principal) throws SMSException {
        if (debug.messageEnabled()) {
            debug.message("Saving SMS entry for dn: " + this.dn);
        }
        if (this.attrSet == null || this.attrSet.size() == 0) {
            if (debug.warningEnabled()) {
                debug.warning("SMSEntry: Cannot save an entry that has null attribute values: " + this.dn);
            }
            throw new SMSException(new LDAPException(bundle.getString("sms-NO_ATTRIBUTE_IN_ENTRY") + this.dn + 65));
        }
        LDAPConnection lDAPConnection = this.getConnection(principal);
        try {
            try {
                int n = 0;
                while (n <= connNumRetry) {
                    if (debug.messageEnabled()) {
                        debug.message("SMSEntry.save() retry: " + n);
                    }
                    try {
                        if (this.newEntry) {
                            lDAPConnection.add(new LDAPEntry(this.dn, this.attrSet));
                            this.newEntry = false;
                            break;
                        }
                        if (this.modSet != null) {
                            lDAPConnection.modify(this.dn, this.modSet);
                            break;
                        }
                        if (debug.warningEnabled()) {
                            debug.warning("SMSEntry: Cannot save an entry that has no modifications to attributes: " + this.dn);
                        }
                        break;
                    }
                    catch (LDAPException lDAPException) {
                        if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n == connNumRetry) {
                            throw lDAPException;
                        }
                        ++n;
                        try {
                            Thread.currentThread();
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (LDAPException lDAPException) {
                debug.error("SMSEntry::save() Error in saving entry: " + this.dn + "\nBy Principal: " + principal.getName(), (Throwable)lDAPException);
                throw new SMSException(lDAPException);
            }
            Object var7_7 = null;
            dlayer.releaseConnection(lDAPConnection);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            dlayer.releaseConnection(lDAPConnection);
            throw throwable;
        }
        this.modSet = null;
        if (debug.messageEnabled()) {
            debug.message("SMSEntry: Successfully saved entry: " + this.dn);
        }
    }

    void delete() throws SMSException {
        if (this.readOnly) {
            if (debug.warningEnabled()) {
                debug.warning("SMSEntry: Cannot delete an entry that is marked as read only: " + this.dn);
            }
            throw new SMSException(SMSException.STATUS_NO_PERMISSION);
        }
        this.delete(this.principal);
    }

    /*
     * Unable to fully structure code
     */
    void delete(Principal var1_1) throws SMSException {
        if (this.newEntry) {
            if (SMSEntry.debug.messageEnabled()) {
                SMSEntry.debug.message("SMSEntry: Trying to delete a new entry: " + this.dn);
            }
            this.attrSet = null;
            this.modSet = null;
            return;
        }
        var2_2 = this.subEntries("*", 0, false, false).iterator();
        while (var2_2.hasNext()) {
            var3_3 = (SMSEntry)var2_2.next();
            if (SMSEntry.debug.messageEnabled()) {
                SMSEntry.debug.message("SMSEntry: deleting sub-entry: " + var3_3.dn);
            }
            var3_3.delete(var1_1);
        }
        var3_3 = this.getConnection(var1_1);
        try {
            try {
                var4_4 = 0;
                while (var4_4 <= SMSEntry.connNumRetry) {
                    if (SMSEntry.debug.messageEnabled()) {
                        SMSEntry.debug.message("SMSEntry.delete() retry: " + var4_4);
                    }
                    try {
                        var3_3.delete(this.dn);
                        ** break;
                    }
                    catch (LDAPException var5_6) {
                        if (!SMSEntry.retryErrorCodes.contains("" + var5_6.getLDAPResultCode()) || var4_4 == SMSEntry.connNumRetry) {
                            throw var5_6;
                        }
                        ++var4_4;
                        try {
                            Thread.currentThread();
                            Thread.sleep(SMSEntry.connRetryInterval);
                        }
                        catch (InterruptedException var6_7) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (LDAPException var4_5) {
                if (SMSEntry.debug.warningEnabled()) {
                    SMSEntry.debug.warning("SMSEntry: Unable to delete entry: " + this.dn, (Throwable)var4_5);
                }
                throw new SMSException(var4_5);
            }
lbl40:
            // 2 sources

            var8_8 = null;
            SMSEntry.dlayer.releaseConnection((LDAPConnection)var3_3);
        }
        catch (Throwable var7_10) {
            var8_9 = null;
            SMSEntry.dlayer.releaseConnection((LDAPConnection)var3_3);
            throw var7_10;
        }
        this.attrSet = null;
        this.modSet = null;
        this.newEntry = true;
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("SMSEntry: Successfully deleted entry: " + this.dn);
        }
    }

    Set subEntries(String string, int n, boolean bl, boolean bl2) throws SMSException {
        LDAPCompareAttrNames lDAPCompareAttrNames;
        if (debug.messageEnabled()) {
            debug.message("SMSEntry: Searching for sub-entries: " + this.dn);
        }
        if (this.newEntry) {
            this.read();
        }
        if (this.newEntry) {
            if (debug.messageEnabled()) {
                debug.message("SMSEntry::subEntries --> new entry: " + this.dn);
            }
            return Collections.EMPTY_SET;
        }
        Object[] objectArray = new String[]{string};
        String string2 = MessageFormat.format(FILTER_PATTERN_ALL, objectArray);
        LDAPConnection lDAPConnection = this.getConnection();
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        lDAPSearchConstraints.setMaxResults(n);
        lDAPSearchConstraints.setServerTimeLimit(0);
        LDAPSearchResults lDAPSearchResults = null;
        try {
            block21: {
                try {
                    int n2 = 0;
                    while (n2 <= connNumRetry) {
                        if (debug.messageEnabled()) {
                            debug.message("SMSEntry.subEntries() retry: " + n2);
                        }
                        try {
                            lDAPSearchResults = lDAPConnection.search(this.dn, 1, string2, SMS_ATTRIBUTES, false, lDAPSearchConstraints);
                            break;
                        }
                        catch (LDAPException lDAPException) {
                            if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n2 == connNumRetry) {
                                throw lDAPException;
                            }
                            ++n2;
                            try {
                                Thread.currentThread();
                                Thread.sleep(connRetryInterval);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    if (!bl) break block21;
                    lDAPCompareAttrNames = new LDAPCompareAttrNames(PLACEHOLDER_RDN, bl2);
                    lDAPSearchResults.sort(lDAPCompareAttrNames);
                }
                catch (LDAPException lDAPException) {
                    if (debug.warningEnabled()) {
                        debug.warning("SMSEntry: Unable to search for sub-entries: " + this.dn, (Throwable)lDAPException);
                    }
                    throw new SMSException(lDAPException);
                }
            }
            Object var14_18 = null;
            dlayer.releaseConnection(lDAPConnection);
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            dlayer.releaseConnection(lDAPConnection);
            throw throwable;
        }
        lDAPCompareAttrNames = new OrderedSet();
        while (lDAPSearchResults.hasMoreElements()) {
            LDAPEntry lDAPEntry;
            try {
                lDAPEntry = lDAPSearchResults.next();
            }
            catch (LDAPException lDAPException) {
                if (debug.warningEnabled()) {
                    debug.warning("SMSEntry: Error in obtaining sub-entries: " + this.dn, (Throwable)lDAPException);
                }
                throw new SMSException(lDAPException);
            }
            SMSEntry sMSEntry = new SMSEntry(this.principal, lDAPEntry.getDN(), lDAPEntry.getAttributeSet());
            lDAPCompareAttrNames.add(sMSEntry);
        }
        if (debug.messageEnabled()) {
            debug.message("SMSEntry: Successfully obtained sub-entries for : " + this.dn);
        }
        return lDAPCompareAttrNames;
    }

    protected String getDN() {
        return this.dn;
    }

    protected Principal getPrincipal() {
        return this.principal;
    }

    protected void setPrincipal(Principal principal) {
        this.principal = principal;
    }

    protected void setReadOnly() {
        this.readOnly = true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DN\t\t: " + this.dn + "\n");
        if (this.newEntry) {
            stringBuffer.append("\t(NEW Entry)");
        }
        stringBuffer.append("Attribute Set\t: " + this.attrSet + "\n");
        stringBuffer.append("Modifcation Set\t: " + this.modSet + "\n");
        return stringBuffer.toString();
    }

    private LDAPConnection getConnection() throws SMSException {
        return this.getConnection(this.principal);
    }

    private LDAPConnection getConnection(Principal principal) throws SMSException {
        LDAPConnection lDAPConnection = dlayer.getConnection(principal);
        if (lDAPConnection == null) {
            debug.error("SMSEntry: Unable to get connection to LDAP server for the principal: " + principal + " and dn: " + this.dn);
            throw new SMSException(new LDAPException(bundle.getString("sms-SERVER_DOWN")));
        }
        return lDAPConnection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static LDAPSearchResults search(String string) throws SMSException {
        if (debug.messageEnabled()) {
            debug.message("SMSEntry: search filter: " + string);
        }
        LDAPConnection lDAPConnection = null;
        LDAPSearchResults lDAPSearchResults = null;
        try {
            try {
                lDAPConnection = dlayer.getConnection(SMSEventListenerManager.principal);
                LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
                lDAPSearchConstraints.setMaxResults(0);
                lDAPSearchConstraints.setServerTimeLimit(0);
                int n = 0;
                while (n <= connNumRetry) {
                    if (debug.messageEnabled()) {
                        debug.message("SMSEntry.search() retry: " + n);
                    }
                    try {
                        lDAPSearchResults = lDAPConnection.search(baseDN, 2, string, null, false, lDAPSearchConstraints);
                        break;
                    }
                    catch (LDAPException lDAPException) {
                        if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n == connNumRetry) {
                            throw lDAPException;
                        }
                        ++n;
                        try {
                            Thread.currentThread();
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (LDAPException lDAPException) {
                throw new SMSException(lDAPException);
            }
            Object var8_8 = null;
            if (lDAPConnection != null) {
                dlayer.releaseConnection(lDAPConnection);
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (lDAPConnection != null) {
                dlayer.releaseConnection(lDAPConnection);
            }
            throw throwable;
        }
        if (debug.messageEnabled()) {
            debug.message("SMSEntry::search returned successfully: " + string);
        }
        return lDAPSearchResults;
    }

    public Object clone() {
        SMSEntry sMSEntry = null;
        try {
            sMSEntry = (SMSEntry)super.clone();
            sMSEntry.principal = this.principal;
            sMSEntry.dn = this.dn;
            if (this.attrSet != null) {
                sMSEntry.attrSet = (LDAPAttributeSet)this.attrSet.clone();
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            sMSEntry = new SMSEntry(this.principal, this.dn, this.attrSet);
        }
        sMSEntry.newEntry = this.newEntry;
        sMSEntry.readOnly = this.readOnly;
        if (debug.messageEnabled()) {
            debug.message("SMSEntry clones: " + this.dn);
        }
        return sMSEntry;
    }

    void refresh(SMSEntry sMSEntry) {
        this.attrSet = sMSEntry.attrSet != null ? (LDAPAttributeSet)sMSEntry.attrSet.clone() : null;
        this.newEntry = sMSEntry.newEntry;
    }

    public static boolean checkIfEntryExists(String string, Principal principal) {
        if (debug.messageEnabled()) {
            debug.message("SMSEntry: checking if entry exists: " + string);
        }
        try {
            SMSEntry sMSEntry = new SMSEntry(principal, string);
            return !sMSEntry.newEntry;
        }
        catch (SMSException sMSException) {
            if (debug.warningEnabled()) {
                debug.warning("SMSEntry: exception while checking for entry: " + string);
            }
            return false;
        }
    }

    static {
        connNumRetry = 3;
        connRetryInterval = 1000;
        retryErrorCodes = new HashSet();
        debug = Debug.getInstance((String)"amSDK");
        AMResourceBundleCache aMResourceBundleCache = AMResourceBundleCache.getInstance();
        bundle = aMResourceBundleCache.getResBundle("amSDK", Locale.ENGLISH);
        try {
            ServerInstance serverInstance = null;
            DSConfigMgr dSConfigMgr = DSConfigMgr.getDSConfigMgr();
            if (dSConfigMgr != null) {
                serverInstance = dSConfigMgr.getServerInstance(LDAPUser.Type.AUTH_PROXY);
            }
            if (serverInstance != null) {
                dlayer = DataLayer.getInstance(serverInstance);
                baseDN = serverInstance.getBaseDN();
            }
            if (dSConfigMgr == null || serverInstance == null || dlayer == null) {
                debug.error("SMSEntry: Unable to initialize");
                initializationException = new SMSException("amSDK", "ums-configmanagererror", null);
            }
            debug.message("SMSEntry: Initialized successfully");
            String string = System.getProperty("com.iplanet.am.sdk.caching.enabled");
            if (string == null) {
                string = SystemProperties.get((String)"com.iplanet.am.sdk.caching.enabled");
            }
            if (string == null || string.equalsIgnoreCase("true")) {
                cacheSMSEntries = true;
            }
            debug.message("SMSEntry: cache enabled: " + cacheSMSEntries);
            connNumRetry = DataLayer.getConnNumRetry();
            connRetryInterval = DataLayer.getConnRetryInterval();
            retryErrorCodes = DataLayer.getRetryErrorCodes();
        }
        catch (Exception exception) {
            debug.error("SMSEntry: Unable to initalize(exception):", (Throwable)exception);
            initializationException = new SMSException("amSDK", "ums-configmanagererror", null);
        }
        SMS_ATTRIBUTES = new String[]{PLACEHOLDER_RDN, ATTR_SCHEMA, ATTR_PLUGIN_SCHEMA, ATTR_KEYVAL, ATTR_OBJECTCLASS, ATTR_PRIORITY, ATTR_SERVICE_ID, ATTR_LABELED_URI};
    }
}

