/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.sm;

import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.sm.SMSEntry;
import com.sun.identity.sm.SMSEventListenerManager;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.ServiceManager;
import com.sun.identity.sm.ServiceSchemaManagerImpl;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import netscape.ldap.util.DN;

class CachedSMSEntry {
    private static final String cachedSMSEntriesMutex = "CachedSMSEntriesMutex";
    protected static final String UPDATE_NOTIFY_METHOD = "updateAndNotifyListeners";
    protected static final String UPDATE_METHOD = "update";
    protected static Map smsEntries = new HashMap(1000);
    protected Set serviceObjects;
    protected Set principals;
    protected DN dn;
    protected SMSEntry smsEntry;
    protected String notificationID;

    private CachedSMSEntry(SMSEntry sMSEntry) {
        this.smsEntry = sMSEntry;
        this.dn = new DN(sMSEntry.getDN());
        this.serviceObjects = new HashSet();
        this.principals = new HashSet();
        this.principals.add(sMSEntry.getPrincipal());
        this.smsEntry.setPrincipal(SMSEventListenerManager.principal);
        this.smsEntry.setReadOnly();
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry: create new instance: " + this.dn);
        }
    }

    void update() {
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry: update method called: " + this.dn);
        }
        try {
            this.smsEntry.read();
            this.updateServiceListeners(UPDATE_NOTIFY_METHOD);
        }
        catch (SMSException sMSException) {
            SMSEntry.debug.error("Error in reading entry attributes: " + this.dn, (Throwable)sMSException);
        }
    }

    void updateServiceListeners(String string) {
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry::updateServiceListeners method called: " + this.dn);
        }
        Iterator iterator = this.serviceObjects.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            try {
                Method method = e.getClass().getDeclaredMethod(string, null);
                method.invoke(e, null);
            }
            catch (Exception exception) {
                SMSEntry.debug.error("CachedSMSEntry::unable to deliver notification(" + this.dn + ")", (Throwable)exception);
            }
        }
    }

    void addServiceListener(Object object) {
        if (this.serviceObjects.isEmpty()) {
            try {
                Class<?> clazz = Class.forName("com.sun.identity.sm.CachedSMSEntry");
                this.notificationID = SMSEventListenerManager.notifyChangesToNode(this.smsEntry.getDN(), clazz.getDeclaredMethod(UPDATE_METHOD, null), this, null);
            }
            catch (Exception exception) {
                SMSEntry.debug.error("CachedSMSEntry::unable to register service objects for notifications: ", (Throwable)exception);
            }
        }
        this.serviceObjects.add(object);
    }

    protected void removeServiceListener(Object object) {
        this.serviceObjects.remove(object);
        if (this.serviceObjects.isEmpty()) {
            SMSEventListenerManager.removeNotification(this.notificationID);
        }
    }

    synchronized void addPrincipal(Principal principal) {
        HashSet<String> hashSet = new HashSet<String>(this.principals);
        hashSet.add(principal.getName());
        this.principals = hashSet;
    }

    boolean checkPrincipal(Principal principal) {
        return this.principals.contains(principal.getName());
    }

    SMSEntry getSMSEntry() {
        return (SMSEntry)this.smsEntry.clone();
    }

    boolean isNewEntry() {
        return this.smsEntry.newEntry;
    }

    String getDN() {
        return this.dn.toString();
    }

    void refresh(SMSEntry sMSEntry) throws SMSException {
        this.smsEntry.refresh(sMSEntry);
        this.updateServiceListeners(UPDATE_METHOD);
    }

    static CachedSMSEntry getInstance(ServiceSchemaManagerImpl serviceSchemaManagerImpl, String string, String string2) throws SMSException {
        String string3 = ServiceManager.getServiceNameDN(string, string2);
        return CachedSMSEntry.getInstance(SMSEventListenerManager.principal, string3, serviceSchemaManagerImpl);
    }

    static CachedSMSEntry getInstance(Principal principal, String string, Object object) throws SMSException {
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry::getInstance: " + string);
        }
        String string2 = new DN(string).toRFCString().toLowerCase();
        CachedSMSEntry cachedSMSEntry = null;
        String string3 = cachedSMSEntriesMutex;
        synchronized (string3) {
            cachedSMSEntry = (CachedSMSEntry)smsEntries.get(string2);
            if (cachedSMSEntry == null) {
                cachedSMSEntry = new CachedSMSEntry(new SMSEntry(principal, string));
                HashMap<String, CachedSMSEntry> hashMap = null;
                hashMap = new HashMap<String, CachedSMSEntry>(smsEntries);
                hashMap.put(string2, cachedSMSEntry);
                smsEntries = hashMap;
            }
        }
        if (!cachedSMSEntry.checkPrincipal(principal)) {
            new SMSEntry(principal, string);
            cachedSMSEntry.addPrincipal(principal);
        }
        if (object != null) {
            cachedSMSEntry.addServiceListener(object);
        }
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry::getInstance success: " + string);
        }
        return cachedSMSEntry;
    }

    static synchronized void addInstance(SMSEntry sMSEntry) {
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry::addInstance: " + sMSEntry);
        }
        String string = new DN(sMSEntry.getDN()).toRFCString().toLowerCase();
        String string2 = cachedSMSEntriesMutex;
        synchronized (string2) {
            if (smsEntries.get(string) == null) {
                smsEntries.put(string, new CachedSMSEntry(sMSEntry));
                if (SMSEntry.debug.messageEnabled()) {
                    SMSEntry.debug.message("CachedSMSEntry::addInstance: adding instance: " + sMSEntry);
                }
            }
        }
    }

    static void clearCache() {
        String string = cachedSMSEntriesMutex;
        synchronized (string) {
            smsEntries = new HashMap();
        }
    }

    String getXMLSchema() {
        String[] stringArray = this.smsEntry.getAttributeValues("sunServiceSchema");
        if (stringArray == null) {
            return null;
        }
        return stringArray[0];
    }

    void writeXMLSchema(SSOToken sSOToken, InputStream inputStream) throws SSOException, SMSException, IOException {
        int n = inputStream.available();
        byte[] byArray = new byte[n];
        inputStream.read(byArray, 0, n);
        this.writeXMLSchema(sSOToken, new String(byArray));
    }

    void writeXMLSchema(SSOToken sSOToken, String string) throws SSOException, SMSException {
        String[] stringArray = new String[]{string};
        SMSEntry sMSEntry = this.getSMSEntry();
        sMSEntry.setAttribute("sunServiceSchema", stringArray);
        SSOTokenManager.getInstance().validateToken(sSOToken);
        sMSEntry.save(sSOToken.getPrincipal());
        this.refresh(sMSEntry);
        if (SMSEntry.debug.messageEnabled()) {
            SMSEntry.debug.message("CachedSMSEntry::writeXMLSchema: successfully wrote the XML schema for dn: " + sMSEntry.getDN());
        }
    }
}

