/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.xmlsig;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.security.DecodeAction;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;

public class JKSKeyProvider
implements KeyProvider {
    private KeyStore ks = null;
    private String privateKeyPass = null;
    private String keystorePass = "";
    private String keystoreFile = "";

    private void initialize() {
        String string;
        FileInputStream fileInputStream = null;
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        this.keystoreFile = SystemProperties.get((String)"com.sun.identity.saml.xmlsig.keystore");
        if (this.keystoreFile == null || this.keystoreFile.equals("")) {
            SAMLUtils.debug.error("XML Siganture: keystore file does not exist");
        }
        if ((string = SystemProperties.get((String)"com.sun.identity.saml.xmlsig.storepass")) != null) {
            try {
                fileInputStream = new FileInputStream(string);
                inputStreamReader = new InputStreamReader(fileInputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                this.keystorePass = (String)AccessController.doPrivileged(new DecodeAction(bufferedReader.readLine()));
                fileInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                SAMLUtils.debug.error("JKSKeyProvider.initialize: Unable to read keystore password file " + string);
            }
        } else {
            SAMLUtils.debug.error("XML signature: keystore password is null");
        }
        String string2 = SystemProperties.get((String)"com.sun.identity.saml.xmlsig.keypass");
        if (string2 != null) {
            try {
                fileInputStream = new FileInputStream(string2);
                inputStreamReader = new InputStreamReader(fileInputStream);
                bufferedReader = new BufferedReader(inputStreamReader);
                this.privateKeyPass = (String)AccessController.doPrivileged(new DecodeAction(bufferedReader.readLine()));
                fileInputStream.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
                SAMLUtils.debug.error("JKSKeyProvider.initialize: Unable to read privatekey password file " + string);
            }
        }
    }

    public JKSKeyProvider() {
        this.initialize();
        String string = "JKS";
        try {
            this.ks = KeyStore.getInstance(string);
            FileInputStream fileInputStream = new FileInputStream(this.keystoreFile);
            this.ks.load(fileInputStream, this.keystorePass.toCharArray());
        }
        catch (Exception exception) {
            SAMLUtils.debug.error(exception.getMessage());
        }
    }

    public void setKey(String string, String string2) {
        this.keystorePass = string;
        this.privateKeyPass = string2;
    }

    public X509Certificate getX509Certificate(String string) {
        X509Certificate x509Certificate = null;
        try {
            x509Certificate = (X509Certificate)this.ks.getCertificate(string);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error(exception.getMessage());
        }
        return x509Certificate;
    }

    public PublicKey getPublicKey(String string) {
        PublicKey publicKey = null;
        try {
            X509Certificate x509Certificate = (X509Certificate)this.ks.getCertificate(string);
            publicKey = x509Certificate.getPublicKey();
        }
        catch (Exception exception) {
            SAMLUtils.debug.error(exception.getMessage());
        }
        return publicKey;
    }

    public PrivateKey getPrivateKey(String string) {
        PrivateKey privateKey = null;
        try {
            privateKey = (PrivateKey)this.ks.getKey(string, this.privateKeyPass.toCharArray());
        }
        catch (Exception exception) {
            SAMLUtils.debug.error(exception.getMessage());
        }
        return privateKey;
    }

    public String getCertificateAlias(Certificate certificate) {
        String string = null;
        try {
            if (this.ks != null) {
                string = this.ks.getCertificateAlias(certificate);
            }
        }
        catch (KeyStoreException keyStoreException) {
            return null;
        }
        return string;
    }
}

