/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.xmlsig;

import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.xmlsig.KeyProvider;
import com.sun.identity.saml.xmlsig.OfflineResolver;
import com.sun.identity.saml.xmlsig.SignatureProvider;
import com.sun.identity.saml.xmlsig.XMLSignatureException;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.apache.xml.security.Init;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.signature.XMLSignature;
import org.apache.xml.security.transforms.Transforms;
import org.apache.xml.security.utils.Constants;
import org.apache.xml.security.utils.XMLUtils;
import org.apache.xml.security.utils.resolver.ResourceResolverSpi;
import org.apache.xpath.XPathAPI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AMSignatureProvider
implements SignatureProvider {
    private KeyProvider keystore = null;
    private String c14nMethod = null;
    private String transformAlg = null;

    public AMSignatureProvider() {
        Init.init();
        try {
            this.keystore = (KeyProvider)Class.forName(SAMLUtils.bundle.getString("keyproviderimplclass")).newInstance();
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("AMSignatureProvider:constructor error", (Throwable)exception);
        }
        try {
            this.c14nMethod = SAMLUtils.bundle.getString("canonicalizationMethod");
            if (this.c14nMethod != null) {
                this.c14nMethod = this.c14nMethod.trim();
            }
        }
        catch (Exception exception) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AMSignatureProvider", (Throwable)exception);
            }
            this.c14nMethod = null;
        }
        try {
            this.transformAlg = SAMLUtils.bundle.getString("transformAlgorithm");
            if (this.transformAlg != null) {
                this.transformAlg = this.transformAlg.trim();
            }
        }
        catch (Exception exception) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AMSignatureProvider", (Throwable)exception);
            }
            this.transformAlg = null;
        }
    }

    public void initialize(KeyProvider keyProvider) {
        if (keyProvider == null) {
            SAMLUtils.debug.error("Key Provider is null");
        } else {
            this.keystore = keyProvider;
        }
    }

    public Element signXML(Document document, String string) throws XMLSignatureException {
        return this.signXML(document, string, SAMLUtils.bundle.getString("xmlsigalgorithm"));
    }

    public Element signXML(Document document, String string, String string2) throws XMLSignatureException {
        if (document == null) {
            SAMLUtils.debug.error("signXML: doc is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (string == null || string.equals("")) {
            SAMLUtils.debug.error("signXML: certAlias is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        Element element = null;
        XMLSignature xMLSignature = null;
        try {
            Constants.setSignatureSpecNSprefix((String)"");
            if (this.keystore == null) {
                throw new XMLSignatureException(SAMLUtils.bundle.getString("nullkeystore"));
            }
            PrivateKey privateKey = this.keystore.getPrivateKey(string);
            if (privateKey == null) {
                SAMLUtils.debug.error("private key is null");
                throw new XMLSignatureException(SAMLUtils.bundle.getString("nullprivatekey"));
            }
            element = document.getDocumentElement();
            if (string2 == null || string2.equals("")) {
                string2 = SAMLUtils.bundle.getString("xmlsigalgorithm");
            }
            if (!this.isValidAlgorithm(string2)) {
                throw new XMLSignatureException(SAMLUtils.bundle.getString("invalidalgorithm"));
            }
            if (this.c14nMethod == null || this.c14nMethod.equals("")) {
                xMLSignature = new XMLSignature(document, "", string2);
            } else {
                if (!this.isValidCanonicalizationMethod(this.c14nMethod)) {
                    throw new XMLSignatureException(SAMLUtils.bundle.getString("invalidCanonicalizationMethod"));
                }
                xMLSignature = new XMLSignature(document, "", string2, this.c14nMethod);
            }
            element.appendChild(xMLSignature.getElement());
            xMLSignature.getSignedInfo().addResourceResolver((ResourceResolverSpi)new OfflineResolver());
            Transforms transforms = new Transforms(document);
            transforms.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            if (this.transformAlg != null && !this.transformAlg.equals("")) {
                if (!this.isValidTransformAlgorithm(this.transformAlg)) {
                    throw new XMLSignatureException(SAMLUtils.bundle.getString("invalidTransformAlgorithm"));
                }
                transforms.addTransform(this.transformAlg);
            }
            xMLSignature.addDocument("", transforms, "http://www.w3.org/2000/09/xmldsig#sha1");
            X509Certificate x509Certificate = this.keystore.getX509Certificate(string);
            xMLSignature.addKeyInfo(x509Certificate);
            xMLSignature.sign((Key)privateKey);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("AMSignatureProvider::signXML", (Throwable)exception);
            throw new XMLSignatureException(exception.getMessage());
        }
        return xMLSignature.getElement();
    }

    public String signXML(String string, String string2) throws XMLSignatureException {
        return this.signXML(string, string2, SAMLUtils.bundle.getString("xmlsigalgorithm"));
    }

    public String signXML(String string, String string2, String string3) throws XMLSignatureException {
        Object object;
        if (string == null || string.equals("")) {
            SAMLUtils.debug.error("signXML: xmlString is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (string2 == null || string2.equals("")) {
            SAMLUtils.debug.error("signXML: certAlias is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        Element element = null;
        try {
            object = com.sun.identity.saml.common.XMLUtils.toDOMDocument(string);
            element = this.signXML((Document)object, string2, string3);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("AMSignatureProvider::signXML", (Throwable)exception);
            throw new XMLSignatureException(exception.getMessage());
        }
        object = new ByteArrayOutputStream(2000);
        XMLUtils.outputDOM((Node)element, (OutputStream)object);
        return ((ByteArrayOutputStream)object).toString();
    }

    public Element signXML(Document document, String string, String string2, String string3) throws XMLSignatureException {
        return this.signXML(document, string, string2, string3, null);
    }

    public Element signXML(Document document, String string, String string2, String string3, String string4) throws XMLSignatureException {
        if (document == null) {
            SAMLUtils.debug.error("signXML: doc is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (string == null || string.equals("")) {
            SAMLUtils.debug.error("signXML: certAlias is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        Element element = null;
        XMLSignature xMLSignature = null;
        try {
            Node node;
            Constants.setSignatureSpecNSprefix((String)"");
            PrivateKey privateKey = this.keystore.getPrivateKey(string);
            if (privateKey == null) {
                SAMLUtils.debug.error("private key is null");
                throw new XMLSignatureException(SAMLUtils.bundle.getString("nullprivatekey"));
            }
            element = (Element)XPathAPI.selectSingleNode((Node)document, (String)("//*[@id=\"" + string3 + "\"]"));
            if (element == null) {
                SAMLUtils.debug.error("signXML: could not resolv id attribute");
                throw new XMLSignatureException(SAMLUtils.bundle.getString("invalidIDAttribute"));
            }
            if (string2 == null || string2.equals("")) {
                string2 = SAMLUtils.bundle.getString("xmlsigalgorithm");
            }
            if (!this.isValidAlgorithm(string2)) {
                throw new XMLSignatureException(SAMLUtils.bundle.getString("invalidalgorithm"));
            }
            xMLSignature = new XMLSignature(document, "", string2, "http://www.w3.org/2001/10/xml-exc-c14n#");
            if (string4 == null) {
                element.appendChild(xMLSignature.getElement());
            } else {
                node = XPathAPI.selectSingleNode((Node)document, (String)string4);
                element.insertBefore(xMLSignature.getElement(), node);
            }
            xMLSignature.getSignedInfo().addResourceResolver((ResourceResolverSpi)new OfflineResolver());
            node = new Transforms(document);
            node.addTransform("http://www.w3.org/2000/09/xmldsig#enveloped-signature");
            node.addTransform("http://www.w3.org/2001/10/xml-exc-c14n#");
            String string5 = "#" + string3;
            xMLSignature.addDocument(string5, (Transforms)node, "http://www.w3.org/2000/09/xmldsig#sha1");
            xMLSignature.sign((Key)privateKey);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("AMSignatureProvider::signXML", (Throwable)exception);
            throw new XMLSignatureException(exception.getMessage());
        }
        return xMLSignature.getElement();
    }

    public String signXML(String string, String string2, String string3, String string4) throws XMLSignatureException {
        Object object;
        if (string == null || string.equals("")) {
            SAMLUtils.debug.error("signXML: xmlString is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (string2 == null || string2.equals("")) {
            SAMLUtils.debug.error("signXML: certAlias is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        Element element = null;
        try {
            object = com.sun.identity.saml.common.XMLUtils.toDOMDocument(string);
            element = this.signXML((Document)object, string2, string3, string4);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("AMSignatureProvider::signXML", (Throwable)exception);
            throw new XMLSignatureException(exception.getMessage());
        }
        object = new ByteArrayOutputStream(2000);
        XMLUtils.outputDOM((Node)element, (OutputStream)object);
        return ((ByteArrayOutputStream)object).toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean verifyXMLSignature(Document document, String string) throws XMLSignatureException {
        if (document == null) {
            SAMLUtils.debug.error("verifyXMLSignature: document is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        try {
            Element element = XMLUtils.createDSctx((Document)document, (String)"ds", (String)"http://www.w3.org/2000/09/xmldsig#");
            NodeList nodeList = XPathAPI.selectNodeList((Node)document, (String)"//ds:Signature", (Node)element);
            X509Certificate x509Certificate = this.keystore.getX509Certificate(string);
            PublicKey publicKey = this.keystore.getPublicKey(string);
            Element element2 = null;
            int n = 0;
            while (true) {
                if (n >= nodeList.getLength()) {
                    return true;
                }
                element2 = (Element)nodeList.item(n);
                XMLSignature xMLSignature = new XMLSignature(element2, "");
                xMLSignature.addResourceResolver((ResourceResolverSpi)new OfflineResolver());
                KeyInfo keyInfo = xMLSignature.getKeyInfo();
                X509Certificate x509Certificate2 = this.getX509Certificate(keyInfo);
                if (keyInfo != null && x509Certificate2 != null) {
                    PublicKey publicKey2;
                    String string2 = this.keystore.getCertificateAlias(x509Certificate2);
                    if (string2 == null) {
                        SAMLUtils.debug.error("verifyXMLSignature: certificate is not trusted.");
                        throw new XMLSignatureException(SAMLUtils.bundle.getString("untrustedCertificate"));
                    }
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Found CERT. Cert alias name is " + string2);
                    }
                    if ((publicKey2 = this.getPublicKey(keyInfo)) == null) {
                        SAMLUtils.debug.error("Could not find public key from KeyInfo to verify signature");
                        return false;
                    }
                    if (!xMLSignature.checkSignatureValue((Key)publicKey2)) {
                        return false;
                    }
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("verifyXMLSignature: Signature " + n + " verified");
                    }
                } else {
                    if (string == null || string.equals("")) {
                        return false;
                    }
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Could not find a KeyInfo, try to use certAlias");
                    }
                    if (x509Certificate != null) {
                        if (!xMLSignature.checkSignatureValue(x509Certificate)) {
                            return false;
                        }
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("verifyXMLSignature: Signature " + n + " verified");
                        }
                    } else {
                        if (publicKey == null) {
                            SAMLUtils.debug.error("Could not find public key based on certAlias to verify signature");
                            return false;
                        }
                        if (!xMLSignature.checkSignatureValue((Key)publicKey)) {
                            return false;
                        }
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("verifyXMLSignature: Signature " + n + " verified");
                        }
                    }
                }
                ++n;
            }
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("verifyXMLSignature Exception: ", (Throwable)exception);
            throw new XMLSignatureException(exception.getMessage());
        }
    }

    public boolean verifyXMLSignature(Document document) throws XMLSignatureException {
        if (document == null) {
            SAMLUtils.debug.error("verifyXMLSignature: document is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        return this.verifyXMLSignature(document, null);
    }

    public boolean verifyXMLSignature(Element element) throws XMLSignatureException {
        if (element == null) {
            SAMLUtils.debug.error("signXML: element is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        return this.verifyXMLSignature(com.sun.identity.saml.common.XMLUtils.print(element));
    }

    public boolean verifyXMLSignature(Element element, String string) throws XMLSignatureException {
        if (element == null) {
            SAMLUtils.debug.error("signXML: element is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        return this.verifyXMLSignature(com.sun.identity.saml.common.XMLUtils.print(element), string);
    }

    public boolean verifyXMLSignature(String string) throws XMLSignatureException {
        return this.verifyXMLSignature(string, null);
    }

    public boolean verifyXMLSignature(String string, String string2) throws XMLSignatureException {
        if (string == null || string.equals("")) {
            SAMLUtils.debug.error("signXML: xmlString is null.");
            throw new XMLSignatureException(SAMLUtils.bundle.getString("nullInput"));
        }
        try {
            X509Certificate x509Certificate;
            Document document = com.sun.identity.saml.common.XMLUtils.toDOMDocument(string);
            Element element = XMLUtils.createDSctx((Document)document, (String)"ds", (String)"http://www.w3.org/2000/09/xmldsig#");
            Element element2 = (Element)XPathAPI.selectSingleNode((Node)document, (String)"//ds:Signature[1]", (Node)element);
            XMLSignature xMLSignature = new XMLSignature(element2, "");
            xMLSignature.addResourceResolver((ResourceResolverSpi)new OfflineResolver());
            KeyInfo keyInfo = xMLSignature.getKeyInfo();
            X509Certificate x509Certificate2 = this.getX509Certificate(keyInfo);
            if (keyInfo != null && x509Certificate2 != null) {
                PublicKey publicKey;
                String string3 = this.keystore.getCertificateAlias(x509Certificate2);
                if (string3 == null) {
                    SAMLUtils.debug.error("verifyXMLSignature: certificate is not trusted.");
                    throw new XMLSignatureException(SAMLUtils.bundle.getString("untrustedCertificate"));
                }
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Found CERT. Cert alias name is " + string3);
                }
                if ((publicKey = this.getPublicKey(keyInfo)) != null) {
                    return xMLSignature.checkSignatureValue((Key)publicKey);
                }
                SAMLUtils.debug.error("Could not find public key from KeyInfo to verify signature");
                return false;
            }
            if (string2 == null || string2.equals("")) {
                return false;
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Could not find a KeyInfo, try to use certAlias");
            }
            if ((x509Certificate = this.keystore.getX509Certificate(string2)) != null) {
                return xMLSignature.checkSignatureValue(x509Certificate);
            }
            PublicKey publicKey = this.keystore.getPublicKey(string2);
            if (publicKey != null) {
                return xMLSignature.checkSignatureValue((Key)publicKey);
            }
            SAMLUtils.debug.error("Could not find public key based on certAlias to verify signature");
            return false;
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("verifyXMLSignature Exception: " + exception.getMessage());
            throw new XMLSignatureException(exception.getMessage());
        }
    }

    public KeyProvider getKeyProvider() {
        return this.keystore;
    }

    private X509Certificate getX509Certificate(KeyInfo keyInfo) {
        X509Certificate x509Certificate = null;
        try {
            if (keyInfo != null && keyInfo.containsX509Data()) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Could find a X509Data element in the KeyInfo");
                }
                x509Certificate = keyInfo.getX509Certificate();
            }
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("getX509Certificate(KeyInfo) Exception: " + exception.getMessage());
            return null;
        }
        return x509Certificate;
    }

    private PublicKey getPublicKey(KeyInfo keyInfo) {
        PublicKey publicKey = null;
        X509Certificate x509Certificate = this.getX509Certificate(keyInfo);
        if (x509Certificate != null) {
            publicKey = x509Certificate.getPublicKey();
        }
        return publicKey;
    }

    private boolean isValidAlgorithm(String string) {
        return string.equals("http://www.w3.org/2000/09/xmldsig#hmac-sha1") || string.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1") || string.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1") || string.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1") || string.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-md5") || string.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-ripemd160") || string.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256") || string.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha384") || string.equals("http://www.w3.org/2001/04/xmldsig-more#rsa-sha512") || string.equals("http://www.w3.org/2001/04/xmldsig-more#hmac-md5") || string.equals("http://www.w3.org/2001/04/xmldsig-more#hmac-ripemd160") || string.equals("http://www.w3.org/2001/04/xmldsig-more#hmac-sha256") || string.equals("http://www.w3.org/2001/04/xmldsig-more#hmac-sha384") || string.equals("http://www.w3.org/2001/04/xmldsig-more#hmac-sha512");
    }

    private boolean isValidCanonicalizationMethod(String string) {
        return string.equals("UTF8") || string.equals("(//. | //@* | //namespace::*)") || string.equals("(//. | //@* | //namespace::*)[not(self::comment())]") || string.equals("(.//. | .//@* | .//namespace::*)") || string.equals("(.//. | .//@* | .//namespace::*)[not(self::comment())]") || string.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || string.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments") || string.equals("http://www.w3.org/2001/10/xml-exc-c14n#") || string.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
    }

    private boolean isValidTransformAlgorithm(String string) {
        return string.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || string.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments") || string.equals("http://www.w3.org/2001/10/xml-exc-c14n#") || string.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments") || string.equals("http://www.w3.org/TR/1999/REC-xslt-19991116") || string.equals("http://www.w3.org/2000/09/xmldsig#base64") || string.equals("http://www.w3.org/TR/1999/REC-xpath-19991116") || string.equals("http://www.w3.org/2000/09/xmldsig#enveloped-signature") || string.equals("http://www.w3.org/TR/2001/WD-xptr-20010108") || string.equals("http://www.w3.org/2002/04/xmldsig-filter2") || string.equals("http://www.w3.org/2002/06/xmldsig-filter2") || string.equals("http://www.nue.et-inf.uni-siegen.de/~geuer-pollmann/#xpathFilter");
    }
}

