/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.servlet;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.util.Base64;
import com.iplanet.services.util.CookieUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.saml.AssertionManager;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.Response;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.protocol.StatusCode;
import com.sun.identity.saml.servlet.POSTCleanUpThread;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public class SAMLPOSTProfileServlet
extends HttpServlet {
    private static Map idTimeMap = new HashMap();
    private static Thread cThread = new POSTCleanUpThread(idTimeMap);

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        Object object;
        Object object2;
        Object object3;
        if (httpServletRequest == null || httpServletResponse == null) {
            SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("nullInputParameter"));
            httpServletResponse.sendError(500, SAMLUtils.bundle.getString("nullInputParameter"));
            return;
        }
        SAMLUtils.checkHTTPContentLength(httpServletRequest);
        String string = httpServletRequest.getParameter("TARGET");
        if (string == null) {
            SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("missingTargetSite"));
            httpServletResponse.sendError(400, SAMLUtils.bundle.getString("missingTargetSite"));
            return;
        }
        SAMLServiceManager.SiteEntry siteEntry = this.getDestSite(string);
        String string2 = null;
        if (siteEntry == null || (string2 = siteEntry.getPOSTUrl()) == null) {
            SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("targetForbidden") + " " + string);
            httpServletResponse.sendError(400, SAMLUtils.bundle.getString("targetForbidden") + " " + string);
            return;
        }
        SSOToken sSOToken = this.getSSOToken(httpServletRequest);
        if (sSOToken == null) {
            httpServletResponse.sendError(500, SAMLUtils.bundle.getString("nullSSOToken"));
            return;
        }
        Response response = null;
        try {
            object3 = AssertionManager.getInstance();
            object2 = ((AssertionManager)object3).createSSOAssertion(sSOToken.getTokenID().toString(), null, siteEntry.getSourceID());
            object = new StatusCode("samlp:Success");
            Status status = new Status((StatusCode)object);
            ArrayList<Assertion> arrayList = new ArrayList<Assertion>();
            arrayList.add((Assertion)object2);
            response = new Response(null, status, string2, arrayList);
        }
        catch (SAMLException sAMLException) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.doGet: Exception when creating Response: ", (Throwable)sAMLException);
            httpServletResponse.sendError(500, sAMLException.getMessage());
            return;
        }
        object3 = null;
        try {
            object3 = this.signResponse(response);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.doGet: Exception when signing the response:", (Throwable)exception);
            httpServletResponse.sendError(500, SAMLUtils.bundle.getString("errorSigningResponse"));
            return;
        }
        object2 = null;
        try {
            object2 = Base64.encode((byte[])object3).trim();
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.doGet: Exception when encoding the response:", (Throwable)exception);
            httpServletResponse.sendError(500, SAMLUtils.bundle.getString("errorEncodeResponse"));
            return;
        }
        SAMLUtils.access(Level.INFO, SAMLUtils.bundle.getString("targetURL") + string + ". " + SAMLUtils.bundle.getString("SAMLResponse") + new String((byte[])object3, "UTF-8") + ". " + SAMLUtils.bundle.getString("redirectTo") + string2);
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        object = httpServletResponse.getWriter();
        ((PrintWriter)object).println("<HTML>");
        ((PrintWriter)object).println("<BODY Onload=\"document.forms[0].submit()\">");
        ((PrintWriter)object).println("<FORM METHOD=\"POST\" ACTION=\"" + string2 + "\">");
        ((PrintWriter)object).println("<INPUT TYPE=\"HIDDEN\" NAME=\"SAMLResponse\" ");
        ((PrintWriter)object).println("VALUE=\"" + (String)object2 + "\">");
        ((PrintWriter)object).println("<INPUT TYPE=\"HIDDEN\" NAME=\"TARGET\" VALUE=\"" + string + "\"> </FORM>");
        ((PrintWriter)object).println("</BODY></HTML>");
        ((PrintWriter)object).close();
    }

    private byte[] signResponse(Response response) throws SAMLException {
        response.signXML();
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("SAMLPOSTProfileServlet.signResponse: signed samlResponse is" + response.toString(true, true, true));
        }
        byte[] byArray = null;
        try {
            byArray = response.toString(true, true, true).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SAMLPOSTProfileServlet.signResponse", (Throwable)unsupportedEncodingException);
            }
            throw new SAMLException(unsupportedEncodingException.getMessage());
        }
        return byArray;
    }

    private SAMLServiceManager.SiteEntry getDestSite(String string) {
        SAMLServiceManager.SiteEntry siteEntry = null;
        try {
            URL uRL = new URL(string);
            String string2 = uRL.getHost();
            int n = uRL.getPort();
            if (string2 == null) {
                SAMLUtils.debug.error("SAMLPOSTProfileServlet.getDestSite: missing host in target.");
                return null;
            }
            SAMLServiceManager.SiteEntry siteEntry2 = null;
            Iterator iterator = ((Set)SAMLServiceManager.getAttribute("iplanet-am-saml-trusted-server-list")).iterator();
            String string3 = null;
            int n2 = -1;
            while (iterator.hasNext()) {
                siteEntry2 = (SAMLServiceManager.SiteEntry)iterator.next();
                string3 = siteEntry2.getHostName();
                n2 = siteEntry2.getPort();
                if (string3 == null || string2.indexOf(string3) == -1) continue;
                if (n2 != -1) {
                    if (n2 != n) continue;
                    siteEntry = siteEntry2;
                    break;
                }
                siteEntry = siteEntry2;
            }
            if (siteEntry == null) {
                SAMLUtils.debug.error("SAMLPOSTProfileServlet.getDestSite:  No destSite found from the target.");
                return null;
            }
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.getDestSite: ", (Throwable)exception);
            return null;
        }
        return siteEntry;
    }

    private SSOToken getSSOToken(HttpServletRequest httpServletRequest) {
        SSOToken sSOToken = null;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
            if (sSOToken == null) {
                SAMLUtils.debug.error("SAMLPOSTProfileServlet.getSSOToken: SSOToken is null.");
                return null;
            }
            if (!sSOTokenManager.isValidToken(sSOToken)) {
                SAMLUtils.debug.error("SAMLPOSTProfileServlet.getSSOToken: SSOToken is invalid.");
                return null;
            }
        }
        catch (SSOException sSOException) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.getSSOToken: Exception when getting SSOToken:", (Throwable)sSOException);
            return null;
        }
        return sSOToken;
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        boolean bl;
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        if (httpServletRequest == null || httpServletResponse == null) {
            SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("nullInputParameter"));
            httpServletResponse.sendError(400, SAMLUtils.bundle.getString("nullInputParameter"));
            return;
        }
        SAMLUtils.checkHTTPContentLength(httpServletRequest);
        String string = httpServletRequest.getParameter("TARGET");
        if (string == null) {
            SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("missingTargetSite"));
            httpServletResponse.sendError(400, SAMLUtils.bundle.getString("missingTargetSite"));
            return;
        }
        String string2 = httpServletRequest.getParameter("SAMLResponse");
        if (string2 == null) {
            SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("missingSAMLResponse"));
            httpServletResponse.sendError(400, SAMLUtils.bundle.getString("missingSAMLResponse"));
            return;
        }
        byte[] byArray = null;
        try {
            byArray = Base64.decode((String)string2);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.doPost: Exception when decoding SAMLResponse:", (Throwable)exception);
            httpServletResponse.sendError(500, SAMLUtils.bundle.getString("errorDecodeResponse"));
            return;
        }
        Response response = this.verifySignatureAndGetResponse(byArray);
        if (response == null) {
            SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("errorObtainResponse"));
            httpServletResponse.sendError(400, SAMLUtils.bundle.getString("errorObtainResponse"));
            return;
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("SAMLPOSTProfileServlet.doPost: Received " + response.toString());
        }
        StringBuffer stringBuffer = HttpUtils.getRequestURL((HttpServletRequest)httpServletRequest);
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("SAMLPOSTProfileServlet.doPost: requestUrl=" + stringBuffer);
        }
        if (!(bl = this.verifyResponse(response, stringBuffer.toString(), httpServletRequest))) {
            SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("invalidResponse"));
            httpServletResponse.sendError(400, SAMLUtils.bundle.getString("invalidResponse"));
            return;
        }
        Map map = this.verifyAssertionAndGetSSMap(response);
        if (map == null) {
            SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("invalidAssertion"));
            httpServletResponse.sendError(400, SAMLUtils.bundle.getString("invalidAssertion"));
            return;
        }
        boolean bl2 = true;
        try {
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
            if (sSOToken == null || !sSOTokenManager.isValidToken(sSOToken)) {
                bl2 = this.generateToken(httpServletRequest, httpServletResponse, map);
            }
        }
        catch (SSOException sSOException) {
            SAMLUtils.debug.message("SAMLPOSTProfileServlet.doPost: There is no SSOToken in the cookie. Generating one.", (Throwable)sSOException);
            bl2 = this.generateToken(httpServletRequest, httpServletResponse, map);
        }
        if (!bl2) {
            SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("failGenerateSSOToken"));
            httpServletResponse.sendError(500, SAMLUtils.bundle.getString("failGenerateSSOToken"));
            return;
        }
        SAMLUtils.access(Level.INFO, SAMLUtils.bundle.getString("accessGranted") + " " + SAMLUtils.bundle.getString("SAMLResponse") + new String(byArray, "UTF-8") + " " + SAMLUtils.bundle.getString("redirectTo") + string);
        if (SAMLUtils.postYN(string)) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("POST to target:" + string);
            }
            SAMLUtils.postToTarget(httpServletResponse, (List)map.get("assertion"), string);
        } else {
            httpServletResponse.setHeader("Location", string);
            httpServletResponse.sendRedirect(string);
        }
    }

    private Response verifySignatureAndGetResponse(byte[] byArray) {
        Response response = null;
        if (byArray == null) {
            return null;
        }
        try {
            response = Response.parseXML(new ByteArrayInputStream(byArray));
        }
        catch (SAMLException sAMLException) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.verifySignatureAndGetResponse:", (Throwable)sAMLException);
        }
        if (response != null && !response.isSignatureValid()) {
            return null;
        }
        return response;
    }

    private boolean verifyResponse(Response response, String string, HttpServletRequest httpServletRequest) {
        String string2 = response.getRecipient();
        if (string2 == null || string2.length() == 0 || !string2.equals(string) && !string2.equals(this.getLBURL(string, httpServletRequest))) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.verifyResponse: Incorrect Recipient.");
            return false;
        }
        if (!response.getStatus().getStatusCode().getValue().endsWith(":Success")) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.verifyResponse: Incorrect StatusCode value.");
            return false;
        }
        return true;
    }

    private String getLBURL(String string, HttpServletRequest httpServletRequest) {
        String string2 = httpServletRequest.getHeader("host");
        if (string2 == null) {
            return string;
        }
        int n = string.indexOf("//");
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append(string.substring(0, n + 2)).append(string2);
        String string3 = string.substring(n + 2, string.length());
        n = string3.indexOf("/");
        if (n != -1) {
            stringBuffer.append(string3.substring(n, string3.length()));
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("SAMLPOSTProfileServlet.getLBURL: LBURL=" + stringBuffer.toString());
        }
        return stringBuffer.toString().trim();
    }

    private Map verifyAssertionAndGetSSMap(Response response) {
        Object object;
        Subject subject = null;
        SAMLServiceManager.SOAPEntry sOAPEntry = null;
        List list = response.getAssertion();
        Iterator iterator = list.iterator();
        Assertion assertion = null;
        String string = null;
        String string2 = null;
        Iterator iterator2 = null;
        Statement statement = null;
        int n = -1;
        Subject subject2 = null;
        SubjectConfirmation subjectConfirmation = null;
        Set set = null;
        String string3 = null;
        Date date = null;
        long l = System.currentTimeMillis() + 180000L;
        while (iterator.hasNext()) {
            assertion = (Assertion)iterator.next();
            string = assertion.getAssertionID();
            if (idTimeMap.containsKey(string)) {
                SAMLUtils.debug.error("SAMLPOSTProfileServlet.verifyAssertionAndGetSSMap: Assertion: " + string + " is used.");
                return null;
            }
            string2 = assertion.getIssuer();
            sOAPEntry = SAMLUtils.getSourceSite(string2);
            if (sOAPEntry == null) {
                SAMLUtils.debug.error("SAMLPOSTProfileServlet.verifyAssertionAndGetSSMap: issuer is not on the Partner list.");
                return null;
            }
            if (!assertion.isSignatureValid()) {
                SAMLUtils.debug.error("SAMLPOSTProfileServlet.verifyAssertionAndGetSSMap: assertion's signature is not valid.");
                return null;
            }
            if (!assertion.isTimeValid()) {
                SAMLUtils.debug.error("SAMLPOSTProfileServlet.verifyAssertionAndGetSSMap: assertion's time is not valid.");
                return null;
            }
            iterator2 = assertion.getStatement().iterator();
            while (iterator2.hasNext()) {
                statement = (Statement)iterator2.next();
                n = statement.getStatementType();
                if (n != 1 && n != 3 && n != 2) continue;
                subject2 = ((SubjectStatement)statement).getSubject();
                subjectConfirmation = subject2.getSubjectConfirmation();
                if (subjectConfirmation == null || (set = subjectConfirmation.getConfirmationMethod()) == null || set.size() != 1) {
                    SAMLUtils.debug.error("SAMLPOSTProfileServlet.verifyAssertionAndGetSSMap: missing or extra ConfirmationMethod.");
                    return null;
                }
                string3 = (String)set.iterator().next();
                if (string3 == null || !string3.equals("urn:oasis:names:tc:SAML:1.0:cm:bearer")) {
                    SAMLUtils.debug.error("SAMLPOSTProfileServlet.verifyAssertionAndGetSSMap:wrong ConfirmationMethod.");
                    return null;
                }
                if (n != 1 || subject != null) continue;
                subject = subject2;
            }
            object = assertion.getConditions();
            if (object != null && (date = ((Conditions)object).getNotOnorAfter()) != null) {
                l = date.getTime();
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SAMLPOSTProfileServlet.doPost: Adding " + string + " to idTimeMap.");
            }
            Map map = idTimeMap;
            synchronized (map) {
                idTimeMap.put(string, new Long(l));
            }
        }
        if (subject == null || sOAPEntry == null) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.verifyAssertionAndGetSSMap: couldn't find Subject.");
            return null;
        }
        object = new HashMap<String, Object>();
        object.put("subject", subject);
        object.put("sourceSite", sOAPEntry);
        object.put("assertion", list);
        return object;
    }

    private boolean generateToken(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map map) {
        try {
            SAMLServiceManager.SOAPEntry sOAPEntry = (SAMLServiceManager.SOAPEntry)map.get("sourceSite");
            String string = sOAPEntry.getSourceID();
            Subject subject = (Subject)map.get("subject");
            Map map2 = sOAPEntry.getAccountMapper().getUser(subject, string);
            String string2 = (String)map2.get("name");
            String string3 = (String)map2.get("org");
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SAMLPOSTProfileServlet.generateToken: name=" + string2 + ", org=" + string3);
            }
            AuthContextLocal authContextLocal = AuthUtils.getAuthContext(string3);
            AuthUtils.getLoginState(authContextLocal).setHttpServletRequest(httpServletRequest);
            authContextLocal.login(AuthContext.IndexType.USER, string2, true);
            SSOToken sSOToken = authContextLocal.getSSOToken();
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("iPlanetAMPlatformService", sSOToken);
            ServiceSchema serviceSchema = serviceSchemaManager.getGlobalSchema();
            Set set = (Set)serviceSchema.getAttributeDefaults().get("iplanet-am-platform-cookie-domains");
            String string4 = sSOToken.getTokenID().toString();
            String string5 = SystemProperties.get((String)"com.iplanet.am.cookie.name");
            if (set.size() == 0) {
                SAMLUtils.debug.message("POSTProfile: cookie domain is null");
                Cookie cookie = CookieUtils.newCookie((String)string5, (String)string4, (String)"/");
                httpServletResponse.addCookie(cookie);
            } else {
                Iterator iterator = set.iterator();
                Cookie cookie = null;
                while (iterator.hasNext()) {
                    cookie = CookieUtils.newCookie((String)string5, (String)string4, (String)"/", (String)((String)iterator.next()));
                    httpServletResponse.addCookie(cookie);
                }
            }
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("SAMLPOSTProfileServlet.generateToken:", (Throwable)exception);
            return false;
        }
        return true;
    }

    static {
        cThread.start();
    }
}

