/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.servlet;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.util.CookieUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.saml.AssertionManager;
import com.sun.identity.saml.SAMLClient;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AudienceRestrictionCondition;
import com.sun.identity.saml.assertion.AuthenticationStatement;
import com.sun.identity.saml.assertion.Condition;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.assertion.SubjectStatement;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AssertionArtifact;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpUtils;

public class SAMLAwareServlet
extends HttpServlet {
    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        if (httpServletRequest == null || httpServletResponse == null) {
            SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("nullInputParameter"));
            httpServletResponse.sendError(500, SAMLUtils.bundle.getString("nullInputParameter"));
            return;
        }
        SAMLUtils.checkHTTPContentLength(httpServletRequest);
        String string = httpServletRequest.getParameter((String)SAMLServiceManager.getAttribute("iplanet-am-saml-target-specifier"));
        String string2 = httpServletRequest.getParameter((String)SAMLServiceManager.getAttribute("iplanet-am-saml-artifact-name"));
        if (string == null || string.equals("")) {
            SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("missingTargetSite"));
            httpServletResponse.sendError(500, SAMLUtils.bundle.getString("invalidConfig"));
            return;
        }
        httpServletResponse.setContentType("text/html; charset=UTF-8");
        if (string2 == null || string2.equals("")) {
            this.IntersiteTransfer(httpServletRequest, httpServletResponse, string);
        } else {
            this.ArtifactHandler(httpServletRequest, httpServletResponse);
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        this.doGet(httpServletRequest, httpServletResponse);
    }

    private List createArtifact(SSOToken sSOToken, String string) throws SAMLException {
        if (sSOToken == null || string == null || string.equals("")) {
            throw new SAMLException(SAMLUtils.bundle.getString("createArtifactError"));
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        AssertionManager assertionManager = AssertionManager.getInstance();
        AssertionArtifact assertionArtifact = assertionManager.createAssertionArtifact(sSOToken.getTokenID().toString(), string);
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("AssertionArtifact id = " + assertionArtifact.toString());
        }
        String string2 = assertionArtifact.getAssertionArtifact();
        arrayList.add(string2);
        return arrayList;
    }

    private void IntersiteTransfer(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string) throws IOException, ServletException {
        StringBuffer stringBuffer;
        Object object;
        Object object2;
        URL uRL = new URL(string);
        String string2 = uRL.getHost();
        int n = uRL.getPort();
        if (string2 == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.error("SAMLAwareServlet:IntersiteTransfer:Failed to get host name of target URL.");
            }
            httpServletResponse.sendError(500, SAMLUtils.bundle.getString("missingTargetHost"));
            return;
        }
        if (SAMLUtils.debug.messageEnabled()) {
            SAMLUtils.debug.message("TargetUrl Host = " + string2 + " Port= " + n);
        }
        SAMLServiceManager.SiteEntry siteEntry = null;
        Set set = (Set)SAMLServiceManager.getAttribute("iplanet-am-saml-trusted-server-list");
        if (set == null) {
            httpServletResponse.sendError(500, SAMLUtils.bundle.getString("nullTrustedSite"));
            return;
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object2 = null;
            int n2 = 0;
            object = (SAMLServiceManager.SiteEntry)iterator.next();
            object2 = ((SAMLServiceManager.SiteEntry)object).getHostName();
            n2 = ((SAMLServiceManager.SiteEntry)object).getPort();
            if (n2 != -1) {
                if (string2.indexOf((String)object2) == -1 || n == -1 || n != n2) continue;
                siteEntry = object;
                break;
            }
            if (string2.indexOf((String)object2) == -1) continue;
            siteEntry = object;
        }
        if (siteEntry != null) {
            Object object3;
            object2 = null;
            try {
                object3 = SSOTokenManager.getInstance();
                object2 = object3.createSSOToken(httpServletRequest);
                if (object2 == null) {
                    SAMLUtils.debug.error("SSOToken is null.");
                    httpServletResponse.sendError(500, SAMLUtils.bundle.getString("nullSSOToken"));
                    return;
                }
                if (!object3.isValidToken(object2)) {
                    SAMLUtils.debug.error("SSOToken is invalid.");
                    httpServletResponse.sendError(500, SAMLUtils.bundle.getString("invalidSSOToken"));
                    return;
                }
            }
            catch (SSOException sSOException) {
                SAMLUtils.debug.error("IntersiteTransfer", (Throwable)sSOException);
                httpServletResponse.sendError(500, sSOException.getMessage());
                return;
            }
            object3 = new ArrayList();
            try {
                object3 = this.createArtifact((SSOToken)object2, siteEntry.getSourceID());
            }
            catch (SAMLException sAMLException) {
                SAMLUtils.debug.error("IntersiteTransfer:Failed to create AssertionArtifact(s)");
                httpServletResponse.sendError(500, sAMLException.getMessage());
                return;
            }
            object = (String)SAMLServiceManager.getAttribute("iplanet-am-saml-target-specifier");
            String string3 = (String)SAMLServiceManager.getAttribute("iplanet-am-saml-artifact-name");
            iterator = object3.iterator();
            stringBuffer = new StringBuffer(1000);
            String string4 = null;
            while (iterator.hasNext()) {
                string4 = URLEncoder.encode((String)iterator.next());
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Encoded SAML AssertionArtifact " + string4);
                }
                stringBuffer.append("&").append(string3).append("=").append(string4);
            }
        } else {
            SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("targetForbidden") + " " + string);
            httpServletResponse.sendError(403, SAMLUtils.bundle.getString("targetForbidden") + " " + string);
            return;
        }
        String string5 = siteEntry.getSAMLUrl() + "?" + (String)object + "=" + string + stringBuffer.toString();
        SAMLUtils.access(Level.INFO, SAMLUtils.bundle.getString("targetURL") + string);
        httpServletResponse.setStatus(302);
        httpServletResponse.setHeader("Location", string5);
        SAMLUtils.access(Level.INFO, SAMLUtils.bundle.getString("redirectTo") + string5);
        httpServletResponse.sendRedirect(string5);
    }

    private boolean checkCondition(HttpServletResponse httpServletResponse, Assertion assertion) throws IOException {
        if (assertion == null) {
            return false;
        }
        if (!assertion.isSignatureValid()) {
            SAMLUtils.debug.error("The assertion in SAML response is(signature) invalid.");
            SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("assertionSignatureNotValid"));
            httpServletResponse.sendError(500, SAMLUtils.bundle.getString("assertionSignatureNotValid"));
            return false;
        }
        if (!assertion.isTimeValid()) {
            SAMLUtils.debug.error("The assertion in SAML response is(time) invalid.");
            SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("assertionTimeNotValid"));
            httpServletResponse.sendError(500, SAMLUtils.bundle.getString("assertionTimeNotValid"));
            return false;
        }
        Conditions conditions = assertion.getConditions();
        Set set = new HashSet();
        set = conditions.getAudienceRestrictionCondition();
        Iterator iterator = null;
        if (set != null && !set.isEmpty()) {
            iterator = set.iterator();
            while (iterator.hasNext()) {
                if (((AudienceRestrictionCondition)iterator.next()).evaluate() == Condition.INDETERMINATE) {
                    if (!SAMLUtils.debug.messageEnabled()) continue;
                    SAMLUtils.debug.message("AudienceRestrictionConditions is indeterminate.");
                    continue;
                }
                httpServletResponse.sendError(500, SAMLUtils.bundle.getString("failAudienceRestrictionCondition"));
                return false;
            }
        }
        return true;
    }

    private Subject examSAMLResponse(HttpServletResponse httpServletResponse, List list) throws IOException {
        if (list == null) {
            return null;
        }
        boolean bl = false;
        Subject subject = null;
        Iterator iterator = list.iterator();
        ArrayList arrayList = new ArrayList();
        while (iterator.hasNext()) {
            Assertion assertion = (Assertion)iterator.next();
            if (!this.checkCondition(httpServletResponse, assertion)) {
                return null;
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Passed checking Conditions!");
            }
            Set set = new HashSet();
            set = assertion.getStatement();
            if (set == null || set.isEmpty()) {
                SAMLUtils.debug.error("SAML Response does not containany Statement.");
                SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("noStatement"));
                httpServletResponse.sendError(500, SAMLUtils.bundle.getString("noStatement"));
                return null;
            }
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                Statement statement = (Statement)iterator2.next();
                subject = ((SubjectStatement)statement).getSubject();
                SubjectConfirmation subjectConfirmation = subject.getSubjectConfirmation();
                Set set2 = new HashSet();
                set2 = subjectConfirmation.getConfirmationMethod();
                if (set2 == null || set2.isEmpty()) {
                    SAMLUtils.debug.error("Subject confirmation method is null");
                    httpServletResponse.sendError(500, SAMLUtils.bundle.getString("nullSubjectConfirmationMethod"));
                    return null;
                }
                String string = (String)set2.iterator().next();
                if (string == null || !string.equals("urn:oasis:names:tc:SAML:1.0:cm:artifact-01")) {
                    SAMLUtils.debug.error("Wrong Confirmation Method.");
                    httpServletResponse.sendError(500, SAMLUtils.bundle.getString("wrongConfirmationMethodValue"));
                    return null;
                }
                if (!(statement instanceof AuthenticationStatement)) continue;
                bl = true;
            }
        }
        if (!bl) {
            SAMLUtils.debug.error("Assertions do not contain a proper SSO AuthenticationStatement");
            SAMLUtils.error(Level.INFO, SAMLUtils.bundle.getString("noSSOAssertion"));
            httpServletResponse.sendError(500, SAMLUtils.bundle.getString("noSSOAssertion"));
            return null;
        }
        return subject;
    }

    private boolean generateToken(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Subject subject, String string, String string2) throws IOException, ServletException {
        if (subject == null || string == null || string.equals("") || string2 == null || string2.equals("")) {
            return false;
        }
        String string3 = SystemProperties.get((String)"com.iplanet.am.cookie.name");
        String string4 = null;
        Set set = null;
        try {
            AuthContextLocal authContextLocal = AuthUtils.getAuthContext(string2);
            AuthUtils.getLoginState(authContextLocal).setHttpServletRequest(httpServletRequest);
            authContextLocal.login(AuthContext.IndexType.USER, string, true);
            SSOToken sSOToken = authContextLocal.getSSOToken();
            ServiceSchemaManager serviceSchemaManager = new ServiceSchemaManager("iPlanetAMPlatformService", sSOToken);
            ServiceSchema serviceSchema = serviceSchemaManager.getGlobalSchema();
            set = (Set)serviceSchema.getAttributeDefaults().get("iplanet-am-platform-cookie-domains");
            string4 = sSOToken.getTokenID().toString();
            if (set.size() == 0) {
                SAMLUtils.debug.message("cookie domain is null");
                Cookie cookie = CookieUtils.newCookie((String)string3, (String)string4, (String)"/");
                httpServletResponse.addCookie(cookie);
            } else {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Cookie cookie = CookieUtils.newCookie((String)string3, (String)string4, (String)"/", (String)((String)iterator.next()));
                    httpServletResponse.addCookie(cookie);
                }
            }
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("generateToken: ", (Throwable)exception);
            SAMLUtils.error(Level.INFO, exception.getMessage());
            httpServletResponse.sendError(500, exception.getMessage());
            return false;
        }
        return true;
    }

    private void ArtifactHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException, ServletException {
        Object object;
        List list;
        String string;
        PrintWriter printWriter;
        block15: {
            AssertionArtifact assertionArtifact;
            String string2;
            String string3;
            Subject subject;
            block14: {
                printWriter = httpServletResponse.getWriter();
                subject = null;
                string = httpServletRequest.getParameter((String)SAMLServiceManager.getAttribute("iplanet-am-saml-target-specifier"));
                String string4 = httpServletRequest.getQueryString();
                Hashtable hashtable = HttpUtils.parseQueryString((String)string4);
                String string5 = (String)SAMLServiceManager.getAttribute("iplanet-am-saml-artifact-name");
                String[] stringArray = (String[])hashtable.get(string5);
                SAMLServiceManager.SOAPEntry sOAPEntry = null;
                string3 = null;
                string2 = null;
                list = null;
                try {
                    list = SAMLClient.artifactQueryHandler(stringArray, null);
                    subject = this.examSAMLResponse(httpServletResponse, list);
                    if (subject == null) {
                        return;
                    }
                    assertionArtifact = new AssertionArtifact(stringArray[0]);
                    object = assertionArtifact.getSourceID();
                    Map map = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
                    if (map == null) {
                        httpServletResponse.sendError(500, SAMLUtils.bundle.getString("nullPartnerUrl"));
                        return;
                    }
                    sOAPEntry = (SAMLServiceManager.SOAPEntry)map.get(object);
                    if (sOAPEntry != null) {
                        Map map2 = sOAPEntry.getAccountMapper().getUser(subject, (String)object);
                        string3 = (String)map2.get("name");
                        string2 = (String)map2.get("org");
                        break block14;
                    }
                    httpServletResponse.sendError(500, SAMLUtils.bundle.getString("failedAccountMapping"));
                    return;
                }
                catch (SAMLException sAMLException) {
                    SAMLUtils.error(Level.INFO, sAMLException.getMessage());
                    httpServletResponse.sendError(500);
                    return;
                }
            }
            assertionArtifact = null;
            try {
                object = SSOTokenManager.getInstance();
                assertionArtifact = object.createSSOToken(httpServletRequest);
                if (assertionArtifact == null ? !this.generateToken(httpServletRequest, httpServletResponse, subject, string3, string2) : !object.isValidToken((SSOToken)assertionArtifact) && !this.generateToken(httpServletRequest, httpServletResponse, subject, string3, string2)) {
                    return;
                }
            }
            catch (SSOException sSOException) {
                SAMLUtils.debug.error("SAML_Aware_Servlet: No SSOToken. Create a new one.");
                if (this.generateToken(httpServletRequest, httpServletResponse, subject, string3, string2)) break block15;
                return;
            }
        }
        SAMLUtils.access(Level.INFO, SAMLUtils.bundle.getString("accessGranted"));
        if (SAMLUtils.postYN(string)) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("POST to target:" + string);
            }
            SAMLUtils.postToTarget(httpServletResponse, list, string);
        } else if (SAMLUtils.debug.messageEnabled()) {
            printWriter.println("<html>\n");
            printWriter.println("<head>\n");
            printWriter.println("<title>Access rights validated</title>\n");
            printWriter.println("<meta http-equiv=\"refresh\" content=\"10; URL=" + string + "\">\n");
            printWriter.println("</head>\n");
            printWriter.println("<body>\n");
            printWriter.println("<H1>Access rights validated</H1>\n");
            printWriter.println("<P>We have verified your access rights <STRONG></STRONG> according to the assertion shown below. \n");
            printWriter.println("You are being redirected to the resource.\n");
            printWriter.println("Please wait ......\n");
            printWriter.println("</P>\n");
            printWriter.println("<HR><P>\n");
            object = list.iterator();
            while (object.hasNext()) {
                printWriter.println(SAMLUtils.displayXML(object.next().toString()));
            }
            printWriter.println("</P>\n");
            printWriter.println("</body>\n");
            printWriter.println("</html>\n");
            printWriter.flush();
        } else {
            httpServletResponse.sendRedirect(string);
        }
    }
}

