/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.protocol;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.SAMLVersionMismatchException;
import com.sun.identity.saml.common.XMLUtils;
import com.sun.identity.saml.protocol.AbstractResponse;
import com.sun.identity.saml.protocol.Status;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Response
extends AbstractResponse {
    protected Status status = null;
    protected List assertions = Collections.EMPTY_LIST;
    protected String xmlString = null;
    protected String signatureString = null;

    protected Response() {
    }

    public void signXML() throws SAMLException {
        if (this.signed) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Response.signXML: the response is already signed.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("alreadySigned"));
        }
        String string = SystemProperties.get((String)"com.sun.identity.saml.xmlsig.certalias");
        if (string == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Response.signXML: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(SAMLUtils.bundle.getString("cannotFindCertAlias"));
        }
        XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
        this.signatureString = xMLSignatureManager.signXML(this.toString(true, true), string);
        this.signature = XMLUtils.toDOMDocument(this.signatureString).getDocumentElement();
        this.signed = true;
        this.xmlString = this.toString(true, true);
    }

    private void buildResponse(String string, String string2, Status status, String string3, List list) throws SAMLException {
        if (string == null || string.equals("")) {
            this.responseID = SAMLUtils.generateID();
            if (this.responseID == null) {
                throw new SAMLRequesterException(SAMLUtils.bundle.getString("errorGenerateID"));
            }
        } else {
            this.responseID = string;
        }
        this.inResponseTo = string2;
        this.recipient = string3;
        this.issueInstant = new Date();
        if (status == null) {
            SAMLUtils.debug.message("Response: missing <Status>.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
        this.status = status;
        if (list != null && list != Collections.EMPTY_LIST) {
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                Object e = list.get(n2);
                if (!(e instanceof Assertion)) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Response: Wrong input for Assertion.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
                ++n2;
            }
            this.assertions = list;
        }
    }

    public Response(String string, String string2, Status status, List list) throws SAMLException {
        this.buildResponse(string, string2, status, null, list);
    }

    public Response(String string, String string2, Status status, String string3, List list) throws SAMLException {
        this.buildResponse(string, string2, status, string3, list);
    }

    public Response(String string, Status status, String string2, List list) throws SAMLException {
        this.buildResponse(string, null, status, string2, list);
    }

    public Response(String string, Status status, List list) throws SAMLException {
        this.buildResponse(string, null, status, null, list);
    }

    public static Response parseXML(String string) throws SAMLException {
        Document document = XMLUtils.toDOMDocument(string);
        Element element = document.getDocumentElement();
        return new Response(element);
    }

    public static Response parseXML(InputStream inputStream) throws SAMLException {
        Document document = XMLUtils.toDOMDocument(inputStream);
        Element element = document.getDocumentElement();
        return new Response(element);
    }

    public Response(Element element) throws SAMLException {
        Object object;
        if (element == null) {
            SAMLUtils.debug.message("Response(Element): null input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        String string = null;
        string = element.getLocalName();
        if (string == null || !string.equals("Response")) {
            SAMLUtils.debug.message("Response(Element): wrong input.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        List list = XMLUtils.getElementsByTagNameNS1(element, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        int n = list.size();
        if (n == 1) {
            object = XMLSignatureManager.getInstance();
            this.valid = ((XMLSignatureManager)object).verifyXMLSignature(element);
            if (!this.valid && SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Response(Element): couldn't verify Response's signature.");
            }
            this.xmlString = XMLUtils.print(element);
            this.signed = true;
        } else if (n != 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Response(Element): included more than one Signature element.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
        }
        this.responseID = element.getAttribute("ResponseID");
        if (this.responseID == null || this.responseID.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Response.parseXML: Reponse doesn't have ResponseID.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute"));
        }
        if (element.hasAttribute("InResponseTo")) {
            this.inResponseTo = element.getAttribute("InResponseTo");
        }
        this.parseMajorVersion(element.getAttribute("MajorVersion"));
        this.parseMinorVersion(element.getAttribute("MinorVersion"));
        if (element.hasAttribute("Recipient")) {
            this.recipient = element.getAttribute("Recipient");
        }
        if ((object = element.getAttribute("IssueInstant")) == null || ((String)object).equals("")) {
            SAMLUtils.debug.message("Response(Element): missing IssueInstant");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute"));
        }
        try {
            this.issueInstant = SAMLUtils.stringToDate((String)object);
        }
        catch (Exception exception) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Resposne(Element): could not parse IssueInstant:" + exception.getMessage());
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        NodeList nodeList = element.getChildNodes();
        int n2 = nodeList.getLength();
        int n3 = 0;
        while (n3 < n2) {
            Node node = nodeList.item(n3);
            String string2 = node.getLocalName();
            if (string2 != null) {
                if (string2.equals("Signature")) {
                    this.signature = (Element)node;
                } else if (string2.equals("Status")) {
                    if (this.status != null) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("Response: included more than one <Status>");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
                    }
                    this.status = new Status((Element)node);
                } else if (string2.equals("Assertion")) {
                    if (this.assertions == Collections.EMPTY_LIST) {
                        this.assertions = new ArrayList();
                    }
                    this.assertions.add(new Assertion((Element)node));
                } else {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Response: included wrong element:" + string2);
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                }
            }
            ++n3;
        }
        if (this.status == null) {
            SAMLUtils.debug.message("Response: missing element <Status>.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("oneElement"));
        }
    }

    private void parseMajorVersion(String string) throws SAMLException {
        try {
            this.majorVersion = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Response(Element): invalid MajorVersion", (Throwable)numberFormatException);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        if (this.majorVersion != 1) {
            if (this.majorVersion > 1) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Response(Element):MajorVersion of the Response is too high.");
                }
                throw new SAMLVersionMismatchException(SAMLUtils.bundle.getString("responseVersionTooHigh"));
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Response(Element):MajorVersion of the Response is too low.");
            }
            throw new SAMLVersionMismatchException(SAMLUtils.bundle.getString("responseVersionTooLow"));
        }
    }

    private void parseMinorVersion(String string) throws SAMLException {
        try {
            this.minorVersion = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Response(Element): invalid MinorVersion", (Throwable)numberFormatException);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        if (this.minorVersion != 0) {
            if (this.minorVersion > 0) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Response(Element):MinorVersion of the Response is too high.");
                }
                throw new SAMLVersionMismatchException(SAMLUtils.bundle.getString("responseVersionTooHigh"));
            }
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Response(Element):MinorVersion of the Response is too low.");
            }
            throw new SAMLVersionMismatchException(SAMLUtils.bundle.getString("responseVersionTooLow"));
        }
    }

    public List getAssertion() {
        return this.assertions;
    }

    public boolean addAssertion(Assertion assertion) {
        if (this.signed) {
            return false;
        }
        if (assertion == null) {
            return false;
        }
        if (this.assertions == null || this.assertions == Collections.EMPTY_LIST) {
            this.assertions = new ArrayList();
        }
        this.assertions.add(assertion);
        return true;
    }

    public Status getStatus() {
        return this.status;
    }

    public boolean setStatus(Status status) {
        if (this.signed) {
            return false;
        }
        if (status == null) {
            return false;
        }
        this.status = status;
        return true;
    }

    public boolean setSignature(Element element) {
        this.signatureString = XMLUtils.print(element);
        return super.setSignature(element);
    }

    public String toString() {
        return this.toString(true, true);
    }

    public String toString(boolean bl, boolean bl2) {
        return this.toString(bl, bl2, false);
    }

    public String toString(boolean bl, boolean bl2, boolean bl3) {
        if (this.signed && this.xmlString != null) {
            return this.xmlString;
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        if (bl3) {
            stringBuffer.append("<?xml version=\"1.0\" encoding=\"").append("UTF-8").append("\" ?>\n");
        }
        String string = "";
        String string2 = "";
        if (bl) {
            string = "samlp:";
        }
        if (bl2) {
            string2 = " xmlns:samlp=\"urn:oasis:names:tc:SAML:1.0:protocol\"";
        }
        String string3 = null;
        try {
            string3 = SAMLUtils.dateToString(this.issueInstant);
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("Request.toString: could not convert issueInstant to String: ", (Throwable)exception);
        }
        stringBuffer.append("<").append(string).append("Response").append(string2).append(" ResponseID=\"").append(this.responseID).append("\"");
        if (this.inResponseTo != null) {
            stringBuffer.append(" InResponseTo=\"").append(this.inResponseTo).append("\"");
        }
        stringBuffer.append(" MajorVersion=\"").append(this.majorVersion).append("\"").append(" MinorVersion=\"").append(this.minorVersion).append("\"").append(" IssueInstant=\"").append(string3).append("\"");
        if (this.recipient != null) {
            stringBuffer.append(" Recipient=\"").append(this.recipient).append("\"");
        }
        stringBuffer.append(">\n");
        if (this.signed) {
            if (this.signatureString != null) {
                stringBuffer.append(this.signatureString);
            } else if (this.signature != null) {
                this.signatureString = XMLUtils.print(this.signature);
                stringBuffer.append(this.signatureString);
            }
        }
        stringBuffer.append(this.status.toString(bl, false));
        if (this.assertions != null && this.assertions != Collections.EMPTY_LIST) {
            Iterator iterator = this.assertions.iterator();
            while (iterator.hasNext()) {
                stringBuffer.append(((Assertion)iterator.next()).toString(true, true));
            }
        }
        stringBuffer.append("</").append(string).append("Response>\n");
        return stringBuffer.toString();
    }
}

