/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.plugins;

import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.PolicyEvaluator;
import com.sun.identity.saml.AssertionManager;
import com.sun.identity.saml.AssertionManagerClient;
import com.sun.identity.saml.assertion.Action;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.assertion.Attribute;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.Evidence;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.XMLUtils;
import com.sun.identity.saml.plugins.ActionMapper;
import com.sun.identity.saml.protocol.AuthorizationDecisionQuery;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;

public class DefaultActionMapper
implements ActionMapper {
    public String getSSOTokenID(AuthorizationDecisionQuery authorizationDecisionQuery) {
        if (authorizationDecisionQuery == null) {
            return null;
        }
        SubjectConfirmation subjectConfirmation = authorizationDecisionQuery.getSubject().getSubjectConfirmation();
        if (subjectConfirmation == null) {
            return null;
        }
        if (!SAMLUtils.isCorrectConfirmationMethod(subjectConfirmation)) {
            return null;
        }
        Element element = subjectConfirmation.getSubjectConfirmationData();
        return XMLUtils.getElementString(element);
    }

    public Assertion getSSOAssertion(AuthorizationDecisionQuery authorizationDecisionQuery, String string) {
        block13: {
            if (authorizationDecisionQuery == null) {
                return null;
            }
            Assertion assertion = null;
            Evidence evidence = authorizationDecisionQuery.getEvidence();
            if (evidence != null) {
                Object object;
                Set set = evidence.getAssertion();
                if (set != null) {
                    object = set.iterator();
                    while (object.hasNext()) {
                        assertion = (Assertion)object.next();
                        if (!SAMLUtils.isAuthNAssertion(assertion)) continue;
                        return assertion;
                    }
                }
                if ((object = evidence.getAssertionIDReference()) != null) {
                    Iterator iterator = object.iterator();
                    try {
                        AssertionManager assertionManager = AssertionManager.getInstance();
                        AssertionIDReference assertionIDReference = null;
                        while (iterator.hasNext()) {
                            assertionIDReference = (AssertionIDReference)iterator.next();
                            try {
                                String string2 = SAMLUtils.getServerURL(assertionIDReference.getAssertionIDReference());
                                if (string2 != null) {
                                    if (SAMLUtils.debug.messageEnabled()) {
                                        SAMLUtils.debug.message("DefaultActionMapper: calling another in lb site:" + string2);
                                    }
                                    AssertionManagerClient assertionManagerClient = new AssertionManagerClient(SAMLUtils.getFullServiceURL(string2));
                                    assertion = assertionManagerClient.getAssertion(assertionIDReference, string);
                                } else {
                                    assertion = assertionManager.getAssertion(assertionIDReference, string);
                                }
                            }
                            catch (Exception exception) {
                                if (!SAMLUtils.debug.messageEnabled()) continue;
                                SAMLUtils.debug.message("DefaultActionMapper.getSSOAssertion: exception when retrieving Assertion from IDRef:" + exception);
                                continue;
                            }
                            if (!SAMLUtils.isAuthNAssertion(assertion)) continue;
                            return assertion;
                        }
                    }
                    catch (Exception exception) {
                        if (!SAMLUtils.debug.messageEnabled()) break block13;
                        SAMLUtils.debug.message("DefaultActionMapper: Couldn't obtain AssertionManager instance:" + exception);
                    }
                }
            }
        }
        return null;
    }

    public Map getAuthorizationDecisions(AuthorizationDecisionQuery authorizationDecisionQuery, SSOToken sSOToken, String string) throws SAMLException {
        if (authorizationDecisionQuery == null || sSOToken == null) {
            SAMLUtils.debug.message("DefaultActionMapper: null input.");
            throw new SAMLException(SAMLUtils.bundle.getString("nullInput"));
        }
        Evidence evidence = authorizationDecisionQuery.getEvidence();
        Subject subject = authorizationDecisionQuery.getSubject();
        Map map = this.convertEvidence(evidence, subject, string);
        ArrayList<Action> arrayList = new ArrayList<Action>();
        ArrayList<Action> arrayList2 = new ArrayList<Action>();
        List list = authorizationDecisionQuery.getAction();
        Iterator iterator = list.iterator();
        PolicyEvaluator policyEvaluator = null;
        String string2 = authorizationDecisionQuery.getResource();
        Action action = null;
        String string3 = null;
        while (iterator.hasNext()) {
            action = (Action)iterator.next();
            string3 = action.getNameSpace();
            if (string3 == null || !string3.equals("urn:oasis:names:tc:SAML:1.0:ghpp")) continue;
            try {
                boolean bl;
                if (policyEvaluator == null) {
                    policyEvaluator = new PolicyEvaluator("iPlanetAMWebAgentService");
                }
                if (bl = policyEvaluator.isAllowed(sSOToken, string2, action.getAction(), map)) {
                    arrayList.add(action);
                    continue;
                }
                arrayList2.add(action);
            }
            catch (Exception exception) {
                if (!SAMLUtils.debug.messageEnabled()) continue;
                SAMLUtils.debug.message("DefaultActionMapper: Exception from policy:" + exception);
            }
        }
        HashMap<String, List> hashMap = new HashMap<String, List>();
        if (!arrayList.isEmpty()) {
            hashMap.put("Permit", arrayList);
        } else if (!arrayList2.isEmpty()) {
            hashMap.put("Deny", arrayList2);
        } else {
            hashMap.put("Indeterminate", list);
        }
        return hashMap;
    }

    private Map convertEvidence(Evidence evidence, Subject subject, String string) {
        Object object;
        Object object2;
        String string2;
        String string3;
        Assertion assertion;
        Iterator iterator;
        HashMap hashMap;
        block12: {
            hashMap = new HashMap();
            if (evidence == null) {
                return hashMap;
            }
            iterator = null;
            assertion = null;
            string3 = (String)SAMLServiceManager.getAttribute("mysitename");
            string2 = null;
            Set set = evidence.getAssertionIDReference();
            if (set != null) {
                iterator = set.iterator();
                try {
                    object2 = AssertionManager.getInstance();
                    object = null;
                    while (iterator.hasNext()) {
                        object = (AssertionIDReference)iterator.next();
                        try {
                            String string4 = SAMLUtils.getServerURL(((AssertionIDReference)object).getAssertionIDReference());
                            if (string4 != null) {
                                if (SAMLUtils.debug.messageEnabled()) {
                                    SAMLUtils.debug.message("DefaultActionMapper:calling another server in lb site:" + string4);
                                }
                                AssertionManagerClient assertionManagerClient = new AssertionManagerClient(SAMLUtils.getFullServiceURL(string4));
                                assertion = assertionManagerClient.getAssertion((AssertionIDReference)object, string);
                            } else {
                                assertion = ((AssertionManager)object2).getAssertion((AssertionIDReference)object, string);
                            }
                        }
                        catch (Exception exception) {
                            if (!SAMLUtils.debug.messageEnabled()) continue;
                            SAMLUtils.debug.message("DefaultActionMapper: couldn't retrieve assertion from idRef:" + exception);
                            continue;
                        }
                        this.addEnvParamsFromAssertion(hashMap, assertion, subject);
                    }
                }
                catch (Exception exception) {
                    if (!SAMLUtils.debug.messageEnabled()) break block12;
                    SAMLUtils.debug.message("DefaultActionMapper: Couldn't obtain AssertionManager instance:" + exception);
                }
            }
        }
        if ((object2 = evidence.getAssertion()) != null) {
            iterator = object2.iterator();
            while (iterator.hasNext()) {
                assertion = (Assertion)iterator.next();
                if (!assertion.isSignatureValid() || !assertion.isTimeValid()) continue;
                string2 = assertion.getIssuer();
                if ((string3 == null || !string3.equals(string2)) && (object = SAMLUtils.getSourceSite(string2)) == null) continue;
                this.addEnvParamsFromAssertion(hashMap, assertion, subject);
            }
        }
        return hashMap;
    }

    private void addEnvParamsFromAssertion(Map map, Assertion assertion, Subject subject) {
        Set set = assertion.getStatement();
        Statement statement = null;
        Iterator iterator = null;
        List list = null;
        Iterator iterator2 = null;
        Attribute attribute = null;
        Element element = null;
        List list2 = null;
        String string = null;
        String string2 = null;
        if (set != null && !set.isEmpty()) {
            iterator = set.iterator();
            while (iterator.hasNext()) {
                statement = (Statement)iterator.next();
                if (statement.getStatementType() != 3 || !subject.equals(((AttributeStatement)statement).getSubject())) continue;
                list = ((AttributeStatement)statement).getAttribute();
                iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    attribute = (Attribute)iterator2.next();
                    try {
                        list2 = attribute.getAttributeValue();
                    }
                    catch (Exception exception) {
                        SAMLUtils.debug.error("DefaultActionMapper.addEnvParamsFromAssertion: cannot obtain attribute value:", (Throwable)exception);
                        continue;
                    }
                    string = attribute.getAttributeName();
                    element = (Element)list2.get(0);
                    if (list2.size() == 1 && !XMLUtils.hasElementChild(element)) {
                        string2 = XMLUtils.getElementValue(element);
                        try {
                            map.put(string, string2);
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                    try {
                        map.put(string, list2);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

