/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.common;

import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtils {
    public static Document toDOMDocument(String string) throws SAMLException {
        byte[] byArray;
        int n = string.indexOf("encoding=");
        String string2 = "UTF-8";
        if (n != -1) {
            int n2;
            int n3 = string.indexOf(34, n);
            int n4 = n2 = n3 == -1 ? n3 : string.indexOf(34, n3 + 1);
            if (n3 != -1 && n2 != -1) {
                string2 = string.substring(n3 + 1, n2);
            }
        }
        try {
            byArray = string.getBytes(string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SAMLUtils.debug.message("XMLUtils encoding is not supported:", (Throwable)unsupportedEncodingException);
            throw new SAMLResponderException(unsupportedEncodingException.getMessage());
        }
        return XMLUtils.toDOMDocument(new ByteArrayInputStream(byArray));
    }

    public static Document toDOMDocument(InputStream inputStream) throws SAMLException {
        if (inputStream == null) {
            SAMLUtils.debug.message("XMLUtils: The input stream is null.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            documentBuilderFactory.setValidating(false);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            documentBuilder.setErrorHandler(new SAMLErrorHandler());
            return documentBuilder.parse(inputStream);
        }
        catch (Exception exception) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Can't parse the document:", (Throwable)exception);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("parseError"));
        }
    }

    public static boolean hasElementChild(Node node) {
        block4: {
            try {
                NodeList nodeList = node.getChildNodes();
                Node node2 = null;
                int n = nodeList.getLength();
                int n2 = 0;
                while (n2 < n) {
                    node2 = nodeList.item(n2);
                    if (node2.getNodeType() == 1) {
                        return true;
                    }
                    ++n2;
                }
            }
            catch (Exception exception) {
                if (!SAMLUtils.debug.messageEnabled()) break block4;
                SAMLUtils.debug.message("SAMLErrorHandler::hasElementChild", (Throwable)exception);
            }
        }
        return false;
    }

    public static String getElementValue(Element element) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        try {
            NodeList nodeList = element.getChildNodes();
            Node node = null;
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                node = nodeList.item(n2);
                if (node.getNodeType() == 3) {
                    stringBuffer.append(node.getNodeValue());
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SAMLErrorHandler::getElementValue", (Throwable)exception);
            }
            return null;
        }
        return stringBuffer.toString().trim();
    }

    public static String getElementString(Element element) {
        if (element == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(1000);
        try {
            NodeList nodeList = element.getChildNodes();
            Node node = null;
            int n = 0;
            int n2 = nodeList.getLength();
            while (n < n2) {
                node = nodeList.item(n);
                if (node.getNodeType() != 3) {
                    return null;
                }
                stringBuffer.append(node.getNodeValue());
                ++n;
            }
        }
        catch (Exception exception) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("SAMLErrorHandler::getElementString", (Throwable)exception);
            }
            return null;
        }
        return stringBuffer.toString().trim();
    }

    public static List getElementsByTagNameNS1(Element element, String string, String string2) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        if (element != null) {
            NodeList nodeList = element.getChildNodes();
            int n = nodeList.getLength();
            Node node = null;
            int n2 = 0;
            while (n2 < n) {
                node = nodeList.item(n2);
                String string3 = node.getLocalName();
                String string4 = node.getNamespaceURI();
                if (string3 != null && string3.equals(string2) && string4 != null && string4.equals(string)) {
                    arrayList.add(node);
                }
                ++n2;
            }
        }
        return arrayList;
    }

    public static String print(Node node) {
        if (node == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(100);
        short s = node.getNodeType();
        switch (s) {
            case 1: {
                Object object;
                stringBuffer.append('<');
                stringBuffer.append(node.getNodeName());
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = namedNodeMap.getLength();
                int n2 = 0;
                while (n2 < n) {
                    object = (Attr)namedNodeMap.item(n2);
                    stringBuffer.append(' ');
                    stringBuffer.append(object.getNodeName());
                    stringBuffer.append("=\"");
                    stringBuffer.append(object.getNodeValue());
                    stringBuffer.append('\"');
                    ++n2;
                }
                stringBuffer.append('>');
                object = node.getChildNodes();
                if (object == null) break;
                int n3 = object.getLength();
                int n4 = 0;
                while (n4 < n3) {
                    stringBuffer.append(XMLUtils.print(object.item(n4)));
                    ++n4;
                }
                break;
            }
            case 5: {
                NodeList nodeList = node.getChildNodes();
                if (nodeList == null) break;
                int n = nodeList.getLength();
                int n5 = 0;
                while (n5 < n) {
                    stringBuffer.append(XMLUtils.print(nodeList.item(n5)));
                    ++n5;
                }
                break;
            }
            case 4: {
                stringBuffer.append(node.getNodeValue());
                break;
            }
            case 3: {
                stringBuffer.append(node.getNodeValue());
                break;
            }
            case 7: {
                stringBuffer.append("<?");
                stringBuffer.append(node.getNodeName());
                String string = node.getNodeValue();
                if (string != null && string.length() > 0) {
                    stringBuffer.append(' ');
                    stringBuffer.append(string);
                }
                stringBuffer.append("?>");
            }
        }
        if (s == 1) {
            stringBuffer.append("</");
            stringBuffer.append(node.getNodeName());
            stringBuffer.append('>');
        }
        return stringBuffer.toString();
    }

    public static String normalize(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            switch (c) {
                case '<': {
                    stringBuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    break;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    break;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    break;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    break;
                }
                default: {
                    stringBuffer.append(c);
                }
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static class SAMLErrorHandler
    implements ErrorHandler {
        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        private String getLocationString(SAXParseException sAXParseException) {
            StringBuffer stringBuffer = new StringBuffer(100);
            String string = sAXParseException.getSystemId();
            if (string != null) {
                int n = string.lastIndexOf(47);
                if (n != -1) {
                    string = string.substring(n + 1);
                }
                stringBuffer.append(string);
            }
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getLineNumber());
            stringBuffer.append(':');
            stringBuffer.append(sAXParseException.getColumnNumber());
            return stringBuffer.toString();
        }
    }
}

