/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.sun.identity.saml.assertion.AttributeDesignator;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.XMLUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class Attribute
extends AttributeDesignator {
    protected List _attributeValue;

    public Attribute(Element element) throws SAMLException {
        Object object;
        if (element == null) {
            SAMLUtils.debug.message("Attribute: Input is null.");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        String string = null;
        string = element.getLocalName();
        if (string == null || !string.equals("Attribute")) {
            SAMLUtils.debug.message("Attribute: wrong input");
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        int n = 0;
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n2 = namedNodeMap.getLength();
        n = 0;
        while (n < n2) {
            object = namedNodeMap.item(n);
            if (object.getNodeType() == 2) {
                String string2 = object.getLocalName();
                if (string2 == null || string2.equals("")) {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Attribute:Attribute Name is either null or empty.");
                    }
                    throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
                }
                if (string2.equals("AttributeName")) {
                    this._attributeName = ((Attr)object).getValue().trim();
                } else if (string2.equals("AttributeNamespace")) {
                    this._attributeNameSpace = ((Attr)object).getValue().trim();
                }
            }
            ++n;
        }
        if (this._attributeName == null || this._attributeName.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Attribute: AttributeName is required attribute");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute"));
        }
        if (this._attributeNameSpace == null || this._attributeNameSpace.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Attribute: AttributeNamespace is required attribute");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute"));
        }
        object = element.getChildNodes();
        int n3 = object.getLength();
        if (n3 > 0) {
            n = 0;
            while (n < n3) {
                Node node = object.item(n);
                if (node.getNodeType() == 1) {
                    String string3 = node.getLocalName();
                    String string4 = node.getNamespaceURI();
                    if (string3 == null || string3.equals("") || string4 == null || string4.equals("")) {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("Attribute: The tag name or tag namespace of child element is either null or empty.");
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
                    }
                    if (string3.equals("AttributeValue") && string4.equals("urn:oasis:names:tc:SAML:1.0:assertion")) {
                        if (this._attributeValue == null) {
                            this._attributeValue = new ArrayList();
                        }
                        if (!this._attributeValue.add((Element)node)) {
                            if (SAMLUtils.debug.messageEnabled()) {
                                SAMLUtils.debug.message("Attribute: failed to add to the attribute value list.");
                            }
                            throw new SAMLRequesterException(SAMLUtils.bundle.getString("addListError"));
                        }
                    } else {
                        if (SAMLUtils.debug.messageEnabled()) {
                            SAMLUtils.debug.message("Attribute:wrong element:" + string3);
                        }
                        throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
                    }
                }
                ++n;
            }
        }
        if (this._attributeValue == null || this._attributeValue.isEmpty()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Attribute: should contain at least one AttributeValue.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingElement"));
        }
    }

    public Attribute(String string, String string2, List list) throws SAMLException {
        super(string, string2);
        if (list == null || list.isEmpty()) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Attribute: AttributeValue isrequired.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (this._attributeValue == null) {
            this._attributeValue = new ArrayList();
        }
        Iterator iterator = list.iterator();
        String string3 = null;
        while (iterator.hasNext()) {
            string3 = ((Element)iterator.next()).getLocalName();
            if (string3 != null && string3.equals("AttributeValue")) continue;
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AttributeValue: wrong input.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        this._attributeValue = list;
    }

    public Attribute(String string, String string2, String string3) throws SAMLException {
        super(string, string2);
        this.addAttributeValue(string3);
    }

    public List getAttributeValue() throws SAMLException {
        return this._attributeValue;
    }

    public void addAttributeValue(String string) throws SAMLException {
        if (string == null || string.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("addAttributeValue: Input is null");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        StringBuffer stringBuffer = new StringBuffer(300);
        stringBuffer.append("<").append("saml:").append("AttributeValue").append(" xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"").append(">").append(string).append("</").append("saml:").append("AttributeValue>");
        try {
            Element element = XMLUtils.toDOMDocument(stringBuffer.toString().trim()).getDocumentElement();
            if (this._attributeValue == null) {
                this._attributeValue = new ArrayList();
            }
            if (!this._attributeValue.add(element)) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Attribute: failed to add to the attribute value list.");
                }
                throw new SAMLRequesterException(SAMLUtils.bundle.getString("addListError"));
            }
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("addAttributeValue error", (Throwable)exception);
            throw new SAMLRequesterException("Exception in addAttributeValue" + exception.getMessage());
        }
    }

    public void addAttributeValue(Element element) throws SAMLException {
        if (element == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("addAttributeValue: input  is null.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        String string = element.getLocalName();
        if (string == null || !string.equals("AttributeValue")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("AttributeValue: wrong input.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput"));
        }
        try {
            if (this._attributeValue == null) {
                this._attributeValue = new ArrayList();
            }
            if (!this._attributeValue.add(element)) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Attribute: failed to add to the attribute value list.");
                }
                throw new SAMLRequesterException(SAMLUtils.bundle.getString("addListError"));
            }
        }
        catch (Exception exception) {
            SAMLUtils.debug.error("addAttributeValue error", (Throwable)exception);
            throw new SAMLRequesterException("Exception in addAttributeValue" + exception.getMessage());
        }
    }

    public String toString() {
        return this.toString(true, false);
    }

    public String toString(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(1000);
        String string = "";
        String string2 = "";
        if (bl) {
            string = "saml:";
        }
        if (bl2) {
            string2 = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        stringBuffer.append("<").append(string).append("Attribute").append(string2).append(" AttributeName=\"").append(this._attributeName).append("\" AttributeNamespace=\"").append(this._attributeNameSpace).append("\">\n");
        Iterator iterator = this._attributeValue.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(XMLUtils.print((Element)iterator.next())).append("\n");
        }
        stringBuffer.append("</").append(string).append("Attribute>\n");
        return stringBuffer.toString();
    }
}

