/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.saml.assertion;

import com.iplanet.am.util.SystemProperties;
import com.sun.identity.saml.assertion.Advice;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.assertion.AttributeStatement;
import com.sun.identity.saml.assertion.AuthenticationStatement;
import com.sun.identity.saml.assertion.AuthorizationDecisionStatement;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.Statement;
import com.sun.identity.saml.common.SAMLConstants;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLRequesterException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.SAMLVersionMismatchException;
import com.sun.identity.saml.common.XMLUtils;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Assertion {
    static SAMLConstants sc;
    private Set _statements = Collections.synchronizedSet(new HashSet());
    private int _majorVersion = 1;
    private int _minorVersion = 0;
    private AssertionIDReference _assertionID = null;
    private String _issuer = null;
    private Date _issueInstant;
    private Conditions _conditions;
    private Advice _advice;
    protected String xmlString = null;
    protected String signatureString = null;
    protected Element signature = null;
    protected boolean signed = false;
    protected boolean valid = true;

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isSignatureValid() {
        return this.valid;
    }

    public void signXML() throws SAMLException {
        if (this.signed) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion.signXML: the assertion is already signed.");
            }
            throw new SAMLException(SAMLUtils.bundle.getString("alreadySigned"));
        }
        String string = SystemProperties.get((String)"com.sun.identity.saml.xmlsig.certalias");
        if (string == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assetion.signXML: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(SAMLUtils.bundle.getString("cannotFindCertAlias"));
        }
        XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
        this.signatureString = xMLSignatureManager.signXML(this.toString(true, true), string);
        this.signature = XMLUtils.toDOMDocument(this.signatureString).getDocumentElement();
        this.signed = true;
        this.xmlString = this.toString(true, true);
    }

    public Element getSignature() {
        return this.signature;
    }

    public boolean setSignature(Element element) {
        if (this.signed) {
            return false;
        }
        if (element == null) {
            return false;
        }
        this.signature = element;
        this.signed = true;
        this.signatureString = XMLUtils.print(element);
        return true;
    }

    protected Assertion() {
    }

    public Assertion(Element element) throws SAMLException {
        Object object;
        Element element2 = element;
        String string = element2.getLocalName();
        if (string == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: local name missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (!string.equals("Assertion")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: invalid root element");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidElement") + ":" + string);
        }
        String string2 = element2.getAttribute("Issuer");
        if (string2 == null || string2.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: Issuer missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute") + ":" + "Issuer");
        }
        this._issuer = string2;
        List list = XMLUtils.getElementsByTagNameNS1(element, "http://www.w3.org/2000/09/xmldsig#", "Signature");
        int n = list.size();
        if (n == 1) {
            Map map = (Map)SAMLServiceManager.getAttribute("iplanet-am-saml-partner-urls");
            object = (SAMLServiceManager.SOAPEntry)map.get(this._issuer);
            String string3 = null;
            if (object != null) {
                string3 = ((SAMLServiceManager.SOAPEntry)object).getCertAlias();
            }
            XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
            this.valid = xMLSignatureManager.verifyXMLSignature(element, string3);
            if (!this.valid && SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion(Element): couldn't verify Assertion's signature.");
            }
            this.xmlString = XMLUtils.print(element);
            this.signed = true;
        } else if (n != 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion(Element): included more than one Signature element.");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("moreElement"));
        }
        string2 = element2.getAttribute("MajorVersion");
        if (string2 == null || string2.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: MajorVersion missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute") + ":" + "MajorVersion");
        }
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            SAMLUtils.debug.error("Assertion: invalid integer in MajorVersion", (Throwable)numberFormatException);
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidNumber") + ":" + "MajorVersion");
        }
        if (n2 != 1) {
            if (n2 < 1) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Assertion: MajorVersion too low");
                }
                throw new SAMLVersionMismatchException(SAMLUtils.bundle.getString("assertionVersionTooLow") + ":" + "MajorVersion");
            }
            if (n2 > 1) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Assertion: MajorVersion too high");
                }
                throw new SAMLVersionMismatchException(SAMLUtils.bundle.getString("assertionVersionTooHigh") + ":" + "MajorVersion");
            }
            this._minorVersion = Integer.parseInt(string2);
        }
        if ((string2 = element2.getAttribute("MinorVersion")) == null || string2.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: MinorVersion missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute") + ":" + "MinorVersion");
        }
        n2 = 0;
        try {
            n2 = Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            SAMLUtils.debug.error("Assertion: invalid integer in MinorVersion", (Throwable)numberFormatException);
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("invalidNumber") + ":" + "MinorVersion");
        }
        if (n2 != 0) {
            if (n2 < 0) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Assertion: MinorVersion too low");
                }
                throw new SAMLVersionMismatchException(SAMLUtils.bundle.getString("assertionVersionTooLow"));
            }
            if (n2 > 0) {
                if (SAMLUtils.debug.messageEnabled()) {
                    SAMLUtils.debug.message("Assertion: MinorVersion too high");
                }
                throw new SAMLVersionMismatchException(SAMLUtils.bundle.getString("assertionVersionTooHigh") + ":" + "MinorVersion");
            }
            this._minorVersion = Integer.parseInt(string2);
        }
        if ((string2 = element2.getAttribute("AssertionID")) == null || string2.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: AssertionID missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute") + ":" + "AssertionID");
        }
        this._assertionID = new AssertionIDReference(string2);
        string2 = element2.getAttribute("IssueInstant");
        if (string2 == null || string2.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: IssueInstant missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingAttribute") + ":" + "IssueInstant");
        }
        try {
            this._issueInstant = SAMLUtils.stringToDate(string2);
        }
        catch (ParseException parseException) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: could not parse IssueInstant", (Throwable)parseException);
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("wrongInput" + parseException.getMessage()));
        }
        n2 = 0;
        object = element.getChildNodes();
        int n3 = object.getLength();
        int n4 = 0;
        while (n4 < n3) {
            Node node = object.item(n4);
            if (node.getNodeType() == 1) {
                String string4 = node.getLocalName();
                if (string4.equals("Conditions")) {
                    this._conditions = new Conditions((Element)node);
                } else if (string4.equals("Advice")) {
                    this._advice = new Advice((Element)node);
                } else if (string4.equals("AuthenticationStatement")) {
                    this._statements.add(new AuthenticationStatement((Element)node));
                    n2 = 1;
                } else if (string4.equals("AuthorizationDecisionStatement")) {
                    this._statements.add(new AuthorizationDecisionStatement((Element)node));
                    n2 = 1;
                } else if (string4.equals("AttributeStatement")) {
                    this._statements.add(new AttributeStatement((Element)node));
                    n2 = 1;
                } else if (string4.equals("Signature")) {
                    this.signature = (Element)node;
                } else {
                    if (SAMLUtils.debug.messageEnabled()) {
                        SAMLUtils.debug.message("Assertion: invalid element in Assertion");
                    }
                    throw new SAMLRequesterException("invalidElement");
                }
            }
            ++n4;
        }
        if (n2 == 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: mandatory statement missing");
            }
            throw new SAMLRequesterException("missingStatement");
        }
    }

    public boolean isTimeValid() {
        if (this._conditions == null) {
            return true;
        }
        return this._conditions.checkDateValidity(System.currentTimeMillis());
    }

    public Assertion(String string, String string2, Date date, Set set) throws SAMLException {
        if (string2 == null || string2.equals("")) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion:  null input specified");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (set.size() == 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion:mandatory statement missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingStatement"));
        }
        this._statements.addAll(set);
        this._assertionID = new AssertionIDReference(string);
        if (string2 != null) {
            this._issuer = string2;
        }
        this._issueInstant = date != null ? date : new Date();
    }

    public Assertion(String string, String string2, Date date, Conditions conditions, Set set) throws SAMLException {
        if (string2 == null || string2.equals("") || conditions == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion:  null input specified");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (set.size() == 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion:mandatory statement missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingStatement"));
        }
        this._statements.addAll(set);
        this._assertionID = new AssertionIDReference(string);
        if (string2 != null) {
            this._issuer = string2;
        }
        this._issueInstant = date != null ? date : new Date();
        if (conditions != null) {
            this._conditions = conditions;
        }
    }

    public Assertion(String string, String string2, Date date, Conditions conditions, Advice advice, Set set) throws SAMLException {
        if (string2 == null || string2.equals("") || conditions == null) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion:  null input specified");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("nullInput"));
        }
        if (set.size() == 0) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion:mandatory statement missing");
            }
            throw new SAMLRequesterException(SAMLUtils.bundle.getString("missingStatement"));
        }
        this._statements.addAll(set);
        this._assertionID = new AssertionIDReference(string);
        if (string2 != null) {
            this._issuer = string2;
        }
        this._issueInstant = date != null ? date : new Date();
        if (conditions != null) {
            this._conditions = conditions;
        }
        if (advice != null) {
            this._advice = advice;
        }
    }

    public boolean addStatement(Statement statement) {
        if (this.signed) {
            return false;
        }
        if (statement == null) {
            return false;
        }
        this._statements.add(statement);
        return true;
    }

    protected boolean setIssueInstant(Date date) {
        if (this.signed) {
            return false;
        }
        if (date == null) {
            return false;
        }
        this._issueInstant = date;
        return true;
    }

    protected boolean setAssertionID(String string) {
        if (this.signed) {
            return false;
        }
        if (string == null) {
            return false;
        }
        try {
            this._assertionID = new AssertionIDReference(string);
        }
        catch (Exception exception) {
            if (SAMLUtils.debug.messageEnabled()) {
                SAMLUtils.debug.message("Assertion: Exception in setting assertion id: " + exception.getMessage());
            }
            return false;
        }
        return true;
    }

    protected boolean setIssuer(String string) {
        if (this.signed) {
            return false;
        }
        if (string == null || string.equals("")) {
            return false;
        }
        this._issuer = string;
        return true;
    }

    public boolean setAdvice(Advice advice) {
        if (this.signed) {
            return false;
        }
        if (advice == null) {
            return false;
        }
        this._advice = advice;
        return true;
    }

    public boolean setConditions(Conditions conditions) {
        if (this.signed) {
            return false;
        }
        if (conditions == null) {
            return false;
        }
        this._conditions = conditions;
        return true;
    }

    public int getMajorVersion() {
        return this._majorVersion;
    }

    public int getMinorVersion() {
        return this._minorVersion;
    }

    public Date getIssueInstant() {
        return this._issueInstant;
    }

    public String getIssuer() {
        return this._issuer;
    }

    public String getAssertionID() {
        return this._assertionID.getAssertionIDReference();
    }

    public Conditions getConditions() {
        return this._conditions;
    }

    public Advice getAdvice() {
        return this._advice;
    }

    public Set getStatement() {
        return this._statements;
    }

    public String toString() {
        String string = this.toString(true, false);
        return string;
    }

    public String toString(boolean bl, boolean bl2) {
        Object object;
        if (this.signed && this.xmlString != null) {
            return this.xmlString;
        }
        StringBuffer stringBuffer = new StringBuffer(3000);
        String string = "";
        String string2 = "";
        if (bl2) {
            string = " xmlns:saml=\"urn:oasis:names:tc:SAML:1.0:assertion\"";
        }
        if (bl) {
            string2 = "saml:";
        }
        String string3 = null;
        if (this._issueInstant != null) {
            try {
                string3 = SAMLUtils.dateToString(this._issueInstant);
            }
            catch (ParseException parseException) {
                SAMLUtils.debug.error("Assertion: could not dateToString  NotBefore", (Throwable)parseException);
            }
        }
        stringBuffer.append("<").append(string2).append("Assertion").append(" ").append(string).append(" ").append("MajorVersion").append("=\"").append(this._majorVersion).append("\"").append(" ").append("MinorVersion").append("=\"").append(this._minorVersion).append("\"").append(" ").append("AssertionID=\"").append(this._assertionID.getAssertionIDReference()).append("\"").append(" ").append("Issuer").append("=\"").append(this._issuer).append("\"").append(" ").append("IssueInstant").append("=\"").append(string3).append("\"").append(" ").append(">").append("\n");
        if (this._conditions != null) {
            stringBuffer.append(this._conditions.toString(bl, false));
        }
        if (this._advice != null) {
            stringBuffer.append(this._advice.toString(bl, false));
        }
        Iterator iterator = this.getStatement().iterator();
        while (iterator.hasNext()) {
            object = (Statement)iterator.next();
            stringBuffer.append(((Statement)object).toString(bl, false));
        }
        if (this.signed && this.signatureString != null) {
            stringBuffer.append(this.signatureString);
        }
        object = SAMLUtils.makeEndElementTagXML("Assertion", bl);
        stringBuffer.append((String)object);
        return stringBuffer.toString();
    }
}

