/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.ConditionDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.interfaces.Condition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class SimpleTimeCondition
implements Condition {
    private static final Debug DEBUG = Debug.getInstance((String)"amPolicy");
    private static final String DATE_FORMAT = "yyyy:MM:dd";
    private static final String[] DAYS_OF_WEEK = new String[]{"", "sun", "mon", "tue", "wed", "thu", "fri", "sat"};
    public static final String START_TIME = "StartTime";
    public static final String END_TIME = "EndTime";
    public static final String START_DAY = "StartDay";
    public static final String END_DAY = "EndDay";
    public static final String START_DATE = "StartDate";
    public static final String END_DATE = "EndDate";
    public static final String ENFORCEMENT_TIME_ZONE = "EnforcementTimeZone";
    public static final String REQUEST_TIME = "requestTime";
    public static final String REQUEST_TIME_ZONE = "requestTimeZone";
    private Map properties;
    private int startTime = -1;
    private int startHour = -1;
    private int startMinute;
    private int endTime = -1;
    private int endHour = -1;
    private int endMinute;
    private int startDay = -1;
    private int endDay = -1;
    private int[] startDate = new int[]{-1, 0, 0};
    private int[] endDate = new int[]{-1, 0, 0};
    private TimeZone enforcementTimeZone;
    private static List propertyNames = new ArrayList(7);

    public List getPropertyNames() {
        return new ArrayList(propertyNames);
    }

    public Syntax getPropertySyntax(String string) {
        return Syntax.NONE;
    }

    public String getDisplayName(String string, Locale locale) throws PolicyException {
        return "";
    }

    public Set getValidValues(String string) throws PolicyException {
        return Collections.EMPTY_SET;
    }

    public void setProperties(Map map) throws PolicyException {
        this.properties = map;
        this.startTime = -1;
        this.startHour = -1;
        this.endTime = -1;
        this.endHour = -1;
        this.startDay = -1;
        this.endDay = -1;
        this.startDate[0] = -1;
        this.endDate[0] = -1;
        this.validateProperties();
    }

    public Map getProperties() {
        return this.properties == null ? null : Collections.unmodifiableMap(this.properties);
    }

    private boolean validateProperties() throws PolicyException {
        Object object;
        Object object2;
        if (this.properties == null || this.properties.keySet() == null) {
            throw new PolicyException("amPolicy", "properties_not_initialized", null, null);
        }
        Set set = this.properties.keySet();
        if (!(set.contains(START_TIME) || set.contains(START_DAY) || set.contains(START_DATE) || set.contains(DAYS_OF_WEEK))) {
            Object[] objectArray = new String[]{"StartTime,StartDay,StartDate" + DAYS_OF_WEEK};
            throw new PolicyException("amPolicy", "at_least_one_of_the_properties_should_be_defined", objectArray, null);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            if (START_TIME.equals(object2) || START_DAY.equals(object2) || START_DATE.equals(object2) || END_TIME.equals(object2) || END_DAY.equals(object2) || END_DATE.equals(object2) || DAYS_OF_WEEK.equals(object2) || ENFORCEMENT_TIME_ZONE.equals(object2)) continue;
            Object[] objectArray = new String[]{object2};
            throw new PolicyException("amPolicy", "attempt_to_set_invalid_property", objectArray, null);
        }
        object2 = (Set)this.properties.get(ENFORCEMENT_TIME_ZONE);
        if (object2 != null && !object2.isEmpty()) {
            object = (String)object2.iterator().next();
            this.enforcementTimeZone = TimeZone.getTimeZone((String)object);
        }
        object = (Set)this.properties.get(START_TIME);
        Set set2 = (Set)this.properties.get(END_TIME);
        if (object != null && set2 == null) {
            Object[] objectArray = new String[]{START_TIME, END_TIME};
            throw new PolicyException("amPolicy", "pair_property_not_defined", objectArray, null);
        }
        if (object == null && set2 != null) {
            Object[] objectArray = new String[]{END_TIME, START_TIME};
            throw new PolicyException("amPolicy", "pair_property_not_defined", objectArray, null);
        }
        if (object != null) {
            this.validateTimes((Set)object, set2);
        }
        Set set3 = (Set)this.properties.get(START_DAY);
        Set set4 = (Set)this.properties.get(END_DAY);
        if (set3 != null && set4 == null) {
            Object[] objectArray = new String[]{START_DAY, END_DAY};
            throw new PolicyException("amPolicy", "pair_property_not_defined", objectArray, null);
        }
        if (set3 == null && set4 != null) {
            Object[] objectArray = new String[]{END_DAY, START_DAY};
            throw new PolicyException("amPolicy", "pair_property_not_defined", objectArray, null);
        }
        if (set3 != null) {
            this.validateDays(set3, set4);
        }
        Set set5 = (Set)this.properties.get(START_DATE);
        Set set6 = (Set)this.properties.get(END_DATE);
        if (set5 != null && set6 == null) {
            Object[] objectArray = new String[]{START_DATE, END_DATE};
            throw new PolicyException("amPolicy", "pair_property_not_defined", objectArray, null);
        }
        if (set5 == null && set6 != null) {
            Object[] objectArray = new String[]{END_DATE, START_DATE};
            throw new PolicyException("amPolicy", "pair_property_not_defined", objectArray, null);
        }
        if (set5 != null) {
            this.validateDates(set5, set6);
        }
        return true;
    }

    private boolean validateDays(Set set, Set set2) throws PolicyException {
        if (set.size() != 1) {
            Object[] objectArray = new String[]{START_DAY};
            throw new PolicyException("amPolicy", "property_does_not_allow_multiple_values", objectArray, null);
        }
        if (set2.size() != 1) {
            Object[] objectArray = new String[]{END_DAY};
            throw new PolicyException("amPolicy", "property_does_not_allow_multiple_values", objectArray, null);
        }
        String string = (String)set.iterator().next();
        this.startDay = this.parseDayString(string);
        String string2 = (String)set2.iterator().next();
        this.endDay = this.parseDayString(string2);
        return true;
    }

    private boolean validateDates(Set set, Set set2) throws PolicyException {
        if (set.size() != 1) {
            Object[] objectArray = new String[]{START_DATE};
            throw new PolicyException("amPolicy", "property_does_not_allow_multiple_values", objectArray, null);
        }
        if (set2.size() != 1) {
            Object[] objectArray = new String[]{END_DATE};
            throw new PolicyException("amPolicy", "property_does_not_allow_multiple_values", objectArray, null);
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(DATE_FORMAT);
        simpleDateFormat.setLenient(false);
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        String string = (String)set.iterator().next();
        String string2 = (String)set2.iterator().next();
        Date date = null;
        Date date2 = null;
        try {
            date = simpleDateFormat.parse(string);
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{START_DATE, string};
            throw new PolicyException("amPolicy", "invalid_property_value", objectArray, exception);
        }
        try {
            date2 = simpleDateFormat.parse(string2);
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{END_DATE, string2};
            throw new PolicyException("amPolicy", "invalid_property_value", objectArray, exception);
        }
        if (date.getTime() > date2.getTime()) {
            throw new PolicyException("amPolicy", "start_date_can_not_be_larger_than_end_date", null, null);
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        gregorianCalendar.setTime(date);
        this.startDate[0] = gregorianCalendar.get(1);
        this.startDate[1] = gregorianCalendar.get(2);
        this.startDate[2] = gregorianCalendar.get(5);
        gregorianCalendar.setTime(date2);
        this.endDate[0] = gregorianCalendar.get(1);
        this.endDate[1] = gregorianCalendar.get(2);
        this.endDate[2] = gregorianCalendar.get(5);
        return true;
    }

    private boolean validateTimes(Set set, Set set2) throws PolicyException {
        if (set.size() != 1) {
            Object[] objectArray = new String[]{START_TIME};
            throw new PolicyException("amPolicy", "property_does_not_allow_multiple_values", objectArray, null);
        }
        if (set2.size() != 1) {
            Object[] objectArray = new String[]{END_TIME};
            throw new PolicyException("amPolicy", "property_does_not_allow_multiple_values", objectArray, null);
        }
        String string = (String)set.iterator().next();
        this.startTime = this.parseTimeString(string);
        this.startHour = this.startTime / 60;
        this.startMinute = this.startTime - this.startHour * 60;
        String string2 = (String)set2.iterator().next();
        this.endTime = this.parseTimeString(string2);
        this.endHour = this.endTime / 60;
        this.endMinute = this.endTime - this.endHour * 60;
        return true;
    }

    int parseTimeString(String string) throws PolicyException {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        if (stringTokenizer.countTokens() != 2) {
            Object[] objectArray = new String[]{"time", string};
            throw new PolicyException("amPolicy", "invalid_property_value", objectArray, null);
        }
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.nextToken();
        int n = -1;
        int n2 = -1;
        try {
            n = Integer.parseInt(string2);
            n2 = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            Object[] objectArray = new String[]{"time", string};
            throw new PolicyException("amPolicy", "invalid_property_value", objectArray, null);
        }
        if (n < 0 || n > 24 || n2 < 0 || n2 > 59) {
            Object[] objectArray = new String[]{"time", string};
            throw new PolicyException("amPolicy", "invalid_property_value", objectArray, null);
        }
        return n * 60 + n2;
    }

    int parseDayString(String string) throws PolicyException {
        int n = -1;
        int n2 = DAYS_OF_WEEK.length;
        String string2 = string.toLowerCase();
        int n3 = 1;
        while (n3 < 8) {
            if (DAYS_OF_WEEK[n3].equals(string2)) {
                n = n3;
                break;
            }
            ++n3;
        }
        if (n == -1) {
            Object[] objectArray = new String[]{"day", string};
            throw new PolicyException("amPolicy", "invalid_property_value", objectArray, null);
        }
        return n;
    }

    private boolean isAllowed(SSOToken sSOToken, Map map) throws PolicyException, SSOException {
        boolean bl = this.getConditionDecision(sSOToken, map).isAllowed();
        if (DEBUG.messageEnabled()) {
            DEBUG.message("At SimpleTimeCondition.isAllowed():requestTime,  allowed = " + bl);
        }
        return bl;
    }

    public Object clone() {
        SimpleTimeCondition simpleTimeCondition = null;
        try {
            simpleTimeCondition = (SimpleTimeCondition)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        if (this.startDate != null) {
            simpleTimeCondition.startDate = new int[this.startDate.length];
            System.arraycopy(this.startDate, 0, simpleTimeCondition.startDate, 0, this.startDate.length);
        }
        if (this.endDate != null) {
            simpleTimeCondition.endDate = new int[this.endDate.length];
            System.arraycopy(this.endDate, 0, simpleTimeCondition.endDate, 0, this.endDate.length);
        }
        if (this.enforcementTimeZone != null) {
            simpleTimeCondition.enforcementTimeZone = (TimeZone)this.enforcementTimeZone.clone();
        }
        if (this.properties != null) {
            simpleTimeCondition.properties = new HashMap();
            Iterator iterator = this.properties.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                HashSet hashSet = new HashSet();
                hashSet.addAll((Set)this.properties.get(k));
                simpleTimeCondition.properties.put(k, hashSet);
            }
        }
        return simpleTimeCondition;
    }

    private long[] getEffectiveRange(long l, TimeZone timeZone) {
        long l2;
        long l3;
        long[] lArray = new long[2];
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setTime(new Date(l));
        long l4 = Long.MIN_VALUE;
        if (this.startHour != -1) {
            gregorianCalendar.set(11, this.startHour);
            gregorianCalendar.set(12, this.startMinute);
            gregorianCalendar.set(13, 0);
            gregorianCalendar.set(14, 0);
            l4 = gregorianCalendar.getTime().getTime();
        }
        long l5 = Long.MAX_VALUE;
        if (this.endHour != -1) {
            gregorianCalendar.set(11, this.endHour);
            gregorianCalendar.set(12, this.endMinute);
            gregorianCalendar.set(13, 0);
            gregorianCalendar.set(14, 0);
            l5 = gregorianCalendar.getTime().getTime();
        }
        if (l5 < l4) {
            GregorianCalendar gregorianCalendar2 = new GregorianCalendar(timeZone);
            if (l < l4) {
                gregorianCalendar2.setTime(new Date(l4));
                ((Calendar)gregorianCalendar2).roll(6, false);
                l4 = gregorianCalendar2.getTime().getTime();
            } else {
                gregorianCalendar2.setTime(new Date(l5));
                ((Calendar)gregorianCalendar2).roll(6, true);
                l5 = gregorianCalendar2.getTime().getTime();
            }
        }
        long l6 = Long.MIN_VALUE;
        if (this.startDay != -1) {
            gregorianCalendar.set(7, this.startDay);
            gregorianCalendar.set(11, 0);
            gregorianCalendar.set(12, 0);
            gregorianCalendar.set(13, 0);
            gregorianCalendar.set(14, 0);
            l6 = gregorianCalendar.getTime().getTime();
        }
        long l7 = Long.MAX_VALUE;
        if (this.endDay != -1) {
            gregorianCalendar.set(3, gregorianCalendar.get(3));
            gregorianCalendar.set(7, this.endDay);
            gregorianCalendar.set(11, 24);
            gregorianCalendar.set(12, 0);
            gregorianCalendar.set(13, 0);
            gregorianCalendar.set(14, 0);
            l7 = gregorianCalendar.getTime().getTime();
        }
        if (l7 <= l6) {
            GregorianCalendar gregorianCalendar3 = new GregorianCalendar(timeZone);
            if (l < l6) {
                gregorianCalendar3.setTime(new Date(l6));
                ((Calendar)gregorianCalendar3).roll(3, false);
                l6 = gregorianCalendar3.getTime().getTime();
            } else {
                gregorianCalendar3.setTime(new Date(l7));
                ((Calendar)gregorianCalendar3).roll(3, true);
                l7 = gregorianCalendar3.getTime().getTime();
            }
        }
        long l8 = Long.MIN_VALUE;
        if (this.startDate[0] != -1) {
            gregorianCalendar.set(1, this.startDate[0]);
            gregorianCalendar.set(2, this.startDate[1]);
            gregorianCalendar.set(5, this.startDate[2]);
            gregorianCalendar.set(11, 0);
            gregorianCalendar.set(12, 0);
            gregorianCalendar.set(13, 0);
            gregorianCalendar.set(14, 0);
            l8 = gregorianCalendar.getTime().getTime();
        }
        long l9 = Long.MAX_VALUE;
        if (this.endDate[0] != -1) {
            gregorianCalendar.set(1, this.endDate[0]);
            gregorianCalendar.set(2, this.endDate[1]);
            gregorianCalendar.set(5, this.endDate[2]);
            gregorianCalendar.set(11, 24);
            gregorianCalendar.set(12, 0);
            gregorianCalendar.set(13, 0);
            gregorianCalendar.set(14, 0);
            l9 = gregorianCalendar.getTime().getTime();
        }
        if (l4 > (l3 = Long.MIN_VALUE)) {
            l3 = l4;
        }
        if (l6 > l3) {
            l3 = l6;
        }
        if (l8 > l3) {
            l3 = l8;
        }
        if (l5 < (l2 = Long.MAX_VALUE)) {
            l2 = l5;
        }
        if (l7 < l2) {
            l2 = l7;
        }
        if (l9 < l2) {
            l2 = l9;
        }
        lArray[0] = l3;
        lArray[1] = l2;
        return lArray;
    }

    public ConditionDecision getConditionDecision(SSOToken sSOToken, Map map) throws PolicyException, SSOException {
        TimeZone timeZone;
        boolean bl = false;
        long l = System.currentTimeMillis();
        Long l2 = (Long)map.get(REQUEST_TIME);
        if (l2 != null) {
            l = l2;
        }
        if ((timeZone = this.enforcementTimeZone) == null && (timeZone = (TimeZone)map.get(REQUEST_TIME_ZONE)) == null) {
            timeZone = TimeZone.getDefault();
        }
        long[] lArray = this.getEffectiveRange(l, timeZone);
        if (DEBUG.messageEnabled()) {
            DEBUG.message("At SimpleTimeCondition.getConditionDecision(): effectiveRange = " + new Date(lArray[0]) + "," + new Date(lArray[1]));
        }
        long l3 = Long.MAX_VALUE;
        if (l >= lArray[0] && l <= lArray[1]) {
            bl = true;
            l3 = lArray[1];
        } else if (l < lArray[0]) {
            l3 = lArray[0];
        }
        return new ConditionDecision(bl, l3);
    }

    static {
        propertyNames.add(START_TIME);
        propertyNames.add(END_TIME);
        propertyNames.add(START_DAY);
        propertyNames.add(END_DAY);
        propertyNames.add(START_DATE);
        propertyNames.add(END_DATE);
        propertyNames.add(ENFORCEMENT_TIME_ZONE);
    }
}

