/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.policy.plugins.LDAPConnectionPools;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.ConnectionPool;
import netscape.ldap.util.DN;

public class Organization
implements Subject {
    static final String LDAP_SCOPE_BASE = "SCOPE_BASE";
    static final String LDAP_SCOPE_ONE = "SCOPE_ONE";
    static final String LDAP_SCOPE_SUB = "SCOPE_SUB";
    private boolean initialized = false;
    private Set selectedOrgDNs = Collections.EMPTY_SET;
    private String authid;
    private String authpw;
    private String baseDN;
    private String userSearchFilter;
    private String orgSearchFilter;
    private int userSearchScope = 2;
    private int orgSearchScope = 2;
    private String userRDNAttrName;
    private String orgRDNAttrName;
    private int timeLimit;
    private int maxResults;
    private boolean sslEnabled = false;
    private int minPoolSize;
    private int maxPoolSize;
    private ConnectionPool connPool;
    private String orgName;
    private boolean localDS;
    private boolean aliasEnabled;
    static Debug debug = Debug.getInstance((String)"amPolicy");

    public void initialize(Map map) throws PolicyException {
        if (map == null) {
            throw new PolicyException("amPolicy", "org_initialization_failed", null, null);
        }
        String string = (String)map.get("iplanet-am-policy-config-ldap-server");
        this.localDS = PolicyUtils.isLocalDS(string);
        this.aliasEnabled = Boolean.valueOf((String)map.get("iplanet-am-policy-config-user-alias-enabled"));
        this.authid = (String)map.get("iplanet-am-policy-config-ldap-bind-dn");
        this.authpw = (String)map.get("iplanet-am-policy-config-ldap-bind-password");
        this.baseDN = (String)map.get("iplanet-am-policy-config-ldap-base-dn");
        this.userSearchFilter = (String)map.get("iplanet-am-policy-config-ldap-users-search-filter");
        String string2 = (String)map.get("iplanet-am-policy-config-ldap-users-search-scope");
        this.userSearchScope = string2.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (string2.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        this.userRDNAttrName = (String)map.get("iplanet-am-policy-config-ldap-users-search-attribute");
        this.orgSearchFilter = (String)map.get("iplanet-am-policy-config-ldap-organizations-search-filter");
        string2 = (String)map.get("iplanet-am-policy-config-ldap-organizations-search-scope");
        this.orgSearchScope = string2.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (string2.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        this.orgRDNAttrName = (String)map.get("iplanet-am-policy-config-ldap-organizations-search-attribute");
        try {
            this.timeLimit = Integer.parseInt((String)map.get("iplanet-am-policy-config-search-timeout"));
            this.maxResults = Integer.parseInt((String)map.get("iplanet-am-policy-config-search-limit"));
            this.minPoolSize = Integer.parseInt((String)map.get("iplanet-am-policy-config-connection_pool_min_size"));
            this.maxPoolSize = Integer.parseInt((String)map.get("iplanet-am-policy-config-connection_pool_max_size"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PolicyException(numberFormatException);
        }
        String string3 = (String)map.get("iplanet-am-policy-config-ldap-ssl-enabled");
        this.sslEnabled = string3.equalsIgnoreCase("true");
        Set set = (Set)map.get("OrganizationName");
        if (set != null && set.size() != 0) {
            Iterator iterator = set.iterator();
            this.orgName = (String)iterator.next();
        }
        if (debug.messageEnabled()) {
            debug.message("Organization.initialize(): getting params\nhostName: " + string + "\nauthid: " + this.authid + "\nbaseDN: " + this.baseDN + "\nuserSearchFilter: " + this.userSearchFilter + "\nuserRDNAttrName: " + this.userRDNAttrName + "\norgSearchFilter: " + this.orgSearchFilter + "\norgRDNAttrName: " + this.orgRDNAttrName + "\ntimeLimit: " + this.timeLimit + "\nmaxResults: " + this.maxResults + "\nminPoolSize: " + this.minPoolSize + "\nmaxPoolSize: " + this.maxPoolSize + "\nSSLEnabled: " + this.sslEnabled + "\nOrgName: " + this.orgName);
        }
        LDAPConnectionPools.initConnectionPool(string, this.sslEnabled, this.minPoolSize, this.maxPoolSize);
        this.connPool = LDAPConnectionPools.getConnectionPool(string);
        this.initialized = true;
    }

    public Syntax getValueSyntax(SSOToken sSOToken) throws SSOException {
        return Syntax.MULTIPLE_CHOICE;
    }

    public ValidValues getValidValues(SSOToken sSOToken) throws SSOException, PolicyException {
        return this.getValidValues(sSOToken, "*");
    }

    public ValidValues getValidValues(SSOToken sSOToken, String string) throws SSOException, PolicyException {
        if (!this.initialized) {
            throw new PolicyException("amPolicy", "org_subject_not_yet_initialized", null, null);
        }
        String string2 = null;
        string2 = string != null && !string.equals("") ? "(&" + this.orgSearchFilter + "(" + this.orgRDNAttrName + "=" + string + "))" : this.orgSearchFilter;
        if (debug.messageEnabled()) {
            debug.message("Organization.getValidValues(): organization search filter is: " + string2);
        }
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        lDAPSearchConstraints.setMaxResults(this.maxResults);
        lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        try {
            try {
                lDAPConnection.authenticate(this.authid, this.authpw);
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.baseDN, this.orgSearchScope, string2, null, false, lDAPSearchConstraints);
                while (lDAPSearchResults.hasMoreElements()) {
                    try {
                        LDAPEntry lDAPEntry = lDAPSearchResults.next();
                        if (lDAPEntry == null) continue;
                        hashSet.add(lDAPEntry.getDN());
                        if (!debug.messageEnabled()) continue;
                        debug.message("Organization.getValidValues(): found org name =" + lDAPEntry.getDN());
                    }
                    catch (LDAPReferralException lDAPReferralException) {
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{this.orgName};
                        int n2 = lDAPException.getLDAPResultCode();
                        if (n2 == 4) {
                            debug.warning("Organization.getValidValues(): exceeded the size limit");
                            n = 1;
                            continue;
                        }
                        if (n2 == 3) {
                            debug.warning("Organization.getValidValues(): exceeded the time limit");
                            n = 2;
                            continue;
                        }
                        throw new PolicyException(lDAPException);
                    }
                }
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 49) {
                    throw new PolicyException("amPolicy", "ldap_invalid_password", null, null);
                }
                String string3 = lDAPException.getMessage();
                String string4 = lDAPException.getLDAPErrorMessage();
                if (string4 != null) {
                    throw new PolicyException(string3 + ": " + string4);
                }
                throw new PolicyException(string3);
            }
            catch (Exception exception) {
                throw new PolicyException(exception);
            }
            Object var14_18 = null;
            this.connPool.close(lDAPConnection);
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            this.connPool.close(lDAPConnection);
            throw throwable;
        }
        if (debug.messageEnabled()) {
            debug.message("Organization.getValidValues(): return set=" + ((Object)hashSet).toString());
        }
        return new ValidValues(n, hashSet);
    }

    public String getDisplayNameForValue(String string, Locale locale) throws NameNotFoundException {
        return string;
    }

    public Set getValues() {
        if (debug.messageEnabled()) {
            debug.message("Organization.getValues() gets called");
        }
        return this.selectedOrgDNs;
    }

    public void setValues(Set set) throws InvalidNameException {
        if (set == null) {
            debug.error("Organization.setValues() Invalid names");
            throw new InvalidNameException("amPolicy", "org_subject_invalid_user_names", null, "null", 5);
        }
        this.selectedOrgDNs = new HashSet();
        this.selectedOrgDNs.addAll(set);
        if (debug.messageEnabled()) {
            debug.message("Organization.setValues(): selected org names=" + this.selectedOrgDNs);
        }
    }

    public boolean isMember(SSOToken sSOToken) throws SSOException, PolicyException {
        HashSet<String> hashSet = new HashSet<String>();
        String string = sSOToken.getPrincipal().getName();
        if (debug.messageEnabled()) {
            debug.message("Organization.isMember(): user local DN is " + string);
        }
        String string2 = null;
        if (this.localDS) {
            string2 = string;
        } else {
            Object object;
            int n = string.indexOf("=");
            int n2 = string.indexOf(",");
            if (n <= 0 || n2 <= 0 || n >= n2) {
                throw new PolicyException("amPolicy", "org_subject_invalid_local_user_dn", null, null);
            }
            String string3 = string.substring(n + 1, n2);
            String string4 = null;
            string4 = this.userSearchFilter != null && !this.userSearchFilter.equals("") ? "(&" + this.userSearchFilter + PolicyUtils.constructUserFilter(sSOToken, this.userRDNAttrName, string3, this.aliasEnabled) + ")" : PolicyUtils.constructUserFilter(sSOToken, this.userRDNAttrName, string3, this.aliasEnabled);
            if (debug.messageEnabled()) {
                debug.message("Organization.isMember(): search filter is: " + string4);
            }
            LDAPConnection lDAPConnection = this.connPool.getConnection();
            LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
            lDAPSearchConstraints.setMaxResults(this.maxResults);
            lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
            try {
                try {
                    lDAPConnection.authenticate(this.authid, this.authpw);
                    object = lDAPConnection.search(this.baseDN, this.userSearchScope, string4, null, false, lDAPSearchConstraints);
                    while (((LDAPSearchResults)object).hasMoreElements()) {
                        try {
                            LDAPEntry lDAPEntry = ((LDAPSearchResults)object).next();
                            if (lDAPEntry == null) continue;
                            hashSet.add(lDAPEntry.getDN());
                        }
                        catch (LDAPReferralException lDAPReferralException) {
                        }
                        catch (LDAPException lDAPException) {
                            Object[] objectArray = new String[]{this.orgName};
                            int n3 = lDAPException.getLDAPResultCode();
                            if (n3 == 4) {
                                debug.warning("Organization.isMember(): exceeded the size limit");
                                throw new PolicyException("amPolicy", "ldap_search_exceed_size_limit", objectArray, null);
                            }
                            if (n3 == 3) {
                                debug.warning("Organization.isMember(): exceeded the time limit");
                                throw new PolicyException("amPolicy", "ldap_search_exceed_time_limit", objectArray, null);
                            }
                            throw new PolicyException(lDAPException);
                        }
                    }
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() == 49) {
                        throw new PolicyException("amPolicy", "ldap_invalid_password", null, null);
                    }
                    String string5 = lDAPException.getMessage();
                    String string6 = lDAPException.getLDAPErrorMessage();
                    if (string6 != null) {
                        throw new PolicyException(string5 + ": " + string6);
                    }
                    throw new PolicyException(string5);
                }
                catch (Exception exception) {
                    throw new PolicyException(exception);
                }
                Object var17_23 = null;
                this.connPool.close(lDAPConnection);
            }
            catch (Throwable throwable) {
                Object var17_24 = null;
                this.connPool.close(lDAPConnection);
                throw throwable;
            }
            if (hashSet.size() > 0) {
                if (debug.messageEnabled()) {
                    debug.message("Organization.isMember(): qualified users=" + hashSet);
                }
                object = hashSet.iterator();
                string2 = (String)object.next();
            } else {
                if (debug.messageEnabled()) {
                    debug.message("Organization.isMember(): User " + string3 + " is not found in the directory");
                }
                return false;
            }
        }
        Iterator iterator = this.selectedOrgDNs.iterator();
        while (iterator.hasNext()) {
            String string7 = (String)iterator.next();
            if (!this.isMemberOfOrg(string7, string2)) continue;
            if (debug.messageEnabled()) {
                debug.message("Organization.isMember(): User " + string2 + " is a member of the Organization object");
            }
            return true;
        }
        if (debug.messageEnabled()) {
            debug.message("Organization.isMember(): User " + string2 + " is not a member of this Organization object");
        }
        return false;
    }

    private boolean isMemberOfOrg(String string, String string2) {
        DN dN = new DN(string);
        DN dN2 = new DN(string2);
        return dN2.isDescendantOf(dN);
    }

    public int hashCode() {
        return this.selectedOrgDNs.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof Organization) {
            Organization organization = (Organization)object;
            if (this.selectedOrgDNs != null && organization.selectedOrgDNs != null && this.selectedOrgDNs.equals(organization.selectedOrgDNs)) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        Organization organization = null;
        try {
            organization = (Organization)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        if (this.selectedOrgDNs != null) {
            organization.selectedOrgDNs = new HashSet();
            organization.selectedOrgDNs.addAll(this.selectedOrgDNs);
        }
        return organization;
    }
}

