/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.policy.plugins.LDAPConnectionPools;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.ConnectionPool;
import netscape.ldap.util.DN;

public class LDAPUsers
implements Subject {
    static final String LDAP_SCOPE_BASE = "SCOPE_BASE";
    static final String LDAP_SCOPE_ONE = "SCOPE_ONE";
    static final String LDAP_SCOPE_SUB = "SCOPE_SUB";
    private boolean initialized = false;
    private Set selectedUserDNs = Collections.EMPTY_SET;
    private String authid;
    private String authpw;
    private String baseDN;
    private String userSearchFilter;
    private int userSearchScope = 2;
    private String userRDNAttrName;
    private int timeLimit;
    private int maxResults;
    private boolean sslEnabled = false;
    private int minPoolSize;
    private int maxPoolSize;
    private String orgName;
    private ConnectionPool connPool;
    private boolean localDS;
    private boolean aliasEnabled;
    static Debug debug = Debug.getInstance((String)"amPolicy");

    public void initialize(Map map) throws PolicyException {
        if (map == null) {
            throw new PolicyException("amPolicy", "ldapusers_initialization_failed", null, null);
        }
        String string = (String)map.get("iplanet-am-policy-config-ldap-server");
        this.localDS = PolicyUtils.isLocalDS(string);
        this.aliasEnabled = Boolean.valueOf((String)map.get("iplanet-am-policy-config-user-alias-enabled"));
        this.authid = (String)map.get("iplanet-am-policy-config-ldap-bind-dn");
        this.authpw = (String)map.get("iplanet-am-policy-config-ldap-bind-password");
        this.baseDN = (String)map.get("iplanet-am-policy-config-ldap-users-base-dn");
        this.userSearchFilter = (String)map.get("iplanet-am-policy-config-ldap-users-search-filter");
        String string2 = (String)map.get("iplanet-am-policy-config-ldap-users-search-scope");
        this.userSearchScope = string2.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (string2.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        this.userRDNAttrName = (String)map.get("iplanet-am-policy-config-ldap-users-search-attribute");
        try {
            this.timeLimit = Integer.parseInt((String)map.get("iplanet-am-policy-config-search-timeout"));
            this.maxResults = Integer.parseInt((String)map.get("iplanet-am-policy-config-search-limit"));
            this.minPoolSize = Integer.parseInt((String)map.get("iplanet-am-policy-config-connection_pool_min_size"));
            this.maxPoolSize = Integer.parseInt((String)map.get("iplanet-am-policy-config-connection_pool_max_size"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PolicyException(numberFormatException);
        }
        String string3 = (String)map.get("iplanet-am-policy-config-ldap-ssl-enabled");
        this.sslEnabled = string3.equalsIgnoreCase("true");
        Set set = (Set)map.get("OrganizationName");
        if (set != null && set.size() != 0) {
            Iterator iterator = set.iterator();
            this.orgName = (String)iterator.next();
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPUsers.initialize(): getting params\nhostName: " + string + "\nauthid: " + this.authid + "\nbaseDN: " + this.baseDN + "\nuserSearchFilter: " + this.userSearchFilter + "\nuserRDNAttrName: " + this.userRDNAttrName + "\ntimeLimit: " + this.timeLimit + "\nmaxResults: " + this.maxResults + "\nminPoolSize: " + this.minPoolSize + "\nmaxPoolSize: " + this.maxPoolSize + "\nSSLEnabled: " + this.sslEnabled + "\nOrgName: " + this.orgName);
        }
        LDAPConnectionPools.initConnectionPool(string, this.sslEnabled, this.minPoolSize, this.maxPoolSize);
        this.connPool = LDAPConnectionPools.getConnectionPool(string);
        this.initialized = true;
    }

    public Syntax getValueSyntax(SSOToken sSOToken) throws SSOException {
        return Syntax.MULTIPLE_CHOICE;
    }

    public ValidValues getValidValues(SSOToken sSOToken) throws SSOException, PolicyException {
        return this.getValidValues(sSOToken, "*");
    }

    public ValidValues getValidValues(SSOToken sSOToken, String string) throws SSOException, PolicyException {
        if (!this.initialized) {
            throw new PolicyException("amPolicy", "ldapusers_subject_not_yet_initialized", null, null);
        }
        String string2 = null;
        string2 = string != null && !string.equals("") ? "(&" + this.userSearchFilter + "(" + this.userRDNAttrName + "=" + string + "))" : this.userSearchFilter;
        if (debug.messageEnabled()) {
            debug.message("LDAPUsers.getValidValues(): user search filter is: " + string2);
        }
        HashSet<String> hashSet = new HashSet<String>();
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        lDAPSearchConstraints.setMaxResults(this.maxResults);
        lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
        int n = 0;
        try {
            try {
                lDAPConnection.authenticate(this.authid, this.authpw);
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.baseDN, this.userSearchScope, string2, null, false, lDAPSearchConstraints);
                while (lDAPSearchResults.hasMoreElements()) {
                    try {
                        LDAPEntry lDAPEntry = lDAPSearchResults.next();
                        if (lDAPEntry == null) continue;
                        hashSet.add(lDAPEntry.getDN());
                        if (!debug.messageEnabled()) continue;
                        debug.message("LDAPUsers.getValidValues(): found user name=" + lDAPEntry.getDN());
                    }
                    catch (LDAPReferralException lDAPReferralException) {
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{this.orgName};
                        int n2 = lDAPException.getLDAPResultCode();
                        if (n2 == 4) {
                            debug.warning("LDAPUsers.getValidValues(): exceeded the size limit");
                            n = 1;
                            continue;
                        }
                        if (n2 == 3) {
                            debug.warning("LDAPUsers.getValidValues(): exceeded the time limit");
                            n = 2;
                            continue;
                        }
                        throw new PolicyException(lDAPException);
                    }
                }
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 49) {
                    throw new PolicyException("amPolicy", "ldap_invalid_password", null, null);
                }
                String string3 = lDAPException.getMessage();
                String string4 = lDAPException.getLDAPErrorMessage();
                if (string4 != null) {
                    throw new PolicyException(string3 + ": " + string4);
                }
                throw new PolicyException(string3);
            }
            catch (Exception exception) {
                throw new PolicyException(exception);
            }
            Object var14_18 = null;
            this.connPool.close(lDAPConnection);
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            this.connPool.close(lDAPConnection);
            throw throwable;
        }
        return new ValidValues(n, hashSet);
    }

    public String getDisplayNameForValue(String string, Locale locale) throws NameNotFoundException {
        return string;
    }

    public Set getValues() {
        if (debug.messageEnabled()) {
            debug.message("LDAPUsers.getValues() gets called");
        }
        return this.selectedUserDNs;
    }

    public void setValues(Set set) throws InvalidNameException {
        if (set == null) {
            debug.error("LDAPUsers.setValues(): Invalid names");
            throw new InvalidNameException("amPolicy", "ldapusers_subject_invalid_user_names", null, "null", 5);
        }
        this.selectedUserDNs = new HashSet();
        this.selectedUserDNs.addAll(set);
        if (debug.messageEnabled()) {
            debug.message("LDAPUsers.setValues(): selected user names=" + this.selectedUserDNs);
        }
    }

    public boolean isMember(SSOToken sSOToken) throws SSOException, PolicyException {
        HashSet<String> hashSet = new HashSet<String>();
        String string = sSOToken.getPrincipal().getName();
        if (debug.messageEnabled()) {
            debug.message("LDAPUsers.isMember(): user local DN is " + string);
        }
        DN dN = null;
        if (this.localDS) {
            dN = new DN(string);
        } else {
            Object object;
            int n = string.indexOf("=");
            int n2 = string.indexOf(",");
            if (n <= 0 || n2 <= 0 || n >= n2) {
                throw new PolicyException("amPolicy", "ldapusers_subject_invalid_local_user_dn", null, null);
            }
            String string2 = string.substring(n + 1, n2);
            String string3 = null;
            string3 = this.userSearchFilter != null && !this.userSearchFilter.equals("") ? "(&" + this.userSearchFilter + PolicyUtils.constructUserFilter(sSOToken, this.userRDNAttrName, string2, this.aliasEnabled) + ")" : PolicyUtils.constructUserFilter(sSOToken, this.userRDNAttrName, string2, this.aliasEnabled);
            if (debug.messageEnabled()) {
                debug.message("LDAPUsers.isMember(): search filter is: " + string3);
            }
            LDAPConnection lDAPConnection = this.connPool.getConnection();
            LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
            lDAPSearchConstraints.setMaxResults(this.maxResults);
            lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
            try {
                try {
                    lDAPConnection.authenticate(this.authid, this.authpw);
                    object = lDAPConnection.search(this.baseDN, this.userSearchScope, string3, null, false, lDAPSearchConstraints);
                    while (((LDAPSearchResults)object).hasMoreElements()) {
                        try {
                            LDAPEntry lDAPEntry = ((LDAPSearchResults)object).next();
                            if (lDAPEntry == null) continue;
                            hashSet.add(lDAPEntry.getDN());
                        }
                        catch (LDAPReferralException lDAPReferralException) {
                        }
                        catch (LDAPException lDAPException) {
                            Object[] objectArray = new String[]{this.orgName};
                            int n3 = lDAPException.getLDAPResultCode();
                            if (n3 == 4) {
                                debug.warning("LDAPUsers.isMember(): exceeded the size limit");
                                throw new PolicyException("amPolicy", "ldap_search_exceed_size_limit", objectArray, null);
                            }
                            if (n3 == 3) {
                                debug.warning("LDAPUsers.isMember(): exceeded the time limit");
                                throw new PolicyException("amPolicy", "ldap_search_exceed_time_limit", objectArray, null);
                            }
                            throw new PolicyException(lDAPException);
                        }
                    }
                }
                catch (LDAPException lDAPException) {
                    if (lDAPException.getLDAPResultCode() == 49) {
                        throw new PolicyException("amPolicy", "ldap_invalid_password", null, null);
                    }
                    String string4 = lDAPException.getMessage();
                    String string5 = lDAPException.getLDAPErrorMessage();
                    if (string5 != null) {
                        throw new PolicyException(string4 + ": " + string5);
                    }
                    throw new PolicyException(string4);
                }
                catch (Exception exception) {
                    throw new PolicyException(exception);
                }
                Object var17_23 = null;
                this.connPool.close(lDAPConnection);
            }
            catch (Throwable throwable) {
                Object var17_24 = null;
                this.connPool.close(lDAPConnection);
                throw throwable;
            }
            if (hashSet.size() > 0) {
                if (debug.messageEnabled()) {
                    debug.message("LDAPUsers.isMember(): qualified users=" + hashSet);
                }
                object = hashSet.iterator();
                dN = new DN((String)object.next());
            } else {
                if (debug.messageEnabled()) {
                    debug.message("LDAPUsers.isMember(): User " + string2 + " is not found in the directory");
                }
                return false;
            }
        }
        Iterator iterator = this.selectedUserDNs.iterator();
        while (iterator.hasNext()) {
            DN dN2 = new DN((String)iterator.next());
            if (!dN.equals(dN2)) continue;
            if (debug.messageEnabled()) {
                debug.message("LDAPUsers.isMember(): User " + dN + " is a member of the LDAPUsers object");
            }
            return true;
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPUsers.isMember(): User " + dN + " is not a member of this LDAPUsers object");
        }
        return false;
    }

    public int hashCode() {
        return this.selectedUserDNs.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof LDAPUsers) {
            LDAPUsers lDAPUsers = (LDAPUsers)object;
            if (this.selectedUserDNs != null && lDAPUsers.selectedUserDNs != null && this.selectedUserDNs.equals(lDAPUsers.selectedUserDNs)) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        LDAPUsers lDAPUsers = null;
        try {
            lDAPUsers = (LDAPUsers)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        if (this.selectedUserDNs != null) {
            lDAPUsers.selectedUserDNs = new HashSet();
            lDAPUsers.selectedUserDNs.addAll(this.selectedUserDNs);
        }
        return lDAPUsers;
    }
}

