/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.plugins;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidNameException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyUtils;
import com.sun.identity.policy.Syntax;
import com.sun.identity.policy.ValidValues;
import com.sun.identity.policy.interfaces.Subject;
import com.sun.identity.policy.plugins.LDAPConnectionPools;
import java.io.Serializable;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPReferralException;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.util.ConnectionPool;
import netscape.ldap.util.DN;

public class LDAPRoles
implements Subject {
    static final String LDAP_OBJECT_CLASS = "objectclass";
    static final String LDAP_ROLE_ATTR = "nsroledefinition";
    static final String LDAP_USER_ROLE_ATTR = "nsrole";
    static final String LDAP_SCOPE_BASE = "SCOPE_BASE";
    static final String LDAP_SCOPE_ONE = "SCOPE_ONE";
    static final String LDAP_SCOPE_SUB = "SCOPE_SUB";
    private boolean initialized = false;
    private Set selectedRoleDNs = Collections.EMPTY_SET;
    private String authid;
    private String authpw;
    private String baseDN;
    private String roleSearchFilter;
    private int roleSearchScope = 2;
    private String userSearchFilter;
    private int userSearchScope = 2;
    private String roleRDNAttrName;
    private String userRDNAttrName;
    private int timeLimit;
    private int maxResults;
    private boolean sslEnabled = false;
    private int minPoolSize;
    private int maxPoolSize;
    private String orgName;
    private ConnectionPool connPool;
    private boolean localDS;
    private boolean aliasEnabled;
    static Debug debug = Debug.getInstance((String)"amPolicy");

    public void initialize(Map map) throws PolicyException {
        if (map == null) {
            throw new PolicyException("amPolicy", "ldaproles_initialization_failed", null, null);
        }
        String string = (String)map.get("iplanet-am-policy-config-ldap-server");
        this.localDS = PolicyUtils.isLocalDS(string);
        this.aliasEnabled = Boolean.valueOf((String)map.get("iplanet-am-policy-config-user-alias-enabled"));
        this.authid = (String)map.get("iplanet-am-policy-config-ldap-bind-dn");
        this.authpw = (String)map.get("iplanet-am-policy-config-ldap-bind-password");
        this.baseDN = (String)map.get("iplanet-am-policy-config-ldap-base-dn");
        this.roleSearchFilter = (String)map.get("iplanet-am-policy-config-ldap-roles-search-filter");
        String string2 = (String)map.get("iplanet-am-policy-config-ldap-roles-search-scope");
        this.roleSearchScope = string2.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (string2.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        this.roleRDNAttrName = (String)map.get("iplanet-am-policy-config-ldap-roles-search-attribute");
        this.userSearchFilter = (String)map.get("iplanet-am-policy-config-ldap-users-search-filter");
        string2 = (String)map.get("iplanet-am-policy-config-ldap-users-search-scope");
        this.userSearchScope = string2.equalsIgnoreCase(LDAP_SCOPE_BASE) ? 0 : (string2.equalsIgnoreCase(LDAP_SCOPE_ONE) ? 1 : 2);
        this.userRDNAttrName = (String)map.get("iplanet-am-policy-config-ldap-users-search-attribute");
        try {
            this.timeLimit = Integer.parseInt((String)map.get("iplanet-am-policy-config-search-timeout"));
            this.maxResults = Integer.parseInt((String)map.get("iplanet-am-policy-config-search-limit"));
            this.minPoolSize = Integer.parseInt((String)map.get("iplanet-am-policy-config-connection_pool_min_size"));
            this.maxPoolSize = Integer.parseInt((String)map.get("iplanet-am-policy-config-connection_pool_max_size"));
        }
        catch (NumberFormatException numberFormatException) {
            throw new PolicyException(numberFormatException);
        }
        String string3 = (String)map.get("iplanet-am-policy-config-ldap-ssl-enabled");
        this.sslEnabled = string3.equalsIgnoreCase("true");
        Set set = (Set)map.get("OrganizationName");
        if (set != null && set.size() != 0) {
            Iterator iterator = set.iterator();
            this.orgName = (String)iterator.next();
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPRoles.initialize(): getting params\nhostName: " + string + "\nauthid: " + this.authid + "\nbaseDN: " + this.baseDN + "\nroleSearchFilter: " + this.roleSearchFilter + "\nroleRDNAttrName: " + this.roleRDNAttrName + "\nuserSearchFilter: " + this.userSearchFilter + "\nuserRDNAttrName: " + this.userRDNAttrName + "\ntimeLimit: " + this.timeLimit + "\nmaxResults: " + this.maxResults + "\nminPoolSize: " + this.minPoolSize + "\nmaxPoolSize: " + this.maxPoolSize + "\nSSLEnabled: " + this.sslEnabled + "\nOrgName: " + this.orgName);
        }
        LDAPConnectionPools.initConnectionPool(string, this.sslEnabled, this.minPoolSize, this.maxPoolSize);
        this.connPool = LDAPConnectionPools.getConnectionPool(string);
        this.initialized = true;
        try {
            this.getValidValues(null, "*");
            if (debug.messageEnabled()) {
                debug.message("LDAPRoles.initialize(): getValidValues() gets called");
            }
        }
        catch (Exception exception) {
            debug.error("LDAPRoles.initialize():", (Throwable)exception);
        }
    }

    public Syntax getValueSyntax(SSOToken sSOToken) throws SSOException {
        return Syntax.MULTIPLE_CHOICE;
    }

    public ValidValues getValidValues(SSOToken sSOToken) throws SSOException, PolicyException {
        return this.getValidValues(sSOToken, "*");
    }

    public ValidValues getValidValues(SSOToken sSOToken, String string) throws SSOException, PolicyException {
        if (!this.initialized) {
            throw new PolicyException("amPolicy", "ldaproles_subject_not_yet_initialized", null, null);
        }
        String string2 = null;
        string2 = string != null && !string.equals("") ? "(&" + this.roleSearchFilter + "(" + this.roleRDNAttrName + "=" + string + "))" : this.roleSearchFilter;
        if (debug.messageEnabled()) {
            debug.message("LDAPRoles.getValidValues(): role search filter is: " + string2);
        }
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        lDAPSearchConstraints.setMaxResults(this.maxResults);
        lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
        HashSet<String> hashSet = new HashSet<String>();
        int n = 0;
        try {
            try {
                lDAPConnection.authenticate(this.authid, this.authpw);
                LDAPSearchResults lDAPSearchResults = lDAPConnection.search(this.baseDN, this.roleSearchScope, string2, null, false, lDAPSearchConstraints);
                while (lDAPSearchResults.hasMoreElements()) {
                    try {
                        LDAPEntry lDAPEntry = lDAPSearchResults.next();
                        if (lDAPEntry == null) continue;
                        hashSet.add(lDAPEntry.getDN());
                        if (!debug.messageEnabled()) continue;
                        debug.message("LDAPRoles.getValidValues(): found role name=" + lDAPEntry.getDN());
                    }
                    catch (LDAPReferralException lDAPReferralException) {
                    }
                    catch (LDAPException lDAPException) {
                        String[] stringArray = new String[]{this.orgName};
                        int n2 = lDAPException.getLDAPResultCode();
                        if (n2 == 4) {
                            debug.warning("LDAPRoles.getValidValues(): exceeded the size limit");
                            n = 1;
                            continue;
                        }
                        if (n2 == 3) {
                            debug.warning("LDAPRoles.getValidValues(): exceeded the time limit");
                            n = 2;
                            continue;
                        }
                        throw new PolicyException(lDAPException);
                    }
                }
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 49) {
                    throw new PolicyException("amPolicy", "ldap_invalid_password", null, null);
                }
                String string3 = lDAPException.getMessage();
                String string4 = lDAPException.getLDAPErrorMessage();
                if (string4 != null) {
                    throw new PolicyException(string3 + ": " + string4);
                }
                throw new PolicyException(string3);
            }
            catch (Exception exception) {
                throw new PolicyException(exception);
            }
            Object var14_18 = null;
            this.connPool.close(lDAPConnection);
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            this.connPool.close(lDAPConnection);
            throw throwable;
        }
        return new ValidValues(n, hashSet);
    }

    public String getDisplayNameForValue(String string, Locale locale) throws NameNotFoundException {
        return string;
    }

    public Set getValues() {
        if (debug.messageEnabled()) {
            debug.message("LDAPRoles.getValues() gets called");
        }
        return this.selectedRoleDNs;
    }

    public void setValues(Set set) throws InvalidNameException {
        if (set == null) {
            debug.error("LDAPRoles.setValues() Invalid names");
            throw new InvalidNameException("amPolicy", "ldaproles_subject_invalid_group_names", null, null, 5);
        }
        this.selectedRoleDNs = new HashSet();
        this.selectedRoleDNs.addAll(set);
        if (debug.messageEnabled()) {
            debug.message("LDAPRoles.setValues(): selected role names=" + this.selectedRoleDNs);
        }
    }

    public boolean isMember(SSOToken sSOToken) throws SSOException, PolicyException {
        DN dN;
        Object object;
        Serializable serializable;
        HashSet<LDAPEntry> hashSet = new HashSet<LDAPEntry>();
        String string = sSOToken.getPrincipal().getName();
        if (debug.messageEnabled()) {
            debug.message("LDAPRoles.isMember(): user local DN is " + string);
        }
        String string2 = this.baseDN;
        if (this.localDS) {
            string2 = new DN(string).toString();
            if (debug.messageEnabled()) {
                debug.message("LDAPRoles.isMember(): search user " + string2 + " only as it is local.");
            }
        }
        int n = string.indexOf("=");
        int n2 = string.indexOf(",");
        if (n <= 0 || n2 <= 0 || n >= n2) {
            throw new PolicyException("amPolicy", "ldaproles_subject_invalid_local_user_dn", null, null);
        }
        String string3 = string.substring(n + 1, n2);
        String string4 = null;
        string4 = this.userSearchFilter != null && !this.userSearchFilter.equals("") ? "(&" + this.userSearchFilter + PolicyUtils.constructUserFilter(sSOToken, this.userRDNAttrName, string3, this.aliasEnabled) + ")" : PolicyUtils.constructUserFilter(sSOToken, this.userRDNAttrName, string3, this.aliasEnabled);
        if (debug.messageEnabled()) {
            debug.message("LDAPRoles.isMember(): search filter is: " + string4);
        }
        LDAPConnection lDAPConnection = this.connPool.getConnection();
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        lDAPSearchConstraints.setMaxResults(this.maxResults);
        lDAPSearchConstraints.setServerTimeLimit(this.timeLimit);
        String[] stringArray = new String[]{LDAP_USER_ROLE_ATTR};
        try {
            try {
                lDAPConnection.authenticate(this.authid, this.authpw);
                serializable = lDAPConnection.search(string2, this.userSearchScope, string4, stringArray, false, lDAPSearchConstraints);
                while (((LDAPSearchResults)serializable).hasMoreElements()) {
                    try {
                        object = ((LDAPSearchResults)serializable).next();
                        if (object == null) continue;
                        hashSet.add((LDAPEntry)object);
                    }
                    catch (LDAPReferralException lDAPReferralException) {
                    }
                    catch (LDAPException lDAPException) {
                        Object[] objectArray = new String[]{this.orgName};
                        int n3 = lDAPException.getLDAPResultCode();
                        if (n3 == 4) {
                            debug.warning("LDAPRoles.isMember(): exceeded the size limit");
                            throw new PolicyException("amPolicy", "ldap_search_exceed_size_limit", objectArray, null);
                        }
                        if (n3 == 3) {
                            debug.warning("LDAPRoles.isMember(): exceeded the time limit");
                            throw new PolicyException("amPolicy", "ldap_search_exceed_time_limit", objectArray, null);
                        }
                        throw new PolicyException(lDAPException);
                    }
                }
            }
            catch (LDAPException lDAPException) {
                if (lDAPException.getLDAPResultCode() == 49) {
                    throw new PolicyException("amPolicy", "ldap_invalid_password", null, null);
                }
                String string5 = lDAPException.getMessage();
                String string6 = lDAPException.getLDAPErrorMessage();
                if (string6 != null) {
                    throw new PolicyException(string5 + ": " + string6);
                }
                throw new PolicyException(string5);
            }
            catch (Exception exception) {
                throw new PolicyException(exception);
            }
            dN = null;
            this.connPool.close(lDAPConnection);
        }
        catch (Throwable throwable) {
            Object var18_26 = null;
            this.connPool.close(lDAPConnection);
            throw throwable;
        }
        serializable = null;
        object = null;
        if (hashSet.size() > 0) {
            Iterator iterator = hashSet.iterator();
            serializable = (LDAPEntry)iterator.next();
            object = ((LDAPEntry)serializable).getDN();
            LDAPAttribute lDAPAttribute = ((LDAPEntry)serializable).getAttribute(LDAP_USER_ROLE_ATTR);
            if (lDAPAttribute != null) {
                Enumeration enumeration = lDAPAttribute.getStringValues();
                while (enumeration != null && enumeration.hasMoreElements()) {
                    String string7 = (String)enumeration.nextElement();
                    dN = new DN(string7);
                    Iterator iterator2 = this.selectedRoleDNs.iterator();
                    while (iterator2.hasNext()) {
                        DN dN2 = new DN((String)iterator2.next());
                        if (!dN2.equals(dN)) continue;
                        if (debug.messageEnabled()) {
                            debug.message("LDAPRoles.isMember(): User " + (String)object + " is a member of the LDAPRoles");
                        }
                        return true;
                    }
                }
            }
        }
        if (debug.messageEnabled()) {
            debug.message("LDAPRoles.isMember(): User " + (String)object + " is not a member of this LDAPRoles object");
        }
        return false;
    }

    public int hashCode() {
        return this.selectedRoleDNs.hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof LDAPRoles) {
            LDAPRoles lDAPRoles = (LDAPRoles)object;
            if (this.selectedRoleDNs != null && lDAPRoles.selectedRoleDNs != null && this.selectedRoleDNs.equals(lDAPRoles.selectedRoleDNs)) {
                return true;
            }
        }
        return false;
    }

    public Object clone() {
        LDAPRoles lDAPRoles = null;
        try {
            lDAPRoles = (LDAPRoles)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        if (this.selectedRoleDNs != null) {
            lDAPRoles.selectedRoleDNs = new HashSet();
            lDAPRoles.selectedRoleDNs.addAll(this.selectedRoleDNs);
        }
        return lDAPRoles;
    }
}

