/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.client;

import com.iplanet.am.util.Debug;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.ResourceResult;
import com.sun.identity.policy.client.ClientResourceResult;
import com.sun.identity.policy.client.PolicyEvaluator;
import com.sun.identity.policy.client.ResourceResultCache;
import com.sun.identity.policy.interfaces.ResourceName;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class SSOEntry {
    private String serviceName = null;
    private SSOToken ssoToken = null;
    private Map envParameters = null;
    private ResourceResultCache container = null;
    private Map resourceResults = new Hashtable();
    private static Debug debug = PolicyEvaluator.debug;
    private int pollInterval;

    SSOEntry(String string, SSOToken sSOToken, Map map, int n, ResourceResult resourceResult, ResourceResultCache resourceResultCache) {
        this.serviceName = string;
        this.ssoToken = sSOToken;
        this.envParameters = map;
        this.container = resourceResultCache;
        this.pollInterval = n;
        this.addResourceResult(resourceResult);
        if (debug.messageEnabled()) {
            debug.message("SSOEntry; polling interval=" + this.pollInterval);
        }
    }

    SSOToken getSSOToken() {
        return this.ssoToken;
    }

    public int hashCode() {
        return this.ssoToken.getTokenID().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof SSOEntry) {
            SSOEntry sSOEntry = (SSOEntry)object;
            return this.serviceName.equals(sSOEntry.serviceName) && this.ssoToken.getTokenID().equals((Object)sSOEntry.ssoToken.getTokenID());
        }
        return false;
    }

    void addResourceResult(ResourceResult resourceResult) {
        if (resourceResult != null) {
            long l = System.currentTimeMillis() + this.computeTTL(this.pollInterval, resourceResult);
            this.resourceResults.put(resourceResult.getResourceName(), new ClientResourceResult(resourceResult, l));
        }
    }

    ResourceResult getResourceResult(String string) {
        ClientResourceResult clientResourceResult = (ClientResourceResult)this.resourceResults.get(string);
        if (clientResourceResult != null) {
            return clientResourceResult.getResourceRes();
        }
        return null;
    }

    protected boolean remove() {
        if (this.resourceResults.isEmpty()) {
            debug.message("SSOEntry is cleared");
            this.container.removeEntry(this.serviceName, this.ssoToken);
            return false;
        }
        return true;
    }

    void markResultAsStale(ResourceName resourceName, String string, boolean bl) {
        String[] stringArray = resourceName.split(string);
        if (stringArray != null && stringArray.length > 0) {
            ResourceResult resourceResult = this.getResourceResult(stringArray[0]);
            if (resourceResult != null) {
                if (!this.markStaleNodes(resourceResult, string, resourceName, bl)) {
                    this.addStaleNode(resourceResult, string, resourceName);
                }
            } else {
                this.addStaleRoot(stringArray[0], string, resourceName);
            }
        }
    }

    private boolean markStaleNodes(ResourceResult resourceResult, String string, ResourceName resourceName, boolean bl) {
        boolean bl2 = false;
        ArrayList<ResourceResult> arrayList = new ArrayList<ResourceResult>();
        arrayList.add(resourceResult);
        while (!arrayList.isEmpty()) {
            ResourceResult resourceResult2 = (ResourceResult)arrayList.remove(0);
            ResourceMatch resourceMatch = resourceName.compare(resourceResult2.getResourceName(), string, bl);
            if (resourceMatch.equals(ResourceMatch.EXACT_MATCH)) {
                resourceResult2.markStale();
                bl2 = true;
                continue;
            }
            if (resourceMatch.equals(ResourceMatch.WILDCARD_MATCH)) {
                resourceResult2.markStale();
                bl2 = true;
                continue;
            }
            arrayList.addAll(resourceResult2.getResourceResults());
        }
        return bl2;
    }

    private void addStaleRoot(String string, String string2, ResourceName resourceName) {
        try {
            ResourceResult resourceResult = new ResourceResult(string, new PolicyDecision());
            resourceResult.markStale();
            ResourceResult resourceResult2 = new ResourceResult(string2, new PolicyDecision());
            resourceResult2.markStale();
            resourceResult.addResourceResult(resourceResult2, resourceName);
            this.addResourceResult(resourceResult);
        }
        catch (PolicyException policyException) {
            debug.error("SSOEntry.addStaleRoot", (Throwable)policyException);
        }
    }

    private void addStaleNode(ResourceResult resourceResult, String string, ResourceName resourceName) {
        try {
            ResourceResult resourceResult2 = new ResourceResult(string, new PolicyDecision());
            resourceResult2.markStale();
            resourceResult.addResourceResult(resourceResult2, resourceName);
        }
        catch (PolicyException policyException) {
            debug.error("SSOEntry.addStaleNode", (Throwable)policyException);
        }
    }

    boolean hasSameEnvironment(Map map) {
        if (map == null && this.envParameters == null) {
            return true;
        }
        if (map == null && this.envParameters != null || this.envParameters != null && map == null) {
            return false;
        }
        if (map.size() != this.envParameters.size()) {
            return false;
        }
        boolean bl = true;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext() && bl) {
            String string = (String)iterator.next();
            Set set = (Set)map.get(string);
            Set set2 = (Set)this.envParameters.get(string);
            bl = set != null && set2 != null ? set.equals(set2) : false;
        }
        return bl;
    }

    boolean validate(long l) {
        boolean bl = true;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (this.resourceResults != null && !this.resourceResults.isEmpty()) {
            Iterator iterator = this.resourceResults.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ClientResourceResult clientResourceResult = (ClientResourceResult)this.resourceResults.get(string);
                if (clientResourceResult.getExpireTime() >= l) continue;
                arrayList.add(string);
            }
        }
        if (!arrayList.isEmpty()) {
            int n = arrayList.size();
            int n2 = 0;
            while (n2 < n) {
                String string = (String)arrayList.get(n2);
                if (string != null) {
                    Map map = this.resourceResults;
                    synchronized (map) {
                        this.resourceResults.remove(string);
                    }
                    if (debug.messageEnabled()) {
                        debug.message("Removing ResourceResult [" + string + "] from SSOEntry");
                    }
                }
                ++n2;
            }
        }
        bl = this.remove();
        return bl;
    }

    boolean validate(String string) {
        return this.validate(string, System.currentTimeMillis());
    }

    boolean validate(String string, long l) {
        ClientResourceResult clientResourceResult;
        boolean bl = true;
        if (string != null && !this.resourceResults.isEmpty() && (clientResourceResult = (ClientResourceResult)this.resourceResults.get(string)) != null) {
            if (clientResourceResult.getExpireTime() < l) {
                Map map = this.resourceResults;
                synchronized (map) {
                    if (debug.messageEnabled()) {
                        debug.message("Removing ResourceResult [" + string + "] from SSOEntry");
                    }
                    this.resourceResults.remove(string);
                }
                bl = this.remove();
            } else {
                bl = true;
            }
        }
        return bl;
    }

    private long computeTTL(int n, ResourceResult resourceResult) {
        Map map;
        long l = n * 60 * 1000;
        PolicyDecision policyDecision = resourceResult.getPolicyDecision();
        if (policyDecision != null && (map = policyDecision.getActionDecisions()) != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                ActionDecision actionDecision = (ActionDecision)map.get(iterator.next());
                long l2 = actionDecision.getTimeToLive();
                if (l2 >= l) continue;
                l = l2;
            }
        }
        return l;
    }

    void printSSOEntry() {
        if (debug.messageEnabled()) {
            debug.message("Printing SSOEntry");
        }
        if (this.resourceResults != null && !this.resourceResults.isEmpty()) {
            Iterator iterator = this.resourceResults.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                ClientResourceResult clientResourceResult = (ClientResourceResult)this.resourceResults.get(string);
                if (!debug.messageEnabled()) continue;
                debug.message("Printing resourceresult : " + clientResourceResult.getResourceRes().toString());
            }
        }
    }
}

