/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy.client;

import com.iplanet.am.util.Debug;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.client.SendRequestException;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.Response;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.log.Logger;
import com.sun.identity.policy.ActionDecision;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.ResBundleUtils;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.ResourceResult;
import com.sun.identity.policy.client.AppSSOTokenProvider;
import com.sun.identity.policy.client.AuthService;
import com.sun.identity.policy.client.PolicyProperties;
import com.sun.identity.policy.client.PropertiesEnum;
import com.sun.identity.policy.client.ResourceResultCache;
import com.sun.identity.policy.client.SSOEntry;
import com.sun.identity.policy.interfaces.ResourceName;
import com.sun.identity.policy.remote.PolicyEvaluationException;
import com.sun.identity.policy.remote.PolicyRequest;
import com.sun.identity.policy.remote.PolicyResponse;
import com.sun.identity.policy.remote.PolicyService;
import com.sun.identity.policy.remote.ResourceResultRequest;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class PolicyEvaluator {
    private static final String RESOURCE_SCOPE = "subtree";
    private static final String NAMING_POLICY = "policy";
    static Debug debug = Debug.getInstance((String)"amRemotePolicy");
    private PolicyProperties policyProp = null;
    private String serviceName = null;
    private ResourceName resourceComparator = null;
    private ResourceResultCache cache = null;
    AppSSOTokenProvider appSSOTokenProvider = null;
    static Logger accessLogger = null;
    static Logger errorLogger = null;

    public PolicyEvaluator(String string) throws PolicyException, SSOException {
        this.init(string, null);
    }

    PolicyEvaluator(String string, AppSSOTokenProvider appSSOTokenProvider) throws PolicyException, SSOException {
        this.init(string, appSSOTokenProvider);
    }

    private void init(String string, AppSSOTokenProvider appSSOTokenProvider) throws PolicyException, SSOException {
        this.serviceName = string;
        this.appSSOTokenProvider = appSSOTokenProvider;
        this.policyProp = new PolicyProperties();
        this.getResourceComparator();
        this.cache = ResourceResultCache.getInstance(this.policyProp, this.getAppSSOToken(), string, this.resourceComparator);
        debug.message("PolicyEvaluator is created");
    }

    AppSSOTokenProvider getAppSSOTokenProvider() {
        return this.appSSOTokenProvider;
    }

    public boolean isAllowed(SSOToken sSOToken, String string, String string2) throws PolicyException, SSOException {
        return this.isAllowed(sSOToken, string, string2, null);
    }

    public boolean isAllowed(SSOToken sSOToken, String string, String string2, Map map) throws PolicyException, SSOException {
        Object object;
        Object[] objectArray;
        Object object2;
        boolean bl = false;
        String string3 = this.policyProp.trueValue;
        if (string3 == null) {
            debug.error("PolicyEvaluator.isAllowed, true value is not set");
        } else {
            Set set;
            object2 = new HashSet<String>(1);
            ((HashSet)object2).add(string2);
            objectArray = this.getPolicyDecision(sSOToken, string, (Set)object2, map);
            object = (ActionDecision)objectArray.getActionDecisions().get(string2);
            if (object != null && (set = ((ActionDecision)object).getValues()) != null && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                bl = true;
                while (iterator.hasNext() && bl) {
                    String string4 = (String)iterator.next();
                    bl = string4.equals(string3);
                }
            }
        }
        object2 = String.valueOf(bl);
        object2 = object2 != null ? (((String)object2).equalsIgnoreCase("true") ? "ALLOW" : "DENY") : "DENY";
        objectArray = new String[]{string, string2, object2};
        object = PolicyProperties.getPolicyLogging();
        switch (((PropertiesEnum)object).getIntValue()) {
            case 0: {
                if (!bl) break;
                this.logAccessMessage(Level.INFO, ResBundleUtils.getString("policy_eval_allow", objectArray), sSOToken);
                break;
            }
            case 1: {
                if (bl) break;
                this.logAccessMessage(Level.INFO, ResBundleUtils.getString("policy_eval_deny", objectArray), sSOToken);
                break;
            }
            case 2: {
                this.logAccessMessage(Level.INFO, ResBundleUtils.getString("policy_eval_result", objectArray), sSOToken);
                break;
            }
        }
        return bl;
    }

    public PolicyDecision getPolicyDecision(SSOToken sSOToken, String string, Set set) throws PolicyException, SSOException {
        return this.getPolicyDecision(sSOToken, string, set, null);
    }

    public PolicyDecision getPolicyDecision(SSOToken sSOToken, String string, Set set, Map map) throws PolicyException, SSOException {
        PolicyDecision policyDecision = this.evaluatePolicy(sSOToken, string, set, map);
        if (policyDecision != null && set != null && !set.isEmpty()) {
            Object object;
            Map map2 = policyDecision.getActionDecisions();
            HashSet<Object> hashSet = new HashSet<Object>(map2.size());
            Iterator iterator = map2.keySet().iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                if (set.contains(object)) continue;
                hashSet.add(object);
            }
            object = hashSet.iterator();
            while (object.hasNext()) {
                map2.remove(object.next());
            }
        }
        return policyDecision;
    }

    private PolicyDecision evaluatePolicy(SSOToken sSOToken, String string, Set set, Map map) throws PolicyException, SSOException {
        PolicyDecision policyDecision = null;
        if (sSOToken == null) {
            debug.error("PolicyEvaluator.evaluatePolicy user SSO token is null");
            return null;
        }
        SSOToken sSOToken2 = this.getAppSSOToken();
        if (sSOToken2 == null) {
            return null;
        }
        ArrayList arrayList = new ArrayList(3);
        ResourceResult resourceResult = null;
        SSOEntry sSOEntry = this.cache.getEntry(this.serviceName, sSOToken);
        if (sSOEntry != null && !sSOEntry.validate(string)) {
            sSOEntry = null;
        }
        if (sSOEntry != null && sSOEntry.hasSameEnvironment(map) && (resourceResult = sSOEntry.getResourceResult(this.getRootResourceName(string))) != null) {
            if (debug.messageEnabled()) {
                debug.message("PolicyEvaluator.evaluatePolicy, got res. root from cache");
            }
            policyDecision = this.getPolicyDecision(resourceResult, string);
        }
        if (policyDecision == null) {
            if (debug.messageEnabled()) {
                debug.message("PolicyEvaluator.evaluatePolicy, get results from server");
            }
            if ((resourceResult = this.evalPolicy(sSOToken, sSOToken2, string, map)) != null) {
                if (sSOEntry == null) {
                    sSOEntry = new SSOEntry(this.serviceName, sSOToken, map, this.policyProp.pollInterval, resourceResult, this.cache);
                    this.cache.addEntry(this.serviceName, sSOEntry);
                }
                sSOEntry.addResourceResult(resourceResult);
                if (debug.messageEnabled()) {
                    debug.message("PolicyEvaluator:evaluatePolicy, cache is updated");
                }
                policyDecision = this.getPolicyDecision(resourceResult, string);
            }
        } else if (debug.messageEnabled()) {
            debug.message("PolicyEvaluator:evaluatePolicy, result is from cache");
        }
        return policyDecision;
    }

    private SSOToken getAppSSOToken() {
        SSOToken sSOToken = null;
        sSOToken = this.appSSOTokenProvider != null ? this.appSSOTokenProvider.getAppSSOToken() : AuthService.getApplicationSSOToken(this.policyProp.appUserName, this.policyProp.appPassword);
        if (sSOToken == null) {
            debug.error("PolicyEvaluator.getAppSSOToken, cannot obtain application SSO token");
        }
        return sSOToken;
    }

    private void resetDefaultAppSSOToken() {
        AuthService.resetAppSSOToken();
    }

    private ResourceResult evalPolicy(SSOToken sSOToken, SSOToken sSOToken2, String string, Map map) throws PolicyException {
        String string2;
        PolicyService policyService;
        ResourceResult resourceResult = null;
        URL uRL = this.policyProp.getServiceURL(NAMING_POLICY);
        if (uRL != null && (policyService = this.evaluatePolicy(string2 = this.getPolicyEvalRequestXML(sSOToken, sSOToken2, map, this.getRootResourceName(string)), uRL)) != null) {
            PolicyResponse policyResponse = policyService.getPolicyResponse();
            String string3 = policyResponse.getExceptionMsg();
            if (string3 != null) {
                if (string3.indexOf(ResBundleUtils.getString("app_sso_token_invalid")) >= 0) {
                    if (debug.warningEnabled()) {
                        debug.warning("PolicyEvaluator.evalPolicy : policy response exception " + policyResponse.getExceptionMsg());
                        debug.warning("PolicyEvaluator.evalPolicy : Default Application SSO token is invalid");
                        debug.warning("PolicyEvaluator.evalPolicy :  Resetting Default Application SSO token");
                    }
                    this.resetDefaultAppSSOToken();
                    sSOToken2 = this.getAppSSOToken();
                    if (debug.warningEnabled()) {
                        debug.warning("PolicyEvaluator.evalPolicy : Making Second attempt to fetch policy");
                    }
                    return this.evalPolicyInternal(sSOToken, sSOToken2, string, map);
                }
                debug.error("PolicyEvaluator.evalPolicy : policy response exception " + string3);
                throw new PolicyException(string3);
            }
            Set set = policyResponse.getResourceResults();
            if (set != null) {
                resourceResult = (ResourceResult)set.iterator().next();
            }
        }
        return resourceResult;
    }

    private ResourceResult evalPolicyInternal(SSOToken sSOToken, SSOToken sSOToken2, String string, Map map) throws PolicyException {
        String string2;
        PolicyService policyService;
        ResourceResult resourceResult = null;
        URL uRL = this.policyProp.getServiceURL(NAMING_POLICY);
        if (uRL != null && (policyService = this.evaluatePolicy(string2 = this.getPolicyEvalRequestXML(sSOToken, sSOToken2, map, this.getRootResourceName(string)), uRL)) != null) {
            PolicyResponse policyResponse = policyService.getPolicyResponse();
            String string3 = policyResponse.getExceptionMsg();
            if (string3 != null) {
                debug.error("PolicyEvaluator.evalPolicy : policy response exception " + string3);
                throw new PolicyException(string3);
            }
            Set set = policyResponse.getResourceResults();
            if (set != null) {
                resourceResult = (ResourceResult)set.iterator().next();
            }
        }
        return resourceResult;
    }

    private PolicyService evaluatePolicy(String string, URL uRL) {
        if (debug.messageEnabled()) {
            debug.message("sending policy request to " + uRL);
        }
        PolicyService policyService = null;
        Request request = new Request(string);
        RequestSet requestSet = new RequestSet(NAMING_POLICY);
        requestSet.addRequest(request);
        try {
            Vector vector = PLLClient.send((URL)uRL, (RequestSet)requestSet);
            Response response = (Response)vector.elementAt(0);
            policyService = PolicyService.parseXML(response.getContent());
        }
        catch (SendRequestException sendRequestException) {
            debug.warning("PolicyEvaluator.evaluatePolicy", (Throwable)sendRequestException);
        }
        catch (PolicyEvaluationException policyEvaluationException) {
            debug.warning("PolicyEvaluator.evaluatePolicy", (Throwable)policyEvaluationException);
        }
        return policyService;
    }

    private String getPolicyEvalRequestXML(SSOToken sSOToken, SSOToken sSOToken2, Map map, String string) {
        ResourceResultRequest resourceResultRequest = new ResourceResultRequest();
        if (map != null) {
            resourceResultRequest.setEnvParms(map);
        }
        resourceResultRequest.setResponseAttributes(this.policyProp.responseAttrs);
        resourceResultRequest.setResourceScope(RESOURCE_SCOPE);
        resourceResultRequest.setResourceName(string);
        resourceResultRequest.setServiceName(this.serviceName);
        resourceResultRequest.setUserSSOToken(sSOToken.getTokenID().toString());
        PolicyRequest policyRequest = new PolicyRequest();
        policyRequest.setMethodID(1);
        policyRequest.setAppSSOToken(sSOToken2.getTokenID().toString());
        policyRequest.setResourceResultRequest(resourceResultRequest);
        PolicyService policyService = new PolicyService();
        policyService.setMethodID(1);
        policyService.setPolicyRequest(policyRequest);
        if (debug.messageEnabled()) {
            debug.message(policyService.toXMLString());
        }
        return policyService.toXMLString();
    }

    private void getResourceComparator() throws PolicyEvaluationException {
        Map map = this.policyProp.resourceConfig;
        try {
            Class<?> clazz = Class.forName(this.policyProp.resComparatorClassName);
            this.resourceComparator = (ResourceName)clazz.newInstance();
            this.resourceComparator.initialize(map);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new PolicyEvaluationException(classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            throw new PolicyEvaluationException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new PolicyEvaluationException(illegalAccessException);
        }
    }

    private String getRootResourceName(String string) {
        if (string != null && !string.equals("")) {
            String[] stringArray = this.resourceComparator.split(string);
            return stringArray[0];
        }
        return "";
    }

    private PolicyDecision getPolicyDecision(ResourceResult resourceResult, String string) {
        long l = System.currentTimeMillis();
        HashSet<PolicyDecision> hashSet = new HashSet<PolicyDecision>();
        ArrayList<ResourceResult> arrayList = new ArrayList<ResourceResult>();
        boolean bl = false;
        arrayList.add(resourceResult);
        while (!arrayList.isEmpty() && !bl) {
            PolicyDecision policyDecision;
            ResourceResult resourceResult2 = (ResourceResult)arrayList.remove(0);
            ResourceMatch resourceMatch = this.resourceComparator.compare(string, resourceResult2.getResourceName(), this.policyProp.useWildcard);
            if (resourceMatch.equals(ResourceMatch.EXACT_MATCH)) {
                hashSet.clear();
                policyDecision = resourceResult2.getPolicyDecision();
                boolean bl2 = bl = resourceResult2.isStale() || this.isDecisionExpired(policyDecision, l);
                if (bl) continue;
                hashSet.add(policyDecision);
                arrayList.clear();
                continue;
            }
            if (resourceMatch.equals(ResourceMatch.WILDCARD_MATCH)) {
                policyDecision = resourceResult2.getPolicyDecision();
                boolean bl3 = bl = resourceResult2.isStale() || this.isDecisionExpired(policyDecision, l);
                if (bl) continue;
                hashSet.add(policyDecision);
                arrayList.addAll(resourceResult2.getResourceResults());
                continue;
            }
            arrayList.addAll(resourceResult2.getResourceResults());
        }
        if (bl) {
            return null;
        }
        if (hashSet.isEmpty()) {
            return this.getEmptyPolicyDecision(resourceResult);
        }
        return this.mergePolicyDecisions(resourceResult, hashSet);
    }

    private PolicyDecision getEmptyPolicyDecision(ResourceResult resourceResult) {
        PolicyDecision policyDecision = resourceResult.getPolicyDecision();
        PolicyDecision policyDecision2 = (PolicyDecision)policyDecision.clone();
        Map map = policyDecision2.getActionDecisions();
        map.clear();
        return policyDecision2;
    }

    private PolicyDecision mergePolicyDecisions(ResourceResult resourceResult, Set set) {
        PolicyDecision policyDecision;
        Iterator iterator = set.iterator();
        PolicyDecision policyDecision2 = (PolicyDecision)((PolicyDecision)iterator.next()).clone();
        while (iterator.hasNext()) {
            policyDecision = (PolicyDecision)iterator.next();
            PolicyEvaluator.mergePolicyDecisions(policyDecision, policyDecision2);
        }
        policyDecision = resourceResult.getPolicyDecision();
        policyDecision2.setResponseDecisions(policyDecision.getResponseDecisions());
        return policyDecision2;
    }

    private boolean isDecisionExpired(PolicyDecision policyDecision, long l) {
        boolean bl = false;
        Map map = policyDecision.getActionDecisions();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext() && !bl) {
            ActionDecision actionDecision = (ActionDecision)map.get(iterator.next());
            long l2 = actionDecision.getTimeToLive();
            boolean bl2 = bl = l2 != Long.MAX_VALUE && l2 < l;
        }
        return bl;
    }

    static void mergePolicyDecisions(PolicyDecision policyDecision, PolicyDecision policyDecision2) {
        Map map = policyDecision.getActionDecisions();
        Map map2 = policyDecision2.getActionDecisions();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            ActionDecision actionDecision = (ActionDecision)map.get(string);
            ActionDecision actionDecision2 = (ActionDecision)map2.get(string);
            Set set = actionDecision2.getValues();
            set.addAll(actionDecision.getValues());
        }
    }

    private void logAccessMessage(Level level, String string, SSOToken sSOToken) {
        block4: {
            try {
                if (accessLogger == null && (accessLogger = (Logger)Logger.getLogger((String)"amRemotePolicy.access")) == null) {
                    if (debug.warningEnabled()) {
                        debug.warning("PolicyEvaluator.logAccessMessage : Failed to create Logger");
                    }
                    return;
                }
                com.sun.identity.log.LogRecord logRecord = new com.sun.identity.log.LogRecord(level, string, (Object)sSOToken);
                accessLogger.log((LogRecord)logRecord, (Object)this.getAppSSOToken());
            }
            catch (Throwable throwable) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("PolicyEvaluator.logAccessMessage : Error writing access logs");
            }
        }
    }

    private void logErrorMessage(Level level, String string, SSOToken sSOToken) {
        block4: {
            try {
                if (errorLogger == null && (errorLogger = (Logger)Logger.getLogger((String)"amRemotePolicy.error")) == null) {
                    if (debug.warningEnabled()) {
                        debug.warning("PolicyEvaluator.logAccessMessage : Failed to create Logger");
                    }
                    return;
                }
                com.sun.identity.log.LogRecord logRecord = new com.sun.identity.log.LogRecord(level, string, (Object)sSOToken);
                errorLogger.log((LogRecord)logRecord, (Object)this.getAppSSOToken());
            }
            catch (Throwable throwable) {
                if (!debug.warningEnabled()) break block4;
                debug.warning("PolicyEvaluator.logAccessMessage : Error writing error logs");
            }
        }
    }
}

