/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.Debug;
import com.iplanet.services.util.XMLUtils;
import com.sun.identity.policy.PolicyDecision;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.policy.interfaces.ResourceName;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Node;

public class ResourceResult {
    public static final String SUBTREE_SCOPE = "subtree";
    public static final String SELF_SCOPE = "self";
    static final String VIRTUAL_ROOT = "-__viRTuAl-rOot--_";
    static final String RESOURCE_RESULT = "ResourceResult";
    static final String RESOURCE_NAME = "name";
    static final Debug DEBUG = PolicyManager.debug;
    private String resourceName = null;
    private PolicyDecision policyDecision = null;
    private Set resourceResults = new HashSet();
    private long timeToLive = Long.MAX_VALUE;
    private boolean advicesAreSet = false;
    private String stringForm = null;
    private String xmlForm = null;
    private boolean stale = false;

    ResourceResult() {
    }

    public ResourceResult(String string, PolicyDecision policyDecision) {
        this.resourceName = string;
        this.setPolicyDecision(policyDecision);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    void setResourceName(String string) {
        this.resourceName = string;
        this.stringForm = null;
        this.xmlForm = null;
    }

    public PolicyDecision getPolicyDecision() {
        return this.policyDecision;
    }

    public void setPolicyDecision(PolicyDecision policyDecision) {
        this.policyDecision = policyDecision;
        long l = policyDecision.getTimeToLive();
        if (l < this.timeToLive) {
            this.timeToLive = l;
        }
        this.advicesAreSet = this.advicesAreSet || policyDecision.hasAdvices();
        this.stringForm = null;
        this.xmlForm = null;
    }

    public Set getResourceResults() {
        return this.resourceResults;
    }

    void setResourceResults(Set set) {
        if (set == null) {
            this.resourceResults.clear();
        } else {
            this.resourceResults = set;
        }
        this.stringForm = null;
        this.xmlForm = null;
    }

    public static ResourceResult parseResourceResult(Node node) throws PolicyException {
        ResourceResult resourceResult = new ResourceResult();
        String string = XMLUtils.getNodeAttributeValue((Node)node, (String)RESOURCE_NAME);
        if (string == null) {
            DEBUG.error("ResourceResult: missing attribute name");
            Object[] objectArray = new Object[]{RESOURCE_NAME};
            throw new PolicyException("amPolicy", "missing_attribute_in_resourceresult", objectArray, null);
        }
        resourceResult.setResourceName(string);
        Node node2 = XMLUtils.getChildNode((Node)node, (String)"PolicyDecision");
        if (node2 == null) {
            DEBUG.error("ResourceResult: missing element PolicyDecision");
            Object[] objectArray = new Object[]{"PolicyDecision"};
            throw new PolicyException("amPolicy", "missing_attribute_in_resourceresult", objectArray, null);
        }
        resourceResult.setPolicyDecision(PolicyDecision.parsePolicyDecision(node2));
        Set set = XMLUtils.getChildNodes((Node)node, (String)RESOURCE_RESULT);
        if (set != null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                node2 = (Node)iterator.next();
                ResourceResult resourceResult2 = ResourceResult.parseResourceResult(node2);
                resourceResult.resourceResults.add(resourceResult2);
            }
        }
        return resourceResult;
    }

    public String toString() {
        if (this.stringForm == null) {
            StringBuffer stringBuffer = new StringBuffer(200);
            stringBuffer.append("Resource Result for resourceName : ").append(this.resourceName).append("\r\n").append("PolicyDecision : ").append(this.policyDecision).append("Nested ResourceResults : ").append(this.resourceResults);
            this.stringForm = stringBuffer.toString();
        }
        return this.stringForm;
    }

    public String toXML() {
        if (this.xmlForm == null) {
            StringBuffer stringBuffer = new StringBuffer(1000);
            stringBuffer.append("<").append(RESOURCE_RESULT).append(" ").append(RESOURCE_NAME).append("=\"").append(XMLUtils.escapeSpecialCharacters((String)this.resourceName)).append("\">").append("\r\n");
            if (this.policyDecision != null) {
                stringBuffer.append(this.policyDecision.toXML());
            }
            Iterator iterator = this.resourceResults.iterator();
            while (iterator.hasNext()) {
                ResourceResult resourceResult = (ResourceResult)iterator.next();
                stringBuffer.append(resourceResult.toXML());
            }
            stringBuffer.append("</").append(RESOURCE_RESULT).append(">").append("\r\n");
            this.xmlForm = stringBuffer.toString();
        }
        return this.xmlForm;
    }

    public void addResourceResult(ResourceResult resourceResult, ServiceType serviceType) throws PolicyException {
        this.addResourceResult(resourceResult, serviceType.getResourceNameComparator());
    }

    public void addResourceResult(ResourceResult resourceResult, ResourceName resourceName) throws PolicyException {
        long l;
        Object object;
        if (!this.isSuperResourceResultOf(resourceResult, resourceName)) {
            Object[] objectArray = new String[]{this.resourceName, resourceResult.resourceName};
            throw new PolicyException("amPolicy", "invalid_sub_resourceresult", objectArray, null);
        }
        Iterator iterator = this.resourceResults.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            object = (ResourceResult)iterator.next();
            if (!((ResourceResult)object).isSuperResourceResultOf(resourceResult, resourceName)) continue;
            ((ResourceResult)object).addResourceResult(resourceResult, resourceName);
            bl = false;
            break;
        }
        if (bl) {
            object = new HashSet();
            Iterator iterator2 = this.resourceResults.iterator();
            while (iterator2.hasNext()) {
                ResourceResult resourceResult2 = (ResourceResult)iterator2.next();
                if (!resourceResult.isSuperResourceResultOf(resourceResult2, resourceName)) continue;
                object.add(resourceResult2);
            }
            this.resourceResults.removeAll((Collection<?>)object);
            resourceResult.resourceResults.addAll(object);
            this.resourceResults.add(resourceResult);
        }
        if ((l = resourceResult.getTimeToLive()) < this.timeToLive) {
            this.timeToLive = l;
        }
        this.advicesAreSet = this.advicesAreSet || resourceResult.hasAdvices();
        this.stringForm = null;
        this.xmlForm = null;
    }

    public void markStale() {
        this.stale = true;
    }

    public boolean isStale() {
        return this.stale;
    }

    private boolean isSuperResourceResultOf(ResourceResult resourceResult, ResourceName resourceName) throws PolicyException {
        boolean bl = false;
        if (VIRTUAL_ROOT.equals(this.resourceName)) {
            bl = true;
        } else if (resourceName != null) {
            boolean bl2 = false;
            ResourceMatch resourceMatch = resourceName.compare(this.resourceName, resourceResult.resourceName, bl2);
            if (resourceMatch.equals(ResourceMatch.SUB_RESOURCE_MATCH)) {
                bl = true;
            }
        } else {
            bl = resourceResult.resourceName.startsWith(this.resourceName);
        }
        return bl;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public boolean hasAdvices() {
        return this.advicesAreSet;
    }
}

