/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.policy;

import com.iplanet.am.util.Cache;
import com.iplanet.services.util.XMLException;
import com.iplanet.services.util.XMLUtils;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.sun.identity.policy.InvalidFormatException;
import com.sun.identity.policy.NameNotFoundException;
import com.sun.identity.policy.NoPermissionException;
import com.sun.identity.policy.Policy;
import com.sun.identity.policy.PolicyException;
import com.sun.identity.policy.PolicyManager;
import com.sun.identity.policy.Referrals;
import com.sun.identity.policy.ResourceMatch;
import com.sun.identity.policy.Rule;
import com.sun.identity.policy.ServiceType;
import com.sun.identity.policy.ServiceTypeManager;
import com.sun.identity.policy.interfaces.Referral;
import com.sun.identity.policy.plugins.OrgReferral;
import com.sun.identity.sm.SMSException;
import com.sun.identity.sm.SMSSchema;
import com.sun.identity.sm.SchemaException;
import com.sun.identity.sm.ServiceConfig;
import com.sun.identity.sm.ServiceConfigManager;
import com.sun.identity.sm.ServiceManager;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import netscape.ldap.util.DN;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ResourceManager {
    private String org = "/";
    private SSOToken token = null;
    private ServiceConfigManager scm = null;
    private boolean canCreateNewRes = false;
    ServiceTypeManager stm = null;
    private ServiceConfig rConfig = null;
    private Hashtable serviceTypeHash = new Hashtable();
    private static final String RESOURCES_XML = "xmlresources";
    private static final String RESOURCE_PREFIXES = "resourceprefixes";
    static final String EMPTY_RESOURCE_NAME = "---EMPTY---";
    static final String LTS = "<";
    static final String LTSS = "</";
    static final String GTS = ">";
    static final String SGTS = "/>";
    static final String SPACE = " ";
    static final String QUOTE = "\"";
    static final String EQUALS = "=";
    static final String NEW_LINE = "\n";
    static final String RESOURCE_PREFIXES_XML = "resourcePrefixesXml";
    static final String ATTRIBUTE_VALUE_PAIR = "AttributValuePair";
    static final String PREFIX = "Prefix";
    static final String NAME = "name";
    static final String COUNT = "count";
    Cache policyNames = new Cache(1000);

    ResourceManager(SSOToken sSOToken, String string, ServiceConfigManager serviceConfigManager) throws SSOException {
        this.token = sSOToken;
        this.org = string;
        this.scm = serviceConfigManager;
        DN dN = new DN(this.org);
        DN dN2 = new DN(ServiceManager.getBaseDN());
        this.stm = ServiceTypeManager.getServiceTypeManager();
        String string2 = serviceConfigManager.getName();
        this.canCreateNewRes = dN.equals(dN2);
        Object var7_7 = null;
    }

    public Set getManagedResourceNames() throws PolicyException {
        HashSet hashSet = null;
        ServiceConfig serviceConfig = this.getResourcesServiceConfig(false);
        if (serviceConfig == null) {
            hashSet = Collections.EMPTY_SET;
        } else {
            Set set = null;
            try {
                set = serviceConfig.getSubConfigNames();
            }
            catch (SMSException sMSException) {
                throw new PolicyException(sMSException);
            }
            if (set == null || set.isEmpty()) {
                hashSet = Collections.EMPTY_SET;
            } else {
                hashSet = new HashSet();
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    hashSet.addAll(this.getManagedResourceNames(string));
                }
            }
        }
        return hashSet;
    }

    public Set getManagedResourceNames(String string) throws PolicyException {
        Set set;
        ServiceConfig serviceConfig = this.getResourcesServiceConfig(false);
        if (serviceConfig == null) {
            return Collections.EMPTY_SET;
        }
        ServiceConfig serviceConfig2 = null;
        try {
            serviceConfig2 = serviceConfig.getSubConfig(string);
        }
        catch (SMSException sMSException) {
            throw new PolicyException(sMSException);
        }
        catch (SSOException sSOException) {
            throw new PolicyException("amPolicy", "invalid_sso_token", null, null);
        }
        if (serviceConfig2 == null) {
            return Collections.EMPTY_SET;
        }
        Map map = null;
        map = serviceConfig2.getAttributes();
        if (map == null || !map.containsKey(RESOURCE_PREFIXES)) {
            return Collections.EMPTY_SET;
        }
        Set set2 = set = (Set)map.get(RESOURCE_PREFIXES);
        if (set != null && !set.isEmpty()) {
            String string2 = (String)set.iterator().next();
            set2 = this.xmlToResourcePrefixes(string2).keySet();
        }
        return set2;
    }

    public boolean canCreateNewResource(String string) throws PolicyException {
        return this.canCreateNewRes;
    }

    public Set getValidServiceNames() throws SSOException, PolicyException {
        HashSet<String> hashSet = null;
        Iterator iterator = this.stm.getServiceTypeNames().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (!this.canCreateNewResource(string) && this.getManagedResourceNames(string).isEmpty()) continue;
            if (hashSet == null) {
                hashSet = new HashSet<String>();
            }
            hashSet.add(string);
        }
        return hashSet == null ? Collections.EMPTY_SET : hashSet;
    }

    public Set getPolicyNames(String string, String string2, boolean bl) throws InvalidFormatException, NoPermissionException, PolicyException, SSOException {
        StringBuffer stringBuffer = new StringBuffer();
        String string3 = stringBuffer.append(string).append(string2).append(bl).toString();
        Set set = null;
        set = (Set)this.policyNames.get((Object)string3);
        if (set != null) {
            return set;
        }
        Node node = this.getXMLRootNode(string);
        if (node == null) {
            return Collections.EMPTY_SET;
        }
        ServiceType serviceType = this.getServiceType(string);
        set = this.getPolicyNames(node, null, serviceType, string2, bl);
        this.policyNames.put((Object)string3, (Object)set);
        return set;
    }

    private ServiceType getServiceType(String string) throws SSOException, NameNotFoundException {
        ServiceType serviceType = (ServiceType)this.serviceTypeHash.get(string);
        if (serviceType == null) {
            serviceType = this.stm.getServiceType(string);
            this.serviceTypeHash.put(string, serviceType);
        }
        return serviceType;
    }

    void addPolicyToResourceTree(Policy policy) throws PolicyException, SSOException {
        Set set;
        Set set2 = policy.getRuleNames();
        Iterator iterator = set2.iterator();
        String string = null;
        Rule rule = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            rule = policy.getRule(string);
            this.addRuleToResourceTree(policy.getName(), rule);
        }
        Referrals referrals = policy.getReferrals();
        if (referrals != null && (set = referrals.getReferralNames()) != null && !set.isEmpty()) {
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                Set set3;
                String string2 = (String)iterator2.next();
                Referral referral = referrals.getReferral(string2);
                if (!(referral instanceof OrgReferral) || (set3 = referral.getValues()) == null || set3.isEmpty()) continue;
                Iterator iterator3 = set3.iterator();
                while (iterator3.hasNext()) {
                    String string3 = (String)iterator3.next();
                    PolicyManager policyManager = new PolicyManager(this.token, string3);
                    ResourceManager resourceManager = policyManager.getResourceManager();
                    Set set4 = policy.getRuleNames();
                    Iterator iterator4 = set4.iterator();
                    while (iterator4.hasNext()) {
                        String string4 = (String)iterator4.next();
                        Rule rule2 = policy.getRule(string4);
                        String string5 = rule2.getResourceName();
                        if (string5 == null) continue;
                        String string6 = rule2.getServiceTypeName();
                        HashSet<String> hashSet = new HashSet<String>();
                        hashSet.add(string5);
                        resourceManager.addResourcePrefixes(string6, hashSet);
                    }
                }
            }
        }
    }

    void removePolicyFromResourceTree(Policy policy) throws PolicyException, SSOException {
        Set set;
        Set set2 = policy.getRuleNames();
        Iterator iterator = set2.iterator();
        String string = null;
        Rule rule = null;
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            rule = policy.getRule(string);
            this.removeRuleFromResourceTree(policy.getName(), rule.getResourceName(), rule.getServiceTypeName(), rule.getServiceType());
        }
        Referrals referrals = policy.getReferrals();
        if (referrals != null && (set = referrals.getReferralNames()) != null && !set.isEmpty()) {
            Iterator iterator2 = set.iterator();
            while (iterator2.hasNext()) {
                Set set3;
                String string2 = (String)iterator2.next();
                Referral referral = referrals.getReferral(string2);
                if (!(referral instanceof OrgReferral) || (set3 = referral.getValues()) == null || set3.isEmpty()) continue;
                Iterator iterator3 = set3.iterator();
                while (iterator3.hasNext()) {
                    String string3 = (String)iterator3.next();
                    PolicyManager policyManager = new PolicyManager(this.token, string3);
                    ResourceManager resourceManager = policyManager.getResourceManager();
                    Iterator iterator4 = policy.getRuleNames().iterator();
                    while (iterator4.hasNext()) {
                        String string4 = (String)iterator4.next();
                        Rule rule2 = policy.getRule(string);
                        String string5 = rule2.getResourceName();
                        if (string5 == null) continue;
                        String string6 = rule2.getServiceTypeName();
                        HashSet<String> hashSet = new HashSet<String>();
                        hashSet.add(string5);
                        resourceManager.removeResourcePrefixes(string6, hashSet);
                    }
                }
            }
        }
    }

    void replacePolicyInResourceTree(Policy policy, Policy policy2) throws PolicyException, SSOException {
        this.removePolicyFromResourceTree(policy);
        this.addPolicyToResourceTree(policy2);
    }

    private ServiceConfig getResourcesServiceConfig(boolean bl) throws PolicyException {
        if (this.rConfig == null) {
            try {
                ServiceConfig serviceConfig;
                this.rConfig = bl ? PolicyManager.createOrGetPolicyConfig("Resources", "Resources", this.scm, this.org) : ((serviceConfig = this.scm.getOrganizationConfig(this.org, null)) == null ? null : serviceConfig.getSubConfig("Resources"));
            }
            catch (SMSException sMSException) {
                throw new PolicyException(sMSException);
            }
            catch (SSOException sSOException) {
                throw new PolicyException("amPolicy", "invalid_sso_token", null, null);
            }
        }
        return this.rConfig;
    }

    private void addRuleToResourceTree(String string, Rule rule) throws PolicyException, SSOException {
        Node node;
        ServiceConfig serviceConfig;
        String string2 = rule.getResourceName();
        String string3 = rule.getServiceTypeName();
        ServiceType serviceType = rule.getServiceType();
        if (string2 == null || string2.equals("")) {
            string2 = EMPTY_RESOURCE_NAME;
        }
        if ((serviceConfig = this.getResourcesServiceConfig(true)) == null) {
            return;
        }
        ServiceConfig serviceConfig2 = null;
        try {
            serviceConfig2 = serviceConfig.getSubConfig(string3);
        }
        catch (SMSException sMSException) {
            throw new PolicyException(sMSException);
        }
        if (serviceConfig2 == null) {
            try {
                String string4 = rule.toResourcesXml(string);
                HashMap hashMap = new HashMap();
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add(string4);
                hashMap.put(RESOURCES_XML, hashSet);
                serviceConfig.addSubConfig(string3, "ServiceType", 0, hashMap);
            }
            catch (SMSException sMSException) {
                throw new PolicyException(sMSException);
            }
            return;
        }
        Map map = null;
        map = serviceConfig2.getAttributes();
        if (map == null || !map.containsKey(RESOURCES_XML)) {
            try {
                String string5 = rule.toResourcesXml(string);
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add(string5);
                serviceConfig2.addAttribute(RESOURCES_XML, hashSet);
            }
            catch (SMSException sMSException) {
                throw new PolicyException(sMSException);
            }
            return;
        }
        Set set = (Set)map.get(RESOURCES_XML);
        if (set.isEmpty()) {
            try {
                String string6 = rule.toResourcesXml(string);
                HashMap hashMap = new HashMap();
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add(string6);
                hashMap.put(RESOURCES_XML, hashSet);
                serviceConfig2.setAttributes(hashMap);
            }
            catch (SMSException sMSException) {
                throw new PolicyException(sMSException);
            }
            return;
        }
        Object[] objectArray = this.getXMLRootNode(set);
        Document document = (Document)objectArray[1];
        boolean bl = this.matchAndAddReferenceNode(document, node = (Node)objectArray[0], string2, string, serviceType);
        if (!bl) {
            return;
        }
        String string7 = SMSSchema.nodeToString(node);
        HashMap hashMap = new HashMap();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string7);
        hashMap.put(RESOURCES_XML, hashSet);
        try {
            serviceConfig2.setAttributes(hashMap);
        }
        catch (SMSException sMSException) {
            throw new PolicyException(sMSException);
        }
    }

    private void removeRuleFromResourceTree(String string, String string2, String string3, ServiceType serviceType) throws PolicyException, SSOException {
        ServiceConfig serviceConfig;
        if (string2 == null || string2.equals("")) {
            string2 = EMPTY_RESOURCE_NAME;
        }
        if ((serviceConfig = this.getResourcesServiceConfig(false)) == null) {
            return;
        }
        ServiceConfig serviceConfig2 = null;
        try {
            serviceConfig2 = serviceConfig.getSubConfig(string3);
        }
        catch (SMSException sMSException) {
            throw new PolicyException(sMSException);
        }
        if (serviceConfig2 == null) {
            return;
        }
        Map map = null;
        map = serviceConfig2.getAttributes();
        if (map == null || !map.containsKey(RESOURCES_XML)) {
            return;
        }
        int n = map.size();
        Set set = (Set)map.get(RESOURCES_XML);
        if (set.isEmpty()) {
            return;
        }
        Object[] objectArray = this.getXMLRootNode(set);
        Node node = (Node)objectArray[0];
        boolean bl = this.matchAndRemoveReferenceNode(node, string2, string, serviceType, new Stack());
        if (!bl) {
            return;
        }
        if (!node.hasChildNodes()) {
            try {
                serviceConfig2.removeAttribute(RESOURCES_XML);
                if (n == 1) {
                    serviceConfig.removeSubConfig(string3);
                }
                return;
            }
            catch (SMSException sMSException) {
                throw new PolicyException(sMSException);
            }
        }
        String string4 = SMSSchema.nodeToString(node);
        HashMap hashMap = new HashMap();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string4);
        hashMap.put(RESOURCES_XML, hashSet);
        try {
            serviceConfig2.setAttributes(hashMap);
        }
        catch (SMSException sMSException) {
            throw new PolicyException(sMSException);
        }
    }

    private boolean matchAndAddReferenceNode(Document document, Node node, String string, String string2, ServiceType serviceType) throws PolicyException {
        boolean bl = true;
        Set set = XMLUtils.getChildNodes((Node)node, (String)"Reference");
        if (set == null || set.isEmpty()) {
            this.addReferenceNodes(document, node, string, string2, serviceType);
            return bl;
        }
        Iterator iterator = set.iterator();
        Node node2 = null;
        String string3 = null;
        ResourceMatch resourceMatch = null;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            node2 = (Node)iterator.next();
            string3 = XMLUtils.getNodeAttributeValue((Node)node2, (String)NAME);
            resourceMatch = serviceType.compare(string, string3);
            if (resourceMatch.equals(ResourceMatch.EXACT_MATCH)) {
                bl2 = true;
                Set set2 = this.getPolicyNames(node2);
                if (set2.contains(string2)) {
                    bl = false;
                    break;
                }
                this.addPolicyNameNode(document, node2, string2);
                break;
            }
            if (!resourceMatch.equals(ResourceMatch.SUPER_RESOURCE_MATCH)) continue;
            bl2 = true;
            String string4 = serviceType.getSubResource(string, string3);
            bl = this.matchAndAddReferenceNode(document, node2, string4, string2, serviceType);
            break;
        }
        if (!bl2) {
            this.addReferenceNodes(document, node, string, string2, serviceType);
        }
        return bl;
    }

    private boolean matchAndRemoveReferenceNode(Node node, String string, String string2, ServiceType serviceType, Stack stack) throws PolicyException {
        Set set = XMLUtils.getChildNodes((Node)node, (String)"Reference");
        if (set == null || set.isEmpty()) {
            return false;
        }
        Iterator iterator = set.iterator();
        Node node2 = null;
        String string3 = null;
        ResourceMatch resourceMatch = null;
        while (iterator.hasNext()) {
            node2 = (Node)iterator.next();
            string3 = XMLUtils.getNodeAttributeValue((Node)node2, (String)NAME);
            resourceMatch = serviceType.compare(string, string3);
            if (resourceMatch.equals(ResourceMatch.EXACT_MATCH)) {
                stack.push(node);
                return this.removePolicyNameNode(node2, string2, stack);
            }
            if (!resourceMatch.equals(ResourceMatch.SUPER_RESOURCE_MATCH)) continue;
            String string4 = serviceType.getSubResource(string, string3);
            stack.push(node);
            return this.matchAndRemoveReferenceNode(node2, string4, string2, serviceType, stack);
        }
        return false;
    }

    private void addPolicyNameNode(Document document, Node node, String string) throws PolicyException {
        Element element = document.createElement("PolicyName");
        element.setAttribute(NAME, string);
        node.appendChild(element);
    }

    private boolean removePolicyNameNode(Node node, String string, Stack stack) throws PolicyException {
        Set set = XMLUtils.getChildNodes((Node)node, (String)"PolicyName");
        int n = set.size();
        Iterator iterator = set.iterator();
        Node node2 = null;
        String string2 = null;
        while (iterator.hasNext()) {
            node2 = (Node)iterator.next();
            string2 = XMLUtils.getNodeAttributeValue((Node)node2, (String)NAME);
            if (!string2.equals(string)) continue;
            node.removeChild(node2);
            this.removeReferenceNodes(node, stack);
            return true;
        }
        return false;
    }

    private void addReferenceNodes(Document document, Node node, String string, String string2, ServiceType serviceType) throws PolicyException {
        String[] stringArray = serviceType.split(string);
        int n = stringArray.length;
        if (n < 1) {
            return;
        }
        Element[] elementArray = new Element[n];
        Element element = document.createElement("PolicyName");
        element.setAttribute(NAME, string2);
        elementArray[n - 1] = document.createElement("Reference");
        elementArray[n - 1].setAttribute(NAME, stringArray[n - 1]);
        elementArray[n - 1].appendChild(element);
        int n2 = n - 2;
        while (n2 >= 0) {
            elementArray[n2] = document.createElement("Reference");
            elementArray[n2].setAttribute(NAME, stringArray[n2]);
            elementArray[n2].appendChild(elementArray[n2 + 1]);
            --n2;
        }
        node.appendChild(elementArray[0]);
    }

    private void removeReferenceNodes(Node node, Stack stack) {
        if (!node.hasChildNodes() && !stack.empty()) {
            Node node2 = (Node)stack.pop();
            node2.removeChild(node);
            this.removeReferenceNodes(node2, stack);
        }
    }

    Node getXMLRootNode(String string) throws InvalidFormatException, NoPermissionException, PolicyException {
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("searching for resources of the service type: " + string + " in organization: " + this.org);
        }
        try {
            ServiceConfig serviceConfig = this.getResourcesServiceConfig(false);
            if (serviceConfig == null) {
                if (PolicyManager.debug.messageEnabled()) {
                    PolicyManager.debug.message("Resources branch is non-existent in organization: " + this.org);
                }
                return null;
            }
            ServiceConfig serviceConfig2 = serviceConfig.getSubConfig(string);
            if (serviceConfig2 == null) {
                if (PolicyManager.debug.warningEnabled()) {
                    PolicyManager.debug.warning(string + " branch under Resources is null" + " in organization: " + this.org);
                }
                return null;
            }
            Map map = serviceConfig2.getAttributes();
            Set set = null;
            if (map != null) {
                set = (Set)map.get(RESOURCES_XML);
            }
            if (set == null) {
                if (PolicyManager.debug.warningEnabled()) {
                    PolicyManager.debug.warning("Unable to find resources attribute for the service: " + string + " under Resources in organization: " + this.org);
                }
                return null;
            }
            if (set.isEmpty()) {
                if (PolicyManager.debug.warningEnabled()) {
                    PolicyManager.debug.warning("Unable to find resources attribute value for the service: " + string + " in organization: " + this.org);
                }
                return null;
            }
            Object[] objectArray = this.getXMLRootNode(set);
            return (Node)objectArray[0];
        }
        catch (SMSException sMSException) {
            PolicyManager.debug.error("Unable to get resources of the service type: " + string + " in organization" + this.org);
            Object[] objectArray = new String[]{string, this.org};
            if (sMSException.getExceptionCode() == SMSException.STATUS_NO_PERMISSION) {
                throw new NoPermissionException("amPolicy", "unable_to_get_resources_for_service", objectArray);
            }
            throw new PolicyException(sMSException);
        }
        catch (SSOException sSOException) {
            throw new PolicyException("amPolicy", "invalid_sso_token", null, null);
        }
    }

    private Object[] getXMLRootNode(Set set) throws PolicyException {
        Iterator iterator = set.iterator();
        String string = (String)iterator.next();
        Document document = null;
        try {
            document = SMSSchema.getXMLDocument(string, false);
        }
        catch (SchemaException schemaException) {
            PolicyManager.debug.error("XML parsing error: " + string);
            throw new PolicyException(schemaException);
        }
        catch (SMSException sMSException) {
            throw new PolicyException(sMSException);
        }
        Node node = XMLUtils.getRootNode((Document)document, (String)"PolicyCrossReferences");
        if (node == null) {
            PolicyManager.debug.error("invalid (no root node) xml resources blob: " + string);
            throw new InvalidFormatException("amPolicy", "invalid_resources_blob_no_root", null, "", 3);
        }
        String string2 = XMLUtils.getNodeAttributeValue((Node)node, (String)"type");
        if (!string2.equals("Resources")) {
            PolicyManager.debug.error("invalid (no type attr for PolicyCrossReference element) xml resources blob: " + string);
            throw new InvalidFormatException("amPolicy", "invalid_resources_blob_no_type", null, "", 3);
        }
        if (PolicyManager.debug.messageEnabled()) {
            PolicyManager.debug.message("returning XML root node");
        }
        Object[] objectArray = new Object[]{node, document};
        return objectArray;
    }

    private Set getPolicyNames(Node node, String string, ServiceType serviceType, String string2, boolean bl) {
        Set set = XMLUtils.getChildNodes((Node)node, (String)"Reference");
        Iterator iterator = set.iterator();
        Node node2 = null;
        String string3 = null;
        String string4 = null;
        ResourceMatch resourceMatch = null;
        while (iterator.hasNext()) {
            node2 = (Node)iterator.next();
            string3 = XMLUtils.getNodeAttributeValue((Node)node2, (String)NAME);
            string4 = string == null ? string3 : serviceType.append(string, string3);
            resourceMatch = serviceType.compare(string2, string4);
            if (resourceMatch.equals(ResourceMatch.EXACT_MATCH)) {
                return this.getPolicyNames(node2);
            }
            if (!resourceMatch.equals(ResourceMatch.SUPER_RESOURCE_MATCH)) continue;
            if (!bl) {
                return this.getPolicyNames(node2, string4, serviceType, string2, false);
            }
            Set set2 = this.getPolicyNames(node2);
            Set set3 = this.getPolicyNames(node2, string4, serviceType, string2, true);
            if (set3.isEmpty()) {
                return set2;
            }
            if (set2.isEmpty()) {
                return set3;
            }
            set2.addAll(set3);
            return set2;
        }
        if (!bl && string != null) {
            return this.getPolicyNames(node2);
        }
        return Collections.EMPTY_SET;
    }

    private Set getPolicyNames(Node node) {
        if (node == null) {
            return Collections.EMPTY_SET;
        }
        Set set = XMLUtils.getChildNodes((Node)node, (String)"PolicyName");
        Iterator iterator = set.iterator();
        Node node2 = null;
        String string = null;
        HashSet<String> hashSet = new HashSet<String>();
        while (iterator.hasNext()) {
            node2 = (Node)iterator.next();
            string = XMLUtils.getNodeAttributeValue((Node)node2, (String)NAME);
            hashSet.add(string);
        }
        return hashSet;
    }

    void addResourcePrefixes(String string, Set set) throws PolicyException {
        ServiceConfig serviceConfig = this.getResourcesServiceConfig(true);
        if (serviceConfig == null) {
            return;
        }
        ServiceConfig serviceConfig2 = null;
        try {
            serviceConfig2 = serviceConfig.getSubConfig(string);
        }
        catch (SMSException sMSException) {
            throw new PolicyException(sMSException);
        }
        catch (SSOException sSOException) {
            throw new PolicyException("amPolicy", "invalid_sso_token", null, null);
        }
        if (serviceConfig2 == null) {
            try {
                HashMap hashMap = new HashMap();
                HashSet<String> hashSet = new HashSet<String>();
                Map map = this.addResourcePrefixes(set, new HashMap());
                hashSet.clear();
                hashSet.add(ResourceManager.resourcePrefixesToXml(map));
                hashMap.put(RESOURCE_PREFIXES, hashSet);
                serviceConfig.addSubConfig(string, "ServiceType", 0, hashMap);
            }
            catch (SMSException sMSException) {
                throw new PolicyException(sMSException);
            }
            catch (SSOException sSOException) {
                throw new PolicyException("amPolicy", "invalid_sso_token", null, null);
            }
            return;
        }
        Map map = null;
        map = serviceConfig2.getAttributes();
        if (map == null || !map.containsKey(RESOURCE_PREFIXES)) {
            try {
                HashSet<String> hashSet = new HashSet<String>();
                Map map2 = this.addResourcePrefixes(set, new HashMap());
                hashSet.clear();
                hashSet.add(ResourceManager.resourcePrefixesToXml(map2));
                serviceConfig2.addAttribute(RESOURCE_PREFIXES, hashSet);
            }
            catch (SMSException sMSException) {
                throw new PolicyException(sMSException);
            }
            catch (SSOException sSOException) {
                throw new PolicyException("amPolicy", "invalid_sso_token", null, null);
            }
            return;
        }
        Set set2 = (Set)map.get(RESOURCE_PREFIXES);
        try {
            Object object;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Map map3 = null;
            if (set2 != null && !set2.isEmpty()) {
                object = (String)set2.iterator().next();
                map3 = this.xmlToResourcePrefixes((String)object);
            } else {
                map3 = new HashMap();
            }
            map3 = this.addResourcePrefixes(set, map3);
            object = new HashSet(1);
            object.add(ResourceManager.resourcePrefixesToXml(map3));
            hashMap.put(RESOURCE_PREFIXES, object);
            serviceConfig2.setAttributes(hashMap);
        }
        catch (SMSException sMSException) {
            throw new PolicyException(sMSException);
        }
        catch (SSOException sSOException) {
            throw new PolicyException("amPolicy", "invalid_sso_token", null, null);
        }
    }

    void removeResourcePrefixes(String string, Set set) throws PolicyException {
        Object object;
        ServiceConfig serviceConfig = this.getResourcesServiceConfig(false);
        if (serviceConfig == null) {
            return;
        }
        ServiceConfig serviceConfig2 = null;
        try {
            serviceConfig2 = serviceConfig.getSubConfig(string);
        }
        catch (SMSException sMSException) {
            throw new PolicyException(sMSException);
        }
        catch (SSOException sSOException) {
            throw new PolicyException("amPolicy", "invalid_sso_token", null, null);
        }
        if (serviceConfig2 == null) {
            return;
        }
        Map map = null;
        map = serviceConfig2.getAttributes();
        if (map == null || !map.containsKey(RESOURCE_PREFIXES)) {
            return;
        }
        int n = map.size();
        Set set2 = (Set)map.get(RESOURCE_PREFIXES);
        Map map2 = null;
        if (set2 != null && !set2.isEmpty()) {
            object = (String)set2.iterator().next();
            map2 = this.xmlToResourcePrefixes((String)object);
        } else {
            map2 = new HashMap();
        }
        object = new HashMap();
        map2 = this.removeResourcePrefixes(set, map2);
        HashSet<String> hashSet = new HashSet<String>(1);
        hashSet.add(ResourceManager.resourcePrefixesToXml(map2));
        object.put(RESOURCE_PREFIXES, hashSet);
        try {
            serviceConfig2.setAttributes((Map)object);
        }
        catch (SMSException sMSException) {
            throw new PolicyException(sMSException);
        }
        catch (SSOException sSOException) {
            throw new PolicyException("amPolicy", "invalid_sso_token", null, null);
        }
    }

    public String[] splitResourceName(String string, String string2) throws NameNotFoundException, SSOException, PolicyException {
        ServiceType serviceType = this.getServiceType(string);
        Set set = this.getManagedResourceNames(string);
        String[] stringArray = new String[2];
        if (set.isEmpty()) {
            stringArray[0] = "";
            stringArray[1] = string2;
            return stringArray;
        }
        Iterator iterator = set.iterator();
        String string3 = null;
        ResourceMatch resourceMatch = null;
        boolean bl = false;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            string3 = (String)iterator.next();
            resourceMatch = serviceType.compare(string2, string3);
            if (resourceMatch.equals(ResourceMatch.SUPER_RESOURCE_MATCH)) {
                bl = true;
                break;
            }
            if (!resourceMatch.equals(ResourceMatch.EXACT_MATCH)) continue;
            bl2 = true;
            break;
        }
        if (bl) {
            stringArray[0] = string3;
            stringArray[1] = serviceType.getSubResource(string2, string3);
            return stringArray;
        }
        if (bl2) {
            stringArray[0] = string3;
            stringArray[1] = "";
            return stringArray;
        }
        stringArray[0] = "";
        stringArray[1] = string2;
        return stringArray;
    }

    void saveResourceIndex(String string, String string2) throws PolicyException, SSOException {
        HashMap hashMap = new HashMap();
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add(string2);
        hashMap.put(RESOURCES_XML, hashSet);
        ServiceConfig serviceConfig = this.getResourcesServiceConfig(true);
        if (serviceConfig != null) {
            ServiceConfig serviceConfig2 = null;
            try {
                serviceConfig2 = serviceConfig.getSubConfig(string);
                if (serviceConfig2 == null) {
                    serviceConfig.addSubConfig(string, "ServiceType", 0, hashMap);
                } else {
                    serviceConfig2.setAttributes(hashMap);
                }
            }
            catch (SMSException sMSException) {
                throw new PolicyException(sMSException);
            }
        }
    }

    private Map xmlToResourcePrefixes(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        try {
            Set set;
            Node node;
            Document document = XMLUtils.getXMLDocument((InputStream)new ByteArrayInputStream(string.getBytes()));
            if (document != null && (node = XMLUtils.getRootNode((Document)document, (String)RESOURCE_PREFIXES)) != null && (set = XMLUtils.getChildNodes((Node)node, (String)PREFIX)) != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Node node2 = (Node)iterator.next();
                    String string2 = XMLUtils.getNodeAttributeValue((Node)node2, (String)NAME);
                    String string3 = XMLUtils.getNodeAttributeValue((Node)node2, (String)COUNT);
                    if (string2 == null || string3 == null) continue;
                    hashMap.put(string2, string3);
                }
            }
        }
        catch (XMLException xMLException) {
            PolicyManager.debug.error("XML parsing error for resource prefixes  in organization: " + this.org);
        }
        return hashMap;
    }

    private static String resourcePrefixesToXml(Map map) {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append(LTS).append(RESOURCE_PREFIXES).append(GTS).append(NEW_LINE);
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = (String)map.get(string);
            stringBuffer.append(LTS).append(PREFIX).append(SPACE).append(NAME).append(EQUALS).append(QUOTE).append(XMLUtils.escapeSpecialCharacters((String)string)).append(QUOTE).append(SPACE).append(COUNT).append(EQUALS).append(QUOTE).append(string2).append(QUOTE).append(SGTS).append(NEW_LINE);
        }
        stringBuffer.append(LTSS).append(RESOURCE_PREFIXES).append(GTS).append(NEW_LINE);
        return stringBuffer.toString();
    }

    private Map addResourcePrefixes(Set set, Map map) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = 0;
            String string2 = (String)map.get(string);
            if (string2 != null) {
                try {
                    n = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    PolicyManager.debug.error("ResourceManager.addResourcePrefixes:", (Throwable)exception);
                }
            }
            map.put(string, Integer.toString(++n));
        }
        return map;
    }

    private Map removeResourcePrefixes(Set set, Map map) {
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int n = 0;
            String string2 = (String)map.get(string);
            if (string2 != null) {
                try {
                    n = Integer.parseInt(string2);
                }
                catch (Exception exception) {
                    PolicyManager.debug.error("ResourceManager.removeResourcePrefixes:", (Throwable)exception);
                }
            }
            if (--n > 0) {
                map.put(string, Integer.toString(n));
                continue;
            }
            map.remove(string);
        }
        return map;
    }
}

