/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.registration;

import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSNameRegistrationResponse;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.federation.services.registration.FSNameRegistrationHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.federation.services.util.FSSignatureUtil;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import java.io.IOException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class FSRegistrationReturnServlet
extends HttpServlet {
    ServletConfig config = null;
    FSAllianceManager allianceInst = null;
    private static String COMMON_ERROR_PAGE = "";
    private HttpServletRequest request = null;

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSRegistrationReturnServlet Initializing...");
        }
        this.config = servletConfig;
        this.allianceInst = FSServiceUtils.getAllianceInstance();
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        this.doGetPost(httpServletRequest, httpServletResponse);
    }

    private void doGetPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSRegistrationReturnServlet doGetPost...");
        }
        String string = "";
        if (!FSServiceUtils.isLibertyEnabled()) {
            FSUtils.debug.error("FSRegistrationReturnServlet: " + FSUtils.bundle.getString("notLibertyEnabled"));
            FSUtils.error("FSRegistrationReturnServlet", FSUtils.bundle.getString("notLibertyEnabled"));
            httpServletResponse.sendError(500, FSUtils.bundle.getString("notLibertyEnabled"));
            return;
        }
        string = FSServiceUtils.getMetaAlias(httpServletRequest);
        if (string == null || string.length() < 1) {
            FSUtils.debug.message("Unable to retrieve alias, Hosted Provider. Cannot process request");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("aliasNotFound"));
            return;
        }
        FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
        try {
            fSHostedProviderDescriptor = this.allianceInst.getHostedProviderByMetaAlias(string);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("Failed to get Hosted Provider");
            httpServletResponse.sendError(500, FSUtils.bundle.getString("failed-reading-hosted-descriptor"));
            return;
        }
        this.request = httpServletRequest;
        this.setRegistrationURL(fSHostedProviderDescriptor.getProviderID());
        FSNameRegistrationResponse fSNameRegistrationResponse = new FSNameRegistrationResponse();
        try {
            fSNameRegistrationResponse = FSNameRegistrationResponse.parseURLEncodedRequest(httpServletRequest);
        }
        catch (FSMsgException fSMsgException) {
            this.showBadRequestErrorPage(httpServletResponse);
            return;
        }
        catch (SAMLException sAMLException) {
            this.showBadRequestErrorPage(httpServletResponse);
            return;
        }
        String string2 = fSNameRegistrationResponse.getProviderId();
        FSProviderDescriptor fSProviderDescriptor = null;
        try {
            fSProviderDescriptor = this.allianceInst.getProvider(string2);
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            // empty catch block
        }
        if (fSProviderDescriptor == null) {
            this.showBadRequestErrorPage(httpServletResponse);
            return;
        }
        boolean bl = true;
        try {
            if (FSServiceUtils.isSigningOn()) {
                bl = this.verifyResponseSignature(httpServletRequest, fSProviderDescriptor);
            }
        }
        catch (SAMLException sAMLException) {
        }
        catch (FSException fSException) {
            // empty catch block
        }
        if (bl) {
            FSNameRegistrationHandler fSNameRegistrationHandler = new FSNameRegistrationHandler();
            fSNameRegistrationHandler.setHostedDescriptor(fSHostedProviderDescriptor);
            fSNameRegistrationHandler.setRemoteDescriptor(fSProviderDescriptor);
            fSNameRegistrationHandler.processRegistrationResponse(httpServletRequest, httpServletResponse, fSNameRegistrationResponse);
            return;
        }
        FSUtils.debug.error("FSRegistrationReturnServlet Signature on registration request is invalidCannot proceed name registration");
        FSUtils.error("FSRegistrationReturnServlet", FSUtils.bundle.getString("registration-invalid-signature"));
        this.showBadRequestErrorPage(httpServletResponse);
    }

    private boolean verifyResponseSignature(HttpServletRequest httpServletRequest, FSProviderDescriptor fSProviderDescriptor) throws SAMLException, FSException {
        boolean bl;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Entered FSRegistrationRequestServlet::verifyRegistrationSignature");
        }
        String string = "";
        string = fSProviderDescriptor.getKeyInfo();
        if (string == null || string.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSRegistrationRequestServlet.verifyRegistrationSignature: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannot-find-cert-alias"));
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("The certAlias is : " + string);
        }
        if (!(bl = FSSignatureUtil.verifyRequestSignature(httpServletRequest, string))) {
            FSUtils.debug.error("Registration response is not properly signed");
            return false;
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Registration response is properly signed");
        }
        return true;
    }

    private void showBadRequestErrorPage(HttpServletResponse httpServletResponse) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(COMMON_ERROR_PAGE);
        char c = COMMON_ERROR_PAGE.indexOf(63) < 0 ? (char)'?' : '&';
        stringBuffer.append(c);
        stringBuffer.append("federror");
        stringBuffer.append('=');
        stringBuffer.append(FSUtils.bundle.getString("registration-request-improper"));
        stringBuffer.append('&');
        stringBuffer.append("fedremark");
        stringBuffer.append('=');
        stringBuffer.append(FSUtils.bundle.getString("registration-failed"));
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("Redirecting to Error page : " + stringBuffer.toString());
        }
        try {
            httpServletResponse.sendRedirect(stringBuffer.toString());
        }
        catch (IOException iOException) {
            FSUtils.debug.error("Failed to redirect to error page");
        }
    }

    protected void setRegistrationURL(String string) {
        try {
            if (this.allianceInst != null) {
                COMMON_ERROR_PAGE = this.allianceInst.getHostedProvider(string).getLocalConfiguration().getErrorPageURL(this.request);
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSAllianceManagementException " + fSAllianceManagementException.getMessage());
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("COMMON_ERROR_PAGE : " + COMMON_ERROR_PAGE);
        }
    }
}

