/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSAuthnResponse;
import com.sun.identity.federation.services.fednsso.FSSSOAndFedHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.XMLUtils;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import sun.misc.BASE64Encoder;

public class FSSSOWMLPostProfileHandler
extends FSSSOAndFedHandler {
    protected FSSSOWMLPostProfileHandler() {
    }

    public FSSSOWMLPostProfileHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSAuthnRequest fSAuthnRequest, FSProviderDescriptor fSProviderDescriptor, String string) {
        super(httpServletRequest, httpServletResponse, fSAuthnRequest, fSProviderDescriptor, string);
    }

    protected void sendAuthnResponse(FSAuthnResponse fSAuthnResponse) {
        FSUtils.debug.message("FSSSOWMLPostProfileHandler.sendAuthnResponse: Called");
        try {
            Object object;
            Object object2;
            BASE64Encoder bASE64Encoder;
            Object object3;
            fSAuthnResponse.setProviderId(this.hostProviderId);
            Document document = XMLUtils.toDOMDocument(fSAuthnResponse.toXMLString(true, true));
            if (FSServiceUtils.isSigningOn()) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSSOWMLPostProfileHandler.sendAuthnResponse: start signing assertions");
                }
                if ((object3 = fSAuthnResponse.getAssertion()) != null) {
                    bASE64Encoder = object3.iterator();
                    while (bASE64Encoder.hasNext()) {
                        object2 = (FSAssertion)bASE64Encoder.next();
                        object = ((FSAssertion)object2).getID();
                        FSUtils.debug.message("FSSSOWMLPostProfileHandler.sendAuthnResponse: id attr is" + (String)object);
                        FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
                        if (fSAllianceManager == null) {
                            FSUtils.debug.error("FSSSOWMLPostProfileHandler.doSingleSignOn: could not create alliance instance");
                            return;
                        }
                        String string = fSAllianceManager.getProvider(this.hostProviderId).getKeyInfo();
                        if (string == null) {
                            FSUtils.debug.error("SOAPReceiver.onMessage: couldn't obtain this site's cert alias.");
                            return;
                        }
                        FSUtils.debug.message("FSSSOWMLPostProfileHandler.sendAuthnResponse: Site's certAlias is " + string);
                        XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
                        xMLSignatureManager.signXML(document, string, SAMLUtils.bundle.getString("xmlsigalgorithm"), (String)object);
                        FSUtils.debug.message("FSSSOWMLPostProfileHandler.sendAuthnResponse: SignatureManager finished signing ");
                    }
                }
            }
            object3 = FSServiceUtils.printDocument(document);
            FSUtils.debug.message("FSSSOWMLPostProfileHandler.sendAuthnResponse: Signed AuthnResponse: " + (String)object3);
            bASE64Encoder = new BASE64Encoder();
            object2 = bASE64Encoder.encode(((String)object3).getBytes());
            this.response.setContentType("text/vnd.wap.wml");
            this.response.setHeader("Pragma", "no-cache");
            this.response.setHeader("Cache-Control", "no-cache");
            object = this.response.getWriter();
            ((PrintWriter)object).println("<!DOCTYPE wml PUBLIC \"-//WAPFORUM//DTD WML 1.1//EN\" \"http://www.wapforum.org/DTD/wml_1.1.xml\">");
            ((PrintWriter)object).println("<wml>");
            ((PrintWriter)object).println("<card id=\"response\" title=\"IDP Response\">");
            ((PrintWriter)object).println("<onevent type=\"onenterforward\">");
            ((PrintWriter)object).println("<go method=\"post\" href=\"" + this.spDescriptor.getAssertionConsumerServiceURL() + "\">");
            ((PrintWriter)object).println("<postfield name=\"LARES\" value=\"" + (String)object2 + "\"/>");
            ((PrintWriter)object).println("</go>");
            ((PrintWriter)object).println("</onevent>");
            ((PrintWriter)object).println("<onevent type=\"onenterbackward\">");
            ((PrintWriter)object).println("<prev/>");
            ((PrintWriter)object).println("</onevent>");
            ((PrintWriter)object).println("</card>");
            ((PrintWriter)object).println("</wml>");
            ((PrintWriter)object).close();
            FSUtils.debug.message("FSSSOWMLPostProfileHandler:sendAuthnResponse: AuthnResponse sent successfully to: " + this.spDescriptor.getAssertionConsumerServiceURL());
        }
        catch (Exception exception) {
            FSUtils.debug.message("FSSSOWMLPostProfileHandler:sendAuthnResponse: Failed to send AuthnResponse");
        }
    }

    protected boolean doSingleSignOn(SSOToken sSOToken, String string, NameIdentifier nameIdentifier, NameIdentifier nameIdentifier2) {
        FSAuthnResponse fSAuthnResponse = this.createAuthnResponse(sSOToken, string, nameIdentifier, nameIdentifier2);
        this.sendAuthnResponse(fSAuthnResponse);
        return true;
    }
}

