/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services.fednsso;

import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSRequest;
import com.sun.identity.federation.message.FSResponse;
import com.sun.identity.federation.message.FSSubject;
import com.sun.identity.federation.message.common.IDPProvidedNameIdentifier;
import com.sun.identity.federation.services.FSSOAPService;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.fednsso.FSAssertionArtifactHandler;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLResponderException;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.common.XMLUtils;
import com.sun.identity.saml.xmlsig.XMLSignatureManager;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.soap.SOAPMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FSBrowserArtifactConsumerHandler
extends FSAssertionArtifactHandler {
    private FSRequest samlRequest = null;

    protected FSBrowserArtifactConsumerHandler() {
    }

    public FSBrowserArtifactConsumerHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSProviderDescriptor fSProviderDescriptor, boolean bl, String string) {
        super(httpServletRequest, httpServletResponse, fSProviderDescriptor, bl, string);
    }

    public FSBrowserArtifactConsumerHandler(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FSProviderDescriptor fSProviderDescriptor, String string, FSRequest fSRequest) {
        super(httpServletRequest, httpServletResponse, fSProviderDescriptor, false, string);
        this.samlRequest = fSRequest;
        this.samlRequest.setMinorVersion(0);
    }

    public void processSAMLRequest() {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSBrowserArtifactConsumerHandler.processSAMLRequest: Called");
        }
        String string = FSServiceUtils.getBaseURL(this.request);
        String string2 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(this.request), null, null, this.request, string);
        try {
            Object object;
            Document document;
            FSResponse fSResponse = null;
            FSSOAPService fSSOAPService = FSSOAPService.getInstance();
            this.samlRequest.setID(this.samlRequest.getRequestID());
            SOAPMessage sOAPMessage = fSSOAPService.bindSAMLRequest(this.samlRequest);
            if (FSServiceUtils.isSigningOn()) {
                document = (Document)FSServiceUtils.createSOAPDOM(sOAPMessage);
                object = FSServiceUtils.getAllianceInstance();
                if (object == null) {
                    FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLRequest: could not create alliance instance");
                    FSUtils.forwardRequest(this.request, this.response, string2);
                    return;
                }
                String string3 = ((FSAllianceManager)object).getProvider(this.hostProviderId).getKeyInfo();
                if (string3 == null) {
                    FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLRequest: couldn't obtain this site's cert alias.");
                    FSUtils.forwardRequest(this.request, this.response, string2);
                    return;
                }
                FSUtils.debug.message("FSBrowserArtifactConsumerHandler.processSAMLRequest: certAlias: " + string3);
                XMLSignatureManager xMLSignatureManager = XMLSignatureManager.getInstance();
                String string4 = this.samlRequest.getID();
                xMLSignatureManager.signXML(document, string3, SAMLUtils.bundle.getString("xmlsigalgorithm"), string4);
                sOAPMessage = FSServiceUtils.convertDOMToSOAP(document);
            }
            if ((document = fSSOAPService.doSyncCall(this.response, sOAPMessage, this.idpDescriptor, false)) == null) {
                FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLRequest: " + FSUtils.bundle.getString("invalidSOAPResponse") + " Response SOAPMessage is null");
                FSUtils.error("FSBrowserArtifactConsumerHandler", FSUtils.bundle.getString("noReplyfromSOAPReceiver"));
                FSUtils.forwardRequest(this.request, this.response, string2);
                return;
            }
            object = fSSOAPService.parseSOAPMessage((SOAPMessage)document);
            if (object != null && object.getTagName().trim().equalsIgnoreCase("soap_env:Fault")) {
                FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLRequest: " + FSUtils.bundle.getString("invalidSOAPResponse") + " SOAPFault occured");
                FSUtils.error("FSBrowserArtifactConsumerHandler", FSUtils.bundle.getString("invalidSOAPResponse"));
                FSUtils.forwardRequest(this.request, this.response, string2);
                return;
            }
            if (object != null && object.getLocalName().trim().equalsIgnoreCase("Response")) {
                fSResponse = new FSResponse((Element)object);
                if (fSResponse == null) {
                    FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLRequest: " + FSUtils.bundle.getString("invalidSOAPResponse") + " Could not create SAML Response");
                    FSUtils.error("FSBrowserArtifactConsumerHandler", FSUtils.bundle.getString("invalidSOAPResponse"));
                    FSUtils.forwardRequest(this.request, this.response, string2);
                    return;
                }
            } else {
                FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLRequest: " + FSUtils.bundle.getString("invalidSOAPResponse") + " SOAP response does not contain samlp:Response");
                FSUtils.error("FSBrowserArtifactConsumerHandler", FSUtils.bundle.getString("invalidSOAPResponse"));
                FSUtils.forwardRequest(this.request, this.response, string2);
                return;
            }
            this.processSAMLResponse(fSResponse);
            return;
        }
        catch (Exception exception) {
            StringWriter stringWriter = new StringWriter();
            exception.printStackTrace(new PrintWriter(stringWriter));
            FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLRequest: Exception occured: " + exception.getMessage() + "\n" + stringWriter.getBuffer().toString());
            FSUtils.error("FSBrowserArtifactConsumerHandler", exception.getMessage());
            try {
                FSUtils.forwardRequest(this.request, this.response, string2);
            }
            catch (Exception exception2) {
                FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLRequest: IOException occured: " + exception2.getMessage());
                FSUtils.error("FSBrowserArtifactConsumerHandler", exception2.getMessage());
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processSAMLResponse(FSResponse fSResponse) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSBrowserArtifactConsumerHandler.processSAMLResponse: Called");
        }
        String string = FSServiceUtils.getBaseURL(this.request);
        String string2 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(this.request), null, null, this.request, string);
        try {
            int n;
            boolean bl;
            if (fSResponse == null) {
                FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLResponse: null input " + FSUtils.bundle.getString("missingResponse"));
                FSUtils.error("FSBrowserArtifactConsumerHandler", FSUtils.bundle.getString("missingResponse"));
                FSUtils.forwardRequest(this.request, this.response, string2);
                return;
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSBrowserArtifactConsumerHandler.processSAMLResponse: Received " + fSResponse.toXMLString());
            }
            if (!(bl = this.verifyResponseStatus(fSResponse))) {
                FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLResponse: verify Status failed " + FSUtils.bundle.getString("invalidResponse"));
                FSUtils.error("FSBrowserArtifactConsumerHandler", FSUtils.bundle.getString("invalidResponse"));
                FSUtils.forwardRequest(this.request, this.response, string2);
                return;
            }
            List list = fSResponse.getAssertion();
            if (list == null || list.size() <= 0) {
                FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLResponse" + FSUtils.bundle.getString("invalidResponse") + ": No assertion found inside the AuthnResponse");
                FSUtils.error("FSBrowserArtifactConsumerHandler", FSUtils.bundle.getString("invalidResponse"));
                FSUtils.forwardRequest(this.request, this.response, string2);
                return;
            }
            Iterator iterator = list.iterator();
            FSAssertion fSAssertion = (FSAssertion)iterator.next();
            FSAuthnRequest fSAuthnRequest = this.getInResponseToRequest(fSAssertion.getInResponseTo());
            if (fSAuthnRequest == null) {
                FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLResponse: " + FSUtils.bundle.getString("invalidResponse") + ": Assertion does not correspond to any AuthnRequest");
                FSUtils.error("FSBrowserArtifactConsumerHandler", FSUtils.bundle.getString("invalidResponse"));
                FSUtils.forwardRequest(this.request, this.response, string2);
                return;
            }
            this.authnRequest = fSAuthnRequest;
            this.relayState = this.authnRequest.getRelayState();
            this.doFederate = this.authnRequest.getFederate();
            String string3 = "RequestID";
            string2 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(this.request), this.authnRequest.getRelayState(), null, this.request, string);
            FSProviderDescriptor fSProviderDescriptor = this.getProvider(fSAssertion.getInResponseTo());
            if (fSProviderDescriptor == null || !fSProviderDescriptor.getProviderID().equals(this.idpDescriptor.getProviderID())) {
                FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLResponse: " + FSUtils.bundle.getString("invalidAssertion") + ": Assertion does not correspond to any IDP");
                FSUtils.error("FSBrowserArtifactConsumerHandler", FSUtils.bundle.getString("invalidAssertion"));
                FSUtils.forwardRequest(this.request, this.response, string2);
                return;
            }
            FSSubject fSSubject = (FSSubject)this.validateAssertions(list);
            if (fSSubject == null) {
                FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLResponse: validateAssertions failed: " + FSUtils.bundle.getString("invalidAssertion"));
                FSUtils.error("FSBrowserArtifactConsumerHandler", FSUtils.bundle.getString("invalidAssertion"));
                FSUtils.forwardRequest(this.request, this.response, string2);
                return;
            }
            if (this.doFederate) {
                IDPProvidedNameIdentifier iDPProvidedNameIdentifier = fSSubject.getIDPProvidedNameIdentifier();
                if (iDPProvidedNameIdentifier == null) {
                    FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLResponse: Single Sign-On failed. NameIdentifier of the subject is null: ");
                    FSUtils.error("FSBrowserArtifactConsumerHandler", FSUtils.bundle.getString("SingleSignOnFailed"));
                    throw new FSException("NameIdentifier of the subject is null");
                }
                if (this.doAccountFederation(iDPProvidedNameIdentifier)) {
                    return;
                }
                FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLResponse: " + FSUtils.bundle.getString("AccountFederationFailed"));
                FSUtils.error("FSBrowserArtifactConsumerHandler", FSUtils.bundle.getString("AccountFederationFailed"));
                FSUtils.forwardRequest(this.request, this.response, string2);
                return;
            }
            IDPProvidedNameIdentifier iDPProvidedNameIdentifier = fSSubject.getIDPProvidedNameIdentifier();
            NameIdentifier nameIdentifier = fSSubject.getNameIdentifier();
            if (iDPProvidedNameIdentifier == null || nameIdentifier == null) {
                FSUtils.error("FSBrowserArtifactConsumerHandler", FSUtils.bundle.getString("invalidResponse"));
                FSUtils.forwardRequest(this.request, this.response, string2);
                return;
            }
            String string4 = iDPProvidedNameIdentifier.getName();
            String string5 = nameIdentifier.getName();
            if (string4 == null || string5 == null) {
                FSUtils.error("FSBrowserArtifactConsumerHandler", FSUtils.bundle.getString("invalidResponse"));
                FSUtils.forwardRequest(this.request, this.response, string2);
                return;
            }
            if (string4.equals(string5)) {
                nameIdentifier = iDPProvidedNameIdentifier;
                n = 1;
            } else {
                n = 0;
            }
            if (nameIdentifier == null) {
                FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLResponse: SingleSignOnFailed");
                FSUtils.error("FSBrowserArtifactConsumerHandler", FSUtils.bundle.getString("SingleSignOnFailed"));
                throw new FSException("NameIdentifier of the subject is null");
            }
            String string6 = this.localConfig.getAssociatedOrgDN();
            FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLResponse: oh=" + nameIdentifier.getName() + " sd=" + nameIdentifier.getNameQualifier());
            if (this.doSingleSignOn(nameIdentifier, n, string6)) {
                return;
            }
            FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLResponse: SingleSignOnFailed");
            FSUtils.error("FSBrowserArtifactConsumerHandler", FSUtils.bundle.getString("SingleSignOnFailed"));
            FSUtils.forwardRequest(this.request, this.response, string2);
            return;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSBrowserArtifactConsumerHandler.processSAMLResponse: Exception occured: " + exception.getMessage());
            FSUtils.error("FSBrowserArtifactConsumerHandler", exception.getMessage());
            return;
        }
    }

    protected void redirectToResource(String string) throws FSException {
        String string2 = "RequestID";
        String string3 = FSServiceUtils.getBaseURL(this.request);
        String string4 = FSServiceUtils.getCommonLoginPageURL(FSServiceUtils.getMetaAlias(this.request), this.authnRequest.getRelayState(), null, this.request, string3);
        try {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSBrowserArtifactConsumerHandler.redirectToResource: Called");
            }
            if (string == null) {
                FSUtils.debug.error("FSBrowserArtifactConsumerHandler.redirectToResource: Resource URL is null");
                FSUtils.error("FSBrowserArtifactConsumerHandler", FSUtils.bundle.getString("nullInputParameter"));
                FSUtils.forwardRequest(this.request, this.response, string4);
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSBrowserArtifactConsumerHandler.redirectToResource: User's Authentication Assertion verified redirecting to Resource:" + string);
            }
            this.response.setContentType("text/html");
            this.response.sendRedirect(string);
        }
        catch (IOException iOException) {
            throw new FSException(iOException.getMessage());
        }
    }

    protected FSAuthnRequest getInResponseToRequest(String string) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSBrowserArtifactConsumerHandler.getInResponseToRequest: Called");
        }
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(this.hostProviderId);
        this.authnRequest = fSSessionManager.getAuthnRequest(string);
        return this.authnRequest;
    }

    protected FSProviderDescriptor getProvider(String string) {
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSBrowserArtifactConsumerHandler.getProvider: Called");
        }
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(this.hostProviderId);
        return fSSessionManager.getProviderDescriptor(string);
    }

    protected FSRequest signSAMLRequest(FSRequest fSRequest) throws SAMLException {
        Object object;
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSBrowserArtifactConsumerHandler.signSAMLRequest: Called");
        }
        if (fSRequest.isSigned()) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSBrowserArtifactConsumerHandler.signSAMLRequest: the request is already signed.");
            }
            throw new SAMLException(FSUtils.bundle.getString("alreadySigned"));
        }
        String string = null;
        try {
            object = FSServiceUtils.getAllianceInstance();
            string = ((FSAllianceManager)object).getHostedProvider(this.hostProviderId).getKeyInfo();
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSBrowserArtifactConsumerHandler.signSAMLRequest: FSAllianceManagementException occured while obtaining certAlias: " + fSAllianceManagementException.getMessage());
            throw new SAMLResponderException(fSAllianceManagementException.getMessage());
        }
        if (string == null || string.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSBrowserArtifactConsumerHandler.signSAMLRequest: couldn't obtain this site's cert alias.");
            }
            throw new SAMLResponderException(FSUtils.bundle.getString("cannotFindCertAlias"));
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSBrowserArtifactConsumerHandler.signSAMLRequest: Provider's certAlias is found: " + string);
        }
        object = XMLSignatureManager.getInstance();
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSBrowserArtifactConsumerHandler.signSAMLRequest: XMLString to be signed: " + fSRequest.toString(true, true));
        }
        String string2 = ((XMLSignatureManager)object).signXML(fSRequest.toString(true, true), string);
        Element element = XMLUtils.toDOMDocument(string2).getDocumentElement();
        fSRequest.setSignature(element);
        return fSRequest;
    }
}

