/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.iplanet.sso.SSOToken;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.services.FSSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class FSSessionManager {
    private static Map instanceMap = new HashMap();
    private Map userDNSessionListMap = new HashMap();
    private Map idAuthnRequestMap = new HashMap();
    private Map idLocalSSOTokenMap = new HashMap();
    private Map idDestnMap = new HashMap();
    private String hostProviderId = null;
    private Map relayStateMap = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$com$sun$identity$federation$services$FSSessionManager;

    public String getRelayState(String string) {
        return (String)this.relayStateMap.get(string);
    }

    public void setRelayState(String string, String string2) {
        this.relayStateMap.put(string, string2);
    }

    public void removeRelayState(String string) {
        this.relayStateMap.remove(string);
    }

    public FSAuthnRequest getAuthnRequest(String string) {
        FSUtils.debug.message("FSSessionManager.getAuthnRequest: Called");
        return (FSAuthnRequest)this.idAuthnRequestMap.get(string);
    }

    public void setAuthnRequest(String string, FSAuthnRequest fSAuthnRequest) {
        FSUtils.debug.message("FSSessionManager.setAuthnRequest: Called");
        this.removeAuthnRequest(string);
        this.idAuthnRequestMap.put(string, fSAuthnRequest);
    }

    public void removeAuthnRequest(String string) {
        FSUtils.debug.message("FSSessionManager.removeAuthnRequest: Called");
        this.idAuthnRequestMap.remove(string);
        this.idDestnMap.remove(string);
    }

    public SSOToken getLocalSSOToken(String string) {
        FSUtils.debug.message("FSSessionManager.getLocalSSOToken: Called");
        return (SSOToken)this.idLocalSSOTokenMap.get(string);
    }

    public void setLocalSSOToken(String string, SSOToken sSOToken) {
        FSUtils.debug.message("FSSessionManager.setLocalSSOToken: Called");
        this.removeLocalSSOToken(string);
        this.idLocalSSOTokenMap.put(string, sSOToken);
    }

    public void removeLocalSSOToken(String string) {
        FSUtils.debug.message("FSSessionManager.removeLocalSSOToken: Called");
        this.idLocalSSOTokenMap.remove(string);
    }

    public FSProviderDescriptor getProviderDescriptor(String string) {
        FSUtils.debug.message("FSSessionManager.getProviderDescriptor: Called");
        return (FSProviderDescriptor)this.idDestnMap.get(string);
    }

    public void setProviderDescriptor(String string, FSProviderDescriptor fSProviderDescriptor) {
        FSUtils.debug.message("FSSessionManager.setProviderDescriptor: Called");
        this.idDestnMap.remove(string);
        this.idDestnMap.put(string, fSProviderDescriptor);
    }

    public List getSessionList(String string) {
        FSUtils.debug.message("FSSessionManager.getSessionList: Called");
        string = string.toLowerCase();
        return (List)this.userDNSessionListMap.get(string);
    }

    public void setSessionList(String string, List list) {
        FSUtils.debug.message("FSSessionManager.setSessionList: Called");
        string = string.toLowerCase();
        this.removeSessionList(string);
        this.userDNSessionListMap.put(string, list);
    }

    public void removeSessionList(String string) {
        FSUtils.debug.message("FSSessionManager.removeSessionList: Called");
        string = string.toLowerCase();
        this.userDNSessionListMap.remove(string);
    }

    public synchronized FSSession getSession(String string, String string2) {
        FSUtils.debug.message("FSSessionManager.getSession: Called");
        List list = this.getSessionList(string);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FSSession fSSession = (FSSession)iterator.next();
                if (!fSSession.isEquals(string2)) continue;
                return fSSession;
            }
        }
        return null;
    }

    public FSSession getSession(SSOToken sSOToken) {
        FSUtils.debug.message("FSSessionManager.getSession: Called");
        try {
            String string = sSOToken.getPrincipal().getName();
            String string2 = sSOToken.getTokenID().toString();
            return this.getSession(string, string2);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSSessionManager.getSession: " + exception.getMessage());
            return null;
        }
    }

    public void removeProvider(String string, String string2) {
        FSUtils.debug.message("FSSessionManager.removeProvider: Called");
        List list = this.getSessionList(string);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FSSession fSSession = (FSSession)iterator.next();
                if (fSSession == null) continue;
                FSUtils.debug.message("Calling session.removeSessionPartner(providerID)");
                fSSession.removeSessionPartner(string2);
            }
            return;
        }
    }

    public synchronized void removeSession(String string, FSSession fSSession) {
        FSUtils.debug.message("FSSessionManager.removeSession: Called");
        List list = this.getSessionList(string);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FSSession fSSession2 = (FSSession)iterator.next();
                if (!fSSession2.equals(fSSession)) continue;
                list.remove(fSSession2);
                this.setSessionList(string, list);
                return;
            }
            return;
        }
    }

    public synchronized void addSession(String string, FSSession fSSession) {
        FSUtils.debug.message("FSSessionManager.addSession: Called");
        List list = this.getSessionList(string);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                FSSession fSSession2 = (FSSession)iterator.next();
                if (!fSSession2.equals(fSSession)) continue;
                list.remove(fSSession2);
                break;
            }
            list.add(fSSession);
            this.setSessionList(string, list);
            return;
        }
        ArrayList<FSSession> arrayList = new ArrayList<FSSession>();
        arrayList.add(fSSession);
        this.setSessionList(string, arrayList);
    }

    private FSSessionManager(String string) {
        FSUtils.debug.message("FSSessionManager(): Called. A new instance of FSSessionManager created");
        this.hostProviderId = string;
    }

    public static FSSessionManager getInstance(String string) {
        FSUtils.debug.message("FSSessionManager.getInstance: Called");
        FSSessionManager fSSessionManager = null;
        Class clazz = class$com$sun$identity$federation$services$FSSessionManager == null ? (class$com$sun$identity$federation$services$FSSessionManager = FSSessionManager.class$("com.sun.identity.federation.services.FSSessionManager")) : class$com$sun$identity$federation$services$FSSessionManager;
        synchronized (clazz) {
            fSSessionManager = (FSSessionManager)instanceMap.get(string);
            if (fSSessionManager == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSSessionManager.getInstance: Constructing a new instance of FSSessionManager: " + string);
                }
                fSSessionManager = new FSSessionManager(string);
                instanceMap.put(string, fSSessionManager);
            }
        }
        return fSSessionManager;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

