/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSCircleOfTrustDescriptor;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.alliance.FSSPAuthenticationContextInfo;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAuthnRequest;
import com.sun.identity.federation.message.FSAuthnRequestEnvelope;
import com.sun.identity.federation.message.FSIDPList;
import com.sun.identity.federation.message.common.AuthnContext;
import com.sun.identity.federation.message.common.IDPEntries;
import com.sun.identity.federation.message.common.IDPEntry;
import com.sun.identity.federation.services.FSLoginHelperException;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.liberty.LibertyManager;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import sun.misc.BASE64Encoder;

public class FSLoginHelper {
    private static String headerKey = "headerKey";
    private static String responseDataKey = "responseData";
    private static String URLKey = "urlKey";
    private String interSiteURL = null;
    private static String authnReqIDKey = "RequestID";
    private static String providerIDKey = "_liberty_idp";
    private static boolean messageEnabled = false;
    private String amserverURI = null;
    private String authContextString = null;
    private String authnContextProfileClassRef = null;
    private String authnContextStatementRef = null;
    private String respondWithString = null;
    private boolean forceAuthn;
    private boolean isPassive;
    private String providerID = null;
    private FSLocalConfigurationDescriptor cnfgDesc = null;
    private Set cotSet = null;
    private String protocolProfile = null;
    private static FSAllianceManager allianceManager = null;
    private static String fedCookieName = SystemProperties.get((String)"com.sun.identity.federation.fedCookieName");
    private String errorPage = null;
    private HttpServletRequest request = null;
    private boolean isPassiveQuery = false;

    public FSLoginHelper(HttpServletRequest httpServletRequest) {
        this.request = httpServletRequest;
        this.amserverURI = FSServiceUtils.getBaseURL(httpServletRequest);
        this.interSiteURL = this.amserverURI + "/" + "IntersiteTransferService";
        if (messageEnabled) {
            FSUtils.debug.message("FSLoginHepler::Constructor called. Setting BaseURL to " + this.amserverURI + httpServletRequest.getParameter("metaAlias"));
        }
        String string = httpServletRequest.getParameter("isPassive");
        if (messageEnabled) {
            FSUtils.debug.message("FSLoginHepler::isPassive query param" + string);
        }
        if (string != null && string.equals("true")) {
            this.isPassiveQuery = true;
        }
    }

    private void setAllianceInfo(String string, String string2) throws FSLoginHelperException {
        block10: {
            try {
                FSHostedProviderDescriptor fSHostedProviderDescriptor = null;
                if (allianceManager == null) {
                    FSUtils.debug.error("FSLoginHelper::setAllianceInfo could not get alliane manager handle Cannot proceed so throwing error page");
                    throw new FSLoginHelperException("FSLoginHelper:: could not get alliancemanager handle.");
                }
                fSHostedProviderDescriptor = allianceManager.getHostedProviderByMetaAlias(string);
                if (fSHostedProviderDescriptor == null) {
                    FSUtils.debug.error("FSLoginHelper::setAllianceInfo getHostedProviderByMetaAlias retured null. Cannot proceed so throwing error page");
                    throw new FSLoginHelperException("FSLoginHelper:: could not get provider Descriptor handle.");
                }
                this.cotSet = fSHostedProviderDescriptor.getListOfCOTs();
                this.providerID = fSHostedProviderDescriptor.getProviderID();
                this.cnfgDesc = fSHostedProviderDescriptor.getLocalConfiguration();
                if (this.cnfgDesc != null) {
                    this.respondWithString = "lib:AuthenticationStatement";
                    this.forceAuthn = this.cnfgDesc.getForceAuthentication();
                    this.isPassive = this.cnfgDesc.getIsPassive();
                    this.protocolProfile = this.cnfgDesc.getAuthnfedProfile();
                    this.authContextString = this.cnfgDesc.getDefaultAuthenticationContext();
                    this.errorPage = this.cnfgDesc.getErrorPageURL(this.request);
                    if (string2 != null) {
                        Map map = this.cnfgDesc.getSPAuthContextInfo();
                        Set set = map.entrySet();
                        Iterator iterator = set.iterator();
                        FSSPAuthenticationContextInfo fSSPAuthenticationContextInfo = null;
                        if (messageEnabled) {
                            FSUtils.debug.message("FSLoginHelper()::authLevel not null");
                        }
                        while (iterator.hasNext()) {
                            Map.Entry entry = iterator.next();
                            fSSPAuthenticationContextInfo = (FSSPAuthenticationContextInfo)entry.getValue();
                            Integer n = new Integer(string2);
                            int n2 = n;
                            if (fSSPAuthenticationContextInfo.getAuthenticationLevel() != n2) continue;
                            this.authContextString = fSSPAuthenticationContextInfo.getAuthenticationContext();
                            if (!messageEnabled) break;
                            FSUtils.debug.message("FSLoginHelper():: Found auth context " + this.authContextString + "for auth level " + string2);
                            break;
                        }
                    }
                    if (messageEnabled) {
                        FSUtils.debug.message("FSLoginHelper()::respondWithString: " + this.respondWithString);
                        FSUtils.debug.message("FSLoginHelper()::providerID: " + this.providerID);
                        FSUtils.debug.message("FSLoginHelper()::forceAuthn: " + this.forceAuthn);
                        FSUtils.debug.message("FSLoginHelper()::isPassive: " + this.isPassive);
                    }
                    break block10;
                }
                FSUtils.debug.error("FSLoginHelper:setAllianceInfo failedFSLocalConfigurationDescriptor is null");
                throw new FSLoginHelperException("FSLoginHelper:: could not get local config.");
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                FSUtils.debug.error("FSLoginHelper::setAllianceInfo Alliance management Failed." + fSAllianceManagementException.getMessage());
                throw new FSLoginHelperException("FSLoginHelper:: FSAllianceManagementException" + fSAllianceManagementException.getMessage());
            }
            catch (Exception exception) {
                FSUtils.debug.error("FSLoginHelper::setAllianceInfo General Exception caugth." + exception.getMessage());
                throw new FSLoginHelperException("FSLoginHelper:: FSAllianceManagementException" + exception.getMessage());
            }
        }
    }

    public Map createAuthnRequest(Map map, String string, String string2, String string3, String string4, boolean bl) throws FSLoginHelperException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        this.setAllianceInfo(string3, string2);
        if (messageEnabled) {
            FSUtils.debug.message("FSLoginHelper.createAuthnRequest(): called");
        }
        FSProviderDescriptor fSProviderDescriptor = null;
        if (string4 != null) {
            try {
                fSProviderDescriptor = allianceManager.getProvider(string4);
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                FSUtils.debug.error("FSLoginHelper::createAuthnRequest AllianceManagement caugth " + fSAllianceManagementException.getMessage());
                throw new FSLoginHelperException("FSLoginHelper:: createAuthnRequest AllianceManagement caugth " + fSAllianceManagementException.getMessage());
            }
        }
        FSAuthnRequest fSAuthnRequest = null;
        fSAuthnRequest = string4 != null ? this.getAuthnReq(map, string, true) : this.getAuthnReq(map, string, false);
        if (fSAuthnRequest == null) {
            FSUtils.debug.error("FSLoginHelper.createAuthnRequest()::AuthnRequest is null");
            String string5 = LibertyManager.getProviderID(string3);
            String string6 = this.errorPage;
            string6 = string6 + "&" + "federror" + "=" + URLEncoder.encode("Unable to create AuthnRequest") + "&" + "fedremark" + "=" + URLEncoder.encode("Please check your Federation Configuration.");
            return this.createMap(string6, null, hashMap);
        }
        String string7 = fSAuthnRequest.getRequestID();
        if (messageEnabled) {
            FSUtils.debug.message("FSLoginHelper.createAuthnRequest():: RequestID: " + string7);
        }
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(this.providerID);
        fSSessionManager.setAuthnRequest(string7, fSAuthnRequest);
        fSSessionManager.setProviderDescriptor(string7, fSProviderDescriptor);
        String string8 = null;
        boolean bl2 = true;
        boolean bl3 = false;
        String string9 = LibertyManager.getProviderID(string3);
        Set set = this.getIDPs(string9);
        if (string4 == null) {
            bl3 = true;
        }
        if (set.size() > 1) {
            bl2 = false;
        }
        if (this.isLECPProfile(map)) {
            Object object;
            FSUtils.debug.message("FSLoginHelper.createAuthnRequest(): LECP Request Identified");
            hashMap.put("content-type", "application/vnd.liberty-request+xml");
            String string10 = null;
            try {
                String string11;
                FSAllianceManager fSAllianceManager;
                Object object2;
                object = null;
                String string12 = null;
                boolean bl4 = false;
                FSIDPList fSIDPList = null;
                string12 = allianceManager.getProvider(string9).getProviderName();
                String string13 = allianceManager.getProvider(string9).getAssertionConsumerServiceURL();
                ArrayList<IDPEntry> arrayList = null;
                String string14 = null;
                String string15 = null;
                String string16 = null;
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    string14 = (String)iterator.next();
                    if (string14 == null) continue;
                    object2 = allianceManager.getProvider(string14);
                    string15 = ((FSProviderDescriptor)object2).getProviderName();
                    string16 = ((FSProviderDescriptor)object2).getSSOServiceURL();
                    if (arrayList == null) {
                        arrayList = new ArrayList<IDPEntry>();
                    }
                    arrayList.add(new IDPEntry(string14, string15, string16));
                }
                object2 = new IDPEntries(arrayList);
                fSIDPList = new FSIDPList((IDPEntries)object2, null);
                if (FSServiceUtils.isSigningOn() && (fSAllianceManager = FSServiceUtils.getAllianceInstance()).getHostedProvider(string11 = LibertyManager.getProviderID(string3)).getAuthnRequestSigned()) {
                    fSAuthnRequest.signXML(fSAllianceManager.getHostedProvider(string11).getKeyInfo());
                }
                object = new FSAuthnRequestEnvelope(fSAuthnRequest, this.providerID, string12, string13, fSIDPList, bl4);
                FSUtils.debug.message("FSLoginHelper.createAuthnRequest: AuthnRequestEnvelope: " + ((FSAuthnRequestEnvelope)object).toXMLString());
                string10 = ((FSAuthnRequestEnvelope)object).toXMLString();
            }
            catch (Exception exception) {
                FSUtils.debug.error("FSLoginHelper.createAuthnRequest(): Exception Occured: " + exception.getMessage());
            }
            object = this.createMap(null, string10, hashMap);
            object.put(authnReqIDKey, string7);
            return object;
        }
        String string17 = this.getTLDURL();
        if (bl3 && string17 != null && !bl2) {
            if (messageEnabled) {
                FSUtils.debug.message("FSLoginHelper:: createAuthnRequest In case where isSSO true and tldURL is true and not single idp. So redirecting to thirdlevel domain");
            }
            string8 = string17 + "?" + "RelayState" + "=" + URLEncoder.encode(this.interSiteURL + "?" + authnReqIDKey + "=" + URLEncoder.encode(string7) + "&" + "metaAlias" + "=" + string3);
        } else {
            String string18;
            if (bl3 && !bl2) {
                if (messageEnabled) {
                    FSUtils.debug.message("FSLoginHelper:: createAuthnRequest  In case where isSSO true and not a single idp so have show common login page");
                }
                Map map2 = this.createMap(null, null, hashMap);
                map2.put(authnReqIDKey, string7);
                return map2;
            }
            boolean bl5 = false;
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            if (string4 == null) {
                if (set != null && set.size() > 0) {
                    string4 = (String)set.iterator().next();
                } else {
                    FSUtils.debug.error("FSLoginHelper:: no idps found in config. Cannot proceed.");
                    string18 = LibertyManager.getProviderID(string3);
                    string8 = this.errorPage;
                    string8 = string8 + "&" + "federror" + "=" + URLEncoder.encode("No IDPs Found in Configuration.") + "&" + "fedremark" + "=" + URLEncoder.encode("Please configure you Federation Services for an IDP.");
                    bl5 = true;
                }
            }
            if (!bl5) {
                string18 = LibertyManager.getSuccintID(string4);
                if (messageEnabled) {
                    FSUtils.debug.message("FSLoginHelper:: createAuthnRequest  Redirecting to intersiteTransfer URL " + this.interSiteURL + " with providerID and SuccintID. " + string4 + "---" + string18);
                }
                String string19 = SAMLUtils.hexStringToBase64(string18);
                if (!bl) {
                    String string20 = LibertyManager.getProviderID(string3);
                    this.changeToPassiveAuthnRequest(string7, string20);
                }
                string8 = this.interSiteURL + "?" + authnReqIDKey + "=" + URLEncoder.encode(string7) + "&" + providerIDKey + "=" + URLEncoder.encode(string19) + "&" + "metaAlias" + "=" + string3;
            }
        }
        if (this.isPassiveQuery) {
            String string21 = LibertyManager.getProviderID(string3);
            this.changeToPassiveAuthnRequest(string7, string21);
        }
        if (messageEnabled) {
            FSUtils.debug.message("FSLoginHelper.createAuthnRequest()::redirectURL : " + string8);
        }
        if (this.isWMLProfile(map)) {
            hashMap.put("content-type", "text/vnd.wap.wml");
        } else {
            hashMap.put("content-type", "text/html");
        }
        Map map3 = this.createMap(string8, null, hashMap);
        map3.put(authnReqIDKey, string7);
        return map3;
    }

    void changeToPassiveAuthnRequest(String string, String string2) {
        FSAuthnRequest fSAuthnRequest;
        FSUtils.debug.message("FSPreLogin.changeToPassiveAuthnRequest called");
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(string2);
        if (fSSessionManager == null) {
            FSUtils.debug.message("Session Manager null");
        }
        if ((fSAuthnRequest = fSSessionManager.getAuthnRequest(string)) != null && !fSAuthnRequest.getFederate()) {
            fSAuthnRequest.setIsPassive(true);
            fSAuthnRequest.setForceAuthn(false);
        }
        fSSessionManager.setAuthnRequest(string, fSAuthnRequest);
    }

    private Set getIDPs(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        try {
            String string2 = "";
            String string3 = "";
            String string4 = "";
            String string5 = "IDP".toLowerCase();
            FSProviderDescriptor fSProviderDescriptor = null;
            FSHostedProviderDescriptor fSHostedProviderDescriptor = allianceManager.getHostedProvider(string);
            FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = fSHostedProviderDescriptor.getLocalConfiguration();
            Set set = fSLocalConfigurationDescriptor.getTrustedProviders();
            if (set != null && !set.isEmpty()) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    string2 = (String)iterator.next();
                    fSProviderDescriptor = allianceManager.getProvider(string2);
                    string3 = fSProviderDescriptor.getProviderStatus();
                    string4 = fSProviderDescriptor.getProviderRole();
                    string4 = string4.toLowerCase();
                    if (messageEnabled) {
                        FSUtils.debug.message("FSLoginHelper::getIDPs For providerId " + string2 + " status is " + string3 + " and Role is " + string4);
                    }
                    if (!string3.equals("active") || string4.indexOf(string5) == -1) continue;
                    hashSet.add(string2);
                }
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSLoginHelper::getIDPs Error in getting idp List", (Throwable)((Object)fSAllianceManagementException));
        }
        if (messageEnabled) {
            FSUtils.debug.message("FSLoginHelper::getIDPs returing idpset as " + hashSet);
        }
        return hashSet;
    }

    private FSAuthnRequest getAuthnReq(Map map, String string, boolean bl) throws FSLoginHelperException {
        FSAuthnRequest fSAuthnRequest = null;
        AuthnContext authnContext = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        ArrayList arrayList3 = new ArrayList();
        try {
            if (this.isLECPProfile(map)) {
                this.protocolProfile = "http://projectliberty.org/profiles/lecp";
            } else if (this.isWMLProfile(map)) {
                this.protocolProfile = "http://projectliberty.org/profiles/wml-post";
            }
            if (messageEnabled) {
                FSUtils.debug.message("FSLoginHelper::getAuthnReq():Federation profile is:" + this.protocolProfile);
            }
            if (bl) {
                this.forceAuthn = true;
                this.isPassive = false;
            }
            if (this.respondWithString != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(this.respondWithString, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    arrayList.add(string2);
                }
            } else {
                arrayList = null;
            }
            arrayList2.add(this.authContextString);
            arrayList3 = null;
            authnContext = new AuthnContext(arrayList2, arrayList3);
            fSAuthnRequest = new FSAuthnRequest(null, arrayList, null, this.providerID, this.forceAuthn, this.isPassive, bl, this.protocolProfile, authnContext, string, "minimum");
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSLoginHelper.getAuthnReq():Error during procesing" + exception.getMessage());
            throw new FSLoginHelperException("FSLoginHelper.getAuthnReq()In Exception " + exception.getMessage());
        }
        return fSAuthnRequest;
    }

    private Map createMap(String string, String string2, Map map) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put(headerKey, map);
        if (string != null) {
            hashMap.put(URLKey, string);
        } else if (string2 != null) {
            hashMap.put(responseDataKey, string2);
        }
        return hashMap;
    }

    private boolean isLECPProfile(Map map) {
        FSUtils.debug.message("FSLoginHelper.isLECPProfile called");
        if (map != null) {
            String string = (String)map.get("Liberty-Enabled");
            if (string == null) {
                String string2 = "Liberty-Enabled".toLowerCase();
                FSUtils.debug.message("FSLoginHelper.isLECPProfile checking for lower case header: " + string2);
                string = (String)map.get(string2);
            }
            return string != null;
        }
        return false;
    }

    private boolean isWMLProfile(Map map) {
        String string;
        if (map != null && (string = (String)map.get("accept")) != null && string.toLowerCase().indexOf("text/vnd.wap.wml") != -1) {
            FSUtils.debug.message("FSLoginHelper.isWMLProfile() :: true ");
            return true;
        }
        return false;
    }

    private String getTLDURL() {
        String string = null;
        if (messageEnabled) {
            FSUtils.debug.message("FSLoginHelper.getTLDURL() :: called");
        }
        try {
            if (this.cotSet == null || this.cotSet.isEmpty()) {
                FSUtils.debug.error("FSLoginHelper::getTLDURL():Received COT Set is Invalid");
            } else {
                if (this.cotSet.size() > 1) {
                    if (messageEnabled) {
                        FSUtils.debug.message("FSLoginHelper::getTLDURL() Multiple COTs found will do polling ");
                    }
                } else if (messageEnabled) {
                    FSUtils.debug.message("FSLoginHelper::getTLDURL() Single COT found");
                }
                Iterator iterator = this.cotSet.iterator();
                while (iterator.hasNext()) {
                    FSCircleOfTrustDescriptor fSCircleOfTrustDescriptor = allianceManager.getCircleOfTrust((String)iterator.next());
                    if (fSCircleOfTrustDescriptor == null || !fSCircleOfTrustDescriptor.getCircleOfTrustStatus().equalsIgnoreCase("active")) continue;
                    if (messageEnabled) {
                        FSUtils.debug.message("FSLoginHelper::getTLDURL found a active cot with cotid : " + fSCircleOfTrustDescriptor.getCircleOfTrustName());
                    }
                    string = fSCircleOfTrustDescriptor.getReaderServiceURL();
                }
            }
        }
        catch (FSAllianceManagementException fSAllianceManagementException) {
            FSUtils.debug.error("FSLoginHelper.getTLDURL():FSAllianceManagementException:" + fSAllianceManagementException.getMessage());
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSLoginHelper.getTLDURL():General Exception:" + exception.getMessage());
        }
        if (messageEnabled) {
            FSUtils.debug.message("FSLoginHelper::getTLDURL().tldURL  " + string);
        }
        return string;
    }

    public String createAuthnRequestEnvelope(HttpServletRequest httpServletRequest) {
        FSUtils.debug.message("FSLoginHelper.createAuthnRequestEnvelope(): called" + httpServletRequest.getParameter("metaAlias"));
        try {
            String string;
            FSAllianceManager fSAllianceManager;
            Object object;
            Object object2;
            String string2;
            String string3 = httpServletRequest.getParameter("metaAlias");
            this.setAllianceInfo(string3, null);
            FSAuthnRequest fSAuthnRequest = null;
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            Enumeration enumeration = httpServletRequest.getHeaderNames();
            while (enumeration.hasMoreElements()) {
                string2 = enumeration.nextElement().toString();
                object2 = httpServletRequest.getHeader(string2);
                hashMap.put(string2, object2);
            }
            string2 = LibertyManager.getProviderID(string3);
            object2 = this.getIDPs(string2);
            String string4 = httpServletRequest.getParameter("RelayState");
            if (string4 == null || string4.equals("")) {
                string4 = LibertyManager.getFederationDonePageURL(string2, httpServletRequest);
            }
            if ((fSAuthnRequest = this.getAuthnReq(hashMap, string4, true)) == null) {
                FSUtils.debug.error("FSLoginHelper.createAuthnRequest()::AuthnRequest is null");
                String string5 = LibertyManager.getProviderID(string3);
                String string6 = this.errorPage;
                string6 = string6 + "&" + "federror" + "=" + URLEncoder.encode("Unable to create AuthnRequest") + "&" + "fedremark" + "=" + URLEncoder.encode("Please check your Federation Configuration.");
                return string6;
            }
            String string7 = fSAuthnRequest.getRequestID();
            if (messageEnabled) {
                FSUtils.debug.message("FSLoginHelper.createAuthnRequest():: RequestID: " + string7);
            }
            FSSessionManager fSSessionManager = FSSessionManager.getInstance(string2);
            fSSessionManager.setAuthnRequest(string7, fSAuthnRequest);
            SSOTokenManager sSOTokenManager = SSOTokenManager.getInstance();
            SSOToken sSOToken = sSOTokenManager.createSSOToken(httpServletRequest);
            if (sSOToken != null) {
                fSSessionManager.setLocalSSOToken(string7, sSOToken);
            }
            Object var13_16 = null;
            String string8 = null;
            FSAuthnRequestEnvelope fSAuthnRequestEnvelope = null;
            String string9 = null;
            boolean bl = false;
            FSIDPList fSIDPList = null;
            string9 = allianceManager.getProvider(string2).getProviderName();
            String string10 = allianceManager.getProvider(string2).getAssertionConsumerServiceURL();
            ArrayList<IDPEntry> arrayList = null;
            String string11 = null;
            String string12 = null;
            String string13 = null;
            Iterator iterator = object2.iterator();
            while (iterator.hasNext()) {
                string11 = (String)iterator.next();
                if (string11 == null) continue;
                object = allianceManager.getProvider(string11);
                string12 = ((FSProviderDescriptor)object).getProviderName();
                string13 = ((FSProviderDescriptor)object).getSSOServiceURL();
                if (arrayList == null) {
                    arrayList = new ArrayList<IDPEntry>();
                }
                arrayList.add(new IDPEntry(string11, string12, string13));
            }
            object = new IDPEntries(arrayList);
            fSIDPList = new FSIDPList((IDPEntries)object, null);
            if (FSServiceUtils.isSigningOn() && (fSAllianceManager = FSServiceUtils.getAllianceInstance()).getHostedProvider(string = LibertyManager.getProviderID(string3)).getAuthnRequestSigned()) {
                fSAuthnRequest.signXML(fSAllianceManager.getHostedProvider(string).getKeyInfo());
            }
            fSAuthnRequestEnvelope = new FSAuthnRequestEnvelope(fSAuthnRequest, string2, string9, string10, fSIDPList, bl);
            FSUtils.debug.message("FSLoginHelper.createAuthnRequest: AuthnRequestEnvelope: " + fSAuthnRequestEnvelope.toXMLString());
            string8 = fSAuthnRequestEnvelope.toXMLString();
            return string8;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSLoginHelper.createAuthnRequest(): Exception Occured: " + exception.getMessage());
            return null;
        }
    }

    static {
        if (FSUtils.debug.messageEnabled()) {
            messageEnabled = true;
        }
        allianceManager = FSServiceUtils.getAllianceInstance();
    }
}

