/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.services;

import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.naming.WebtopNaming;
import com.iplanet.sso.SSOException;
import com.iplanet.sso.SSOToken;
import com.iplanet.sso.SSOTokenListener;
import com.iplanet.sso.SSOTokenManager;
import com.sun.identity.federation.alliance.FSAllianceManagementException;
import com.sun.identity.federation.alliance.FSAllianceManager;
import com.sun.identity.federation.alliance.FSHostedProviderDescriptor;
import com.sun.identity.federation.alliance.FSLocalConfigurationDescriptor;
import com.sun.identity.federation.alliance.FSProviderDescriptor;
import com.sun.identity.federation.common.FSException;
import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.FSAssertion;
import com.sun.identity.federation.message.FSAssertionArtifact;
import com.sun.identity.federation.message.FSAuthenticationStatement;
import com.sun.identity.federation.message.FSSubject;
import com.sun.identity.federation.message.common.AuthnContextStmt;
import com.sun.identity.federation.message.common.IDPProvidedNameIdentifier;
import com.sun.identity.federation.services.FSAssertionManagerClient;
import com.sun.identity.federation.services.FSSession;
import com.sun.identity.federation.services.FSSessionManager;
import com.sun.identity.federation.services.util.FSServiceUtils;
import com.sun.identity.saml.AssertionSSOTokenListener;
import com.sun.identity.saml.assertion.Assertion;
import com.sun.identity.saml.assertion.AssertionIDReference;
import com.sun.identity.saml.assertion.AudienceRestrictionCondition;
import com.sun.identity.saml.assertion.Conditions;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.assertion.Subject;
import com.sun.identity.saml.assertion.SubjectConfirmation;
import com.sun.identity.saml.assertion.SubjectLocality;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.SAMLServiceManager;
import com.sun.identity.saml.common.SAMLUtils;
import com.sun.identity.saml.protocol.AssertionArtifact;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class FSAssertionManager {
    private static Map instanceMap = new HashMap();
    private Map artIdMap = null;
    private Map artAuthnRequestMap = null;
    private static Map idEntryMap = null;
    private static String SERVICE_NAMING = "fsassertionmanager";
    private SubjectLocality authLocality = null;
    private String IPAddress = null;
    private Thread cThread = null;
    private String hostProviderId = null;
    static /* synthetic */ Class class$com$sun$identity$federation$services$FSAssertionManager;

    private FSAssertionManager(String string) {
        idEntryMap = new HashMap();
        this.artIdMap = new HashMap();
        this.artAuthnRequestMap = new HashMap();
        this.hostProviderId = string;
        try {
            String string2 = SystemProperties.get((String)"com.iplanet.am.server.host");
            this.IPAddress = InetAddress.getByName(string2).getHostAddress();
            this.authLocality = new SubjectLocality(this.IPAddress, string2);
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAssertionManager.constructor: couldn't obtain the localhost's ipaddress:", (Throwable)exception);
        }
        this.cThread = new CleanUpThread();
        this.cThread.start();
    }

    public static FSAssertionManager getInstance(String string) throws FSException {
        FSUtils.debug.message("FSAssertionManager.getInstance: Called");
        FSAssertionManager fSAssertionManager = null;
        Class clazz = class$com$sun$identity$federation$services$FSAssertionManager == null ? (class$com$sun$identity$federation$services$FSAssertionManager = FSAssertionManager.class$("com.sun.identity.federation.services.FSAssertionManager")) : class$com$sun$identity$federation$services$FSAssertionManager;
        synchronized (clazz) {
            fSAssertionManager = (FSAssertionManager)instanceMap.get(string);
            if (fSAssertionManager == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionManager.getInstance: Constructing a new instance of FSAssertionManager");
                }
                fSAssertionManager = new FSAssertionManager(string);
                instanceMap.put(string, fSAssertionManager);
            }
        }
        return fSAssertionManager;
    }

    void deleteAssertion(String string, String string2) {
        Object object;
        if (string2 != null) {
            object = this.artIdMap;
            synchronized (object) {
                this.artIdMap.remove(string2);
            }
        }
        if (string != null) {
            object = null;
            Map map = idEntryMap;
            synchronized (map) {
                object = (Entry)idEntryMap.remove(string);
            }
            if (object != null) {
                String string3;
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionManager.deleteAssertion:deleting " + string);
                }
                if (string2 == null && (string3 = ((Entry)object).getArtifactString()) != null) {
                    Map map2 = this.artIdMap;
                    synchronized (map2) {
                        this.artIdMap.remove(string3);
                    }
                }
            }
        }
    }

    public AssertionArtifact createFSAssertionArtifact(String string, FSProviderDescriptor fSProviderDescriptor, String string2, NameIdentifier nameIdentifier, NameIdentifier nameIdentifier2, String string3, int n) throws FSException, SAMLException {
        if (string == null || fSProviderDescriptor == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager: null input for method createFSAssertionArtifact.");
            }
            throw new FSException("nullInput", null);
        }
        String string4 = fSProviderDescriptor.getProviderID();
        String string5 = SAMLUtils.generateAssertionHandle();
        if (string5 == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.createFSAssertionArtifact: couldn't generate assertion handle.");
            }
            throw new FSException("errorCreateArtifact", null);
        }
        FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
        FSHostedProviderDescriptor fSHostedProviderDescriptor = fSAllianceManager.getHostedProvider(string2);
        String string6 = fSHostedProviderDescriptor.getProviderSuccinctID();
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManager.createFSAssertionArt: SourceID for the Artifact: " + string6);
        }
        byte[] byArray = FSUtils.hexStringToByteArray(string6);
        byte[] byArray2 = null;
        try {
            byArray2 = string5.getBytes("ISO-8859-1");
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAssertionManager.createFSAssertionArt: " + exception.getMessage());
            return null;
        }
        FSAssertionArtifact fSAssertionArtifact = new FSAssertionArtifact(byArray, byArray2);
        int n2 = 0;
        FSAssertion fSAssertion = this.createFSAssertion(string, fSAssertionArtifact, fSProviderDescriptor, string2, nameIdentifier, nameIdentifier2, string3, n2);
        return fSAssertionArtifact;
    }

    public FSAssertion createFSAssertion(String string, AssertionArtifact assertionArtifact, FSProviderDescriptor fSProviderDescriptor, String string2, NameIdentifier nameIdentifier, NameIdentifier nameIdentifier2, String string3, int n) throws FSException, SAMLException {
        Object object;
        int n2;
        Object object2;
        long l;
        Comparable<Integer> comparable;
        Object object3;
        Object object4;
        String string4;
        Object object5;
        FSUtils.debug.message("FSAssertionManager.createFSAssertion(id): Called");
        if (string == null || fSProviderDescriptor == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager: null input for method createFSAssertionArtifact.");
            }
            throw new FSException("nullInput", null);
        }
        String string5 = fSProviderDescriptor.getProviderID();
        String string6 = null;
        String string7 = null;
        String string8 = null;
        Date date = null;
        String string9 = null;
        Object var15_15 = null;
        SSOToken sSOToken = null;
        String string10 = null;
        try {
            object5 = SSOTokenManager.getInstance();
            sSOToken = object5.createSSOToken(string);
            string4 = sSOToken.getProperty("authInstant");
            if (string4 != null) {
                try {
                    date = FSUtils.stringToDate(string4);
                }
                catch (Exception exception) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("FSAssertionManager.createFSAssertion(id): AuthInstant not foundin the Token");
                    }
                }
            } else {
                date = new Date();
            }
            string6 = sSOToken.getAuthType();
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.createFSAssertion(id):AuthInstant = " + date);
            }
            try {
                object4 = FSSessionManager.getInstance(this.hostProviderId);
                object3 = ((FSSessionManager)object4).getSession(sSOToken);
                string7 = string8 = ((FSSession)object3).getAuthnContext();
            }
            catch (Exception exception) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionManager.createFSAssertion(id): AuthnContextStatement for the token is null Assertion will not contain any  AuthenticationStatement");
                }
                string7 = null;
            }
            if (string7 == null) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionManager.createFSAssertion(id): AuthnContextStatement for the token is null Assertion will not contain any  AuthenticationStatement");
                }
                string6 = SAMLServiceManager.getAuthMethodURI(string6);
            } else {
                string6 = "http://projectliberty.org/schemas/authctx/2002/05";
            }
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.createFSAssertion(id):AuthnContextStatement used for authenticating the user: " + string7);
            }
            string10 = sSOToken.getPrincipal().getName();
            if (string2 == null) {
                FSUtils.debug.error("FSAssertionManager.createAssertion(id): Alliance manager could not find local descriptor");
                throw new FSException("Alliance manager could not find local descriptor");
            }
            string9 = string2;
        }
        catch (Exception exception) {
            FSUtils.debug.error("FSAssertionManager.createAssertion(id): exception retrieving info from the SSOToken: ", (Throwable)exception);
            throw new FSException(exception, "Alliance manager could not find local descriptor");
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManager.createAssertion(id): Creating Authentication Assertion for user withopaqueHandle= " + nameIdentifier.getName() + " And SecurityDomain= " + string9);
        }
        object5 = null;
        string4 = null;
        if (assertionArtifact != null) {
            string4 = assertionArtifact.getAssertionArtifact();
            object5 = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:artifact-01");
            ((SubjectConfirmation)object5).setSubjectConfirmationData(string4);
        } else {
            object5 = new SubjectConfirmation("urn:oasis:names:tc:SAML:1.0:cm:bearer");
        }
        object4 = null;
        object4 = n == 2 || n == 1 ? new IDPProvidedNameIdentifier(nameIdentifier2.getName(), nameIdentifier2.getNameQualifier(), "urn:liberty:iff:nameid:federated") : new IDPProvidedNameIdentifier(nameIdentifier2.getNameQualifier(), nameIdentifier2.getName());
        object3 = new FSSubject(nameIdentifier, (SubjectConfirmation)object5, (IDPProvidedNameIdentifier)object4);
        AuthnContextStmt authnContextStmt = new AuthnContextStmt(string8, string7);
        authnContextStmt.setMinorVersion(n);
        FSAuthenticationStatement fSAuthenticationStatement = new FSAuthenticationStatement(string6, date, (Subject)object3, this.authLocality, null, authnContextStmt);
        FSSessionManager fSSessionManager = FSSessionManager.getInstance(this.hostProviderId);
        FSSession fSSession = fSSessionManager.getSession(string10, string);
        if (fSSession == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.createAssertion(id): AssertionManager could not find a valid Session foruserDN: " + string10 + " SessionID: " + string);
            }
            return null;
        }
        String string11 = fSSession.getSessionIndex();
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManager.createAssertion(id): SessionIndex: " + string11);
        }
        fSAuthenticationStatement.setSessionIndex(string11);
        Date date2 = new Date();
        FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
        FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = fSAllianceManager.getHostedProvider(string2).getLocalConfiguration();
        if (assertionArtifact != null) {
            try {
                comparable = new Integer(fSLocalConfigurationDescriptor.getArtifactTimeout());
            }
            catch (Exception exception) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionManager.createAssertion(id): AtrifactTimeOut configuration not found in FSConfig. Using Default");
                }
                comparable = null;
            }
            if (comparable == null) {
                comparable = new Integer(120);
            }
            l = comparable * 1000;
        } else {
            try {
                comparable = new Integer(fSLocalConfigurationDescriptor.getAssertionInterval());
            }
            catch (Exception exception) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionManager.createAssertion(id): AtrifactTimeOut configuration not found in FSConfig. Using Default");
                }
                comparable = null;
            }
            if (comparable == null) {
                comparable = new Integer(60);
            }
            FSUtils.debug.message("here before assertion time");
            l = comparable * 1000;
            if (l < 60000L) {
                l = 60000L;
            }
            FSUtils.debug.message("here after assertion time");
        }
        FSUtils.debug.message("here before date");
        comparable = new Date(date2.getTime() + l);
        FSUtils.debug.message("here after date");
        fSAuthenticationStatement.setReauthenticateOnOrAfter((Date)comparable);
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManager.createAssertion(id): Authentication Statement: " + fSAuthenticationStatement.toXMLString());
        }
        Conditions conditions = new Conditions(date2, (Date)comparable);
        if (string5 != null && !string5.equals("")) {
            object2 = new ArrayList();
            object2.add(string5);
            conditions.addAudienceRestrictionCondition(new AudienceRestrictionCondition((List)object2));
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManager.createAssertion(id): Authentication Statement: " + fSAuthenticationStatement.toXMLString());
        }
        object2 = new AssertionIDReference();
        HashSet<FSAuthenticationStatement> hashSet = new HashSet<FSAuthenticationStatement>();
        hashSet.add(fSAuthenticationStatement);
        FSAssertion fSAssertion = new FSAssertion(((AssertionIDReference)object2).getAssertionIDReference(), string2, date2, conditions, hashSet, string3);
        fSAssertion.setMinorVersion(n);
        fSAssertion.setID(((AssertionIDReference)object2).getAssertionIDReference());
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManager.createAssertion(id): Assertion created successfully: " + fSAssertion.toXMLString());
        }
        String string12 = fSAssertion.getAssertionID();
        Entry entry = new Entry(fSAssertion, string5, string4, sSOToken);
        Integer n3 = null;
        try {
            n3 = new Integer(fSLocalConfigurationDescriptor.getAssertionLimit());
        }
        catch (Exception exception) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.createAssertion(id): Assertion MAX number configuration not found in FSConfig.Using Default");
            }
            n3 = null;
        }
        if (n3 == null) {
            n3 = new Integer(10);
        }
        if ((n2 = n3.intValue()) != 0 && idEntryMap.size() > n2) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.createAssertion: reached maxNumber of assertions.");
            }
            throw new FSException("errorCreateAssertion", null);
        }
        try {
            object = idEntryMap;
            synchronized (object) {
                idEntryMap.put(string12, entry);
            }
        }
        catch (Exception exception) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager: couldn't add to idEntryMap." + exception.getMessage());
            }
            throw new FSException("errorCreateAssertion", null);
        }
        FSUtils.access("FSAssertionManager", FSUtils.bundle.getString("assertionCreated") + ":" + fSAssertion.toString());
        if (string4 != null) {
            try {
                object = this.artIdMap;
                synchronized (object) {
                    this.artIdMap.put(string4, string12);
                }
            }
            catch (Exception exception) {
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("FSAssertionManager: couldn't add artifact to the artIdMap.", (Throwable)exception);
                }
                throw new FSException("errorCreateArtifact", null);
            }
        }
        if (sSOToken != null) {
            object = new AssertionSSOTokenListener(string12, string4);
            try {
                sSOToken.addSSOTokenListener((SSOTokenListener)object);
            }
            catch (SSOException sSOException) {
                FSUtils.debug.error("FSAssertionManager.createAssertion(id): Couldn't add listener to token:", (Throwable)sSOException);
            }
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManager.createAssertion(id): Returning Assertion: " + fSAssertion.toXMLString());
        }
        return fSAssertion;
    }

    public Assertion getAssertion(AssertionArtifact assertionArtifact, String string) throws FSException {
        if (assertionArtifact == null || string == null || string.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager: input is null.");
            }
            throw new FSException("nullInput", null);
        }
        String string2 = assertionArtifact.getAssertionArtifact();
        String string3 = SAMLUtils.getServerURL(assertionArtifact.getAssertionHandle());
        if (string3 != null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("AssertionManager.getAssertion(art, destid: calling another server in lb site:" + string3);
            }
            FSAssertionManagerClient fSAssertionManagerClient = new FSAssertionManagerClient(this.hostProviderId, this.getFullServiceURL(string3));
            return fSAssertionManagerClient.getAssertion(assertionArtifact, string);
        }
        String string4 = null;
        try {
            string4 = (String)this.artIdMap.get(string2);
            if (string4 == null) {
                throw new FSException("nullInput", null);
            }
        }
        catch (Exception exception) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getAssertion(art, destid): no AssertionID found corresponding to artifact.");
            }
            throw new FSException("noMatchingAssertion", null);
        }
        Entry entry = null;
        try {
            entry = (Entry)idEntryMap.get(string4);
            if (entry == null) {
                throw new FSException("nullEntry", null);
            }
        }
        catch (Exception exception) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getAssertion(art, destid): no Entry found corresponding to artifact.");
            }
            throw new FSException("noMatchingAssertion", null);
        }
        String string5 = entry.getDestID();
        if (string5 == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getAssertion(art, destid): no destID found corresponding to artifact.");
            }
            throw new FSException("noDestIDMatchingArtifact", null);
        }
        if (!string5.equals(string)) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getAssertion(art, destid): destinationID doesn't match.");
            }
            throw new FSException("destIDNotMatch", null);
        }
        Assertion assertion = entry.getAssertion();
        if (assertion == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getAssertion(art, destid): no Assertion found corresponding to aID.");
            }
            throw new FSException("noMatchingAssertion", null);
        }
        Map map = this.artIdMap;
        synchronized (map) {
            this.artIdMap.remove(string2);
        }
        if (!assertion.isTimeValid()) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager: assertion " + string4 + " is expired.");
            }
            throw new FSException("assertionTimeNotValid", null);
        }
        return assertion;
    }

    public String getDestIdForArtifact(AssertionArtifact assertionArtifact) throws FSException {
        FSUtils.debug.message("FSAssertionManager.getDestIdForArtifact: Called");
        String string = assertionArtifact.getAssertionArtifact();
        String string2 = SAMLUtils.getServerURL(assertionArtifact.getAssertionHandle());
        if (string2 != null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("AssertionManager.getDestIdForArtifact(art, destid: calling another server in lb site:" + string2);
            }
            FSAssertionManagerClient fSAssertionManagerClient = new FSAssertionManagerClient(this.hostProviderId, this.getFullServiceURL(string2));
            return fSAssertionManagerClient.getDestIdForArtifact(assertionArtifact);
        }
        String string3 = null;
        try {
            string3 = (String)this.artIdMap.get(string);
            if (string3 == null) {
                throw new FSException("nullInput", null);
            }
        }
        catch (Exception exception) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getDestIdForArtifact :no AssertionID found corresponding to artifact.");
            }
            throw new FSException("noMatchingAssertion", null);
        }
        Entry entry = null;
        try {
            entry = (Entry)idEntryMap.get(string3);
            if (entry == null) {
                throw new FSException("nullEntry", null);
            }
        }
        catch (Exception exception) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getDestIdForArtifact: no Entry found corresponding to artifact.");
            }
            throw new FSException("noMatchingAssertion", null);
        }
        String string4 = entry.getDestID();
        if (string4 == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("FSAssertionManager.getDestIdForArtifact: no destID found corresponding to artifact.");
            }
            throw new FSException("noDestIDMatchingArtifact", null);
        }
        if (FSUtils.debug.messageEnabled()) {
            FSUtils.debug.message("FSAssertionManager.getDestIdForArtifact: Destination ProviderID found for Artifact: " + string4);
        }
        return string4;
    }

    private String getFullServiceURL(String string) {
        String string2;
        block3: {
            string2 = null;
            try {
                URL uRL = new URL(string);
                URL uRL2 = WebtopNaming.getServiceURL((String)SERVICE_NAMING, (String)uRL.getProtocol(), (String)uRL.getHost(), (String)Integer.toString(uRL.getPort()));
                string2 = uRL2.toString();
                if (FSUtils.debug.messageEnabled()) {
                    FSUtils.debug.message("AssertionManager.getFullServiceURL:full remote URL is: " + string2);
                }
            }
            catch (Exception exception) {
                if (!FSUtils.debug.warningEnabled()) break block3;
                FSUtils.debug.warning("AssertionManager.getFullServiceURL:Exception:", (Throwable)exception);
            }
        }
        return string2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class CleanUpThread
    extends Thread {
        private CleanUpThread() {
        }

        public void run() {
            Set set = null;
            Iterator<Object> iterator = null;
            String string = null;
            Entry entry = null;
            Assertion assertion = null;
            HashSet<String> hashSet = null;
            FSLocalConfigurationDescriptor fSLocalConfigurationDescriptor = null;
            FSAllianceManager fSAllianceManager = FSServiceUtils.getAllianceInstance();
            try {
                fSLocalConfigurationDescriptor = fSAllianceManager.getHostedProvider(FSAssertionManager.this.hostProviderId).getLocalConfiguration();
            }
            catch (FSAllianceManagementException fSAllianceManagementException) {
                FSUtils.debug.error("CleanUpThread.run(): Exception while cleaning up assertion :" + fSAllianceManagementException.getMessage());
            }
            while (true) {
                Integer n;
                try {
                    n = new Integer(fSLocalConfigurationDescriptor.getCleanupInterval());
                }
                catch (Exception exception) {
                    if (FSUtils.debug.messageEnabled()) {
                        FSUtils.debug.message("CleanUpThread.run():Cleanup- Interval configuration not found in FSConfig. Using Default");
                    }
                    n = null;
                }
                if (n == null) {
                    n = new Integer(180);
                }
                long l = n * 1000;
                long l2 = System.currentTimeMillis() + l;
                set = idEntryMap.keySet();
                iterator = set.iterator();
                hashSet = new HashSet<String>();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    entry = (Entry)idEntryMap.get(string);
                    if (entry == null || (assertion = entry.getAssertion()) == null || assertion.isTimeValid()) continue;
                    hashSet.add(string);
                }
                iterator = hashSet.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    FSAssertionManager.this.deleteAssertion(string, null);
                }
                try {
                    long l3 = l2 - System.currentTimeMillis();
                    if (l3 <= 0L) continue;
                    Thread.sleep(l3);
                }
                catch (Exception exception) {
                    continue;
                }
                break;
            }
        }
    }

    private class Entry {
        private String destID = null;
        private String artString = null;
        private SSOToken token = null;
        private Assertion assertion = null;

        public Entry(Assertion assertion, String string, String string2, SSOToken sSOToken) {
            this.assertion = assertion;
            this.destID = string;
            this.artString = string2;
            this.token = sSOToken;
        }

        public Assertion getAssertion() {
            return this.assertion;
        }

        public String getDestID() {
            return this.destID;
        }

        public String getArtifactString() {
            return this.artString;
        }

        public SSOToken getSSOToken() {
            return this.token;
        }
    }
}

