/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.federation.message.common;

import com.sun.identity.federation.common.FSUtils;
import com.sun.identity.federation.message.common.FSMsgException;
import com.sun.identity.saml.assertion.NameIdentifier;
import com.sun.identity.saml.common.SAMLException;
import com.sun.identity.saml.common.XMLUtils;
import org.w3c.dom.Element;

public class IDPProvidedNameIdentifier
extends NameIdentifier {
    public IDPProvidedNameIdentifier(String string, String string2, String string3) throws SAMLException {
        super(string, string2, string3);
    }

    public IDPProvidedNameIdentifier(Element element) throws FSMsgException {
        FSUtils.debug.message("IDPProvidedNameIdentifier(Element):  Called");
        Element element2 = element;
        String string = element2.getLocalName();
        if (string == null) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("IDPProvidedNameIdentifier(Element): local name missing");
            }
            throw new FSMsgException(FSUtils.bundle.getString("nullInput"));
        }
        if (!string.equals("IDPProvidedNameIdentifier")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("IDPProvidedNameIdentifier(Element: invalid root element");
            }
            throw new FSMsgException(FSUtils.bundle.getString("invalidElement"));
        }
        String string2 = element2.getAttribute("NameQualifier");
        if (string2 != null) {
            this.setNameQualifier(string2);
        }
        if ((string2 = element2.getAttribute("Format")) != null) {
            this.setFormat(string2);
        }
        if ((string2 = XMLUtils.getElementValue(element2)) == null || string2.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("IDPProvidedNameIdentifier(Element: null input specified");
            }
            throw new FSMsgException(FSUtils.bundle.getString("nullInput"));
        }
        this.setName(string2);
    }

    public IDPProvidedNameIdentifier(String string, String string2) throws FSMsgException {
        if (string2 == null || string2.equals("")) {
            if (FSUtils.debug.messageEnabled()) {
                FSUtils.debug.message("IDPProvidedNameIdentifier: null input specified");
            }
            throw new FSMsgException(FSUtils.bundle.getString("nullInput"));
        }
        this.setName(string2);
        if (string == null) {
            this.setNameQualifier("");
        } else {
            this.setNameQualifier(string);
        }
    }

    public String toXMLString() throws FSMsgException {
        String string = this.toXMLString(true, false);
        return string;
    }

    public String toXMLString(boolean bl, boolean bl2) throws FSMsgException {
        StringBuffer stringBuffer = new StringBuffer(3000);
        String string = "";
        String string2 = "";
        if (bl2) {
            string = " xmlns:lib=\"http://projectliberty.org/schemas/core/2002/12\"";
        }
        if (bl) {
            string2 = "lib:";
        }
        stringBuffer.append("<").append(string2).append("IDPProvidedNameIdentifier").append(" ").append(string).append(" ");
        if (this.getNameQualifier() != null && !this.getNameQualifier().equals("")) {
            stringBuffer.append("NameQualifier").append("=\"").append(this.getNameQualifier()).append("\"").append(" ");
        }
        if (this.getFormat() != null && !this.getFormat().equals("")) {
            stringBuffer.append("Format").append("=\"").append(this.getFormat()).append("\"").append(" ");
        }
        if (this.getName() != null && !this.getName().equals("")) {
            stringBuffer.append(">").append(this.getName());
            stringBuffer.append("</").append(string2).append("IDPProvidedNameIdentifier").append(">\n");
        }
        return stringBuffer.toString();
    }
}

