/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.share;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.XMLUtils;
import com.iplanet.services.util.Base64;
import com.sun.identity.authentication.service.PagePropertiesCallback;
import com.sun.identity.authentication.spi.DSAMECallbackInterface;
import com.sun.identity.security.DecodeAction;
import com.sun.identity.security.EncodeAction;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.security.auth.callback.ConfirmationCallback;
import javax.security.auth.callback.LanguageCallback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.TextInputCallback;
import javax.security.auth.callback.TextOutputCallback;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AuthXMLUtils {
    static Debug debug = Debug.getInstance((String)"amAuthXMLUtils");

    public static Callback[] getCallbacks(Node node, boolean bl) {
        try {
            return AuthXMLUtils.getCallbacks(node, bl, null);
        }
        catch (Exception exception) {
            debug.message("Exception . ", (Throwable)exception);
            return null;
        }
    }

    public static Callback[] getCallbacks(Node node, boolean bl, Callback[] callbackArray) {
        if (node == null) {
            return null;
        }
        String string = XMLUtils.getNodeAttributeValue((Node)node, (String)"length");
        int n = Integer.parseInt(string);
        if (debug.messageEnabled()) {
            debug.message("Callbacks length is : " + n);
            if (callbackArray != null) {
                int n2 = 0;
                while (n2 < callbackArray.length) {
                    debug.message("callback is : " + callbackArray[n2]);
                    ++n2;
                }
            }
        }
        Callback[] callbackArray2 = new Callback[n];
        Object var6_7 = null;
        NodeList nodeList = node.getChildNodes();
        if (nodeList == null) {
            return null;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        while (n12 < nodeList.getLength()) {
            Node node2 = nodeList.item(n12);
            String string2 = node2.getNodeName();
            if (string2.equals("NameCallback")) {
                if (callbackArray != null) {
                    if ((n3 = AuthXMLUtils.getNameCallbackIndex(callbackArray, n3)) >= 0) {
                        callbackArray2[n12] = AuthXMLUtils.createNameCallback(node2, callbackArray[n3]);
                    }
                    ++n3;
                } else {
                    callbackArray2[n12] = AuthXMLUtils.createNameCallback(node2, null);
                }
            } else if (string2.equals("PasswordCallback")) {
                if (callbackArray != null) {
                    if ((n4 = AuthXMLUtils.getPasswordCallbackIndex(callbackArray, n4)) >= 0) {
                        callbackArray2[n12] = AuthXMLUtils.createPasswordCallback(node2, callbackArray[n4]);
                    }
                    ++n4;
                } else {
                    callbackArray2[n12] = AuthXMLUtils.createPasswordCallback(node2, null);
                }
            } else if (string2.equals("ChoiceCallback")) {
                if (callbackArray != null) {
                    if ((n5 = AuthXMLUtils.getChoiceCallbackIndex(callbackArray, n5)) >= 0) {
                        callbackArray2[n12] = AuthXMLUtils.createChoiceCallback(node2, callbackArray[n5]);
                    }
                    ++n5;
                } else {
                    callbackArray2[n12] = AuthXMLUtils.createChoiceCallback(node2, null);
                }
            } else if (string2.equals("ConfirmationCallback")) {
                if (callbackArray != null) {
                    if ((n6 = AuthXMLUtils.getConfCallbackIndex(callbackArray, n6)) >= 0) {
                        callbackArray2[n12] = AuthXMLUtils.createConfirmationCallback(node2, callbackArray[n6]);
                    }
                    ++n6;
                } else {
                    callbackArray2[n12] = AuthXMLUtils.createConfirmationCallback(node2, null);
                }
            } else if (string2.equals("TextInputCallback")) {
                if (callbackArray != null) {
                    if ((n7 = AuthXMLUtils.getTextInputIndex(callbackArray, n7)) >= 0) {
                        callbackArray2[n12] = AuthXMLUtils.createTextInputCallback(node2, callbackArray[n7]);
                    }
                    ++n7;
                } else {
                    callbackArray2[n12] = AuthXMLUtils.createTextInputCallback(node2, null);
                }
            } else if (string2.equals("TextOutputCallback")) {
                if (callbackArray != null) {
                    if ((n8 = AuthXMLUtils.getTextOutputIndex(callbackArray, n8)) >= 0) {
                        callbackArray2[n12] = AuthXMLUtils.createTextOutputCallback(node2, callbackArray[n8]);
                    }
                    ++n8;
                } else {
                    callbackArray2[n12] = AuthXMLUtils.createTextOutputCallback(node2, null);
                }
            } else if (string2.equals("PagePropertiesCallback") && bl) {
                if (callbackArray != null) {
                    if ((n10 = AuthXMLUtils.getPagePropertiesIndex(callbackArray, n10)) >= 0) {
                        callbackArray2[n12] = AuthXMLUtils.createPagePropertiesCallback(node2, callbackArray[n10]);
                    }
                    ++n10;
                } else {
                    callbackArray2[n12] = AuthXMLUtils.createPagePropertiesCallback(node2, null);
                }
            } else if (string2.equals("LanguageCallback")) {
                if (callbackArray != null) {
                    if ((n9 = AuthXMLUtils.getLanguageCallbackIndex(callbackArray, n9)) >= 0) {
                        callbackArray2[n12] = AuthXMLUtils.createLanguageCallback(node2, callbackArray[n9]);
                    }
                    ++n9;
                } else {
                    callbackArray2[n12] = AuthXMLUtils.createLanguageCallback(node2, null);
                }
            } else if (string2.equals("CustomCallback")) {
                if (callbackArray != null) {
                    n11 = AuthXMLUtils.getCustomCallbackIndex(callbackArray, n10);
                    if (n11 >= 0) {
                        callbackArray2[n12] = AuthXMLUtils.createCustomCallback(node2, callbackArray[n11]);
                    }
                    ++n11;
                } else {
                    callbackArray2[n12] = AuthXMLUtils.createCustomCallback(node2, null);
                }
            }
            ++n12;
        }
        return callbackArray2;
    }

    public static String getXMLForCallbacks(Callback[] callbackArray) {
        if (callbackArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<Callbacks").append(" ").append("length").append("=").append("\"").append(callbackArray.length).append("\"").append(">");
        int n = 0;
        while (n < callbackArray.length) {
            Callback callback;
            if (callbackArray[n] instanceof NameCallback) {
                callback = (NameCallback)callbackArray[n];
                stringBuffer.append(AuthXMLUtils.getNameCallbackXML(callback));
            } else if (callbackArray[n] instanceof PasswordCallback) {
                callback = (PasswordCallback)callbackArray[n];
                stringBuffer.append(AuthXMLUtils.getPasswordCallbackXML((PasswordCallback)callback));
            } else if (callbackArray[n] instanceof ChoiceCallback) {
                callback = (ChoiceCallback)callbackArray[n];
                stringBuffer.append(AuthXMLUtils.getChoiceCallbackXML((ChoiceCallback)callback));
            } else if (callbackArray[n] instanceof ConfirmationCallback) {
                callback = (ConfirmationCallback)callbackArray[n];
                stringBuffer.append(AuthXMLUtils.getConfirmationCallbackXML((ConfirmationCallback)callback));
            } else if (callbackArray[n] instanceof TextInputCallback) {
                callback = (TextInputCallback)callbackArray[n];
                stringBuffer.append(AuthXMLUtils.getTextInputCallbackXML((TextInputCallback)callback));
            } else if (callbackArray[n] instanceof TextOutputCallback) {
                callback = (TextOutputCallback)callbackArray[n];
                stringBuffer.append(AuthXMLUtils.getTextOutputCallbackXML((TextOutputCallback)callback));
            } else if (callbackArray[n] instanceof PagePropertiesCallback) {
                callback = (PagePropertiesCallback)callbackArray[n];
                stringBuffer.append(AuthXMLUtils.getPagePropertiesCallbackXML((PagePropertiesCallback)callback));
            } else if (callbackArray[n] instanceof LanguageCallback) {
                callback = (LanguageCallback)callbackArray[n];
                stringBuffer.append(AuthXMLUtils.getLanguageCallbackXML((LanguageCallback)callback));
            } else if (callbackArray[n] instanceof DSAMECallbackInterface) {
                callback = (DSAMECallbackInterface)callbackArray[n];
                stringBuffer.append(AuthXMLUtils.getCustomCallbackXML((DSAMECallbackInterface)callback));
            }
            ++n;
        }
        stringBuffer.append("</Callbacks>");
        return stringBuffer.toString();
    }

    static NameCallback createNameCallback(Node node, Callback callback) {
        String string;
        String string2 = AuthXMLUtils.getPrompt(node);
        NameCallback nameCallback = null;
        if (callback != null && callback instanceof NameCallback) {
            nameCallback = (NameCallback)callback;
        }
        if (nameCallback == null) {
            string = AuthXMLUtils.getDefaultValue(node);
            nameCallback = string == null ? new NameCallback(string2) : new NameCallback(string2, string);
        }
        string = AuthXMLUtils.getValue(node);
        if (debug.messageEnabled()) {
            debug.message("Value is : " + string);
        }
        if (string != null) {
            nameCallback.setName(string);
        }
        return nameCallback;
    }

    static PasswordCallback createPasswordCallback(Node node, Callback callback) {
        String string = AuthXMLUtils.getPrompt(node);
        boolean bl = false;
        String string2 = XMLUtils.getNodeAttributeValue((Node)node, (String)"echoPassword");
        if (string2 != null && string2.equals("true")) {
            bl = true;
        }
        PasswordCallback passwordCallback = null;
        if (callback != null && callback instanceof PasswordCallback) {
            passwordCallback = (PasswordCallback)callback;
        }
        if (passwordCallback == null) {
            passwordCallback = new PasswordCallback(string, bl);
        }
        String string3 = AuthXMLUtils.getValue(node);
        if (debug.messageEnabled()) {
            debug.message("Value is : " + string3);
        }
        if (string3 != null) {
            passwordCallback.setPassword(string3.toCharArray());
        }
        return passwordCallback;
    }

    static ChoiceCallback createChoiceCallback(Node node, Callback callback) {
        Node node2;
        Object object;
        Object object2;
        ChoiceCallback choiceCallback = null;
        if (callback != null && callback instanceof ChoiceCallback) {
            choiceCallback = (ChoiceCallback)callback;
        }
        if (choiceCallback == null) {
            object2 = AuthXMLUtils.getPrompt(node);
            boolean bl = false;
            object = XMLUtils.getNodeAttributeValue((Node)node, (String)"multipleSelectionsAllowed");
            if (object != null && ((String)object).equals("true")) {
                bl = true;
            }
            String[] stringArray = null;
            int n = 0;
            Node node3 = XMLUtils.getChildNode((Node)node, (String)"ChoiceValues");
            NodeList nodeList = node3.getChildNodes();
            stringArray = new String[nodeList.getLength()];
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                String string;
                Node node4 = nodeList.item(n2);
                String string2 = XMLUtils.getNodeAttributeValue((Node)node4, (String)"isDefault");
                if (string2 != null && string2.equals("yes")) {
                    n = n2;
                }
                stringArray[n2] = string = AuthXMLUtils.getValue(node4);
                ++n2;
            }
            choiceCallback = new ChoiceCallback((String)object2, stringArray, n, bl);
        }
        if ((node2 = XMLUtils.getChildNode((Node)node, (String)"SelectedValues")) != null) {
            object = node2.getChildNodes();
            object2 = new int[object.getLength()];
            int n = 0;
            while (n < object.getLength()) {
                Node node5 = object.item(n);
                object2[n] = Integer.parseInt(XMLUtils.getValueOfValueNode((Node)node5));
                ++n;
            }
            if (choiceCallback.allowMultipleSelections()) {
                choiceCallback.setSelectedIndexes((int[])object2);
            } else {
                choiceCallback.setSelectedIndex((int)object2[0]);
            }
        }
        return choiceCallback;
    }

    static ConfirmationCallback createConfirmationCallback(Node node, Callback callback) {
        Object object;
        ConfirmationCallback confirmationCallback = null;
        if (callback != null && callback instanceof ConfirmationCallback) {
            confirmationCallback = (ConfirmationCallback)callback;
        }
        if (confirmationCallback == null) {
            Object object2;
            object = AuthXMLUtils.getPrompt(node);
            int n = 0;
            String string = XMLUtils.getNodeAttributeValue((Node)node, (String)"messageType");
            if (string.equals("information")) {
                n = 0;
            } else if (string.equals("error")) {
                n = 2;
            } else if (string.equals("warning")) {
                n = 1;
            }
            boolean bl = false;
            int n2 = 0;
            String string2 = XMLUtils.getNodeAttributeValue((Node)node, (String)"optionType");
            if (string2 != null) {
                if (string2.equals("yes_no")) {
                    n2 = 0;
                } else if (string2.equals("yes_no_cancel")) {
                    n2 = 1;
                } else if (string2.equals("ok_cancel")) {
                    n2 = 2;
                } else if (string2.equals("unspecified")) {
                    n2 = -1;
                    bl = true;
                }
            }
            String[] stringArray = null;
            Node node2 = XMLUtils.getChildNode((Node)node, (String)"OptionValues");
            if (node2 != null) {
                object2 = node2.getChildNodes();
                stringArray = new String[object2.getLength()];
                int n3 = 0;
                while (n3 < object2.getLength()) {
                    String string3;
                    Node node3 = object2.item(n3);
                    stringArray[n3] = string3 = AuthXMLUtils.getValue(node3);
                    ++n3;
                }
            }
            object2 = XMLUtils.getChildNode((Node)node, (String)"DefaultOptionValue");
            String string4 = AuthXMLUtils.getValue((Node)object2);
            int n4 = Integer.parseInt(string4);
            confirmationCallback = object != null ? (bl ? new ConfirmationCallback((String)object, n, stringArray, n4) : new ConfirmationCallback((String)object, n, n2, n4)) : (bl ? new ConfirmationCallback(n, stringArray, n4) : new ConfirmationCallback(n, n2, n4));
        }
        if ((object = XMLUtils.getChildNode((Node)node, (String)"SelectedValue")) != null) {
            String string = AuthXMLUtils.getValue((Node)object);
            int n = Integer.parseInt(string);
            confirmationCallback.setSelectedIndex(n);
        }
        return confirmationCallback;
    }

    static TextInputCallback createTextInputCallback(Node node, Callback callback) {
        String string;
        TextInputCallback textInputCallback = null;
        if (callback != null && callback instanceof TextInputCallback) {
            textInputCallback = (TextInputCallback)callback;
        }
        if (textInputCallback == null) {
            string = AuthXMLUtils.getPrompt(node);
            String string2 = AuthXMLUtils.getDefaultValue(node);
            textInputCallback = string2 == null ? new TextInputCallback(string) : new TextInputCallback(string, string2);
        }
        if ((string = AuthXMLUtils.getValue(node)) != null) {
            textInputCallback.setText(string);
        }
        return textInputCallback;
    }

    static TextOutputCallback createTextOutputCallback(Node node, Callback callback) {
        TextOutputCallback textOutputCallback = null;
        if (callback != null && callback instanceof TextOutputCallback) {
            textOutputCallback = (TextOutputCallback)callback;
        }
        if (textOutputCallback == null) {
            String string = AuthXMLUtils.getValue(node);
            int n = 0;
            String string2 = XMLUtils.getNodeAttributeValue((Node)node, (String)"messageType");
            if (string2.equals("information")) {
                n = 0;
            } else if (string2.equals("error")) {
                n = 2;
            } else if (string2.equals("warning")) {
                n = 1;
            }
            textOutputCallback = new TextOutputCallback(n, string);
        }
        return textOutputCallback;
    }

    static PagePropertiesCallback createPagePropertiesCallback(Node node, Callback callback) {
        PagePropertiesCallback pagePropertiesCallback = null;
        if (callback != null && callback instanceof PagePropertiesCallback) {
            pagePropertiesCallback = (PagePropertiesCallback)callback;
        }
        if (pagePropertiesCallback == null) {
            boolean bl = false;
            String string = XMLUtils.getNodeAttributeValue((Node)node, (String)"isErrorState");
            if (string != null && string.equals("true")) {
                bl = true;
            }
            String string2 = AuthXMLUtils.getValueOfChildNode(node, "ModuleName");
            String string3 = AuthXMLUtils.getValueOfChildNode(node, "PageState");
            String string4 = AuthXMLUtils.getValueOfChildNode(node, "HeaderValue");
            String string5 = AuthXMLUtils.getValueOfChildNode(node, "ImageName");
            int n = Integer.parseInt(AuthXMLUtils.getValueOfChildNode(node, "PageTimeOutValue"));
            String string6 = AuthXMLUtils.getValueOfChildNode(node, "TemplateName");
            pagePropertiesCallback = new PagePropertiesCallback(string2, string4, string5, n, string6, bl, string3);
        }
        return pagePropertiesCallback;
    }

    static String getNameCallbackXML(NameCallback nameCallback) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<NameCallback>").append("<Prompt>").append(nameCallback.getPrompt()).append("</Prompt>");
        String string2 = nameCallback.getDefaultName();
        if (string2 != null) {
            stringBuffer.append("<DefaultValue>").append("<Value>").append(string2).append("</Value>").append("</DefaultValue>");
        }
        if ((string = nameCallback.getName()) != null) {
            stringBuffer.append("<Value>").append(string).append("</Value>");
        }
        stringBuffer.append("</NameCallback>");
        return stringBuffer.toString();
    }

    static String getPasswordCallbackXML(PasswordCallback passwordCallback) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<PasswordCallback").append(" ").append("echoPassword").append("=").append("\"");
        if (passwordCallback.isEchoOn()) {
            stringBuffer.append("true");
        } else {
            stringBuffer.append("false");
        }
        stringBuffer.append("\"").append(">").append("<Prompt>").append(passwordCallback.getPrompt()).append("</Prompt>");
        if (passwordCallback.getPassword() != null) {
            stringBuffer.append("<Value>").append(passwordCallback.getPassword()).append("</Value>");
        }
        stringBuffer.append("</PasswordCallback>");
        return stringBuffer.toString();
    }

    static String getChoiceCallbackXML(ChoiceCallback choiceCallback) {
        int[] nArray;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<ChoiceCallback").append(" ").append("multipleSelectionsAllowed").append("=").append("\"");
        if (choiceCallback.allowMultipleSelections()) {
            stringBuffer.append("true");
        } else {
            stringBuffer.append("false");
        }
        stringBuffer.append("\"").append(">").append("<Prompt>").append(choiceCallback.getPrompt()).append("</Prompt>");
        String[] stringArray = choiceCallback.getChoices();
        int n = choiceCallback.getDefaultChoice();
        if (stringArray != null) {
            stringBuffer.append("<ChoiceValues>");
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringBuffer.append("<ChoiceValue");
                if (n2 == n) {
                    stringBuffer.append(" ").append("isDefault").append("=").append("\"").append("yes").append("\"");
                }
                stringBuffer.append(">").append("<Value>").append(stringArray[n2]).append("</Value>").append("</ChoiceValue>");
                ++n2;
            }
            stringBuffer.append("</ChoiceValues>");
        }
        if ((nArray = choiceCallback.getSelectedIndexes()) != null) {
            stringBuffer.append("<SelectedValues>");
            int n3 = 0;
            while (n3 < nArray.length) {
                stringBuffer.append("<Value>").append(Integer.toString(nArray[n3])).append("</Value>");
                ++n3;
            }
            stringBuffer.append("</SelectedValues>");
        }
        stringBuffer.append("</ChoiceCallback>");
        return stringBuffer.toString();
    }

    static String getConfirmationCallbackXML(ConfirmationCallback confirmationCallback) {
        int n;
        String[] stringArray;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<ConfirmationCallback").append(" ").append("messageType").append("=").append("\"");
        switch (confirmationCallback.getMessageType()) {
            case 0: {
                stringBuffer.append("information");
                break;
            }
            case 2: {
                stringBuffer.append("error");
                break;
            }
            case 1: {
                stringBuffer.append("warning");
            }
        }
        stringBuffer.append("\"");
        stringBuffer.append(" ").append("optionType").append("=").append("\"");
        switch (confirmationCallback.getOptionType()) {
            case 0: {
                stringBuffer.append("yes_no");
                break;
            }
            case 1: {
                stringBuffer.append("yes_no_cancel");
                break;
            }
            case 2: {
                stringBuffer.append("ok_cancel");
                break;
            }
            case -1: {
                stringBuffer.append("unspecified");
            }
        }
        stringBuffer.append("\"").append(">");
        if (confirmationCallback.getPrompt() != null) {
            stringBuffer.append("<Prompt>").append(confirmationCallback.getPrompt()).append("</Prompt>");
        }
        if ((stringArray = confirmationCallback.getOptions()) != null) {
            stringBuffer.append("<OptionValues>");
            n = 0;
            while (n < stringArray.length) {
                stringBuffer.append("<OptionValue>").append("<Value>").append(stringArray[n]).append("</Value>").append("</OptionValue>");
                ++n;
            }
            stringBuffer.append("</OptionValues>");
        }
        n = confirmationCallback.getDefaultOption();
        stringBuffer.append("<DefaultOptionValue>").append("<Value>").append(Integer.toString(n)).append("</Value>").append("</DefaultOptionValue>");
        int n2 = confirmationCallback.getSelectedIndex();
        stringBuffer.append("<SelectedValue>").append("<Value>").append(Integer.toString(n2)).append("</Value>").append("</SelectedValue>");
        stringBuffer.append("</ConfirmationCallback>");
        return stringBuffer.toString();
    }

    static String getTextInputCallbackXML(TextInputCallback textInputCallback) {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<TextInputCallback>").append("<Prompt>").append(textInputCallback.getPrompt()).append("</Prompt>");
        String string2 = textInputCallback.getDefaultText();
        if (string2 != null) {
            stringBuffer.append("<DefaultValue>").append("<Value>").append(string2).append("</Value>").append("</DefaultValue>");
        }
        if ((string = textInputCallback.getText()) != null) {
            stringBuffer.append("<Value>").append(string).append("</Value>");
        }
        stringBuffer.append("</TextInputCallback>");
        return stringBuffer.toString();
    }

    static String getTextOutputCallbackXML(TextOutputCallback textOutputCallback) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<TextOutputCallback").append(" ").append("messageType").append("=").append("\"");
        switch (textOutputCallback.getMessageType()) {
            case 0: {
                stringBuffer.append("information");
                break;
            }
            case 2: {
                stringBuffer.append("error");
                break;
            }
            case 1: {
                stringBuffer.append("warning");
            }
        }
        stringBuffer.append("\"").append(">").append("<Value>").append(textOutputCallback.getMessage()).append("</Value>");
        stringBuffer.append("</TextOutputCallback>");
        return stringBuffer.toString();
    }

    static String getPagePropertiesCallbackXML(PagePropertiesCallback pagePropertiesCallback) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<PagePropertiesCallback").append(" ").append("isErrorState").append("=").append("\"");
        if (pagePropertiesCallback.getErrorState()) {
            stringBuffer.append("true");
        } else {
            stringBuffer.append("false");
        }
        stringBuffer.append("\"").append(">").append("<ModuleName>").append(pagePropertiesCallback.getModuleName()).append("</ModuleName>").append("<HeaderValue>").append(pagePropertiesCallback.getHeader()).append("</HeaderValue>").append("<ImageName>").append(pagePropertiesCallback.getImage()).append("</ImageName>").append("<PageTimeOut>").append(Integer.toString(pagePropertiesCallback.getTimeOutValue())).append("</PageTimeOut>").append("<TemplateName>").append(pagePropertiesCallback.getTemplateName()).append("</TemplateName>").append("<PageState>").append(pagePropertiesCallback.getPageState()).append("</PageState>");
        stringBuffer.append("</PagePropertiesCallback>");
        return stringBuffer.toString();
    }

    protected static String getPrompt(Node node) {
        Node node2 = XMLUtils.getChildNode((Node)node, (String)"Prompt");
        if (node2 != null) {
            return XMLUtils.getValueOfValueNode((Node)node2);
        }
        return null;
    }

    protected static String getValue(Node node) {
        Node node2 = XMLUtils.getChildNode((Node)node, (String)"Value");
        if (node2 != null) {
            return XMLUtils.getValueOfValueNode((Node)node2);
        }
        return null;
    }

    protected static String getValueOfChildNode(Node node, String string) {
        Node node2 = XMLUtils.getChildNode((Node)node, (String)string);
        if (node2 != null) {
            return XMLUtils.getValueOfValueNode((Node)node2);
        }
        return null;
    }

    static DSAMECallbackInterface createCustomCallback(Node node, Callback callback) {
        debug.message("in create custom callback");
        String string = XMLUtils.getNodeAttributeValue((Node)node, (String)"className");
        try {
            Object object;
            DSAMECallbackInterface dSAMECallbackInterface = null;
            if (callback != null && callback instanceof DSAMECallbackInterface && (dSAMECallbackInterface = (DSAMECallbackInterface)callback) != null) {
                object = dSAMECallbackInterface.getClass().getName();
                if (debug.messageEnabled()) {
                    debug.message("Class Name is : " + (String)object);
                }
                if (object == null || !((String)object).equals(string)) {
                    dSAMECallbackInterface = null;
                }
            }
            if (dSAMECallbackInterface == null && string != null && !string.equals("")) {
                object = Class.forName(string);
                dSAMECallbackInterface = (DSAMECallbackInterface)((Class)object).newInstance();
            }
            object = new HashMap();
            String string2 = null;
            String string3 = null;
            HashSet<String> hashSet = null;
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                NodeList nodeList2 = node2.getChildNodes();
                int n2 = 0;
                while (n2 < nodeList2.getLength()) {
                    Node node3 = nodeList2.item(n2);
                    String string4 = node3.getLocalName();
                    if (debug.messageEnabled()) {
                        debug.message("child node local name : " + string4);
                    }
                    if (string4.equals("Attribute")) {
                        string3 = XMLUtils.getNodeAttributeValue((Node)node3, (String)"name");
                    }
                    if (node3.getLocalName().equals("Value")) {
                        hashSet = new HashSet<String>();
                        string2 = XMLUtils.getValueOfValueNode((Node)node3);
                        hashSet.add(string2);
                    }
                    ++n2;
                }
                ((HashMap)object).put(string3, hashSet);
                ++n;
            }
            if (debug.messageEnabled()) {
                debug.message("MAP is : " + object);
            }
            dSAMECallbackInterface.setConfig((Map)object);
            return dSAMECallbackInterface;
        }
        catch (Exception exception) {
            debug.message("Error creating callback ", (Throwable)exception);
            return null;
        }
    }

    static String getCustomCallbackXML(DSAMECallbackInterface dSAMECallbackInterface) {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            String string = dSAMECallbackInterface.getClass().getName();
            if (debug.messageEnabled()) {
                debug.message("Custom Callback Class name : " + string);
            }
            stringBuffer.append("<CustomCallback").append(" ").append("className").append("=").append("\"").append(string).append("\"").append(">");
            Map map = dSAMECallbackInterface.getConfig();
            if (debug.messageEnabled()) {
                debug.message("map is : " + map);
            }
            Set set = map.keySet();
            Iterator iterator = set.iterator();
            if (debug.messageEnabled()) {
                debug.message("keyset is : " + set);
            }
            while (iterator.hasNext()) {
                stringBuffer.append("<AttributeValuePair>");
                String string2 = (String)iterator.next();
                if (debug.messageEnabled()) {
                    debug.message("KEY IS : " + string2);
                }
                stringBuffer.append("<Attribute").append(" ").append("name").append("=").append("\"").append(string2).append("\"").append(">").append("</Attribute>");
                Set set2 = (Set)map.get(string2);
                if (debug.messageEnabled()) {
                    debug.message("Value Set : " + set2);
                }
                Iterator iterator2 = set2.iterator();
                while (iterator2.hasNext()) {
                    String string3 = (String)iterator2.next();
                    stringBuffer.append("<Value>").append(string3).append("</Value>");
                }
                stringBuffer.append("</AttributeValuePair>");
            }
            stringBuffer.append("</CustomCallback>");
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            debug.message("Error creating customCallback :", (Throwable)exception);
            return null;
        }
    }

    public static String getSerializedSubject(Subject subject) {
        byte[] byArray = null;
        String string = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(subject);
            byArray = byteArrayOutputStream.toByteArray();
            string = (String)AccessController.doPrivileged(new EncodeAction(Base64.encode((byte[])byArray).trim()));
        }
        catch (Exception exception) {
            debug.message("Exception  : ", (Throwable)exception);
        }
        return string;
    }

    public static Subject getDeSerializedSubject(String string) throws Exception {
        String string2 = (String)AccessController.doPrivileged(new DecodeAction(string));
        byte[] byArray = Base64.decode((String)string2);
        if (byArray == null) {
            return null;
        }
        ObjectInputStream objectInputStream = null;
        Object object = null;
        try {
            byte[] byArray2 = byArray;
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
        }
        catch (Exception exception) {
            debug.message("Exception Message in decrypt: " + exception.getMessage());
        }
        if (object == null) {
            return null;
        }
        Subject subject = (Subject)object;
        if (debug.messageEnabled()) {
            debug.message("returning temp" + subject);
        }
        return subject;
    }

    static int getNameCallbackIndex(Callback[] callbackArray, int n) {
        int n2 = 0;
        n2 = n;
        while (n2 < callbackArray.length) {
            if (callbackArray[n2] instanceof NameCallback) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    static int getPasswordCallbackIndex(Callback[] callbackArray, int n) {
        int n2 = 0;
        n2 = n;
        while (n2 < callbackArray.length) {
            if (callbackArray[n2] instanceof PasswordCallback) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    static int getConfCallbackIndex(Callback[] callbackArray, int n) {
        int n2 = 0;
        n2 = n;
        while (n2 < callbackArray.length) {
            if (callbackArray[n2] instanceof ConfirmationCallback) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    static int getChoiceCallbackIndex(Callback[] callbackArray, int n) {
        int n2 = 0;
        n2 = n;
        while (n2 < callbackArray.length) {
            if (callbackArray[n2] instanceof ChoiceCallback) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    static int getTextInputIndex(Callback[] callbackArray, int n) {
        int n2 = 0;
        n2 = n;
        while (n2 < callbackArray.length) {
            if (callbackArray[n2] instanceof TextInputCallback) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    static int getTextOutputIndex(Callback[] callbackArray, int n) {
        int n2 = 0;
        n2 = n;
        while (n2 < callbackArray.length) {
            if (callbackArray[n2] instanceof TextOutputCallback) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    static int getPagePropertiesIndex(Callback[] callbackArray, int n) {
        int n2 = 0;
        n2 = n;
        while (n2 < callbackArray.length) {
            if (callbackArray[n2] instanceof PagePropertiesCallback) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    static int getCustomCallbackIndex(Callback[] callbackArray, int n) {
        int n2 = 0;
        n2 = n;
        while (n2 < callbackArray.length) {
            if (callbackArray[n2] instanceof DSAMECallbackInterface) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    static int getLanguageCallbackIndex(Callback[] callbackArray, int n) {
        int n2 = 0;
        n2 = n;
        while (n2 < callbackArray.length) {
            if (callbackArray[n2] instanceof LanguageCallback) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    static LanguageCallback createLanguageCallback(Node node, Callback callback) {
        LanguageCallback languageCallback = null;
        if (callback != null && callback instanceof LanguageCallback) {
            languageCallback = (LanguageCallback)callback;
        }
        if (languageCallback == null) {
            languageCallback = new LanguageCallback();
        }
        Node node2 = XMLUtils.getChildNode((Node)node, (String)"Locale");
        String string = XMLUtils.getNodeAttributeValue((Node)node2, (String)"language");
        String string2 = XMLUtils.getNodeAttributeValue((Node)node2, (String)"country");
        String string3 = XMLUtils.getNodeAttributeValue((Node)node2, (String)"variant");
        if (debug.messageEnabled()) {
            debug.message("Language is " + string);
            debug.message("Country is " + string2);
            debug.message("Variant is " + string3);
        }
        if (string != null && string2 != null) {
            Locale locale = null;
            locale = string3 != null ? new Locale(string, string2, string3) : new Locale(string, string2);
            languageCallback.setLocale(locale);
        }
        return languageCallback;
    }

    static String getLanguageCallbackXML(LanguageCallback languageCallback) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<LanguageCallback>").append("<Locale");
        Locale locale = languageCallback.getLocale();
        if (locale != null) {
            String string;
            String string2;
            String string3 = locale.getLanguage();
            if (string3 != null && !string3.equals("")) {
                stringBuffer.append(" ").append("language").append("=").append("\"").append(string3).append("\"");
            }
            if ((string2 = locale.getCountry()) != null && !string2.equals("")) {
                stringBuffer.append(" ").append("country").append("=").append("\"").append(string2).append("\"");
            }
            if ((string = locale.getVariant()) != null && !string.equals("")) {
                stringBuffer.append(" ").append("variant").append("=").append("\"").append(string).append("\"");
            }
        }
        stringBuffer.append(">");
        stringBuffer.append("</Locale>");
        stringBuffer.append("</LanguageCallback>");
        if (debug.messageEnabled()) {
            debug.message("LANGUAGE CALLBACK xmlString : " + stringBuffer.toString());
        }
        return stringBuffer.toString();
    }

    private static String getDefaultValue(Node node) {
        Node node2 = XMLUtils.getChildNode((Node)node, (String)"DefaultValue");
        String string = null;
        if (node2 != null) {
            string = AuthXMLUtils.getValue(node2);
        }
        return string;
    }
}

