/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.iplanet.am.util.Debug;
import com.sun.identity.authentication.service.AMLoginContext;
import com.sun.identity.authentication.service.AuthThreadManager;
import com.sun.identity.authentication.service.LoginState;
import com.sun.identity.authentication.service.LoginStateCallback;
import com.sun.identity.authentication.service.PagePropertiesCallback;
import com.sun.identity.authentication.spi.LoginTimeOutException;
import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;

public class DSAMECallbackHandler
implements CallbackHandler {
    static Debug debug;
    AMLoginContext am;
    Callback[] getRequiredInfo = null;
    LoginState loginState;
    Callback[] submitRequiredInfo = null;
    static AuthThreadManager authThreadManager;
    String sid = null;

    public DSAMECallbackHandler() {
    }

    public DSAMECallbackHandler(AMLoginContext aMLoginContext) {
        debug = Debug.getInstance((String)"amCallback");
        if (debug.messageEnabled()) {
            debug.message("DSAMECallback. ThreadName is.. :" + Thread.currentThread().getName());
        }
        this.am = aMLoginContext;
        authThreadManager = AMLoginContext.authThread;
        this.loginState = aMLoginContext.getLoginState();
        if (debug.messageEnabled()) {
            debug.message("done... DSAMAE callbackhandler...");
        }
    }

    public void handle(Callback[] callbackArray) throws IOException, UnsupportedCallbackException {
        if (debug == null) {
            debug = Debug.getInstance((String)"amCallback");
        }
        if (debug.messageEnabled()) {
            debug.message("callback handler method");
            debug.message("ThreadName is.. :" + Thread.currentThread().getName());
        }
        long l = 60L;
        long l2 = System.currentTimeMillis();
        if (callbackArray != null) {
            l = this.getTimeOut(callbackArray[0]);
        }
        this.loginState.setLastCallbackSent(l2);
        this.loginState.setPageTimeOut(l);
        if (callbackArray.length == 1 && callbackArray[0] instanceof LoginStateCallback) {
            debug.message("LoginState Callbacks");
            ((LoginStateCallback)callbackArray[0]).setLoginState(this.loginState);
        } else {
            this.loginState.setSubmittedCallback(null, this.am);
            this.loginState.setReceivedCallback(callbackArray, this.am);
            Thread thread = Thread.currentThread();
            if (debug.messageEnabled()) {
                debug.message("waiting for submitted info " + thread);
            }
            callbackArray = this.am.submitCallbackInfo();
            if (authThreadManager.isTimedOut(thread)) {
                this.loginState.setTimedOut(true);
                this.loginState.setReceivedCallback(null, this.am);
                authThreadManager.removeFromHash(thread, "timedOutHash");
                throw new IOException("110");
            }
            try {
                this.checkLoginTimeout(l2, l);
            }
            catch (LoginTimeOutException loginTimeOutException) {
                debug.error(" Page Timeout ", (Throwable)loginTimeOutException);
                this.loginState.setTimedOut(true);
                this.loginState.setReceivedCallback(null, this.am);
                throw new IOException("110");
            }
            if (debug.messageEnabled()) {
                debug.message("DSAMECAllbackhandler..." + callbackArray);
            }
            this.loginState.setReceivedCallback(null, this.am);
        }
    }

    long getTimeOut(Callback callback) {
        long l = 60L;
        if (callback == null) {
            return l;
        }
        if (callback instanceof PagePropertiesCallback) {
            PagePropertiesCallback pagePropertiesCallback = (PagePropertiesCallback)callback;
            l = new Integer(pagePropertiesCallback.getTimeOutValue()).longValue();
        } else {
            l = 60L;
        }
        return l;
    }

    void checkLoginTimeout(long l, long l2) throws LoginTimeOutException {
        long l3 = System.currentTimeMillis();
        if (l + (l2 - 3L) * 1000L < l3) {
            throw new LoginTimeOutException("amAuth", "loginTimeout", null);
        }
    }
}

