/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.service;

import com.iplanet.am.util.AMClientDetector;
import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Locale;
import com.iplanet.am.util.Misc;
import com.sun.identity.authentication.service.AuthD;
import com.sun.identity.sm.ServiceListener;
import com.sun.identity.sm.ServiceSchema;
import com.sun.identity.sm.ServiceSchemaManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;

public class AuthenticatorManager
implements ServiceListener {
    private Hashtable authMethods = new Hashtable();
    private Hashtable sAuth = new Hashtable();
    private String adminAuthModule;
    private String detectionEnabled = "false";
    private String clientDetectionClass;
    private AMClientDetector clientDetector;
    private Set defaultSuccessURLSet = Collections.EMPTY_SET;
    private Set defaultFailureURLSet = Collections.EMPTY_SET;
    private long defaultSleepTime = 300L;
    ResourceBundle bundle;
    private String locale;
    Map authMap = new HashMap();
    ServiceSchemaManager schemaManager = null;
    static Debug debug;
    private Map authModuleFactoryMap = Collections.synchronizedMap(new HashMap());

    protected AuthenticatorManager(Map map, ServiceSchemaManager serviceSchemaManager) throws Exception {
        this.schemaManager = serviceSchemaManager;
        this.authMap = map;
        this.update(map);
        this.updateClientData(map);
        debug = Debug.getInstance((String)"amAuth");
        this.addServiceListener("iPlanetAMAuthService");
    }

    public boolean containsAuthenticator(String string) {
        return this.authMethods.containsKey(string);
    }

    public Iterator getAuthenticators() {
        Hashtable hashtable;
        Hashtable hashtable2 = this.authMethods;
        synchronized (hashtable2) {
            hashtable = (Hashtable)this.authMethods.clone();
        }
        return hashtable.keySet().iterator();
    }

    public int getAuthenticatorCount() {
        return this.authMethods.size();
    }

    public String getAdminAuthModule() {
        return this.adminAuthModule;
    }

    private synchronized void update(Map map) {
        try {
            Object object;
            this.adminAuthModule = Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-admin-auth-module");
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            Set set = (Set)map.get("iplanet-am-auth-authenticators");
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                object = (String)iterator.next();
                int n = ((String)object).lastIndexOf(46);
                if (n > -1) {
                    String string = ((String)object).substring(n + 1, ((String)object).length());
                    hashtable.put(string, (String)object);
                    continue;
                }
                hashtable.put((String)object, (String)object);
            }
            this.authMethods = hashtable;
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("AM.update authMethods = " + this.authMethods.toString());
            }
            this.defaultSuccessURLSet = (Set)map.get("iplanet-am-auth-login-success-url");
            this.defaultFailureURLSet = (Set)map.get("iplanet-am-auth-failure-success-url");
            object = new Integer(Misc.getMapAttr((Map)map, (String)"iplanet-am-auth-sleep-interval"));
            this.defaultSleepTime = ((Integer)object).longValue();
        }
        catch (Exception exception) {
            AuthD.debug.error("Error in getting iwtAuth attributes ", (Throwable)exception);
        }
    }

    private synchronized void updateClientData(Map map) throws Exception {
        try {
            this.clientDetector = new AMClientDetector();
            this.bundle = Locale.getResourceBundle((String)"amAuth", (String)this.locale);
            if (!AMClientDetector.isServicePassed()) {
                throw new Exception(this.bundle.getString("ServiceDoesNotExist"));
            }
            this.detectionEnabled = this.clientDetector.detectionEnabled();
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("updateClientData : detection = " + this.detectionEnabled);
            }
            if (this.detectionEnabled.equalsIgnoreCase("true")) {
                this.setClientData(map);
            }
        }
        catch (Exception exception) {
            AuthD.debug.message("Error in getting amAuth attributes ", (Throwable)exception);
            throw new Exception(exception.getMessage());
        }
    }

    private synchronized void setClientData(Map map) {
        try {
            Set set = (Set)map.get("iplanet-am-auth-supported-auth-modules");
            if (set != null) {
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    if (string == null || string.length() <= 0) continue;
                    this.cacheAM(string);
                }
            }
            if (AuthD.debug.messageEnabled()) {
                AuthD.debug.message("setClientData :\nsupportedModules=" + this.sAuth.toString());
            }
        }
        catch (Exception exception) {
            AuthD.debug.warning("AuthD : error getting client data", (Throwable)exception);
        }
    }

    void cacheAM(String string) {
        this.extractAttributeData(string, this.sAuth, true);
    }

    synchronized void extractAttributeData(String string, Hashtable hashtable, boolean bl) {
        int n = string.indexOf("|");
        if (n != -1) {
            String string2 = string.substring(0, n);
            String string3 = string.substring(n + 1, string.length());
            if (bl) {
                HashSet<String> hashSet = new HashSet<String>();
                StringTokenizer stringTokenizer = new StringTokenizer(string3, ",");
                while (stringTokenizer.hasMoreTokens()) {
                    hashSet.add(stringTokenizer.nextToken());
                }
                hashtable.put(string2, hashSet);
            } else {
                hashtable.put(string2, string3);
            }
        }
        if (AuthD.debug.messageEnabled()) {
            AuthD.debug.message("extractAttributeData : attrValue=" + string + "\nsupportedAuth=" + bl + "\nhashTable=" + hashtable.toString());
        }
    }

    public Hashtable getSupportedAuthenticators() {
        Hashtable hashtable = this.sAuth;
        synchronized (hashtable) {
            Hashtable hashtable2 = (Hashtable)this.sAuth.clone();
            return hashtable2;
        }
    }

    public int getSupportedAuthenticatorCount() {
        return this.sAuth.size();
    }

    public boolean isDetectionEnabled() {
        return this.detectionEnabled.equalsIgnoreCase("true");
    }

    public AMClientDetector getClientDetectionInterface() {
        return this.clientDetector;
    }

    public String getAuthenticatorClassName(String string) {
        return (String)this.authMethods.get(string);
    }

    public void schemaChanged(String string, String string2) {
        debug.message("Global config changed");
        try {
            ServiceSchema serviceSchema = this.schemaManager.getGlobalSchema();
            Map map = serviceSchema.getAttributeDefaults();
            this.authMap.putAll(map);
            this.update(this.authMap);
            if (debug.messageEnabled()) {
                debug.message("schemaChange attrs : " + this.authMap);
            }
            this.updateClientData(this.authMap);
        }
        catch (Exception exception) {
            debug.error("Error schemaChanged : ", (Throwable)exception);
        }
    }

    public void globalConfigChanged(String string, String string2, String string3, String string4, int n) {
    }

    public void organizationConfigChanged(String string, String string2, String string3, String string4, String string5, int n) {
    }

    void addServiceListener(String string) {
        debug.message("Adding service listener");
        try {
            this.schemaManager.addListener(this);
        }
        catch (Exception exception) {
            debug.message("addServiceListener error : ", (Throwable)exception);
        }
    }

    public Set getDefaultSuccessURLSet() {
        return this.defaultSuccessURLSet;
    }

    public Set getDefaultFailureURLSet() {
        return this.defaultFailureURLSet;
    }

    public long getDefaultSleepTime() {
        return this.defaultSleepTime * 1000L;
    }
}

