/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.server;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.dpro.session.SessionID;
import com.iplanet.services.comm.server.RequestHandler;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.comm.share.ResponseSet;
import com.sun.identity.authentication.AuthContext;
import com.sun.identity.authentication.server.AuthContextLocal;
import com.sun.identity.authentication.server.AuthXMLRequest;
import com.sun.identity.authentication.server.AuthXMLResponse;
import com.sun.identity.authentication.service.AuthException;
import com.sun.identity.authentication.service.AuthUtils;
import com.sun.identity.authentication.service.LoginState;
import com.sun.identity.authentication.service.X509CertificateCallback;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.common.ISLocaleContext;
import com.sun.identity.common.L10NMessage;
import java.security.cert.X509Certificate;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.ChoiceCallback;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AuthXMLHandler
implements RequestHandler {
    public static boolean localFlag = false;
    private String localAuthServerProtocol = SystemProperties.get((String)"com.iplanet.am.server.protocol");
    private String localAuthServer = SystemProperties.get((String)"com.iplanet.am.server.host");
    private String localAuthServerPort = SystemProperties.get((String)"com.iplanet.am.server.port");
    public static String localAuthServiceID;
    static Debug debug;
    private Locale locale = null;

    public AuthXMLHandler() {
        localAuthServiceID = this.localAuthServerProtocol + "://" + this.localAuthServer + ":" + this.localAuthServerPort;
        this.locale = new ISLocaleContext().getLocale();
    }

    public ResponseSet process(Vector vector, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ResponseSet responseSet = new ResponseSet("auth");
        int n = 0;
        while (n < vector.size()) {
            Request request = (Request)vector.elementAt(n);
            Response response = this.processRequest(request, httpServletRequest, httpServletResponse);
            responseSet.addResponse(response);
            ++n;
        }
        return responseSet;
    }

    private Response processRequest(Request request, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        httpServletRequest.getSession(true);
        String string = request.getContent();
        AuthXMLResponse authXMLResponse = null;
        try {
            AuthXMLRequest authXMLRequest = AuthXMLRequest.parseXML(string);
            authXMLRequest.setHttpServletRequest(httpServletRequest);
            authXMLResponse = this.processAuthXMLRequest(authXMLRequest, httpServletRequest, httpServletResponse);
        }
        catch (AuthException authException) {
            authXMLResponse = new AuthXMLResponse(0);
            authXMLResponse.setErrorCode(authException.getErrorCode());
        }
        return new Response(authXMLResponse.toXMLString());
    }

    private AuthXMLResponse processAuthXMLRequest(AuthXMLRequest authXMLRequest, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String string;
        String[] stringArray;
        Object[] objectArray;
        Object object;
        Object object2;
        if (debug.messageEnabled()) {
            debug.message("authXMLRequest is : " + authXMLRequest);
        }
        int n = authXMLRequest.getRequestType();
        String string2 = authXMLRequest.getAuthIdentifier();
        String string3 = authXMLRequest.getOrgName();
        String string4 = authXMLRequest.getPrevAuthIdentifier();
        AuthContextLocal authContextLocal = authXMLRequest.getAuthContext();
        AuthXMLResponse authXMLResponse = new AuthXMLResponse(n);
        AuthUtils authUtils = new AuthUtils();
        authXMLResponse.setAuthContext(authContextLocal);
        authXMLResponse.setAuthIdentifier(string2);
        authXMLResponse.setPrevAuthIdentifier(string4);
        if (debug.messageEnabled()) {
            debug.message("authContext is : " + authContextLocal);
            debug.message("requestType : " + n);
        }
        if (authUtils.getIndexType(authContextLocal) == AuthContext.IndexType.LEVEL) {
            object2 = authXMLRequest.getSubmittedCallbacks();
            if (debug.messageEnabled()) {
                debug.message("Callbacks are  : " + object2);
            }
            if (object2 != null) {
                if (debug.messageEnabled()) {
                    debug.message("Callback length is : " + ((Callback[])object2).length);
                }
                if (object2[0] instanceof ChoiceCallback) {
                    object = (ChoiceCallback)object2[0];
                    objectArray = ((ChoiceCallback)object).getSelectedIndexes();
                    Object object3 = objectArray[0];
                    stringArray = ((ChoiceCallback)object).getChoices();
                    string = stringArray[object3];
                    if (debug.messageEnabled()) {
                        debug.message("Selected Index is : " + string);
                    }
                    authXMLRequest.setIndexType("moduleInstance");
                    authXMLRequest.setIndexName(string);
                    authXMLRequest.setRequestType(6);
                    n = 6;
                }
            }
        }
        object2 = AuthContext.Status.IN_PROGRESS;
        switch (n) {
            case 0: {
                try {
                    if (authContextLocal == null) {
                        throw new AuthException("108", null);
                    }
                    object = httpServletRequest.getAttribute("javax.servlet.request.X509Certificate");
                    objectArray = (X509Certificate[])object;
                    LoginState loginState = AuthUtils.getLoginState(authContextLocal);
                    stringArray = loginState.getPrevAuthContext();
                    authXMLResponse.setPrevAuthContext((AuthContextLocal)stringArray);
                    if (objectArray != null && objectArray.length != 0) {
                        if (debug.messageEnabled()) {
                            debug.message("length of cert array : " + objectArray.length);
                        }
                        loginState.setX509Certificate((X509Certificate)objectArray[0]);
                    }
                    string = null;
                    if (httpServletRequest != null) {
                        string = httpServletRequest.getRemoteAddr();
                        loginState.setClient(string);
                    }
                    SessionID sessionID = loginState.getSession().getID();
                    String string5 = null;
                    if (sessionID != null) {
                        string5 = sessionID.toString();
                    }
                    if (debug.messageEnabled()) {
                        debug.message("sidString is.. : " + string5);
                    }
                    authXMLResponse.setAuthIdentifier(string5);
                    authXMLResponse.setLoginStatus(AuthContext.Status.IN_PROGRESS);
                    authUtils.setlbCookie(authContextLocal, httpServletResponse);
                    this.checkACException(authXMLResponse, authContextLocal);
                }
                catch (Exception exception) {
                    debug.error("Error creating AuthContext ");
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)exception);
                    }
                    this.setErrorCode(authXMLResponse, exception);
                }
                break;
            }
            case 1: {
                try {
                    authContextLocal.login();
                    this.getRequirements(authContextLocal, authXMLResponse);
                    this.checkACException(authXMLResponse, authContextLocal);
                }
                catch (AuthLoginException authLoginException) {
                    debug.error("Error during login ");
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)authLoginException);
                    }
                    this.setErrorCode(authXMLResponse, authLoginException);
                }
                break;
            }
            case 6: {
                try {
                    object = authXMLRequest.getIndexType();
                    objectArray = authXMLRequest.getIndexName();
                    if (debug.messageEnabled()) {
                        debug.message("indexName is : " + (String)objectArray);
                        debug.message("indexType is : " + object);
                    }
                    authContextLocal.login((AuthContext.IndexType)object, (String)objectArray);
                    this.getRequirements(authContextLocal, authXMLResponse);
                    this.checkACException(authXMLResponse, authContextLocal);
                }
                catch (AuthLoginException authLoginException) {
                    debug.error("Login Exception ");
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)authLoginException);
                    }
                    this.setErrorCode(authXMLResponse, authLoginException);
                }
                break;
            }
            case 8: {
                try {
                    object = authXMLRequest.getSubject();
                    authContextLocal.login((Subject)object);
                    this.getRequirements(authContextLocal, authXMLResponse);
                    this.checkACException(authXMLResponse, authContextLocal);
                }
                catch (AuthLoginException authLoginException) {
                    debug.error("Login Exception ");
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)authLoginException);
                    }
                    this.setErrorCode(authXMLResponse, authLoginException);
                }
                break;
            }
            case 2: {
                try {
                    object = authXMLRequest.getSubmittedCallbacks();
                    authContextLocal.submitRequirements((Callback[])object);
                    objectArray = null;
                    if (authContextLocal.hasMoreRequirements()) {
                        objectArray = authContextLocal.getRequirements();
                    }
                    authXMLResponse.setReqdCallbacks((Callback[])objectArray);
                    object2 = authContextLocal.getStatus();
                    authXMLResponse.setLoginStatus((AuthContext.Status)object2);
                    this.checkACException(authXMLResponse, authContextLocal);
                }
                catch (Exception exception) {
                    debug.error("Error during login ");
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)exception);
                    }
                    this.setErrorCode(authXMLResponse, exception);
                }
                break;
            }
            case 3: {
                try {
                    object = authContextLocal.getModuleInstanceNames();
                    authXMLResponse.setModuleNames((Set)object);
                    authXMLResponse.setAuthContext(authContextLocal);
                    this.checkACException(authXMLResponse, authContextLocal);
                }
                catch (Exception exception) {
                    debug.error("Error aborting ");
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)exception);
                    }
                    this.setErrorCode(authXMLResponse, exception);
                }
                break;
            }
            case 4: {
                try {
                    authContextLocal.logout();
                    object2 = authContextLocal.getStatus();
                    authXMLResponse.setLoginStatus((AuthContext.Status)object2);
                    this.checkACException(authXMLResponse, authContextLocal);
                }
                catch (AuthLoginException authLoginException) {
                    debug.error("Error logging out");
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)authLoginException);
                    }
                    this.setErrorCode(authXMLResponse, authLoginException);
                }
                break;
            }
            case 5: {
                try {
                    authContextLocal.abort();
                    object2 = authContextLocal.getStatus();
                    authXMLResponse.setLoginStatus((AuthContext.Status)object2);
                    this.checkACException(authXMLResponse, authContextLocal);
                    break;
                }
                catch (AuthLoginException authLoginException) {
                    debug.error("Error aborting ");
                    if (debug.messageEnabled()) {
                        debug.message("Exception ", (Throwable)authLoginException);
                    }
                    this.setErrorCode(authXMLResponse, authLoginException);
                }
            }
        }
        if (object2 == AuthContext.Status.FAILED) {
            authXMLResponse.setErrorCode(authContextLocal.getErrorCode());
        }
        if (debug.messageEnabled()) {
            debug.message("loginStatus: " + object2);
            debug.message("error Code: " + authContextLocal.getErrorCode());
            debug.message("error Template: " + authContextLocal.getErrorTemplate());
        }
        return authXMLResponse;
    }

    void getRequirements(AuthContextLocal authContextLocal, AuthXMLResponse authXMLResponse) {
        Callback[] callbackArray = null;
        boolean bl = false;
        if (authContextLocal.hasMoreRequirements()) {
            Object object;
            callbackArray = authContextLocal.getRequirements();
            int n = 0;
            while (n < callbackArray.length) {
                if (callbackArray[n] instanceof X509CertificateCallback) {
                    bl = true;
                    object = (X509CertificateCallback)callbackArray[n];
                    LoginState loginState = AuthUtils.getLoginState(authContextLocal);
                    if (loginState != null) {
                        X509Certificate x509Certificate = loginState.getX509Certificate();
                        ((X509CertificateCallback)object).setCertificate(x509Certificate);
                    }
                    if (callbackArray.length == 1) {
                        authContextLocal.submitRequirements(callbackArray);
                    }
                }
                ++n;
            }
            if (bl && callbackArray.length == 1) {
                authContextLocal.submitRequirements(callbackArray);
                if (authContextLocal.hasMoreRequirements()) {
                    callbackArray = authContextLocal.getRequirements();
                    authXMLResponse.setReqdCallbacks(callbackArray);
                } else {
                    object = authContextLocal.getStatus();
                    if (debug.messageEnabled()) {
                        debug.message("Status: " + object);
                    }
                    authXMLResponse.setLoginStatus((AuthContext.Status)object);
                }
            } else {
                authXMLResponse.setReqdCallbacks(callbackArray);
            }
        } else {
            AuthContext.Status status = authContextLocal.getStatus();
            if (debug.messageEnabled()) {
                debug.message(" Status: " + status);
            }
            authXMLResponse.setLoginStatus(status);
        }
    }

    private void checkACException(AuthXMLResponse authXMLResponse, AuthContextLocal authContextLocal) {
        AuthLoginException authLoginException = authContextLocal.getLoginException();
        if (authLoginException == null) {
            return;
        }
        authXMLResponse.setErrorMessage(authLoginException.getL10NMessage(this.locale));
        authXMLResponse.setIsException(true);
    }

    private void setErrorCode(AuthXMLResponse authXMLResponse, Exception exception) {
        if (exception == null) {
            return;
        }
        if (exception instanceof L10NMessage) {
            authXMLResponse.setErrorCode(this.getAuthErrorCode((L10NMessage)exception));
        } else {
            authXMLResponse.setErrorCode(exception.getMessage());
        }
        authXMLResponse.setIsException(true);
    }

    private String getAuthErrorCode(L10NMessage l10NMessage) {
        String string = l10NMessage.getErrorCode();
        if (string == null) {
            string = l10NMessage.getMessage();
        }
        return string;
    }

    static {
        debug = Debug.getInstance((String)"amXMLHandler");
    }
}

