/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.server;

import com.iplanet.am.util.Debug;
import com.iplanet.services.comm.client.PLLClient;
import com.iplanet.services.comm.server.RequestHandler;
import com.iplanet.services.comm.share.Request;
import com.iplanet.services.comm.share.RequestSet;
import com.iplanet.services.comm.share.Response;
import com.iplanet.services.comm.share.ResponseSet;
import com.iplanet.services.naming.WebtopNaming;
import com.sun.identity.authentication.service.AMAccountLockout;
import java.net.URL;
import java.util.Enumeration;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class AccountLockoutService
implements RequestHandler {
    static Debug debug = Debug.getInstance((String)"amAccountLockout");
    private static final String ACCOUNT_LOCKOUT_SERVICE_NAME = "iplanet-am-naming-auth-alo-class";
    private static final String BEGIN = "<AccountLockoutService><InvalidPassword>";
    private static final String SSOT_BEGIN = "<ServerSSOToken>";
    private static final String SSOT_END = "</ServerSSOToken>";
    private static final String USERDN_BEGIN = "<UserDN>";
    private static final String USERDN_END = "</UserDN>";
    private static final String LOCKOUT_TIME_BEGIN = "<LockoutTime>";
    private static final String LOCKOUT_TIME_END = "</LockoutTime>";
    private static final String LOCKOUT_COUNT_BEGIN = "<LockoutCount>";
    private static final String LOCKOUT_COUNT_END = "</LockoutCount>";
    private static final String LOCKOUT_DURATION_BEGIN = "<LockoutDuration>";
    private static final String LOCKOUT_DURATION_END = "</LockoutDuration>";
    private static final String MEMORY_LOCKING_BEGIN = "<MemoryLocking>";
    private static final String MEMORY_LOCKING_END = "</MemoryLocking>";
    private static final String STATUS_BEGIN = "<Status>";
    private static final String STATUS_END = "</Status>";
    private static final String END = "</InvalidPassword></AccountLockoutService>";

    public AccountLockoutService() {
        if (debug.messageEnabled()) {
            debug.message("AccountLocoutService::constructor called");
        }
    }

    public ResponseSet process(Vector vector, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        ResponseSet responseSet = new ResponseSet(ACCOUNT_LOCKOUT_SERVICE_NAME);
        int n = 0;
        while (n < vector.size()) {
            Request request = (Request)vector.elementAt(n);
            String string = request.getContent();
            if (debug.messageEnabled()) {
                debug.message("ALC:process received: " + string);
            }
            String string2 = AccountLockoutService.getElement(string, USERDN_BEGIN, USERDN_END);
            String string3 = AccountLockoutService.getElement(string, LOCKOUT_TIME_BEGIN, LOCKOUT_TIME_END);
            String string4 = AccountLockoutService.getElement(string, LOCKOUT_COUNT_BEGIN, LOCKOUT_COUNT_END);
            String string5 = AccountLockoutService.getElement(string, LOCKOUT_DURATION_BEGIN, LOCKOUT_DURATION_END);
            String string6 = AccountLockoutService.getElement(string, MEMORY_LOCKING_BEGIN, MEMORY_LOCKING_END);
            if (debug.messageEnabled()) {
                debug.message("ALC:user DN: " + string2);
            }
            String string7 = "OK";
            try {
                long l = Long.parseLong(string3);
                int n2 = Integer.parseInt(string4);
                long l2 = Long.parseLong(string5);
                boolean bl = true;
                if (string6.equalsIgnoreCase("false")) {
                    bl = false;
                }
                if (debug.messageEnabled()) {
                    debug.message("ALC:process calling AMAccountLockout");
                }
                AMAccountLockout.updateInvalidPasswordCount(string2, l, n2, l2, bl);
            }
            catch (NumberFormatException numberFormatException) {
                string7 = "FAILED";
            }
            StringBuffer stringBuffer = new StringBuffer(100);
            stringBuffer.append(BEGIN).append(USERDN_BEGIN).append(string2).append(USERDN_END).append(STATUS_BEGIN).append(string7).append(STATUS_END).append(END);
            if (debug.messageEnabled()) {
                debug.message("AccountLockoutService:invalidPassword response: " + stringBuffer.toString());
            }
            Response response = new Response(stringBuffer.toString());
            responseSet.addResponse(response);
            ++n;
        }
        return responseSet;
    }

    public static void sendInvalidPasswordNotification(String string, long l, int n, long l2, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer(100);
        stringBuffer.append(BEGIN).append(SSOT_BEGIN).append(SSOT_END).append(USERDN_BEGIN).append(string).append(USERDN_END).append(LOCKOUT_TIME_BEGIN).append(l).append(LOCKOUT_TIME_END).append(LOCKOUT_COUNT_BEGIN).append(n).append(LOCKOUT_COUNT_END).append(LOCKOUT_DURATION_BEGIN).append(l2).append(LOCKOUT_DURATION_END).append(MEMORY_LOCKING_BEGIN).append(bl).append(MEMORY_LOCKING_END).append(END);
        if (debug.messageEnabled()) {
            debug.message("AccountLockoutService:sendInvalidPasswdNoti: Message: " + stringBuffer.toString());
        }
        Request request = new Request(stringBuffer.toString());
        RequestSet requestSet = new RequestSet(ACCOUNT_LOCKOUT_SERVICE_NAME);
        requestSet.addRequest(request);
        try {
            Vector vector = WebtopNaming.getServiceAllURLs((String)"auth");
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                URL uRL = (URL)enumeration.nextElement();
                if (debug.messageEnabled()) {
                    debug.message("AccountLockoutService:sendInvalidNot: URL: " + uRL);
                }
                try {
                    PLLClient.send((URL)uRL, (RequestSet)requestSet, null);
                }
                catch (Exception exception) {
                    debug.error("AccountLockoutService: NotificationError: Unabled to send to: " + uRL, (Throwable)exception);
                }
            }
        }
        catch (Exception exception) {
            debug.error("AccountLockoutService: DID NOT SEND NOTIFICATIONS", (Throwable)exception);
        }
    }

    private static String getElement(String string, String string2, String string3) {
        String string4 = null;
        if (string != null) {
            int n = string.indexOf(string2);
            int n2 = string.indexOf(string3);
            if (n != -1 && n2 != -1 && n + string2.length() < n2) {
                string4 = string.substring(n + string2.length(), n2);
            }
        }
        return string4;
    }
}

