/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.securid;

import com.iplanet.am.util.Debug;
import com.sun.identity.authentication.spi.AuthenticationException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ResourceBundle;

public class SecurIDHelper {
    protected static final int DAEMON_TIMEOUT_mS = 7500;
    private final int MAXLOOP = 200;
    private Socket sock = null;
    private BufferedReader reader = null;
    private PrintWriter writer = null;
    private String replaceText;
    private String helperText;
    private static final String charSet = "ISO8859_1";

    public SecurIDHelper(int n, String string) throws AuthenticationException {
        try {
            this.sock = new Socket("127.0.0.1", n);
            this.sock.setSoTimeout(7500);
            this.reader = new BufferedReader(new InputStreamReader(this.sock.getInputStream(), charSet));
            this.writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.sock.getOutputStream(), charSet)));
        }
        catch (UnknownHostException unknownHostException) {
            throw new AuthenticationException(string, "SecurIDHelperLocalhost", null);
        }
        catch (IOException iOException) {
            throw new AuthenticationException(string, "SecurIDHelperIOEx", null);
        }
    }

    protected synchronized int do_write(String string) {
        this.writer.println(string);
        this.writer.flush();
        return string.length();
    }

    public String do_read(int n, ResourceBundle resourceBundle) throws IOException {
        char[] cArray = new char[254];
        int n2 = this.reader.read(cArray, 0, n);
        String string = new String(cArray);
        try {
            if (!string.equals(new String(string.getBytes("ASCII"), "ASCII"))) {
                throw new IOException(resourceBundle.getString("SecurIDHelperInputNotASCII"));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IOException(resourceBundle.getString("SecurIDHelperInputEncodingException"));
        }
        return string;
    }

    public int configHelper(String string, String string2, String string3, String string4, Debug debug, ResourceBundle resourceBundle) {
        String string5;
        boolean bl = false;
        if (debug.messageEnabled()) {
            debug.message("configHelper: port=" + string + ", timeout=" + string2 + ", threads=" + string3);
        }
        try {
            string5 = this.do_read(254, resourceBundle);
        }
        catch (IOException iOException) {
            return -1;
        }
        if (debug.messageEnabled()) {
            debug.message("config rcvd(1): " + string5);
        }
        if (!string5.startsWith("Enter SecurID Helper Listen Port")) {
            return -2;
        }
        int n = this.do_write(string);
        try {
            string5 = this.do_read(254, resourceBundle);
        }
        catch (IOException iOException) {
            return -3;
        }
        if (debug.messageEnabled()) {
            debug.message("config rcvd(2): " + string5);
        }
        if (!string5.startsWith("Enter SecurID Helper Session Timeout")) {
            return -4;
        }
        n = this.do_write(string2);
        try {
            string5 = this.do_read(254, resourceBundle);
        }
        catch (IOException iOException) {
            return -5;
        }
        if (debug.messageEnabled()) {
            debug.message("config rcvd(3): " + string5);
        }
        if (!string5.startsWith("Enter SecurID Helper Max Sessions")) {
            return -6;
        }
        n = this.do_write(string3);
        try {
            string5 = this.do_read(254, resourceBundle);
        }
        catch (IOException iOException) {
            return -7;
        }
        if (debug.messageEnabled()) {
            debug.message("config rcvd(4): " + string5);
        }
        if (!string5.startsWith("Enter Config Path for Server")) {
            return -8;
        }
        n = this.do_write(string4);
        try {
            string5 = this.do_read(254, resourceBundle);
        }
        catch (IOException iOException) {
            return -17;
        }
        if (debug.messageEnabled()) {
            debug.message("config rcvd(5): " + string5);
        }
        if (debug.messageEnabled()) {
            debug.message("SecurID:config:done:instring=" + string5);
        }
        if (!string5.startsWith("get_config_info: amsecuridd configured successfully")) {
            return -18;
        }
        return 0;
    }

    public int authenticate(String string, String string2, String string3, Debug debug, ResourceBundle resourceBundle) {
        int n = 200;
        int n2 = 1000;
        do {
            int n3;
            String string4 = null;
            try {
                string4 = this.do_read(254, resourceBundle);
            }
            catch (IOException iOException) {
                return -1;
            }
            if (string4 == null || string4.equals("")) {
                return -2;
            }
            if (debug.messageEnabled()) {
                debug.message("SecurIDHelper:authenticate:instring=" + string4);
            }
            this.helperText = string4;
            if (string4.startsWith("Enter SecurID login:")) {
                n3 = this.do_write(string2);
                if (debug.messageEnabled()) {
                    debug.message("SecurID:authenticate:replied with: '" + string2 + "'");
                }
                n2 = 1000;
            } else if (string4.startsWith("Enter passcode:")) {
                n3 = this.do_write(string3);
                if (debug.messageEnabled()) {
                    debug.message("SecurID:authenticate:replied with passcode of " + string3.length() + " characters");
                }
                n2 = 1000;
            } else if (string4.startsWith("Authentication passed")) {
                n2 = 0;
            } else if (string4.startsWith("Access denied")) {
                n2 = -1;
            } else if (string4.startsWith("Ready to have the system generate your new PIN? (y/n):")) {
                n3 = this.do_write("y");
                if (debug.messageEnabled()) {
                    debug.message("SecurID:authenticate:replied with: 'y'");
                }
                n2 = 1000;
            } else if (string4.startsWith("New system PIN:")) {
                this.replaceText = "Wait for the your token to change, then enter with the new PIN. " + string4;
                if (debug.messageEnabled()) {
                    debug.message("SecurID:authenticate:replaceText = '" + this.replaceText + "'");
                }
                n2 = 5;
            } else if (string4.startsWith("System generated PIN? (y/n):")) {
                this.replaceText = string4;
                if (debug.messageEnabled()) {
                    debug.message("SecurID:authenticate:replaceText = '" + this.replaceText + "'");
                }
                n2 = 4;
            } else if (string4.startsWith("Enter new PIN, containing")) {
                this.replaceText = string4;
                if (debug.messageEnabled()) {
                    debug.message("SecurIDHelper:authenticate:replaceText = '" + this.replaceText + "'");
                }
                n2 = 2;
            } else if (string4.startsWith("Enter next PASSCODE:")) {
                n2 = 3;
            } else if (string4.startsWith("authentication failed")) {
                n2 = -1;
            } else if (string4.startsWith("unknown return code ")) {
                n2 = -1;
            } else if (string4.startsWith("Processing timed-")) {
                n2 = -1;
            } else if (string4.startsWith("Processing erro")) {
                n2 = -1;
            } else if (string4.startsWith("Wait for the code on your token to change, then connect again with the new PIN")) {
                n2 = 5;
            }
            if (--n != 0) continue;
            n2 = -1;
        } while (n2 == 1000);
        return n2;
    }

    public int nextTokenMode(String string, Debug debug, ResourceBundle resourceBundle) {
        int n = this.do_write(string);
        int n2 = -1;
        String string2 = "";
        try {
            string2 = this.do_read(254, resourceBundle);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return -1;
        }
        if (debug.messageEnabled()) {
            debug.message("SecurIDHelper:nextTokenMode:instring=" + string2);
        }
        if (string2.length() == 0) {
            return -1;
        }
        this.helperText = string2;
        n2 = string2.startsWith("Authentication passed") ? 0 : (string2.startsWith("Access denied") ? -1 : (string2.startsWith("unknown return code ") ? -1 : (string2.startsWith("Processing timed-") ? -1 : (string2.startsWith("Processing erro") ? -1 : (string2.startsWith("authentication failed") ? -1 : (string2.startsWith("Access challenge failed") ? -1 : -1))))));
        return n2;
    }

    public int newPINAnswer(String string, Debug debug, ResourceBundle resourceBundle) {
        int n = this.do_write(string);
        int n2 = -1;
        String string2 = "";
        try {
            string2 = this.do_read(254, resourceBundle);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return -1;
        }
        if (string2.length() == 0) {
            return -1;
        }
        if (debug.messageEnabled()) {
            debug.message("SecurIDHelper:newPINAnswer:instring=" + string2);
        }
        this.helperText = string2;
        if (string2.startsWith("Authentication passed")) {
            n2 = 0;
        } else if (string2.startsWith("Access denied")) {
            n2 = -1;
        } else if (string2.startsWith("unknown return code ")) {
            n2 = -1;
        } else if (string2.startsWith("Processing timed-")) {
            n2 = -1;
        } else if (string2.startsWith("Processing erro")) {
            n2 = -1;
        } else if (string2.startsWith("authentication failed")) {
            n2 = -1;
        } else if (string2.startsWith("Access challenge failed")) {
            n2 = -1;
        } else if (string2.startsWith("Enter new PIN, containing")) {
            this.replaceText = string2;
            n2 = 2;
        } else if (string2.startsWith("New system PIN:")) {
            this.replaceText = "Wait for the your token to change, then enter with the new PIN. " + string2;
            n2 = 5;
        } else {
            n2 = -1;
        }
        return n2;
    }

    public int newPINMode(String string, Debug debug, ResourceBundle resourceBundle) {
        int n = 200;
        int n2 = this.do_write(string);
        String string2 = "";
        int n3 = 1000;
        do {
            string2 = "";
            try {
                string2 = this.do_read(254, resourceBundle);
            }
            catch (IOException iOException) {
                System.err.println(iOException);
                return -1;
            }
            if (string2.length() == 0) {
                return -1;
            }
            if (debug.messageEnabled()) {
                debug.message("SecurIDHelper:newPINMode:instring=" + string2);
            }
            this.helperText = string2;
            if (string2.startsWith("Authentication passed")) {
                n3 = 0;
            } else if (string2.startsWith("authentication failed")) {
                n3 = -1;
            } else if (string2.startsWith("Access challenge failed")) {
                n3 = -1;
            } else if (string2.indexOf("Access denied") != -1) {
                n3 = -1;
            } else if (string2.startsWith("Enter Challenge Response:")) {
                n3 = 3;
            } else if (string2.startsWith("unknown return code ")) {
                n3 = -1;
            } else if (string2.startsWith("Processing timed-")) {
                n3 = -1;
            } else if (string2.startsWith("Processing erro")) {
                n3 = -1;
            } else if (string2.startsWith("Access challenge failed")) {
                n3 = -1;
            } else if (string2.startsWith("Wait for the code on your token to change, then connect again with the new PIN")) {
                n3 = 5;
                this.replaceText = string2;
            } else {
                n3 = string2.startsWith("PIN must have between ") ? -1 : (string2.startsWith("New system PIN rejected") ? -1 : -1);
            }
            if (--n != 0) continue;
            n3 = -1;
        } while (n3 == 1000);
        return n3;
    }

    public String getReplaceText() {
        return this.replaceText;
    }

    public String getHelperText() {
        return this.helperText;
    }

    protected synchronized void destroy(ResourceBundle resourceBundle, Debug debug) {
        try {
            if (this.writer != null) {
                this.writer.flush();
                this.writer.close();
                this.writer = null;
            }
            if (this.reader != null) {
                this.reader.close();
                this.reader = null;
            }
            if (this.sock != null) {
                this.sock.close();
                this.sock = null;
            }
        }
        catch (IOException iOException) {
            debug.error(resourceBundle.getString("SecurIDDestroyIOEx") + iOException.getMessage());
            System.exit(1);
        }
        catch (Exception exception) {
            debug.error(resourceBundle.getString("SecurIDDestroyEx") + exception.getMessage());
        }
    }
}

