/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.radius.client;

import com.sun.identity.authentication.modules.radius.client.AccessChallenge;
import com.sun.identity.authentication.modules.radius.client.AccessReject;
import com.sun.identity.authentication.modules.radius.client.AccessRequest;
import com.sun.identity.authentication.modules.radius.client.ChallengeException;
import com.sun.identity.authentication.modules.radius.client.NASIPAddressAttribute;
import com.sun.identity.authentication.modules.radius.client.NASPacket;
import com.sun.identity.authentication.modules.radius.client.NASPortAttribute;
import com.sun.identity.authentication.modules.radius.client.PacketFactory;
import com.sun.identity.authentication.modules.radius.client.RejectException;
import com.sun.identity.authentication.modules.radius.client.RequestAuthenticator;
import com.sun.identity.authentication.modules.radius.client.ServerPacket;
import com.sun.identity.authentication.modules.radius.client.StateAttribute;
import com.sun.identity.authentication.modules.radius.client.UserNameAttribute;
import com.sun.identity.authentication.modules.radius.client.UserPasswordAttribute;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Properties;

public class RadiusConn {
    public static final int MAX_RETRIES = 10;
    public static final int RETRIES = 5;
    public static int OFFICAL_PORT = 1812;
    public static int DEFAULT_PORT = 1645;
    public static int DEFAULT_TIMEOUT = 5;
    public static String OPTION_DEBUG = "OPTION_DEBUG";
    private Properties _options = null;
    private boolean _traceOn = true;
    private String[] _host = new String[2];
    private int[] _port = new int[2];
    private static int _selected = 0;
    private String _secret = null;
    private DatagramSocket _socket = null;
    private short _id = (short)System.currentTimeMillis();
    private SecureRandom _rand = null;

    public RadiusConn(String string, String string2, int n, String string3, int n2) throws SocketException {
        this(string, n, string2, n, string3, n2, null, null);
    }

    public RadiusConn(String string, int n, String string2, byte[] byArray, Properties properties) throws SocketException {
        this(string, n, string, n, string2, DEFAULT_TIMEOUT, byArray, properties);
    }

    public RadiusConn(String string, int n, String string2, int n2, String string3, int n3, byte[] byArray, Properties properties) throws SocketException {
        this._host[0] = string;
        this._port[0] = n;
        this._host[1] = string2;
        this._port[1] = n2;
        this._secret = string3;
        this._options = properties;
        this._socket = new DatagramSocket();
        this._socket.setSoTimeout(n3 * 1000);
        this._rand = byArray == null ? new SecureRandom() : new SecureRandom(byArray);
    }

    public void disconnect() throws IOException {
        this._socket.disconnect();
    }

    public void authenticate(String string, String string2) throws IOException, NoSuchAlgorithmException, RejectException, ChallengeException {
        int n = 0;
        ServerPacket serverPacket = null;
        do {
            AccessRequest accessRequest = this.createAccessRequest();
            accessRequest.addAttribute(new UserNameAttribute(string));
            accessRequest.addAttribute(new UserPasswordAttribute(accessRequest.getAuthenticator(), this._secret, string2));
            accessRequest.addAttribute(new NASIPAddressAttribute(InetAddress.getLocalHost()));
            accessRequest.addAttribute(new NASPortAttribute(this._socket.getLocalPort()));
            this.send(accessRequest, this._host[_selected], this._port[_selected]);
            try {
                ++n;
                serverPacket = this.receive();
                if (serverPacket instanceof AccessReject) {
                    throw new RejectException((AccessReject)serverPacket);
                }
                if (serverPacket instanceof AccessChallenge) {
                    throw new ChallengeException((AccessChallenge)serverPacket);
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                if (n >= 10) {
                    n = 0;
                    throw interruptedIOException;
                }
                if (n != 5) continue;
                _selected = _selected == 0 ? 1 : 0;
            }
        } while (serverPacket == null);
    }

    public void replyChallenge(String string, ChallengeException challengeException) throws IOException, NoSuchAlgorithmException, RejectException, ChallengeException {
        this.replyChallenge(null, string, challengeException);
    }

    public void replyChallenge(String string, String string2, ChallengeException challengeException) throws IOException, NoSuchAlgorithmException, RejectException, ChallengeException {
        StateAttribute stateAttribute = (StateAttribute)challengeException.getAttributeSet().getAttributeByType(24);
        if (stateAttribute == null) {
            throw new IOException("State not found in challenge");
        }
        AccessRequest accessRequest = this.createAccessRequest();
        accessRequest.addAttribute(stateAttribute);
        if (string != null) {
            accessRequest.addAttribute(new UserNameAttribute(string));
        }
        accessRequest.addAttribute(new UserPasswordAttribute(accessRequest.getAuthenticator(), this._secret, string2));
        accessRequest.addAttribute(new NASIPAddressAttribute(InetAddress.getLocalHost()));
        accessRequest.addAttribute(new NASPortAttribute(this._socket.getLocalPort()));
        this.send(accessRequest, this._host[_selected], this._port[_selected]);
        ServerPacket serverPacket = this.receive();
        if (serverPacket instanceof AccessReject) {
            throw new RejectException((AccessReject)serverPacket);
        }
        if (serverPacket instanceof AccessChallenge) {
            throw new ChallengeException((AccessChallenge)serverPacket);
        }
    }

    public void replyChallenge(String string, String string2, String string3) throws IOException, NoSuchAlgorithmException, RejectException, ChallengeException {
        if (string3 == null) {
            throw new IOException("State not found in challenge");
        }
        AccessRequest accessRequest = this.createAccessRequest();
        accessRequest.addAttribute(new StateAttribute(string3));
        accessRequest.addAttribute(new UserNameAttribute(string));
        accessRequest.addAttribute(new UserPasswordAttribute(accessRequest.getAuthenticator(), this._secret, string2));
        accessRequest.addAttribute(new NASIPAddressAttribute(InetAddress.getLocalHost()));
        accessRequest.addAttribute(new NASPortAttribute(this._socket.getLocalPort()));
        this.send(accessRequest, this._host[_selected], this._port[_selected]);
        ServerPacket serverPacket = this.receive();
        if (serverPacket instanceof AccessReject) {
            throw new RejectException((AccessReject)serverPacket);
        }
        if (serverPacket instanceof AccessChallenge) {
            throw new ChallengeException((AccessChallenge)serverPacket);
        }
    }

    private short getIdentifier() {
        short s = this._id;
        this._id = (short)(s + 1);
        return s;
    }

    private void send(NASPacket nASPacket, String string, int n) throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(new byte[4096], 4096);
        datagramPacket.setPort(n);
        datagramPacket.setAddress(InetAddress.getByName(string));
        byte[] byArray = nASPacket.getData();
        datagramPacket.setLength(byArray.length);
        datagramPacket.setData(byArray);
        this._socket.send(datagramPacket);
        if (this._traceOn) {
            this.trace("Sent " + nASPacket);
        }
    }

    private ServerPacket receive() throws IOException {
        DatagramPacket datagramPacket = new DatagramPacket(new byte[4096], 4096);
        this._socket.receive(datagramPacket);
        byte[] byArray = datagramPacket.getData();
        ServerPacket serverPacket = PacketFactory.createServerPacket(byArray);
        if (this._traceOn) {
            this.trace("Received " + serverPacket + " size=" + serverPacket.getAttributeSet().size());
        }
        return serverPacket;
    }

    private AccessRequest createAccessRequest() throws NoSuchAlgorithmException {
        RequestAuthenticator requestAuthenticator = new RequestAuthenticator(this._rand, this._secret);
        AccessRequest accessRequest = new AccessRequest(this.getIdentifier(), requestAuthenticator);
        return accessRequest;
    }

    private void trace(String string) {
        System.out.println("TRACE: " + string);
        System.out.flush();
    }
}

