/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.nt;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SystemProperties;
import com.sun.identity.authentication.modules.nt.NTPrincipal;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;

public class NT
extends AMLoginModule {
    private static boolean hasInitialized = false;
    private static String baseDir;
    private ResourceBundle bundle = null;
    private static Debug debug;
    private Map options;
    private Map sharedState;
    private String host;
    private String domain;
    private NTPrincipal userPrincipal;
    private static String smbPath;
    private String userTokenId = "";
    private String userName = null;
    private static final String charSet = "ISO8859_1";
    private static final String amAuthNT = "amAuthNT";

    public void init(Subject subject, Map map, Map map2) {
        Locale locale = this.getLoginLocale();
        this.bundle = AMLoginModule.amCache.getResBundle(amAuthNT, locale);
        if (debug.messageEnabled()) {
            debug.message("NT resbundle locale=" + locale);
        }
        this.options = map2;
        if (map2 != null) {
            this.host = Misc.getServerMapAttr((Map)map2, (String)"iplanet-am-auth-nt-host");
            this.domain = Misc.getServerMapAttr((Map)map2, (String)"iplanet-am-auth-nt-domain");
        }
    }

    public int process(Callback[] callbackArray, int n) throws AuthLoginException {
        if (!hasInitialized) {
            throw new AuthLoginException(amAuthNT, "NTSMB", null);
        }
        if (this.host == null || this.host.equals("")) {
            debug.message("NT Host cannot be null ");
            throw new AuthLoginException(amAuthNT, "Hosterror", null);
        }
        if (this.domain == null || this.domain.equals("")) {
            debug.message("NT Domain cannot be null ");
            throw new AuthLoginException(amAuthNT, "Domainerror", null);
        }
        try {
            if (!this.host.equals(new String(this.host.getBytes("ASCII"), "ASCII"))) {
                throw new AuthLoginException(amAuthNT, "NTHostnameNotASCII", null);
            }
            if (!this.domain.equals(new String(this.domain.getBytes("ASCII"), "ASCII"))) {
                throw new AuthLoginException(amAuthNT, "NTDomainnameNotASCII", null);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AuthLoginException(amAuthNT, "NTInputNotASCII", null);
        }
        String string = null;
        this.userName = ((NameCallback)callbackArray[0]).getName();
        string = this.charToString(((PasswordCallback)callbackArray[1]).getPassword(), callbackArray[1]);
        if (this.userName == null || this.userName.equals("")) {
            debug.message("UserId cannot be null");
            throw new AuthLoginException(amAuthNT, "UserIderror", null);
        }
        if (string == null || string.equals("")) {
            debug.message("Password cannot be null");
            this.setFailureID(this.userName);
            throw new AuthLoginException(amAuthNT, "Passworderror", null);
        }
        try {
            if (!this.userName.equals(new String(this.userName.getBytes("ASCII"), "ASCII"))) {
                throw new AuthLoginException(amAuthNT, "NTUsernameNotASCII", null);
            }
            if (!string.equals(new String(string.getBytes("ASCII"), "ASCII"))) {
                this.setFailureID(this.userName);
                throw new AuthLoginException(amAuthNT, "NTPasswordNotASCII", null);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AuthLoginException(amAuthNT, "NTInputNotASCII", null);
        }
        if (debug.messageEnabled()) {
            debug.message("userName='" + this.userName + "' host='" + this.host + "'");
            debug.message("domain='" + this.domain + "'");
        }
        try {
            int n2;
            Runtime runtime = Runtime.getRuntime();
            StringBuffer stringBuffer = new StringBuffer(80);
            String[] stringArray = new String[]{smbPath, "-W", this.domain, "-L", this.host, "-U", this.userName + "%" + string};
            Process process = runtime.exec(stringArray);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), charSet));
            while ((n2 = bufferedReader.read()) > -1) {
                char c = (char)n2;
                stringBuffer.append(c);
            }
            bufferedReader.close();
            String string2 = stringBuffer.toString();
            if (string2.indexOf("Usage:") != -1) {
                if (debug.messageEnabled()) {
                    debug.message("smbclient usage error");
                }
                this.setFailureID(this.userName);
                throw new AuthLoginException(amAuthNT, "NTSMBUsage", null);
            }
            if (string2.indexOf("failed") != -1) {
                if (debug.messageEnabled()) {
                    debug.message("NT authentication failed" + string2);
                }
                this.setFailureID(this.userName);
                throw new AuthLoginException(amAuthNT, "NTLoginFailed", null);
            }
            if (string2.indexOf("timeout") != -1) {
                if (debug.messageEnabled()) {
                    debug.message("smbclient timeout error");
                }
                this.setFailureID(this.userName);
                throw new AuthLoginException(amAuthNT, "NTSMBTimeout", null);
            }
            int n3 = process.waitFor();
            if (debug.messageEnabled()) {
                debug.message("Exit value of samba client: " + n3);
            }
            if (n3 != 0) {
                this.setFailureID(this.userName);
                throw new AuthLoginException(amAuthNT, "NTAuthFailed", null);
            }
            this.userTokenId = this.userName;
            return -1;
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("NT authentication failed" + exception.getMessage());
            }
            this.setFailureID(this.userName);
            throw new AuthLoginException(amAuthNT, "NTAuthFailed", null, exception);
        }
    }

    private String charToString(char[] cArray, Callback callback) {
        if (cArray == null) {
            cArray = new char[]{};
        }
        char[] cArray2 = new char[cArray.length];
        System.arraycopy(cArray, 0, cArray2, 0, cArray.length);
        ((PasswordCallback)callback).clearPassword();
        return new String(cArray2);
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.userTokenId != null) {
            this.userPrincipal = new NTPrincipal(this.userTokenId);
            return this.userPrincipal;
        }
        return null;
    }

    static {
        debug = null;
        if (debug == null) {
            debug = Debug.getInstance((String)amAuthNT);
            debug.message("NT constructor called");
        }
        try {
            baseDir = SystemProperties.get((String)"com.iplanet.am.installdir");
            if (baseDir.equals("")) {
                baseDir = "/opt/SUNWam";
            }
            smbPath = baseDir + "/bin/smbclient";
        }
        catch (Exception exception) {
            debug.error("NT failed to initialize " + exception.getMessage());
        }
        File file = new File(smbPath);
        if (!file.exists()) {
            debug.error("smbclient file not found");
            hasInitialized = false;
        }
        hasInitialized = true;
    }
}

