/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.httpbasic;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SystemProperties;
import com.sun.identity.authentication.modules.httpbasic.HTTPBasicPrincipal;
import com.sun.identity.authentication.modules.ldap.LDAPAuthUtils;
import com.sun.identity.authentication.modules.ldap.LDAPUtilException;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import com.sun.identity.authentication.spi.InvalidPasswordException;
import java.io.IOException;
import java.security.Principal;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import sun.misc.BASE64Decoder;

public class HTTPBasic
extends AMLoginModule {
    private Principal userPrincipal = null;
    private static final String amAuthHTTPBasic = "amAuthHTTPBasic";
    private static Debug debug = Debug.getInstance((String)"amAuthHTTPBasic");
    private ResourceBundle bundle = null;
    private String validatedUserID;
    private static String adminDN;
    private static String hostName;
    private String regEx;
    private LDAPAuthUtils ldapUtil;
    private static boolean ldapSSL;
    private String userName;
    private String userPassword;
    private Map currentConfig;
    private Map options;
    private static int port;
    private static final int SUCCESS = 26;
    private static final int FAILED = 2;
    private final int FINISHED = -1;
    private HttpServletRequest req;
    private HttpServletResponse resp;
    private String SA = "iplanet-am-auth-ldap-";
    private String LDAPSERVER = this.SA + "server";
    private String UNA = this.SA + "user-naming-attribute";
    private String USERSEARCH = this.SA + "user-search-attributes";
    private String SEARCHFILTER = this.SA + "search-filter";
    private String BINDPWD = this.SA + "bind-passwd";
    private String BASEDN = this.SA + "base-dn";
    private String BINDDN = this.SA + "bind-dn";
    private String SSL = this.SA + "ssl-enabled";
    private String SEARCHSCOPE = this.SA + "search-scope";
    private String RETURNUSERDN = this.SA + "return-user-dn";
    private String MODCONFIG = "iplanet-am-auth-http-basic-module-configured";
    private String AUTHLEVEL = "iplanet-am-auth-http-basic-auth-level";
    private static final String INVALID_CHARS = "iplanet-am-auth-ldap-invalid-chars";
    private static final String DEFAULT_REG_EX = "*|(|)|&|!";

    public void init(Subject subject, Map map, Map map2) {
        debug.message("in initialize...");
        Locale locale = this.getLoginLocale();
        this.bundle = AMLoginModule.amCache.getResBundle(amAuthHTTPBasic, locale);
        if (debug.messageEnabled()) {
            debug.message("HttpBasicAuth resbundle locale=" + locale);
        }
        this.options = map2;
    }

    private boolean initHttpBasicAuth() throws AuthLoginException {
        String string;
        debug.message("HTTPBasic initialize()");
        String string2 = Misc.getMapAttr((Map)this.options, (String)this.MODCONFIG);
        if (string2 == null) {
            debug.message("No Service Template created");
            throw new AuthLoginException(amAuthHTTPBasic, "noST", null);
        }
        String string3 = Misc.getMapAttr((Map)this.options, (String)this.AUTHLEVEL);
        if (string3 != null) {
            try {
                this.setAuthLevel(Integer.parseInt(string3));
            }
            catch (Exception exception) {
                debug.error("Unable to set auth level " + string3, (Throwable)exception);
            }
        }
        if ((string = HTTPBasic.getModuleServiceName(string2)) != null) {
            if (string2.equals("LDAP")) {
                return this.initLDAPAttributes(string);
            }
            debug.error(" Init Exception");
            throw new AuthLoginException(amAuthHTTPBasic, "basicauthInitFalied", null);
        }
        return false;
    }

    private boolean initLDAPAttributes(String string) throws AuthLoginException {
        String string2 = null;
        this.currentConfig = this.getOrgServiceTemplate(this.getRequestOrg(), string);
        try {
            string2 = Misc.getServerMapAttr((Map)this.currentConfig, (String)this.LDAPSERVER);
            if (string2 == null) {
                debug.message("No server for configuring");
                return false;
            }
            String string3 = Misc.getServerMapAttr((Map)this.currentConfig, (String)this.BASEDN);
            if (string3 == null) {
                debug.error("Fatal error: baseDN for search has invalid value");
                throw new AuthLoginException(amAuthHTTPBasic, "basednnull", null);
            }
            String string4 = Misc.getMapAttr((Map)this.currentConfig, (String)this.BINDDN, (String)"");
            String string5 = Misc.getMapAttr((Map)this.currentConfig, (String)this.BINDPWD, (String)"");
            String string6 = Misc.getMapAttr((Map)this.currentConfig, (String)this.UNA, (String)"uid");
            Set set = (Set)this.currentConfig.get(this.USERSEARCH);
            String string7 = Misc.getMapAttr((Map)this.currentConfig, (String)this.SEARCHFILTER, (String)"");
            boolean bl = Boolean.valueOf(Misc.getMapAttr((Map)this.currentConfig, (String)this.SSL, (String)"false"));
            String string8 = Misc.getMapAttr((Map)this.currentConfig, (String)this.SEARCHSCOPE, (String)"SUBTREE");
            int n = 2;
            if (string8.equalsIgnoreCase("OBJECT")) {
                n = 0;
            } else if (string8.equalsIgnoreCase("ONELEVEL")) {
                n = 1;
            }
            String string9 = Misc.getMapAttr((Map)this.currentConfig, (String)this.RETURNUSERDN, (String)"true");
            this.regEx = Misc.getMapAttr((Map)this.currentConfig, (String)INVALID_CHARS, (String)DEFAULT_REG_EX);
            int n2 = string2.indexOf(58);
            int n3 = 389;
            String string10 = null;
            if (n2 != -1) {
                string10 = string2.substring(n2 + 1);
                n3 = Integer.parseInt(string10);
                string2 = string2.substring(0, n2);
            }
            this.ldapUtil = new LDAPAuthUtils(string2, n3, bl, this.bundle, string3);
            this.ldapUtil.setScope(n);
            this.ldapUtil.setFilter(string7);
            this.ldapUtil.setUserNamingAttribute(string6);
            this.ldapUtil.setUserSearchAttribute(set);
            this.ldapUtil.setAuthPassword(string5);
            this.ldapUtil.setAuthDN(string4);
            this.ldapUtil.setReturnUserDN(string9);
            if (debug.messageEnabled()) {
                debug.message("bindDN-> " + string4 + "\nbaseDN-> " + string3 + "\nuserNamingAttr-> " + string6 + "\nuserSearchAttr(s)-> " + set + "\nsearchFilter-> " + string7 + "\nsearchScope-> " + n + "\nssl-> " + bl + "\nHost: " + string2 + "\nINDEDX : " + n2 + "\nPORT : " + n3);
            }
            return true;
        }
        catch (Exception exception) {
            debug.error("LDAP Init Exception", (Throwable)exception);
            throw new AuthLoginException(amAuthHTTPBasic, "basicLDAPex", null, exception);
        }
    }

    public int process(Callback[] callbackArray, int n) throws AuthLoginException {
        boolean bl = false;
        this.req = this.getHttpServletRequest();
        this.resp = this.getHttpServletResponse();
        if (this.req == null || this.resp == null) {
            debug.message("Servlet Request and Response cannot be null");
            throw new AuthLoginException(amAuthHTTPBasic, "reqRespNull", null);
        }
        try {
            debug.message("Process HTTPBasic Auth started ...");
            String string = this.req.getHeader("Authorization");
            if (debug.messageEnabled()) {
                debug.message("AUTH : " + string);
            }
            if (this.authenticate(string)) {
                this.validatedUserID = this.userName;
                return -1;
            }
            this.setFailureID(this.userName);
            throw new AuthLoginException(amAuthHTTPBasic, "sendError", null);
        }
        catch (InvalidPasswordException invalidPasswordException) {
            this.setFailureID(this.userName);
            throw new InvalidPasswordException(invalidPasswordException);
        }
        catch (Exception exception) {
            debug.error("login: unknown exception = ", (Throwable)exception);
            this.setFailureID(this.userName);
            throw new AuthLoginException(amAuthHTTPBasic, "sendError", null, exception);
        }
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.validatedUserID != null) {
            this.userPrincipal = new HTTPBasicPrincipal(this.validatedUserID);
            return this.userPrincipal;
        }
        return null;
    }

    private boolean authenticate(String string) throws AuthLoginException, IOException {
        if (string == null || !string.toUpperCase().startsWith("BASIC")) {
            return false;
        }
        int n = 0;
        BASE64Decoder bASE64Decoder = new BASE64Decoder();
        String string2 = string.substring(6);
        String string3 = new String(bASE64Decoder.decodeBuffer(string2));
        int n2 = string3.indexOf(58);
        if (n2 != -1) {
            this.userPassword = string3.substring(n2 + 1);
            this.userName = string3.substring(0, n2);
        }
        return (n = this.authenticateToLDAP(this.userName, this.userPassword)) == 26;
    }

    private int authenticateToLDAP(String string, String string2) throws AuthLoginException {
        try {
            if (this.isSuperAdmin(string)) {
                this.ldapUtil = new LDAPAuthUtils(hostName, port, ldapSSL, this.bundle);
                this.ldapUtil.authenticateSuperAdmin(string, string2, adminDN);
                return this.ldapUtil.getState();
            }
            if (this.initHttpBasicAuth()) {
                this.validateUserName(string, this.regEx);
                this.ldapUtil.authenticateUser(string, string2);
                return this.ldapUtil.getState();
            }
            this.setFailureID(string);
            throw new AuthLoginException(amAuthHTTPBasic, "basicLDAPex", null);
        }
        catch (LDAPUtilException lDAPUtilException) {
            this.setFailureID(string);
            switch (lDAPUtilException.getLDAPResultCode()) {
                case 32: {
                    debug.message("The specified user does not exist.");
                    throw new AuthLoginException(amAuthHTTPBasic, "NoUser", null);
                }
                case 49: {
                    debug.message("Invalid password.");
                    String string3 = this.ldapUtil.getUserId();
                    throw new InvalidPasswordException(amAuthHTTPBasic, "InvalidUP", null, string3, lDAPUtilException);
                }
            }
            throw new AuthLoginException(amAuthHTTPBasic, "basicLDAPex", null);
        }
    }

    public static String getModuleServiceName(String string) {
        return "iPlanetAMAuth" + string + "Service";
    }

    private static void initializeSystemProperties() {
        adminDN = AMLoginModule.getSuperAdminUser();
        hostName = SystemProperties.get((String)"com.iplanet.am.directory.host");
        String string = SystemProperties.get((String)"com.iplanet.am.directory.port");
        port = Integer.parseInt(string);
        if (debug.messageEnabled()) {
            debug.message("adminDN-> " + adminDN + "\nHost: " + hostName + "\nPORT : " + port);
        }
        ldapSSL = Boolean.valueOf(SystemProperties.get((String)"com.iplanet.am.directory.ssl.enabled", (String)"false"));
    }

    static {
        ldapSSL = false;
        if (debug == null) {
            debug = Debug.getInstance((String)"amAuthLDAP");
        }
        HTTPBasic.initializeSystemProperties();
    }
}

