/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.cert;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.iplanet.am.util.SSLSocketFactoryManager;
import com.iplanet.security.x509.X500Name;
import com.sun.identity.authentication.modules.cert.CertAuthPrincipal;
import com.sun.identity.authentication.service.X509CertificateCallback;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.Principal;
import java.security.cert.CRL;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.mail.internet.MimeUtility;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.servlet.http.HttpServletRequest;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPUrl;
import org.mozilla.jss.CryptoManager;

public class Cert
extends AMLoginModule {
    private static Locale locale = null;
    private ResourceBundle bundle = null;
    private static Debug debug = null;
    private String userTokenId = null;
    private X509Certificate thecert = null;
    private String amAuthCert_serverHost;
    private String amAuthCert_startSearchLoc;
    private String amAuthCert_securityType;
    private String amAuthCert_principleUser;
    private String amAuthCert_principlePasswd;
    private String amAuthCert_useSSL;
    private String amAuthCert_userProfileMapper;
    private String amAuthCert_altUserProfileMapper;
    private String amAuthCert_chkCRL;
    private String amAuthCert_chkAttrCRL = null;
    private String amAuthCert_chkCertInLDAP;
    private String amAuthCert_chkAttrCertInLDAP = null;
    private String amAuthCert_ldapProfileID;
    private String amAuthCert_emailAddrTag;
    private int amAuthCert_serverPort = 389;
    private static boolean portal_gw_cert_auth_enabled = false;
    private Set portalGateways = null;
    private boolean ocspEnabled = false;
    private Map options;
    private CertAuthPrincipal userPrincipal;
    private CallbackHandler callbackHandler;
    private static final String amAuthCert = "amAuthCert";

    public void init(Subject subject, Map map, Map map2) {
        if (debug == null) {
            debug = Debug.getInstance((String)amAuthCert);
        }
        Locale locale = this.getLoginLocale();
        this.bundle = AMLoginModule.amCache.getResBundle(amAuthCert, locale);
        this.callbackHandler = this.getCallbackHandler();
        this.options = map2;
        if (debug.messageEnabled()) {
            debug.message("Cert Auth resbundle locale=" + locale);
            debug.message("Cert auth init() done");
        }
    }

    private void initAuthConfig() throws AuthLoginException {
        if (this.options != null) {
            Object object;
            String string;
            if (debug.messageEnabled()) {
                debug.message("Certificate: getting attributes.");
            }
            if ((string = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-auth-level")) != null) {
                try {
                    int n = Integer.parseInt(string);
                    this.setAuthLevel(n);
                }
                catch (Exception exception) {
                    debug.error("Invalid auth level " + string, (Throwable)exception);
                }
            }
            this.amAuthCert_securityType = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-security-type");
            this.amAuthCert_principleUser = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-principal-user");
            this.amAuthCert_principlePasswd = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-principal-passwd");
            this.amAuthCert_useSSL = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-use-ssl");
            this.amAuthCert_userProfileMapper = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-user-profile-mapper");
            this.amAuthCert_altUserProfileMapper = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-user-profile-mapper-other");
            this.amAuthCert_chkCRL = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-check-crl");
            if (this.amAuthCert_chkCRL.equalsIgnoreCase("true")) {
                this.amAuthCert_chkAttrCRL = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-attr-check-crl");
                if (this.amAuthCert_chkAttrCRL == null || this.amAuthCert_chkAttrCRL.equals("")) {
                    throw new AuthLoginException(amAuthCert, "noCRLAttr", null);
                }
            }
            this.amAuthCert_chkCertInLDAP = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-check-cert-in-ldap");
            if (this.amAuthCert_chkCertInLDAP.equalsIgnoreCase("true")) {
                this.amAuthCert_chkAttrCertInLDAP = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-attr-check-ldap");
                if (this.amAuthCert_chkAttrCertInLDAP == null || this.amAuthCert_chkAttrCertInLDAP.equals("")) {
                    throw new AuthLoginException(amAuthCert, "noLDAPAttr", null);
                }
            }
            this.amAuthCert_ldapProfileID = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-ldap-profile-id");
            String string2 = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-check-ocsp");
            this.ocspEnabled = string2 != null && string2.equalsIgnoreCase("true");
            String string3 = Misc.getMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-gw-cert-auth-enabled");
            HttpServletRequest httpServletRequest = this.getHttpServletRequest();
            String string4 = null;
            if (httpServletRequest != null) {
                string4 = httpServletRequest.getRemoteAddr();
            }
            portal_gw_cert_auth_enabled = false;
            if (string3 == null || string3.equals("") || string3.equalsIgnoreCase("none")) {
                if (debug.messageEnabled()) {
                    debug.message("iplanet-am-auth-cert-gw-cert-auth-enabled = " + string3);
                }
            } else if (string3.equalsIgnoreCase("any")) {
                portal_gw_cert_auth_enabled = true;
            } else {
                this.portalGateways = (Set)this.options.get("iplanet-am-auth-cert-gw-cert-auth-enabled");
                if (string4 != null && this.portalGateways.contains(string4)) {
                    portal_gw_cert_auth_enabled = true;
                } else if (debug.messageEnabled()) {
                    debug.message("gateway list does not contain client");
                    object = this.portalGateways.iterator();
                    while (object.hasNext()) {
                        String string5 = (String)object.next();
                        debug.message("client list entry = " + string5);
                    }
                }
            }
            this.amAuthCert_emailAddrTag = this.bundle.getString("emailAddrTag");
            this.amAuthCert_serverHost = Misc.getServerMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-ldap-provider-url");
            if (this.amAuthCert_serverHost == null && (this.amAuthCert_chkCertInLDAP.equalsIgnoreCase("true") || this.amAuthCert_chkCRL.equalsIgnoreCase("true"))) {
                debug.error("Fatal error: LDAP Server and Port misconfigured");
                throw new AuthLoginException(amAuthCert, "wrongLDAPServer", null);
            }
            if (this.amAuthCert_serverHost != null) {
                try {
                    object = new LDAPUrl("ldap://" + this.amAuthCert_serverHost);
                    this.amAuthCert_serverPort = ((LDAPUrl)object).getPort();
                    this.amAuthCert_serverHost = ((LDAPUrl)object).getHost();
                }
                catch (Exception exception) {
                    throw new AuthLoginException(amAuthCert, "wrongLDAPServer", null);
                }
            }
            this.amAuthCert_startSearchLoc = Misc.getServerMapAttr((Map)this.options, (String)"iplanet-am-auth-cert-start-search-loc");
            if (this.amAuthCert_startSearchLoc == null && (this.amAuthCert_chkCertInLDAP.equalsIgnoreCase("true") || this.amAuthCert_chkCRL.equalsIgnoreCase("true"))) {
                debug.error("Fatal error: LDAP Start Search DN is not configured");
                throw new AuthLoginException(amAuthCert, "wrongStartDN", null);
            }
            if (this.amAuthCert_startSearchLoc != null) {
                try {
                    object = new X500Name(this.amAuthCert_startSearchLoc);
                }
                catch (Exception exception) {
                    debug.error("Fatal error: LDAP Start Search DN misconfigured");
                    throw new AuthLoginException(amAuthCert, "wrongStartDN", null);
                }
            }
            if (debug.messageEnabled()) {
                debug.message("\nldapProviderUrl=" + this.amAuthCert_serverHost + "\n\tamAuthCert_serverPort = " + this.amAuthCert_serverPort + "\n\tstartSearchLoc=" + this.amAuthCert_startSearchLoc + "\n\tsecurityType=" + this.amAuthCert_securityType + "\n\tprincipleUser=" + this.amAuthCert_principleUser + "\n\tauthLevel=" + string + "\n\tuseSSL=" + this.amAuthCert_useSSL + "\n\tocspEnable=" + this.ocspEnabled + "\n\tuserProfileMapper=" + this.amAuthCert_userProfileMapper + "\n\taltUserProfileMapper=" + this.amAuthCert_altUserProfileMapper + "\n\tchkCRL=" + this.amAuthCert_chkCRL + "\n\tchkAttrCRL=" + this.amAuthCert_chkAttrCRL + "\n\tchkCertInLDAP=" + this.amAuthCert_chkCertInLDAP + "\n\tchkAttrCertInLDAP=" + this.amAuthCert_chkAttrCertInLDAP + "\n\temailAddr=" + this.amAuthCert_emailAddrTag + "\n\tldapProfileID=" + this.amAuthCert_ldapProfileID + "\n\tgw-cert-auth-enabled=" + portal_gw_cert_auth_enabled + "\n\tclient=" + string4);
            }
        } else {
            debug.error("options is null");
            throw new AuthLoginException(amAuthCert, "CERTex", null);
        }
    }

    public int process(Callback[] callbackArray, int n) throws AuthLoginException {
        Object object;
        Object object2;
        debug.message("in Certificate. process()");
        this.initAuthConfig();
        try {
            object2 = this.getHttpServletRequest();
            if (object2 != null) {
                object = (X509Certificate[])object2.getAttribute("javax.servlet.request.X509Certificate");
                if (object == null || ((X509Certificate[])object).length == 0) {
                    debug.message("Certificate: checking for cert passed in the URL.");
                    if (!portal_gw_cert_auth_enabled) {
                        debug.error("Certificate: cert passed in URL not enabled for this client");
                        throw new AuthLoginException(amAuthCert, "noURLCertAuth", null);
                    }
                    this.thecert = this.getPortalStyleCert();
                } else {
                    if (debug.messageEnabled()) {
                        debug.message("Certificate: got all certs from HttpServletRequest =" + ((X509Certificate[])object).length);
                    }
                    this.thecert = object[0];
                }
            } else {
                this.thecert = this.sendCallback();
            }
            if (this.thecert == null) {
                if (debug.messageEnabled()) {
                    debug.message("Certificate: no cert passed in.");
                }
                throw new AuthLoginException(amAuthCert, "noCert", null);
            }
            this.getTokenFromCert(this.thecert);
            if (debug.messageEnabled()) {
                debug.message("in Certificate. userTokenId=" + this.userTokenId + " from getTokenFromCert");
            }
        }
        catch (AuthLoginException authLoginException) {
            this.setFailureID(this.userTokenId);
            debug.error("Certificate:  exiting validate with exception", (Throwable)authLoginException);
            throw new AuthLoginException(amAuthCert, "noCert", null);
        }
        if (debug.messageEnabled()) {
            debug.message("Got client cert =\n" + this.thecert.toString());
        }
        if (this.ocspEnabled && !this.certValidation(this.thecert)) {
            debug.message("OCSP cert validation failed");
            this.setFailureID(this.userTokenId);
            throw new AuthLoginException(amAuthCert, "CertIsNotValid", null);
        }
        if (this.amAuthCert_chkCertInLDAP.equalsIgnoreCase("false") && this.amAuthCert_chkCRL.equalsIgnoreCase("false")) {
            return -1;
        }
        object2 = null;
        if (this.amAuthCert_useSSL.equalsIgnoreCase("true")) {
            debug.message("Cert:  initial ldc  using ssl.");
            try {
                object2 = new LDAPConnection(SSLSocketFactoryManager.getSSLSocketFactory());
                debug.message("validate(): SSLSocketFactory called");
            }
            catch (Exception exception) {
                debug.error("validate.JSSSocketFactory", (Throwable)exception);
                this.setFailureID(this.userTokenId);
                throw new AuthLoginException(amAuthCert, "jssSokFactoryFail", null);
            }
        } else {
            object2 = new LDAPConnection();
        }
        try {
            ((LDAPConnection)object2).connect(this.amAuthCert_serverHost, this.amAuthCert_serverPort);
            ((LDAPConnection)object2).authenticate(this.amAuthCert_principleUser, this.amAuthCert_principlePasswd);
        }
        catch (LDAPException lDAPException) {
            if (debug.messageEnabled()) {
                debug.message("Certificate: dircontext", (Throwable)lDAPException);
            }
            this.setFailureID(this.userTokenId);
            throw new AuthLoginException(amAuthCert, "CertNoContext", null);
        }
        if (this.amAuthCert_chkCertInLDAP.equalsIgnoreCase("true")) {
            debug.message("X509Certificate: getRegisteredCertificate.");
            object = this.getRegisteredCertificate((LDAPConnection)object2, this.thecert);
            debug.message("X509Certificate: exit getRegisteredCertificate");
            if (object == null) {
                debug.message("X509Certificate: getRegCertificate is null");
                this.setFailureID(this.userTokenId);
                throw new AuthLoginException(amAuthCert, "CertNoReg", null);
            }
        }
        try {
            debug.message("X509Certificate: checkValidity.");
            this.thecert.checkValidity();
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            if (debug.messageEnabled()) {
                debug.message("Certificate:  invalid Certificate", (Throwable)certificateNotYetValidException);
            }
            this.setFailureID(this.userTokenId);
            throw new AuthLoginException(amAuthCert, "CertNotValidYet", null);
        }
        catch (CertificateExpiredException certificateExpiredException) {
            if (debug.messageEnabled()) {
                debug.message("Certificate: Certificate has expired.", (Throwable)certificateExpiredException);
            }
            this.setFailureID(this.userTokenId);
            throw new AuthLoginException(amAuthCert, "CertExpired", null);
        }
        if (this.amAuthCert_chkCRL.equalsIgnoreCase("true")) {
            debug.message("X509Certificate: verifyCertificate.");
            if (!this.verifyCertificate((LDAPConnection)object2, this.thecert)) {
                debug.message("X509Certificate:verifyCertificate failed.");
                this.setFailureID(this.userTokenId);
                throw new AuthLoginException(amAuthCert, "CertVerifyFailed", null);
            }
        }
        return -1;
    }

    private void getTokenFromCert(X509Certificate x509Certificate) throws AuthLoginException {
        try {
            sun.security.x509.X500Name x500Name = (sun.security.x509.X500Name)x509Certificate.getSubjectDN();
            X500Name x500Name2 = new X500Name(x500Name.getEncoded());
            if (debug.messageEnabled()) {
                debug.message("getTokenFromCert: Subject DN : " + x500Name2.getName());
            }
            if (this.amAuthCert_userProfileMapper.equalsIgnoreCase("subject DN")) {
                this.userTokenId = x500Name2.getName();
            }
            if (this.amAuthCert_userProfileMapper.equalsIgnoreCase("subject UID")) {
                this.userTokenId = x500Name2.getAttributeValue("uid");
            }
            if (this.amAuthCert_userProfileMapper.equalsIgnoreCase("subject CN")) {
                this.userTokenId = x500Name2.getCommonName();
            }
            if (this.amAuthCert_userProfileMapper.equalsIgnoreCase(this.amAuthCert_emailAddrTag)) {
                this.userTokenId = x500Name2.getEmail();
                if (this.userTokenId == null) {
                    this.userTokenId = x500Name2.getAttributeValue("mail");
                }
            }
            if (this.amAuthCert_userProfileMapper.equalsIgnoreCase("DER Certificate")) {
                this.userTokenId = String.valueOf(x509Certificate.getTBSCertificate());
            }
            if (this.amAuthCert_userProfileMapper.equals("other")) {
                this.userTokenId = x500Name2.getAttributeValue(this.amAuthCert_altUserProfileMapper);
            }
            if (debug.messageEnabled()) {
                debug.message("getTokenFromCert: " + this.amAuthCert_userProfileMapper + this.userTokenId);
            }
            return;
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("Certificate - Error in getTokenFromCert = ", (Throwable)exception);
            }
            throw new AuthLoginException(amAuthCert, "CertNoReg", null);
        }
    }

    private X509Certificate getRegisteredCertificate(LDAPConnection lDAPConnection, X509Certificate x509Certificate) throws AuthLoginException {
        Object object;
        Object object2;
        CertificateFactory certificateFactory = null;
        String string = null;
        try {
            object2 = (sun.security.x509.X500Name)x509Certificate.getSubjectDN();
            object = new X500Name(((sun.security.x509.X500Name)object2).getEncoded());
            string = ((X500Name)object).getAttributeValue(this.amAuthCert_chkAttrCertInLDAP);
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("Certificate - cn substring: " + exception);
            }
            return null;
        }
        if (string == null) {
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("Certificate - cn substring: " + string);
        }
        try {
            if (debug.messageEnabled()) {
                debug.message("Certificate - ldc.search:searching  " + this.amAuthCert_startSearchLoc + " " + lDAPConnection);
            }
            object2 = new StringBuffer(128).append("(").append(this.amAuthCert_chkAttrCertInLDAP).append("=").append(string).append(")").toString();
            if (debug.messageEnabled()) {
                debug.message("Certificate - ldc.search: using this filter: " + (String)object2);
            }
            object = lDAPConnection.search(this.amAuthCert_startSearchLoc, 2, (String)object2, null, false);
            certificateFactory = CertificateFactory.getInstance("X.509");
            while (object != null && ((LDAPSearchResults)object).hasMoreElements()) {
                LDAPEntry lDAPEntry = ((LDAPSearchResults)object).next();
                LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
                LDAPAttribute lDAPAttribute = lDAPAttributeSet.getAttribute("usercertificate");
                if (lDAPAttribute == null) {
                    if (debug.messageEnabled()) {
                        debug.message("Certificate - get usercertificate is null");
                    }
                    if ((lDAPAttribute = lDAPAttributeSet.getAttribute("usercertificate;binary")) == null) {
                        debug.message("Certificate - get usercertificate;binary is null ");
                        continue;
                    }
                }
                Enumeration enumeration = lDAPAttribute.getByteValues();
                while (enumeration.hasMoreElements()) {
                    byte[] byArray = (byte[])enumeration.nextElement();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                    X509Certificate x509Certificate2 = null;
                    try {
                        x509Certificate2 = (X509Certificate)certificateFactory.generateCertificate(byteArrayInputStream);
                    }
                    catch (CertificateParsingException certificateParsingException) {
                        debug.error("Error in Certificate parsing : ", (Throwable)certificateParsingException);
                    }
                    if (x509Certificate2 == null || !x509Certificate.equals(x509Certificate2)) continue;
                    return x509Certificate2;
                }
            }
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("Certificate - Error finding registered certificate = ", (Throwable)exception);
            }
            throw new AuthLoginException(amAuthCert, "CertNoReg", null);
        }
        if (debug.messageEnabled()) {
            debug.message("Certificate - did not find matching cert in LDAP");
        }
        return null;
    }

    private boolean verifyCertificate(LDAPConnection lDAPConnection, X509Certificate x509Certificate) throws AuthLoginException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        String string = null;
        try {
            object6 = (sun.security.x509.X500Name)x509Certificate.getIssuerDN();
            object5 = new X500Name(((sun.security.x509.X500Name)object6).getEncoded());
            string = ((X500Name)object5).getAttributeValue(this.amAuthCert_chkAttrCRL);
            if (debug.messageEnabled()) {
                debug.message("verifyCertificate retrieved attribute " + this.amAuthCert_chkAttrCRL + " : " + string);
            }
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("verifyCertificate : " + exception);
            }
            return false;
        }
        object6 = null;
        object5 = null;
        try {
            if (debug.messageEnabled()) {
                debug.message("Searching for signers certificate");
            }
            object4 = "(" + this.amAuthCert_chkAttrCRL + "=" + string + ")";
            if (debug.messageEnabled()) {
                debug.message("verifyCertificate - ldc.search: using filter: " + (String)object4);
            }
            if ((object3 = lDAPConnection.search(this.amAuthCert_startSearchLoc, 2, (String)object4, null, false)) == null || !((LDAPSearchResults)object3).hasMoreElements()) {
                if (debug.messageEnabled()) {
                    debug.message("verifyCertificate - No CRL distribution Point configured");
                }
                return false;
            }
            if (((LDAPSearchResults)object3).getCount() > 1) {
                if (debug.messageEnabled()) {
                    debug.message("verifyCertificate - More than one CRL distribution Point configured");
                }
                return false;
            }
            object2 = ((LDAPSearchResults)object3).next();
            object = ((LDAPEntry)object2).getAttributeSet();
            LDAPAttribute lDAPAttribute = ((LDAPAttributeSet)object).getAttribute("cacertificate");
            if (lDAPAttribute == null && (lDAPAttribute = ((LDAPAttributeSet)object).getAttribute("cacertificate;binary")) == null) {
                return false;
            }
            object6 = lDAPAttribute.getByteValues();
            LDAPAttribute lDAPAttribute2 = ((LDAPAttributeSet)object).getAttribute("certificaterevocationlist");
            if (lDAPAttribute2 == null && (lDAPAttribute2 = ((LDAPAttributeSet)object).getAttribute("certificaterevocationlist;binary")) == null) {
                return false;
            }
            object5 = lDAPAttribute2.getByteValues();
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("Error finding CRL distribution Point configured : ", (Throwable)exception);
            }
            return false;
        }
        object4 = null;
        try {
            object3 = CertificateFactory.getInstance("X.509");
            object2 = (byte[])object6.nextElement();
            object4 = (X509Certificate)((CertificateFactory)object3).generateCertificate(new ByteArrayInputStream((byte[])object2));
            object2 = (byte[])object5.nextElement();
            object = (X509CRL)((CertificateFactory)object3).generateCRL(new ByteArrayInputStream((byte[])object2));
            if (((CRL)object).isRevoked(x509Certificate)) {
                return false;
            }
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("Certificate: CertRevoked = ", (Throwable)exception);
            }
            throw new AuthLoginException(amAuthCert, "CertRevoked", null);
        }
        if ((object6.hasMoreElements() || object5.hasMoreElements()) && debug.messageEnabled()) {
            debug.message("CRL distribution Point configured with more than one CAs and CRLs");
        }
        boolean bl = true;
        if (!((X509Certificate)object4).getIssuerDN().equals(((X509Certificate)object4).getSubjectDN())) {
            debug.message("Verifying next signer");
            bl = this.verifyCertificate(lDAPConnection, (X509Certificate)object4);
        }
        return bl;
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.userTokenId != null) {
            this.userPrincipal = new CertAuthPrincipal(this.userTokenId);
            return this.userPrincipal;
        }
        return null;
    }

    public X509Certificate getCertificate() {
        return this.thecert;
    }

    private X509Certificate sendCallback() throws AuthLoginException {
        if (this.callbackHandler == null) {
            throw new AuthLoginException(amAuthCert, "NoCallbackHandler", null);
        }
        X509Certificate x509Certificate = null;
        try {
            Callback[] callbackArray = new Callback[]{new X509CertificateCallback(this.bundle.getString("certificate"))};
            this.callbackHandler.handle(callbackArray);
            x509Certificate = ((X509CertificateCallback)callbackArray[0]).getCertificate();
            return x509Certificate;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            debug.message("message type missing");
            throw new AuthLoginException(amAuthCert, "IllegalArgs", null);
        }
        catch (IOException iOException) {
            throw new AuthLoginException(iOException);
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new AuthLoginException(amAuthCert, "NoCallbackHandler", null);
        }
    }

    private X509Certificate getPortalStyleCert() throws AuthLoginException {
        debug.message("getPortalStyleCert: checking cert in userCert param");
        Hashtable hashtable = this.getLoginState("getPortalStyleCert()").getRequestParamHash();
        String string = null;
        if (hashtable != null && (string = (String)hashtable.get("IDToken0")) == null) {
            string = (String)hashtable.get("Login.Token0");
        }
        if (debug.messageEnabled()) {
            debug.message("in Certificate. validate certParam: " + string);
        }
        if (string == null || string.equals("")) {
            debug.message("Certificate: no cert from HttpServletRequest");
            throw new AuthLoginException(amAuthCert, "noCert", null);
        }
        byte[] byArray = string.getBytes();
        debug.message("in Certificate: got certbytes");
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStream inputStream = null;
        try {
            inputStream = MimeUtility.decode((InputStream)byteArrayInputStream, (String)"base64");
        }
        catch (Exception exception) {
            debug.error("CertificateFromParameter(decode): exception", (Throwable)exception);
            throw new AuthLoginException(amAuthCert, "CERTex", null);
        }
        debug.message("Certificate: CertificateFactory.getInstance.");
        CertificateFactory certificateFactory = null;
        X509Certificate x509Certificate = null;
        try {
            certificateFactory = CertificateFactory.getInstance("X.509");
            x509Certificate = (X509Certificate)certificateFactory.generateCertificate(inputStream);
        }
        catch (Exception exception) {
            debug.error("CertificateFromParameter(X509Cert): exception ", (Throwable)exception);
            throw new AuthLoginException(amAuthCert, "CERTex", null);
        }
        if (x509Certificate == null) {
            throw new AuthLoginException(amAuthCert, "CERTex", null);
        }
        if (debug.messageEnabled()) {
            debug.message("X509Certificate: principal is: " + x509Certificate.getSubjectDN().getName() + "\nissuer DN:" + x509Certificate.getIssuerDN().getName() + "\nserial number:" + String.valueOf(x509Certificate.getSerialNumber()) + "\nsubject dn:" + x509Certificate.getSubjectDN().getName());
        }
        return x509Certificate;
    }

    private boolean certValidation(X509Certificate x509Certificate) {
        try {
            debug.message("inside certValidation");
            CryptoManager cryptoManager = CryptoManager.getInstance();
            if (cryptoManager.isCertValid(x509Certificate.getEncoded(), true, CryptoManager.CertUsage.SSLClient)) {
                debug.message("cert is valid");
                return true;
            }
            debug.message("cert is not valid");
            return false;
        }
        catch (Exception exception) {
            debug.message("certValidation failed with exception", (Throwable)exception);
            return false;
        }
    }
}

