/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.modules.anonymous;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.Misc;
import com.sun.identity.authentication.modules.anonymous.AnonymousAuthPrincipal;
import com.sun.identity.authentication.service.PagePropertiesCallback;
import com.sun.identity.authentication.spi.AMLoginModule;
import com.sun.identity.authentication.spi.AuthLoginException;
import java.io.IOException;
import java.security.Principal;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class Anonymous
extends AMLoginModule {
    private ResourceBundle bundle = null;
    private static Debug debug = null;
    private static final int DEFAULT_ANONYMOUS_AUTH_LEVEL = 0;
    private static final String amAuthAnonymous = "amAuthAnonymous";
    private String userTokenId;
    private String defaultAnonUser;
    private Set validAnonUsernames;
    private int authLevel;
    private String errorMsg = null;
    private String usernameParam = null;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private final int FINISHED = -1;
    private String username;
    private AnonymousAuthPrincipal userPrincipal;
    private CallbackHandler callbackHandler;
    private boolean isCaseSensitive = false;
    private static final String sccsID = "$Id: Anonymous.java,v 1.31 2003/09/12 00:57:15 binlu Exp $ Sun Microsystems, Inc.";

    public void init(Subject subject, Map map, Map map2) {
        if (debug == null) {
            debug = Debug.getInstance((String)amAuthAnonymous);
        }
        Locale locale = this.getLoginLocale();
        this.bundle = AMLoginModule.amCache.getResBundle(amAuthAnonymous, locale);
        if (debug.messageEnabled()) {
            debug.message("Anonymous resbundle locale=" + locale);
        }
        try {
            this.validAnonUsernames = (Set)map2.get("iplanet-am-auth-anonymous-users-list");
            if (this.validAnonUsernames == null) {
                debug.error("No Anonymous Service Template Created");
                this.errorMsg = "AnonValidateEx";
            }
            this.defaultAnonUser = Misc.getMapAttr((Map)map2, (String)"iplanet-am-auth-anonymous-default-user-name");
            String string = Misc.getMapAttr((Map)map2, (String)"iplanet-am-auth-anonymous-auth-level");
            if (string == null || string.equals("")) {
                this.authLevel = 0;
            } else {
                try {
                    this.authLevel = Integer.parseInt(string);
                }
                catch (Exception exception) {
                    debug.error("Invalid auth level " + string);
                    this.authLevel = 0;
                }
            }
            this.callbackHandler = this.getCallbackHandler();
            this.isCaseSensitive = Boolean.valueOf(Misc.getMapAttr((Map)map2, (String)"iplanet-am-auth-anonymous-case-sensitive", (String)"false"));
            if (debug.messageEnabled()) {
                debug.message("isCaseSensitive: " + this.isCaseSensitive);
            }
        }
        catch (Exception exception) {
            if (debug.messageEnabled()) {
                debug.message("possible exception is ", (Throwable)exception);
            }
            debug.error("Failed getting anonymous attributes for organization ");
            this.errorMsg = "AnonValidateEx";
        }
    }

    public int process(Callback[] callbackArray, int n) throws AuthLoginException {
        if (this.errorMsg != null) {
            throw new AuthLoginException(amAuthAnonymous, this.errorMsg, null);
        }
        try {
            this.usernameParam = this.validAnonUsernames != null && !this.validAnonUsernames.isEmpty() ? this.sendCallback() : this.defaultAnonUser;
            if (this.usernameParam == null || this.usernameParam.equals("")) {
                debug.message("User Name entered is either NULL or Empty");
                throw new AuthLoginException(amAuthAnonymous, "UserError", null);
            }
            if (this.usernameParam.equalsIgnoreCase(this.defaultAnonUser)) {
                debug.message("User Type: default Anon User");
                if (this.isCaseSensitive && !this.usernameParam.equals(this.defaultAnonUser)) {
                    this.setFailureID(this.usernameParam);
                    throw new AuthLoginException(amAuthAnonymous, "AnonValidateEx", null);
                }
                this.userTokenId = this.usernameParam;
            } else if (this.validAnonUsernames != null && this.isValidAnonUserName()) {
                debug.message("user is in anonymoususer's list");
                debug.message("UserType: non default Anon User");
                this.userTokenId = this.usernameParam;
            } else {
                this.setFailureID(this.usernameParam);
                throw new AuthLoginException(amAuthAnonymous, "AnonValidateEx", null);
            }
            this.setAuthLevel(this.authLevel);
            if (debug.messageEnabled()) {
                debug.message("Set auth level: " + this.authLevel + "\nAnonymous userid: " + this.userTokenId);
            }
        }
        catch (Exception exception) {
            debug.error("login: User not found in valid Anon List");
            this.setFailureID(this.usernameParam);
            throw new AuthLoginException(amAuthAnonymous, "AnonValidateEx", null);
        }
        return -1;
    }

    private boolean isValidAnonUserName() {
        if (this.isCaseSensitive) {
            return this.validAnonUsernames.contains(this.usernameParam);
        }
        Iterator iterator = this.validAnonUsernames.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            if (string == null || !string.equalsIgnoreCase(this.usernameParam)) continue;
            this.usernameParam = string;
            return true;
        }
        return false;
    }

    public Principal getPrincipal() {
        if (this.userPrincipal != null) {
            return this.userPrincipal;
        }
        if (this.userTokenId != null) {
            this.userPrincipal = new AnonymousAuthPrincipal(this.userTokenId);
            return this.userPrincipal;
        }
        return null;
    }

    private String sendCallback() throws AuthLoginException {
        if (this.callbackHandler == null) {
            throw new AuthLoginException(amAuthAnonymous, "NoCallbackHandler", null);
        }
        String string = null;
        try {
            Callback[] callbackArray = new Callback[2];
            String string2 = this.bundle.getString("moduleHeader");
            PagePropertiesCallback pagePropertiesCallback = new PagePropertiesCallback(null, string2, null, 0, null, false, null);
            callbackArray[0] = pagePropertiesCallback;
            callbackArray[1] = new NameCallback(this.bundle.getString("username"));
            if (debug.messageEnabled()) {
                debug.message("Callback 0 is.. :" + callbackArray[0]);
                debug.message("Callback 1 is.. :" + callbackArray[1]);
            }
            this.callbackHandler.handle(callbackArray);
            string = ((NameCallback)callbackArray[1]).getName();
            return string;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            debug.message("message type missing");
            throw new AuthLoginException(amAuthAnonymous, "IllegalArgs", null);
        }
        catch (IOException iOException) {
            throw new AuthLoginException(iOException);
        }
        catch (UnsupportedCallbackException unsupportedCallbackException) {
            throw new AuthLoginException(amAuthAnonymous, "NoCallbackHandler", null);
        }
    }
}

