/*
 * Decompiled with CFR 0.152.
 */
package com.sun.identity.authentication.internal;

import com.sun.identity.authentication.internal.AuthSubject;
import com.sun.identity.authentication.internal.LoginModule;
import java.util.HashMap;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;

public class LoginContext {
    private AuthSubject subject;
    private CallbackHandler cbHandler;
    private String organization;
    private LoginModule module;
    public static final String LDAP_AUTH_URL = "ldap://";
    public static final String LDAPS_AUTH_URL = "ldaps://";
    public static final String ORGNAME = "ORGANIZATION";
    public static final String PASSWORD = "PASSWORD";
    private static final String GRAPPA_LOGIN_MODULE = "com.sun.identity.authentication.internal.server.LocalLdapAuthModule";
    private static final String DPRO_LOGIN_MODULE = "com.iplanet.dpro.auth.drpoAuthModule";

    protected LoginContext(String string, CallbackHandler callbackHandler) throws LoginException {
        this.organization = string;
        this.subject = new AuthSubject();
        this.cbHandler = callbackHandler;
    }

    protected LoginContext(String string, AuthSubject authSubject, CallbackHandler callbackHandler) throws LoginException {
        this.organization = string;
        this.subject = authSubject;
        this.cbHandler = callbackHandler;
    }

    protected AuthSubject getSubject() {
        return this.subject;
    }

    protected void login() throws LoginException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (this.organization != null) {
            hashMap.put(ORGNAME, this.organization);
        }
        this.module = null;
        try {
            this.module = this.organization != null && (this.organization.toLowerCase().startsWith(LDAP_AUTH_URL) || this.organization.toLowerCase().startsWith(LDAPS_AUTH_URL)) ? this.getGrappaLoginModule() : this.getDproLoginModule();
        }
        catch (Exception exception) {
            try {
                this.module = this.getGrappaLoginModule();
            }
            catch (Exception exception2) {
                throw new LoginException(exception.getMessage() + exception2.getMessage());
            }
        }
        this.module.initialize(this.subject, this.cbHandler, null, hashMap);
        try {
            this.module.login();
        }
        catch (LoginException loginException) {
            this.module.abort();
            throw loginException;
        }
        this.module.commit();
    }

    protected LoginModule getDproLoginModule() throws Exception {
        return (LoginModule)Class.forName(DPRO_LOGIN_MODULE).newInstance();
    }

    protected LoginModule getGrappaLoginModule() throws Exception {
        return (LoginModule)Class.forName(GRAPPA_LOGIN_MODULE).newInstance();
    }

    protected void logout() throws LoginException {
        this.module.logout();
    }
}

