/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.schema;

import com.netscape.jndi.ldap.schema.SchemaElement;
import com.netscape.jndi.ldap.schema.SchemaManager;
import java.io.Serializable;
import java.util.Vector;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.ModificationItem;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPMatchingRuleSchema;
import netscape.ldap.LDAPSchemaElement;

public class SchemaMatchingRule
extends SchemaElement {
    private static final String APPLIES = "APPLIES";
    LDAPMatchingRuleSchema m_ldapMatchingRule;
    private static String[] m_allAttrIds = new String[]{"NUMERICOID", "NAME", "DESC", "OBSOLETE", "SYNTAX", "APPLIES"};
    LDAPConnection m_ld;

    public SchemaMatchingRule(Attributes attributes, SchemaManager schemaManager) throws NamingException {
        super(schemaManager);
        this.m_ldapMatchingRule = SchemaMatchingRule.parseDefAttributes(attributes);
        this.m_path = "AttributeDefinition/" + this.m_ldapMatchingRule.getName();
    }

    public SchemaMatchingRule(LDAPMatchingRuleSchema lDAPMatchingRuleSchema, SchemaManager schemaManager) {
        super(schemaManager);
        this.m_ldapMatchingRule = lDAPMatchingRuleSchema;
        this.m_path = "AttributeDefinition/" + this.m_ldapMatchingRule.getName();
    }

    Attributes extractAttributeIds(String[] stringArray) throws NamingException {
        BasicAttributes basicAttributes = new BasicAttributes();
        String string = null;
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].equals("NUMERICOID")) {
                string = this.m_ldapMatchingRule.getID();
                if (string != null) {
                    basicAttributes.put(new BasicAttribute("NUMERICOID", string));
                }
            } else if (stringArray[n].equals("NAME")) {
                string = this.m_ldapMatchingRule.getName();
                if (string != null) {
                    basicAttributes.put(new BasicAttribute("NAME", string));
                }
            } else if (stringArray[n].equals("DESC")) {
                string = this.m_ldapMatchingRule.getDescription();
                if (string != null) {
                    basicAttributes.put(new BasicAttribute("DESC", string));
                }
            } else if (stringArray[n].equals("SYNTAX")) {
                string = this.m_ldapMatchingRule.getSyntaxString();
                if (string != null) {
                    basicAttributes.put(new BasicAttribute("SYNTAX", string));
                }
            } else if (stringArray[n].equals(APPLIES)) {
                String[] stringArray2 = this.m_ldapMatchingRule.getAttributes();
                if (stringArray2 != null && stringArray2.length > 0) {
                    BasicAttribute basicAttribute = new BasicAttribute(APPLIES);
                    int n2 = 0;
                    while (n2 < stringArray2.length) {
                        basicAttribute.add(stringArray2[n2]);
                        ++n2;
                    }
                    basicAttributes.put(basicAttribute);
                }
            } else if (stringArray[n].equals("OBSOLETE")) {
                if (this.m_ldapMatchingRule.getQualifier("OBSOLETE") != null) {
                    basicAttributes.put(new BasicAttribute("OBSOLETE", "true"));
                }
            } else {
                throw new NamingException("Invalid schema attribute type for matching rule definition " + stringArray[n]);
            }
            ++n;
        }
        return basicAttributes;
    }

    public Attributes getAttributes(String string) throws NamingException {
        if (string.length() != 0) {
            throw new NameNotFoundException(string);
        }
        return this.extractAttributeIds(m_allAttrIds);
    }

    public Attributes getAttributes(String string, String[] stringArray) throws NamingException {
        if (string.length() != 0) {
            throw new NameNotFoundException(string);
        }
        return this.extractAttributeIds(stringArray);
    }

    public Attributes getAttributes(Name name) throws NamingException {
        return this.getAttributes(name.toString());
    }

    public Attributes getAttributes(Name name, String[] stringArray) throws NamingException {
        return this.getAttributes(name.toString(), stringArray);
    }

    public void modifyAttributes(String string, int n, Attributes attributes) throws NamingException {
        if (string.length() != 0) {
            throw new NameNotFoundException(string);
        }
        Attributes attributes2 = this.extractAttributeIds(m_allAttrIds);
        this.modifySchemaElementAttrs(attributes2, n, attributes);
        LDAPMatchingRuleSchema lDAPMatchingRuleSchema = SchemaMatchingRule.parseDefAttributes(attributes2);
        this.m_schemaMgr.modifyMatchingRule(this.m_ldapMatchingRule, lDAPMatchingRuleSchema);
        this.m_ldapMatchingRule = lDAPMatchingRuleSchema;
    }

    public void modifyAttributes(String string, ModificationItem[] modificationItemArray) throws NamingException {
        if (string.length() != 0) {
            throw new NameNotFoundException(string);
        }
        Attributes attributes = this.extractAttributeIds(m_allAttrIds);
        this.modifySchemaElementAttrs(attributes, modificationItemArray);
        LDAPMatchingRuleSchema lDAPMatchingRuleSchema = SchemaMatchingRule.parseDefAttributes(attributes);
        this.m_schemaMgr.modifyMatchingRule(this.m_ldapMatchingRule, lDAPMatchingRuleSchema);
        this.m_ldapMatchingRule = lDAPMatchingRuleSchema;
    }

    public void modifyAttributes(Name name, int n, Attributes attributes) throws NamingException {
        this.modifyAttributes(name.toString(), n, attributes);
    }

    public void modifyAttributes(Name name, ModificationItem[] modificationItemArray) throws NamingException {
        this.modifyAttributes(name.toString(), modificationItemArray);
    }

    static LDAPMatchingRuleSchema parseDefAttributes(Attributes attributes) throws NamingException {
        Serializable serializable;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        boolean bl = false;
        Vector<String> vector = new Vector<String>();
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        while (namingEnumeration.hasMoreElements()) {
            serializable = (Attribute)namingEnumeration.nextElement();
            String string5 = serializable.getID();
            if (string5.equals("NAME")) {
                string = SchemaElement.getSchemaAttrValue((Attribute)serializable);
                continue;
            }
            if (string5.equals("NUMERICOID")) {
                string2 = SchemaElement.getSchemaAttrValue((Attribute)serializable);
                continue;
            }
            if (string5.equals("SYNTAX")) {
                string4 = SchemaElement.getSchemaAttrValue((Attribute)serializable);
                continue;
            }
            if (string5.equals("DESC")) {
                string3 = SchemaElement.getSchemaAttrValue((Attribute)serializable);
                continue;
            }
            if (string5.equals(APPLIES)) {
                NamingEnumeration<?> namingEnumeration2 = serializable.getAll();
                while (namingEnumeration2.hasMoreElements()) {
                    vector.addElement((String)namingEnumeration2.nextElement());
                }
                continue;
            }
            if (string5.equals("OBSOLETE")) {
                bl = SchemaElement.parseTrueFalseValue((Attribute)serializable);
                continue;
            }
            throw new NamingException("Invalid schema attribute type for matching rule definition " + string5);
        }
        serializable = new LDAPMatchingRuleSchema(string, string2, string3, SchemaElement.vectorToStringAry(vector), string4);
        if (bl) {
            ((LDAPSchemaElement)serializable).setQualifier("OBSOLETE", "");
        }
        return serializable;
    }
}

