/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.jndi.ldap.controls;

import com.netscape.jndi.ldap.common.ExceptionMapper;
import com.netscape.jndi.ldap.controls.LdapEntryChangeControl;
import com.netscape.jndi.ldap.controls.LdapPasswordExpiredControl;
import com.netscape.jndi.ldap.controls.LdapPasswordExpiringControl;
import com.netscape.jndi.ldap.controls.LdapSortResponseControl;
import com.netscape.jndi.ldap.controls.LdapVirtualListResponseControl;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.ControlFactory;
import netscape.ldap.LDAPControl;

public class NetscapeControlFactory
extends ControlFactory {
    static final String REQ_SORT = "1.2.840.113556.1.4.473";
    static final String RSP_SORT = "1.2.840.113556.1.4.474";
    static final String REQ_MANAGEDSAIT = "2.16.840.1.113730.3.4.2";
    static final String REQ_PERSISTENTSEARCH = "2.16.840.1.113730.3.4.3";
    static final String RSP_PWDEXPIRED = "2.16.840.1.113730.3.4.4";
    static final String RSP_PWDEXPIRING = "2.16.840.1.113730.3.4.5";
    static final String RSP_ENTRYCHANGED = "2.16.840.1.113730.3.4.7";
    static final String REQ_VIRTUALLIST = "2.16.840.1.113730.3.4.9";
    static final String RSP_VIRTUALLIST = "2.16.840.1.113730.3.4.10";
    static final String REQ_PROXIEDAUTH = "2.16.840.1.113730.3.4.12";

    public Control getControlInstance(Control control) throws NamingException {
        if (control == null) {
            return null;
        }
        LDAPControl lDAPControl = new LDAPControl(control.getID(), control.isCritical(), control.getEncodedValue());
        return NetscapeControlFactory.getControlInstance(lDAPControl);
    }

    public static Control getControlInstance(LDAPControl lDAPControl) throws NamingException {
        if (lDAPControl == null) {
            return null;
        }
        try {
            String string = lDAPControl.getID();
            if (string.equals(RSP_ENTRYCHANGED)) {
                return new LdapEntryChangeControl(lDAPControl.isCritical(), lDAPControl.getValue());
            }
            if (string.equals(RSP_PWDEXPIRED)) {
                return new LdapPasswordExpiredControl(lDAPControl.isCritical(), lDAPControl.getValue());
            }
            if (string.equals(RSP_PWDEXPIRING)) {
                return new LdapPasswordExpiringControl(lDAPControl.isCritical(), lDAPControl.getValue());
            }
            if (string.equals(RSP_SORT)) {
                return new LdapSortResponseControl(lDAPControl.isCritical(), lDAPControl.getValue());
            }
            if (string.equals(RSP_VIRTUALLIST)) {
                return new LdapVirtualListResponseControl(lDAPControl.isCritical(), lDAPControl.getValue());
            }
            return null;
        }
        catch (Exception exception) {
            throw ExceptionMapper.getNamingException(exception);
        }
    }
}

