/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums.validation;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.ldap.ModSet;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.Guid;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.validation.DataConstraintException;
import com.iplanet.ums.validation.IValidator;
import com.iplanet.ums.validation.ValidationElement;
import java.util.Enumeration;
import netscape.ldap.LDAPModification;

public class Validation {
    private static I18n i18n = I18n.getInstance((String)"amSDK");

    public static void validateAttribute(Attr attr, String string, String string2) throws UMSException, DataConstraintException {
        if (attr != null) {
            String[] stringArray = attr.getStringValues();
            int n = 0;
            while (n < stringArray.length) {
                String string3 = stringArray[n];
                if (string3 != null && !string3.equalsIgnoreCase("") && string != null) {
                    Object object;
                    IValidator iValidator = null;
                    try {
                        object = Class.forName(string);
                        iValidator = (IValidator)((Class)object).newInstance();
                    }
                    catch (Exception exception) {
                        throw new UMSException(i18n.getString("ums-instancefailed"), exception);
                    }
                    if (!iValidator.validate(string3, string2)) {
                        object = i18n.getString("validation-dataconstraint");
                        throw new DataConstraintException((String)object + ": " + "{ type=" + attr.getName() + ", value=" + string3 + " }");
                    }
                }
                ++n;
            }
        }
    }

    public static void validateAttribute(Attr attr, Class clazz, Guid guid) throws UMSException, DataConstraintException {
        if (attr == null) {
            return;
        }
        String string = null;
        String string2 = null;
        String string3 = attr.getName();
        CreationTemplate creationTemplate = TemplateManager.getTemplateManager().getCreationTemplate(clazz, guid);
        if (creationTemplate != null) {
            Enumeration enumeration = creationTemplate.getValidation(string3);
            while (enumeration.hasMoreElements()) {
                ValidationElement validationElement = (ValidationElement)enumeration.nextElement();
                string = validationElement.getValidator();
                string2 = validationElement.getRule();
                if (string == null) continue;
                Validation.validateAttribute(attr, string, string2);
            }
        }
    }

    public static void validateAttributes(AttrSet attrSet, Class clazz, Guid guid) throws UMSException, DataConstraintException {
        if (attrSet == null) {
            return;
        }
        String[] stringArray = attrSet.getAttributeNames();
        int n = 0;
        while (n < stringArray.length) {
            Attr attr = attrSet.getAttribute(stringArray[n]);
            Validation.validateAttribute(attr, clazz, guid);
            ++n;
        }
    }

    public static void validateAttributes(ModSet modSet, Class clazz, Guid guid) throws UMSException, DataConstraintException {
        if (modSet == null) {
            return;
        }
        int n = 0;
        while (n < modSet.size()) {
            LDAPModification lDAPModification = modSet.elementAt(n);
            if (lDAPModification.getOp() != 1) {
                Attr attr = new Attr(lDAPModification.getAttribute());
                Validation.validateAttribute(attr, clazz, guid);
            }
            ++n;
        }
    }
}

