/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.ums.DataLayer;
import com.iplanet.ums.Guid;
import com.iplanet.ums.Organization;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.UMSObject;
import com.iplanet.ums.User;
import java.io.Serializable;
import java.security.Principal;
import java.util.Enumeration;
import netscape.ldap.LDAPDN;

class PCMappingTable
implements Serializable {
    private Principal _principal;
    private Guid _mappingGuid;
    private static final String[] ATTRNAMESTOSKIP = new String[]{"ou", "objectclass", "default"};
    private static final String MAPPINGTABLE_ENTRYNAME = "pcmappingtable";
    private static final String DEFAULT_PC_ATTRNAME = "default";

    protected PCMappingTable(Principal principal, Guid guid) throws UMSException {
        this._principal = principal;
        this._mappingGuid = guid;
    }

    public static PCMappingTable getPCMappingTable(Organization organization) throws UMSException {
        Object object;
        PersistentObject persistentObject = null;
        SearchResults searchResults = organization.getChildren("ou=pcmappingtable", null);
        if (searchResults.hasMoreElements()) {
            persistentObject = searchResults.next();
        } else {
            persistentObject = new PersistentObject();
            persistentObject.setAttribute(new Attr("objectclass", new String[]{"top", "extensibleobject"}));
            persistentObject.setAttribute(new Attr("ou", MAPPINGTABLE_ENTRYNAME));
            object = new Guid("ou=pcmappingtable," + organization.getGuid().getDn());
            persistentObject.setGuid((Guid)object);
            organization.addChild(persistentObject);
        }
        searchResults.abandon();
        object = new PCMappingTable(organization.getPrincipal(), persistentObject.getGuid());
        return object;
    }

    public String getPeopleContainer(User user) throws UMSException {
        PersistentObject persistentObject = UMSObject.getObject(this._principal, this._mappingGuid);
        AttrSet attrSet = persistentObject.getAttrSet();
        String string = this.getDefault(attrSet);
        int n = 0;
        while (n < ATTRNAMESTOSKIP.length) {
            attrSet.remove(ATTRNAMESTOSKIP[n]);
            ++n;
        }
        Enumeration enumeration = attrSet.getAttributes();
        while (enumeration.hasMoreElements()) {
            Attr attr = (Attr)enumeration.nextElement();
            String string2 = attr.getName();
            String[] stringArray = attr.getStringValues();
            int n2 = 0;
            while (n2 < stringArray.length) {
                AttrSet attrSet2 = this.getAttrSetFromFilter(stringArray[n2]);
                Enumeration enumeration2 = attrSet2.getAttributes();
                while (enumeration2.hasMoreElements()) {
                    Attr attr2 = (Attr)enumeration2.nextElement();
                    Attr attr3 = user.getAttribute(attr2.getName());
                    if (attr3 == null) continue;
                    String[] stringArray2 = attr2.getStringValues();
                    int n3 = 0;
                    while (n3 < stringArray2.length) {
                        if (attr3.contains(stringArray2[n3])) {
                            return string2;
                        }
                        ++n3;
                    }
                }
                ++n2;
            }
        }
        return string;
    }

    public void addRule(Guid guid, String string) throws UMSException {
        DataLayer.getInstance().addAttributeValue(this._principal, this._mappingGuid, LDAPDN.normalize(guid.getDn()), string);
    }

    public void removeRule(Guid guid, String string) throws UMSException {
        DataLayer.getInstance().removeAttributeValue(this._principal, this._mappingGuid, LDAPDN.normalize(guid.getDn()), string);
    }

    public void setDefault(Guid guid) throws UMSException {
        DataLayer.getInstance().addAttributeValue(this._principal, this._mappingGuid, DEFAULT_PC_ATTRNAME, guid.getDn());
    }

    private String getDefault(AttrSet attrSet) {
        Attr attr = attrSet.getAttribute(DEFAULT_PC_ATTRNAME);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    private AttrSet getAttrSetFromFilter(String string) {
        AttrSet attrSet = new AttrSet();
        String string2 = new String(string);
        string2.trim();
        if (string2.startsWith("(") && string2.endsWith(")")) {
            string2 = string2.substring(1, string2.length() - 1);
        }
        if (string2.startsWith("|") || string2.startsWith("!")) {
            return null;
        }
        if (string2.startsWith("&")) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            while (n4 < string2.length()) {
                if (string2.charAt(n4) == '(') {
                    if (n == 0) {
                        n2 = n4;
                    }
                    ++n;
                }
                if (string2.charAt(n4) == ')' && --n == 0) {
                    int n5;
                    n3 = n4;
                    String string3 = string2.substring(n2, n3 + 1);
                    if (string3.startsWith("(") && string3.endsWith(")")) {
                        string3 = string3.substring(1, string3.length() - 1);
                    }
                    if ((n5 = string3.indexOf(61)) == -1) {
                        return null;
                    }
                    String string4 = string3.substring(0, n5).trim();
                    String string5 = string3.substring(n5 + 1).trim();
                    attrSet.add(new Attr(string4, string5));
                }
                ++n4;
            }
        } else {
            int n = string2.indexOf(61);
            if (n == -1) {
                return null;
            }
            String string6 = string2.substring(0, n).trim();
            String string7 = string2.substring(n + 1).trim();
            attrSet.add(new Attr(string6, string7));
        }
        return attrSet;
    }
}

