/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.am.util.Debug;
import com.iplanet.am.util.SystemProperties;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.ldap.LDAPServiceException;
import com.iplanet.services.ldap.LDAPUser;
import com.iplanet.services.ldap.ModSet;
import com.iplanet.services.ldap.ServerInstance;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.AccessRightsException;
import com.iplanet.ums.EntryAlreadyExistsException;
import com.iplanet.ums.EntryNotFoundException;
import com.iplanet.ums.Guid;
import com.iplanet.ums.InvalidSearchFilterException;
import com.iplanet.ums.SchemaElementAlreadyExistsException;
import com.iplanet.ums.SearchControl;
import com.iplanet.ums.SearchResults;
import com.iplanet.ums.SizeLimitExceededException;
import com.iplanet.ums.SortKey;
import com.iplanet.ums.TimeLimitExceededException;
import com.iplanet.ums.UMSException;
import com.sun.identity.security.ServerInstanceAction;
import java.io.Serializable;
import java.security.AccessController;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import netscape.ldap.LDAPAttribute;
import netscape.ldap.LDAPAttributeSet;
import netscape.ldap.LDAPBind;
import netscape.ldap.LDAPConnection;
import netscape.ldap.LDAPControl;
import netscape.ldap.LDAPEntry;
import netscape.ldap.LDAPException;
import netscape.ldap.LDAPSchema;
import netscape.ldap.LDAPSchemaElement;
import netscape.ldap.LDAPSearchConstraints;
import netscape.ldap.LDAPSearchResults;
import netscape.ldap.LDAPSortKey;
import netscape.ldap.controls.LDAPProxiedAuthControl;
import netscape.ldap.controls.LDAPSortControl;
import netscape.ldap.controls.LDAPVirtualListControl;
import netscape.ldap.util.ConnectionPool;

public class DataLayer
implements Serializable {
    private static Debug debug;
    private static I18n i18n;
    static final int MAX_CONN = 20;
    static final int MAX_BACKLOG = 100;
    static final String LDAP_MAXBACKLOG = "maxbacklog";
    static final String LDAP_RELEASECONNBEFORESEARCH = "releaseconnectionbeforesearchcompletes";
    static final String LDAP_REFERRAL = "referral";
    private static int replicaRetryNum;
    private static long replicaRetryInterval;
    private static final String LDAP_CONNECTION_NUM_RETRIES = "com.iplanet.am.ldap.connection.num.retries";
    private static final String LDAP_CONNECTION_RETRY_INTERVAL = "com.iplanet.am.ldap.connection.delay.between.retries";
    private static final String LDAP_CONNECTION_ERROR_CODES = "com.iplanet.am.ldap.connection.ldap.error.codes.retries";
    private static int connNumRetry;
    private static int connRetryInterval;
    private static HashSet retryErrorCodes;
    private static ConnectionPool _ldapPool;
    private static LDAPConnection _trialConn;
    private static LDAPSearchConstraints _defaultSearchConstraints;
    private static DataLayer m_instance;
    private String m_host = null;
    private int m_port;
    private String m_proxyUser = "";
    private String m_proxyPassword = "";
    private boolean m_releaseConnectionBeforeSearchCompletes = false;
    private static final String[] EMPTY_STRING_ARRAY;

    private DataLayer() {
    }

    private DataLayer(String string, String string2, String string3, int n) {
        this.m_proxyUser = string;
        this.m_proxyPassword = string2;
        this.m_host = string3;
        this.m_port = n;
        this.initReplicaProperties();
        this.initLdapPool();
    }

    public static synchronized DataLayer getInstance(ServerInstance serverInstance) {
        if (m_instance == null) {
            String string = "localhost";
            int n = 389;
            String string2 = "";
            String string3 = "";
            if (serverInstance != null) {
                string = serverInstance.getServerName();
                n = serverInstance.getPort();
                string2 = serverInstance.getAuthID();
                string3 = (String)AccessController.doPrivileged(new ServerInstanceAction(serverInstance));
            }
            m_instance = new DataLayer(string2, string3, string, n);
        }
        return m_instance;
    }

    public static DataLayer getInstance() {
        if (m_instance == null) {
            try {
                DSConfigMgr dSConfigMgr = DSConfigMgr.getDSConfigMgr();
                ServerInstance serverInstance = dSConfigMgr.getServerInstance(LDAPUser.Type.AUTH_PROXY);
                m_instance = DataLayer.getInstance(serverInstance);
            }
            catch (LDAPServiceException lDAPServiceException) {
                debug.error("Error:  Unable to get server config instance " + lDAPServiceException.getMessage());
                lDAPServiceException.printStackTrace();
            }
        }
        return m_instance;
    }

    public LDAPConnection getConnection(Principal principal) {
        if (_ldapPool == null) {
            return null;
        }
        if (debug.messageEnabled()) {
            debug.message("Invoking _ldapPool.getConnection()");
        }
        LDAPConnection lDAPConnection = _ldapPool.getConnection();
        if (debug.messageEnabled()) {
            debug.message("Got Connection : " + lDAPConnection);
        }
        LDAPProxiedAuthControl lDAPProxiedAuthControl = new LDAPProxiedAuthControl(principal.getName(), true);
        LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
        lDAPSearchConstraints.setServerControls(lDAPProxiedAuthControl);
        lDAPConnection.setSearchConstraints(lDAPSearchConstraints);
        return lDAPConnection;
    }

    public void releaseConnection(LDAPConnection lDAPConnection) {
        if (_ldapPool == null || lDAPConnection == null) {
            return;
        }
        lDAPConnection.setSearchConstraints(_defaultSearchConstraints);
        if (debug.messageEnabled()) {
            debug.message("Invoking _ldapPool.close(conn) : " + lDAPConnection);
        }
        _ldapPool.close(lDAPConnection);
        if (debug.messageEnabled()) {
            debug.message("Released Connection : " + lDAPConnection);
        }
    }

    public String[] getAttributeString(Principal principal, Guid guid, String string) {
        LDAPConnection lDAPConnection = null;
        String string2 = guid.getDn();
        try {
            try {
                lDAPConnection = this.getConnection(principal);
                LDAPEntry lDAPEntry = this.readLDAPEntry(lDAPConnection, string2, null);
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
                String[] stringArray = lDAPAttribute.getStringValueArray();
                Object var10_11 = null;
                this.releaseConnection(lDAPConnection);
                return stringArray;
            }
            catch (Exception exception) {
                if (debug.warningEnabled()) {
                    debug.warning("Exception in DataLayer.getAttributeString for DN: " + string2, (Throwable)exception);
                }
                String[] stringArray = null;
                Object var10_12 = null;
                this.releaseConnection(lDAPConnection);
                return stringArray;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.releaseConnection(lDAPConnection);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Attr getAttribute(Principal principal, Guid guid, String string) {
        Attr attr;
        LDAPConnection lDAPConnection = null;
        String string2 = guid.getDn();
        try {
            try {
                String[] stringArray = new String[]{string};
                lDAPConnection = this.getConnection(principal);
                LDAPEntry lDAPEntry = this.readLDAPEntry(lDAPConnection, string2, stringArray);
                LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string);
                if (lDAPAttribute == null) {
                    Attr attr2 = null;
                    Object var11_13 = null;
                    this.releaseConnection(lDAPConnection);
                    return attr2;
                }
                attr = new Attr(lDAPAttribute);
            }
            catch (Exception exception) {
                if (debug.warningEnabled()) {
                    debug.warning("Exception in DataLayer.getAttribute for DN: " + string2, (Throwable)exception);
                }
                Attr attr3 = null;
                Object var11_15 = null;
                this.releaseConnection(lDAPConnection);
                return attr3;
            }
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            this.releaseConnection(lDAPConnection);
            throw throwable;
        }
        Object var11_14 = null;
        this.releaseConnection(lDAPConnection);
        return attr;
    }

    public Collection getAttributes(Principal principal, Guid guid, Collection collection) {
        ArrayList<Attr> arrayList = new ArrayList<Attr>();
        LDAPConnection lDAPConnection = null;
        String string = guid.getDn();
        try {
            try {
                lDAPConnection = this.getConnection(principal);
                LDAPEntry lDAPEntry = this.readLDAPEntry(lDAPConnection, string, collection.toArray(EMPTY_STRING_ARRAY));
                if (lDAPEntry == null) {
                    debug.warning("No attributes returned may not have permission to read");
                    Set set = Collections.EMPTY_SET;
                    Object var12_12 = null;
                    this.releaseConnection(lDAPConnection);
                    return set;
                }
                Iterator iterator = collection.iterator();
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    LDAPAttribute lDAPAttribute = lDAPEntry.getAttribute(string2);
                    if (lDAPAttribute == null) continue;
                    arrayList.add(new Attr(lDAPAttribute));
                }
            }
            catch (Exception exception) {
                if (debug.warningEnabled()) {
                    debug.warning("Exception in DataLayer.getAttributes for DN: " + string, (Throwable)exception);
                }
                Collection collection2 = null;
                Object var12_14 = null;
                this.releaseConnection(lDAPConnection);
                return collection2;
            }
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            this.releaseConnection(lDAPConnection);
            throw throwable;
        }
        Object var12_13 = null;
        this.releaseConnection(lDAPConnection);
        return arrayList;
    }

    public void addEntry(Principal principal, Guid guid, AttrSet attrSet) throws AccessRightsException, EntryAlreadyExistsException, UMSException {
        LDAPConnection lDAPConnection = null;
        String string = guid.getDn();
        try {
            try {
                lDAPConnection = this.getConnection(principal);
                int n = 0;
                while (n <= connNumRetry) {
                    if (debug.messageEnabled()) {
                        debug.message("DataLayer.addEntry retry: " + n);
                    }
                    try {
                        LDAPEntry lDAPEntry = new LDAPEntry(string, attrSet.toLDAPAttributeSet());
                        lDAPConnection.add(lDAPEntry);
                        Object var10_13 = null;
                        this.releaseConnection(lDAPConnection);
                        return;
                    }
                    catch (LDAPException lDAPException) {
                        if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n == connNumRetry) {
                            throw lDAPException;
                        }
                        ++n;
                        try {
                            Thread.currentThread();
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (LDAPException lDAPException) {
                if (debug.warningEnabled()) {
                    debug.warning("Exception in DataLayer.addEntry for DN: " + string, (Throwable)lDAPException);
                }
                int n = lDAPException.getLDAPResultCode();
                Object[] objectArray = new String[]{string};
                switch (n) {
                    case 68: {
                        throw new EntryAlreadyExistsException(i18n.getString("ums-entry_already_exists", objectArray), lDAPException);
                    }
                    case 50: {
                        throw new AccessRightsException(i18n.getString("ums-insufficient_access_add", objectArray), lDAPException);
                    }
                }
                throw new UMSException(i18n.getString("ums-unable_to_add_entry", objectArray), lDAPException);
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            this.releaseConnection(lDAPConnection);
            throw throwable;
        }
        Object var10_14 = null;
        this.releaseConnection(lDAPConnection);
    }

    public void deleteEntry(Principal principal, Guid guid) throws AccessRightsException, EntryNotFoundException, UMSException {
        if (guid == null) {
            String string = i18n.getString("ums-badid");
            throw new IllegalArgumentException(string);
        }
        LDAPConnection lDAPConnection = null;
        String string = guid.getDn();
        try {
            try {
                lDAPConnection = this.getConnection(principal);
                int n = 0;
                while (n <= connNumRetry) {
                    if (debug.messageEnabled()) {
                        debug.message("DataLayer.deleteEntry retry: " + n);
                    }
                    try {
                        lDAPConnection.delete(string);
                        Object var9_12 = null;
                        this.releaseConnection(lDAPConnection);
                        return;
                    }
                    catch (LDAPException lDAPException) {
                        if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n == connNumRetry) {
                            throw lDAPException;
                        }
                        ++n;
                        try {
                            Thread.currentThread();
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (LDAPException lDAPException) {
                debug.error("Exception in DataLayer.deleteEntry for DN: " + string, (Throwable)lDAPException);
                int n = lDAPException.getLDAPResultCode();
                Object[] objectArray = new String[]{string};
                switch (n) {
                    case 32: {
                        throw new EntryNotFoundException(i18n.getString("ums-entry_not_found", objectArray), lDAPException);
                    }
                    case 50: {
                        throw new AccessRightsException(i18n.getString("ums-insufficient_access_delete", objectArray), lDAPException);
                    }
                }
                throw new UMSException(i18n.getString("ums-unable_to_delete_entry", objectArray), lDAPException);
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            this.releaseConnection(lDAPConnection);
            throw throwable;
        }
        Object var9_13 = null;
        this.releaseConnection(lDAPConnection);
    }

    public AttrSet read(Principal principal, Guid guid) throws EntryNotFoundException, UMSException {
        return this.read(principal, guid, null);
    }

    public AttrSet read(Principal principal, Guid guid, String[] stringArray) throws EntryNotFoundException, UMSException {
        LDAPConnection lDAPConnection = null;
        String string = guid.getDn();
        LDAPEntry lDAPEntry = null;
        try {
            block9: {
                try {
                    lDAPConnection = this.getConnection(principal);
                    if (stringArray == null) {
                        lDAPEntry = this.readLDAPEntry(lDAPConnection, string, null);
                        break block9;
                    }
                    lDAPEntry = this.readLDAPEntry(lDAPConnection, string, stringArray);
                }
                catch (LDAPException lDAPException) {
                    if (debug.warningEnabled()) {
                        debug.warning("Exception in DataLayer.read for DN: " + string);
                        debug.warning("LDAPException: " + lDAPException);
                    }
                    int n = lDAPException.getLDAPResultCode();
                    Object[] objectArray = new String[]{string};
                    if (n == 32) {
                        throw new EntryNotFoundException(i18n.getString("ums-entry_not_found", objectArray), lDAPException);
                    }
                    throw new UMSException(i18n.getString("ums-unable_to_read_entry", objectArray), lDAPException);
                }
            }
            Object var11_7 = null;
            this.releaseConnection(lDAPConnection);
        }
        catch (Throwable throwable) {
            Object var11_8 = null;
            this.releaseConnection(lDAPConnection);
            throw throwable;
        }
        if (lDAPEntry == null) {
            throw new AccessRightsException(string);
        }
        LDAPAttributeSet lDAPAttributeSet = lDAPEntry.getAttributeSet();
        if (lDAPAttributeSet == null) {
            Object[] objectArray = new String[]{string};
            throw new EntryNotFoundException(i18n.getString("ums-entry_not_found", objectArray));
        }
        return new AttrSet(lDAPAttributeSet);
    }

    public void rename(Principal principal, Guid guid, String string, boolean bl) throws AccessRightsException, EntryNotFoundException, UMSException {
        LDAPConnection lDAPConnection = null;
        String string2 = guid.getDn();
        try {
            try {
                lDAPConnection = this.getConnection(principal);
                int n = 0;
                while (n <= connNumRetry) {
                    if (debug.messageEnabled()) {
                        debug.message("DataLayer.rename retry: " + n);
                    }
                    try {
                        lDAPConnection.rename(string2, string, bl);
                        Object var11_12 = null;
                        this.releaseConnection(lDAPConnection);
                        return;
                    }
                    catch (LDAPException lDAPException) {
                        if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n == connNumRetry) {
                            throw lDAPException;
                        }
                        ++n;
                        try {
                            Thread.currentThread();
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (LDAPException lDAPException) {
                if (debug.warningEnabled()) {
                    debug.warning("Exception in DataLayer.rename for DN: " + string2, (Throwable)lDAPException);
                }
                int n = lDAPException.getLDAPResultCode();
                switch (n) {
                    case 32: {
                        throw new EntryNotFoundException(string2, lDAPException);
                    }
                    case 50: {
                        throw new AccessRightsException(string2, lDAPException);
                    }
                }
                throw new UMSException(string2, lDAPException);
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            this.releaseConnection(lDAPConnection);
            throw throwable;
        }
        Object var11_13 = null;
        this.releaseConnection(lDAPConnection);
    }

    public void modify(Principal principal, Guid guid, ModSet modSet) throws AccessRightsException, EntryNotFoundException, UMSException {
        LDAPConnection lDAPConnection = null;
        String string = guid.getDn();
        try {
            try {
                lDAPConnection = this.getConnection(principal);
                int n = 0;
                while (n <= connNumRetry) {
                    if (debug.messageEnabled()) {
                        debug.message("DataLayer.modify retry: " + n);
                    }
                    try {
                        lDAPConnection.modify(string, modSet);
                        Object var10_11 = null;
                        this.releaseConnection(lDAPConnection);
                        return;
                    }
                    catch (LDAPException lDAPException) {
                        if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n == connNumRetry) {
                            throw lDAPException;
                        }
                        ++n;
                        try {
                            Thread.currentThread();
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (LDAPException lDAPException) {
                if (debug.warningEnabled()) {
                    debug.warning("Exception in DataLayer.modify for DN: " + string, (Throwable)lDAPException);
                }
                int n = lDAPException.getLDAPResultCode();
                switch (n) {
                    case 32: {
                        throw new EntryNotFoundException(string, lDAPException);
                    }
                    case 50: {
                        throw new AccessRightsException(string, lDAPException);
                    }
                }
                throw new UMSException(string, lDAPException);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            this.releaseConnection(lDAPConnection);
            throw throwable;
        }
        Object var10_12 = null;
        this.releaseConnection(lDAPConnection);
    }

    public void addAttributeValue(Principal principal, Guid guid, String string, String string2) throws UMSException {
        ModSet modSet = new ModSet();
        modSet.add(0, new LDAPAttribute(string, string2));
        this.modify(principal, guid, modSet);
    }

    public void removeAttributeValue(Principal principal, Guid guid, String string, String string2) throws UMSException {
        ModSet modSet = new ModSet();
        modSet.add(1, new LDAPAttribute(string, string2));
        this.modify(principal, guid, modSet);
    }

    private LDAPConnection getSearchConnection(Principal principal, SearchControl searchControl) {
        LDAPConnection lDAPConnection = this.getConnection(principal);
        if (searchControl != null) {
            int[] nArray = searchControl.getVLVRange();
            SortKey[] sortKeyArray = searchControl.getSortKeys();
            ArrayList<LDAPControl> arrayList = new ArrayList<LDAPControl>();
            if (sortKeyArray != null) {
                LDAPSortKey[] lDAPSortKeyArray = new LDAPSortKey[sortKeyArray.length];
                int n = 0;
                while (n < lDAPSortKeyArray.length) {
                    lDAPSortKeyArray[n] = new LDAPSortKey(sortKeyArray[n].attributeName, sortKeyArray[n].reverse);
                    ++n;
                }
                arrayList.add(new LDAPSortControl(lDAPSortKeyArray, false));
                if (nArray != null) {
                    if (searchControl.getVLVJumpTo() == null) {
                        arrayList.add(new LDAPVirtualListControl(nArray[0], nArray[1], nArray[2], 0));
                    } else {
                        arrayList.add(new LDAPVirtualListControl(searchControl.getVLVJumpTo(), nArray[1], nArray[2]));
                    }
                }
            }
            LDAPSearchConstraints lDAPSearchConstraints = lDAPConnection.getSearchConstraints();
            LDAPControl[] lDAPControlArray = lDAPSearchConstraints.getServerControls();
            int n = 0;
            while (n < lDAPControlArray.length) {
                arrayList.add(lDAPControlArray[n]);
                ++n;
            }
            lDAPSearchConstraints.setBatchSize(1);
            lDAPSearchConstraints.setMaxResults(searchControl.getMaxResults());
            lDAPSearchConstraints.setServerTimeLimit(searchControl.getTimeOut());
            if (sortKeyArray != null) {
                lDAPSearchConstraints.setServerControls(arrayList.toArray(new LDAPControl[0]));
            }
            searchControl.set("constraints", lDAPSearchConstraints);
        }
        return lDAPConnection;
    }

    public SearchResults search(Principal principal, Guid guid, int n, String string, String[] stringArray, boolean bl, SearchControl searchControl) throws InvalidSearchFilterException, UMSException {
        LDAPConnection lDAPConnection = null;
        String string2 = guid.getDn();
        String[] stringArray2 = null;
        if (stringArray != null) {
            stringArray2 = new String[stringArray.length + 1];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray2[stringArray2.length - 1] = "objectclass";
        } else {
            stringArray2 = new String[]{"objectclass"};
        }
        LDAPSearchResults lDAPSearchResults = null;
        if (string == null) {
            string = "(objectclass=*)";
        }
        try {
            try {
                SortKey[] sortKeyArray;
                lDAPConnection = this.getSearchConnection(principal, searchControl);
                if (replicaRetryNum != 0) {
                    this.readLDAPEntry(lDAPConnection, string2, null);
                }
                int n2 = 0;
                while (n2 <= connNumRetry) {
                    if (debug.messageEnabled()) {
                        debug.message("DataLayer.search retry: " + n2);
                    }
                    try {
                        if (searchControl == null) {
                            lDAPSearchResults = lDAPConnection.search(string2, n, string, stringArray2, bl);
                            break;
                        }
                        lDAPSearchResults = lDAPConnection.search(string2, n, string, stringArray2, bl, (LDAPSearchConstraints)searchControl.get("constraints"));
                        break;
                    }
                    catch (LDAPException lDAPException) {
                        if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n2 == connNumRetry) {
                            throw lDAPException;
                        }
                        ++n2;
                        try {
                            Thread.currentThread();
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                SortKey[] sortKeyArray2 = new SearchResults(lDAPSearchResults, lDAPConnection, this);
                sortKeyArray2.set("baseID", string2);
                sortKeyArray2.set("searchFilter", string);
                sortKeyArray2.set("searchScope", new Integer(n));
                if (searchControl != null && (searchControl.contains("vlvRange") || searchControl.contains("vlvJumpTo"))) {
                    sortKeyArray2.set("expectVlvResponse", new Boolean(true));
                }
                if (searchControl != null && searchControl.contains("sortKeys") && (sortKeyArray = searchControl.getSortKeys()) != null && sortKeyArray.length > 0) {
                    sortKeyArray2.set("sortKeys", sortKeyArray);
                }
                sortKeyArray = sortKeyArray2;
                Object var17_20 = null;
                return sortKeyArray;
            }
            catch (LDAPException lDAPException) {
                this.releaseConnection(lDAPConnection);
                debug.error("Exception in DataLayer.search: ", (Throwable)lDAPException);
                String string3 = i18n.getString("ums-searchfailed");
                int n3 = lDAPException.getLDAPResultCode();
                switch (n3) {
                    case 3: {
                        int n4 = searchControl != null ? searchControl.getTimeOut() : 0;
                        throw new TimeLimitExceededException(String.valueOf(n4), lDAPException);
                    }
                    case 4: {
                        int n5 = searchControl != null ? searchControl.getMaxResults() : 0;
                        throw new SizeLimitExceededException(String.valueOf(n5), lDAPException);
                    }
                    case 2: 
                    case 89: {
                        throw new InvalidSearchFilterException(string, lDAPException);
                    }
                }
                throw new UMSException(string3, lDAPException);
            }
        }
        catch (Throwable throwable) {
            Object var17_21 = null;
            throw throwable;
        }
    }

    public SearchResults searchIDs(Principal principal, Guid guid, int n, String string, SearchControl searchControl) throws InvalidSearchFilterException, UMSException {
        String[] stringArray = new String[]{"objectclass"};
        return this.search(principal, guid, n, string, stringArray, false, searchControl);
    }

    public LDAPSchema getSchema(Principal principal) throws AccessRightsException, UMSException {
        LDAPConnection lDAPConnection = null;
        LDAPSchema lDAPSchema = new LDAPSchema();
        try {
            try {
                lDAPConnection = this.getConnection(principal);
                lDAPConnection.setProperty("com.netscape.ldap.schema.quoting", "standard");
                int n = 0;
                while (n <= connNumRetry) {
                    if (debug.messageEnabled()) {
                        debug.message("DataLayer.getSchema retry: " + n);
                    }
                    try {
                        if (n > 0) {
                            try {
                                lDAPConnection.read("fake=fake");
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        lDAPSchema.fetchSchema(lDAPConnection, "cn=schema");
                        LDAPSchema lDAPSchema2 = lDAPSchema;
                        Object var8_11 = null;
                        this.releaseConnection(lDAPConnection);
                        return lDAPSchema2;
                    }
                    catch (LDAPException lDAPException) {
                        if (!retryErrorCodes.contains("" + lDAPException.getLDAPResultCode()) || n == connNumRetry) {
                            throw lDAPException;
                        }
                        ++n;
                        try {
                            Thread.currentThread();
                            Thread.sleep(connRetryInterval);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (LDAPException lDAPException) {
                debug.error("Exception in DataLayer.getSchema: ", (Throwable)lDAPException);
                int n = lDAPException.getLDAPResultCode();
                switch (n) {
                    case 50: {
                        throw new AccessRightsException(this.m_host, lDAPException);
                    }
                }
                throw new UMSException(this.m_host, lDAPException);
            }
        }
        catch (Throwable throwable) {
            Object var8_13 = null;
            this.releaseConnection(lDAPConnection);
            throw throwable;
        }
        Object var8_12 = null;
        this.releaseConnection(lDAPConnection);
        return lDAPSchema;
    }

    public void addSchema(Principal principal, LDAPSchemaElement lDAPSchemaElement) throws AccessRightsException, SchemaElementAlreadyExistsException, UMSException {
        LDAPConnection lDAPConnection = null;
        try {
            try {
                lDAPConnection = this.getConnection(principal);
                lDAPConnection.setProperty("com.netscape.ldap.schema.quoting", "standard");
                lDAPSchemaElement.add(lDAPConnection, "cn=schema");
            }
            catch (LDAPException lDAPException) {
                debug.error("Exception in DataLayer.addSchema: ", (Throwable)lDAPException);
                int n = lDAPException.getLDAPResultCode();
                switch (n) {
                    case 20: {
                        throw new SchemaElementAlreadyExistsException(lDAPSchemaElement.getName(), lDAPException);
                    }
                    case 50: {
                        throw new AccessRightsException(lDAPSchemaElement.getName(), lDAPException);
                    }
                }
                throw new UMSException(lDAPSchemaElement.getName(), lDAPException);
            }
            Object var7_4 = null;
            this.releaseConnection(lDAPConnection);
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this.releaseConnection(lDAPConnection);
            throw throwable;
        }
    }

    public void removeSchema(Principal principal, LDAPSchemaElement lDAPSchemaElement) throws AccessRightsException, UMSException {
        LDAPConnection lDAPConnection = null;
        try {
            try {
                lDAPConnection = this.getConnection(principal);
                lDAPConnection.setProperty("com.netscape.ldap.schema.quoting", "standard");
                lDAPSchemaElement.remove(lDAPConnection, "cn=schema");
            }
            catch (LDAPException lDAPException) {
                debug.error("Exception in DataLayer.removeSchema:", (Throwable)lDAPException);
                int n = lDAPException.getLDAPResultCode();
                switch (n) {
                    case 50: {
                        throw new AccessRightsException(lDAPSchemaElement.getName(), lDAPException);
                    }
                }
                throw new UMSException(lDAPSchemaElement.getName(), lDAPException);
            }
            Object var7_4 = null;
            this.releaseConnection(lDAPConnection);
        }
        catch (Throwable throwable) {
            Object var7_5 = null;
            this.releaseConnection(lDAPConnection);
            throw throwable;
        }
    }

    private void initReplicaProperties() {
        String string;
        String string2 = SystemProperties.get((String)"com.iplanet.am.replica.num.retries");
        if (string2 != null) {
            try {
                replicaRetryNum = Integer.parseInt(string2);
                if (replicaRetryNum < 0) {
                    replicaRetryNum = 0;
                    debug.warning("Invalid value for replica retry num, set to 0");
                }
            }
            catch (NumberFormatException numberFormatException) {
                debug.warning("Invalid value for replica retry num");
            }
        }
        if ((string = SystemProperties.get((String)"com.iplanet.am.replica.delay.between.retries")) != null) {
            try {
                replicaRetryInterval = Long.parseLong(string);
                if (replicaRetryInterval < 0L) {
                    replicaRetryInterval = 0L;
                    debug.warning("Invalid value for replica interval, set to 0");
                }
            }
            catch (NumberFormatException numberFormatException) {
                debug.warning("Invalid value for replica interval");
            }
        }
    }

    public LDAPEntry readLDAPEntry(LDAPConnection lDAPConnection, String string, String[] stringArray) throws LDAPException {
        LDAPException lDAPException = null;
        int n = 0;
        int n2 = 0;
        while (n <= replicaRetryNum && n2 <= connNumRetry) {
            if (debug.messageEnabled()) {
                debug.message("DataLayer.readLDAPEntry: connRetry: " + n2);
                debug.message("DataLayer.readLDAPEntry: retry: " + n);
            }
            try {
                if (stringArray == null) {
                    return lDAPConnection.read(string);
                }
                return lDAPConnection.read(string, stringArray);
            }
            catch (LDAPException lDAPException2) {
                int n3 = lDAPException2.getLDAPResultCode();
                if (n3 == 32) {
                    if (debug.messageEnabled()) {
                        debug.message("Replica: entry not found: " + string + " retry: " + n);
                    }
                    if (n == replicaRetryNum) {
                        lDAPException = lDAPException2;
                    } else {
                        try {
                            Thread.sleep(replicaRetryInterval);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++n;
                    continue;
                }
                if (retryErrorCodes.contains("" + n3)) {
                    if (n2 == connNumRetry) {
                        lDAPException = lDAPException2;
                    } else {
                        try {
                            Thread.sleep(connRetryInterval);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++n2;
                    continue;
                }
                throw lDAPException2;
            }
        }
        throw lDAPException;
    }

    private synchronized void initLdapPool() {
        if (_ldapPool != null) {
            return;
        }
        ServerInstance serverInstance = null;
        try {
            DSConfigMgr dSConfigMgr = DSConfigMgr.getDSConfigMgr();
            _trialConn = dSConfigMgr.getNewProxyConnection();
            serverInstance = dSConfigMgr.getServerInstance(LDAPUser.Type.AUTH_PROXY);
            if (serverInstance == null) {
                debug.error("Error getting server config.");
            }
        }
        catch (LDAPServiceException lDAPServiceException) {
            debug.error("Error initializing connection pool " + lDAPServiceException.getMessage());
            lDAPServiceException.printStackTrace();
        }
        int n = serverInstance.getMinConnections();
        int n2 = serverInstance.getMaxConnections();
        int n3 = serverInstance.getIntValue(LDAP_MAXBACKLOG, 100);
        this.m_releaseConnectionBeforeSearchCompletes = serverInstance.getBooleanValue(LDAP_RELEASECONNBEFORESEARCH, false);
        boolean bl = serverInstance.getBooleanValue(LDAP_REFERRAL, true);
        if (debug.messageEnabled()) {
            debug.message("Creating ldap connection pool with :");
            debug.message("poolMin : " + n);
            debug.message("poolMax : " + n2);
            debug.message("maxBackLog : " + n3);
        }
        try {
            _trialConn.setOption(30, new Integer(n3));
            _trialConn.setOption(8, new Boolean(bl));
            LDAPBind lDAPBind = new LDAPBind(){

                public void bind(LDAPConnection lDAPConnection) throws LDAPException {
                    String string = _trialConn.getAuthenticationDN();
                    String string2 = _trialConn.getAuthenticationPassword();
                    String string3 = lDAPConnection.getHost();
                    int n = lDAPConnection.getPort();
                    lDAPConnection.connect(3, string3, n, string, string2);
                }
            };
            _trialConn.setOption(13, lDAPBind);
            _defaultSearchConstraints = _trialConn.getSearchConstraints();
            _ldapPool = new ConnectionPool(n, n2, _trialConn);
        }
        catch (LDAPException lDAPException) {
            debug.error("Exception in DataLayer.initLdapPool:", (Throwable)lDAPException);
            lDAPException.printStackTrace();
        }
    }

    public static int getConnNumRetry() {
        return connNumRetry;
    }

    public static int getConnRetryInterval() {
        return connRetryInterval;
    }

    public static HashSet getRetryErrorCodes() {
        return retryErrorCodes;
    }

    static {
        String string;
        block10: {
            String string2;
            block9: {
                i18n = I18n.getInstance((String)"amSDK");
                replicaRetryNum = 1;
                replicaRetryInterval = 1000L;
                connNumRetry = 3;
                connRetryInterval = 1000;
                retryErrorCodes = new HashSet();
                debug = Debug.getInstance((String)"amSDK");
                String string3 = SystemProperties.get((String)LDAP_CONNECTION_NUM_RETRIES);
                if (string3 != null) {
                    try {
                        connNumRetry = Integer.parseInt(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (!debug.warningEnabled()) break block9;
                        debug.warning("Invalid value for com.iplanet.am.ldap.connection.num.retries");
                    }
                }
            }
            if ((string2 = SystemProperties.get((String)LDAP_CONNECTION_RETRY_INTERVAL)) != null) {
                try {
                    connRetryInterval = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!debug.warningEnabled()) break block10;
                    debug.warning("Invalid value for com.iplanet.am.ldap.connection.delay.between.retries");
                }
            }
        }
        if ((string = SystemProperties.get((String)LDAP_CONNECTION_ERROR_CODES)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                retryErrorCodes.add(stringTokenizer.nextToken().trim());
            }
        }
        if (debug.messageEnabled()) {
            debug.message("DataLayer: number of retry = " + connNumRetry);
            debug.message("DataLayer: retry interval = " + connRetryInterval);
            debug.message("DataLayer: retry error codes = " + retryErrorCodes);
        }
        _ldapPool = null;
        _trialConn = null;
        _defaultSearchConstraints = null;
        m_instance = null;
        EMPTY_STRING_ARRAY = new String[0];
    }
}

