/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ums;

import com.iplanet.am.util.Debug;
import com.iplanet.services.ldap.Attr;
import com.iplanet.services.ldap.AttrSet;
import com.iplanet.services.ldap.ModSet;
import com.iplanet.services.ldap.aci.ACI;
import com.iplanet.services.ldap.aci.ACIParseException;
import com.iplanet.services.ldap.aci.QualifiedCollection;
import com.iplanet.services.util.I18n;
import com.iplanet.ums.AccessRightObject;
import com.iplanet.ums.CreationTemplate;
import com.iplanet.ums.IRole;
import com.iplanet.ums.PersistentObject;
import com.iplanet.ums.TemplateManager;
import com.iplanet.ums.UMSException;
import com.iplanet.ums.cos.COSManager;
import com.iplanet.ums.cos.COSNotFoundException;
import com.iplanet.ums.cos.COSTemplate;
import com.iplanet.ums.cos.DirectCOSDefinition;
import java.security.Principal;
import java.util.HashSet;
import java.util.Iterator;

public abstract class BaseRole
extends PersistentObject
implements IRole {
    private static I18n i18n = I18n.getInstance((String)"amSDK");
    private static Debug debug = Debug.getInstance((String)"amSDK");
    private static final String COS_PKG = "com.iplanet.ums.cos.cosrc";
    private static final String COS_PREFIX = "cos";
    private static COSManager _cm = null;
    private static TemplateManager _tempMgr = null;
    private static CreationTemplate _basicCOSTemplate = null;
    private static final String _COSATTRTYPE = " operational";
    private PersistentObject parentObject = null;
    private static final String READ_PERM_STRING = "read";
    private static final String READ_PERM_HEADER = "Read permission for ";
    private static final String WRITE_PERM_STRING = "write";
    private static final String WRITE_PERM_HEADER = "Write permission for ";

    protected BaseRole() {
    }

    BaseRole(Principal principal, String string) throws UMSException {
    }

    public BaseRole(CreationTemplate creationTemplate, AttrSet attrSet) throws UMSException {
        super(creationTemplate, attrSet);
    }

    public boolean hasMember(PersistentObject persistentObject) throws UMSException {
        boolean bl = false;
        Attr attr = persistentObject.getAttribute("nsRole");
        if (attr != null && (attr.contains(this.getGuid().getDn()) || attr.contains(this.getGuid().getDn().toLowerCase()))) {
            bl = true;
        }
        return bl;
    }

    private void newRoleDefault(String string, AttrSet attrSet) throws UMSException {
        DirectCOSDefinition directCOSDefinition = null;
        try {
            debug.message("BaseRole.newRoleDefault : before got cosdefinition");
            directCOSDefinition = this.getRoleDefaultCOSDefinition(string);
            debug.message("BaseRole.newRoleDefault : got cos definition");
        }
        catch (COSNotFoundException cOSNotFoundException) {
            directCOSDefinition = this.createRoleDefaultCOSDefinition(string, attrSet);
            debug.message("BaseRole.newRoleDefault : cos definition created");
        }
        debug.message("BaseRole.newRoleDefault : before remove cos template");
        try {
            directCOSDefinition.removeCOSTemplate("\"" + this.getGuid().getDn() + "\"");
        }
        catch (Exception exception) {
            // empty catch block
        }
        debug.message("BaseRole.newRoleDefault : After remove cos template");
        if (_cm == null) {
            _cm = this.getCOSManager();
        }
        debug.message("BaseRole.newRoleDefault : before add cos template");
        directCOSDefinition.addCOSTemplate(this.newCOSTemplate(string, attrSet));
        debug.message("BaseRole.newRoleDefault : after add cos template");
    }

    private void modRoleDefault(String string, AttrSet attrSet, int n) throws COSNotFoundException, UMSException {
        COSTemplate cOSTemplate;
        DirectCOSDefinition directCOSDefinition;
        try {
            directCOSDefinition = this.getRoleDefaultCOSDefinition(string);
        }
        catch (COSNotFoundException cOSNotFoundException) {
            debug.error("BaseRole.modRoleDefault : no cos definition");
            this.newRoleDefault(string, attrSet);
            return;
        }
        debug.message("BaseRole.modRoleDefault : got cos definition");
        if (n != 1) {
            debug.message("BaseRole.modRoleDefault : before append");
            this.appendCOSAttribute(directCOSDefinition, attrSet);
            debug.message("BaseRole.modRoleDefault : after append");
        }
        try {
            cOSTemplate = directCOSDefinition.getCOSTemplate("\"" + this.getGuid().getDn() + "\"");
        }
        catch (COSNotFoundException cOSNotFoundException) {
            debug.error("BaseRole.modRoleDefault : no cos template");
            COSTemplate cOSTemplate2 = this.newCOSTemplate(string, attrSet);
            directCOSDefinition.addCOSTemplate(cOSTemplate2);
            return;
        }
        debug.message("BaseRole.modRoleDefault : got cos template");
        ModSet modSet = new ModSet(attrSet, n);
        cOSTemplate.modify(modSet);
        cOSTemplate.save();
        debug.message("BaseRole.modRoleDefault : cos template saved");
    }

    private AttrSet getRoleDefault(String string) throws COSNotFoundException, UMSException {
        DirectCOSDefinition directCOSDefinition = this.getRoleDefaultCOSDefinition(string);
        COSTemplate cOSTemplate = directCOSDefinition.getCOSTemplate("\"" + this.getGuid().getDn() + "\"");
        return this.getAttrSet(cOSTemplate);
    }

    public AccessRightObject getAccessRight() throws UMSException, ACIParseException {
        Iterator iterator;
        QualifiedCollection qualifiedCollection = null;
        QualifiedCollection qualifiedCollection2 = null;
        if (this.parentObject == null) {
            this.parentObject = this.getParentObject();
        }
        if ((iterator = this.parentObject.getACI().iterator()) != null) {
            String string = this.getGuid().getDn().trim();
            while (iterator.hasNext()) {
                String string2;
                ACI aCI = (ACI)iterator.next();
                if (debug.messageEnabled()) {
                    debug.message("BaseRole.getAccessRight ACI.toString =" + aCI.toString());
                }
                if ((string2 = aCI.getName()).equalsIgnoreCase(READ_PERM_HEADER + string)) {
                    qualifiedCollection = aCI.getTargetAttributes();
                    if (qualifiedCollection2 == null) continue;
                    break;
                }
                if (!string2.equalsIgnoreCase(WRITE_PERM_HEADER + string)) continue;
                qualifiedCollection2 = aCI.getTargetAttributes();
                if (qualifiedCollection != null) break;
            }
        }
        if (qualifiedCollection == null) {
            if (qualifiedCollection2 == null) {
                return new AccessRightObject(null, null);
            }
            return new AccessRightObject(null, qualifiedCollection2.getCollection());
        }
        if (qualifiedCollection2 == null) {
            return new AccessRightObject(qualifiedCollection.getCollection(), null);
        }
        return new AccessRightObject(qualifiedCollection.getCollection(), qualifiedCollection2.getCollection());
    }

    public void newAccessRight(AccessRightObject accessRightObject) throws UMSException, ACIParseException {
        Attr attr;
        QualifiedCollection qualifiedCollection;
        HashSet<String> hashSet;
        Object object;
        Object object2;
        Iterator iterator;
        ACI aCI = null;
        Object object3 = null;
        if (this.parentObject == null) {
            this.parentObject = this.getParentObject();
        }
        if ((iterator = this.parentObject.getACI().iterator()) != null) {
            object2 = this.getGuid().getDn().trim();
            while (iterator.hasNext()) {
                object = (ACI)iterator.next();
                if (debug.messageEnabled()) {
                    debug.message("BaseRole.newAccessRight ACI.toString =" + ((ACI)object).toString());
                }
                if (((String)((Object)(hashSet = ((ACI)object).getName()))).equals(READ_PERM_HEADER + (String)object2)) {
                    aCI = object;
                    if (object3 == null) continue;
                    break;
                }
                if (!((String)((Object)hashSet)).equals(WRITE_PERM_HEADER + (String)object2)) continue;
                object3 = object;
                if (aCI != null) break;
            }
        }
        if (aCI != null) {
            debug.message("modify existing read aci");
            object2 = new Attr("aci", aCI.getACIText());
            if (debug.messageEnabled()) {
                debug.message("readaci.ACIText :" + aCI.getACIText());
            }
            this.parentObject.modify((Attr)object2, 1);
            object = ACI.valueOf(aCI.toString());
            hashSet = new QualifiedCollection(accessRightObject.getReadableAttributeNames(), false);
            ((ACI)object).setTargetAttributes((QualifiedCollection)((Object)hashSet));
            object2 = new Attr("aci", ((ACI)object).toString());
            this.parentObject.modify((Attr)object2, 0);
        } else {
            debug.message("new read aci");
            object2 = new ACI(READ_PERM_HEADER + this.getGuid().getDn());
            ((ACI)object2).setName(READ_PERM_HEADER + this.getGuid().getDn());
            object = new QualifiedCollection(accessRightObject.getReadableAttributeNames(), false);
            ((ACI)object2).setTargetAttributes((QualifiedCollection)object);
            hashSet = new HashSet<String>();
            hashSet.add(READ_PERM_STRING);
            qualifiedCollection = new QualifiedCollection(hashSet, false);
            ((ACI)object2).setPermissions(qualifiedCollection);
            hashSet = new HashSet();
            hashSet.add(this.getGuid().getDn());
            ((ACI)object2).setRoles(hashSet);
            attr = new Attr("aci", ((ACI)object2).toString());
            if (debug.messageEnabled()) {
                debug.message("READ " + this.getGuid().getDn() + "=" + ((ACI)object2).toString());
            }
            this.parentObject.modify(attr, 0);
        }
        if (object3 != null) {
            debug.message("modify existing write aci");
            object2 = new Attr("aci", ((ACI)object3).getACIText());
            if (debug.messageEnabled()) {
                debug.message("writeaci.ACIText :" + ((ACI)object3).getACIText());
            }
            this.parentObject.modify((Attr)object2, 1);
            object = ACI.valueOf(((ACI)object3).toString());
            hashSet = new QualifiedCollection(accessRightObject.getWritableAttributeNames(), false);
            ((ACI)object).setTargetAttributes((QualifiedCollection)((Object)hashSet));
            object2 = new Attr("aci", ((ACI)object).toString());
            this.parentObject.modify((Attr)object2, 0);
        } else {
            debug.message("new write aci");
            object2 = new ACI(WRITE_PERM_HEADER + this.getGuid().getDn());
            ((ACI)object2).setName(WRITE_PERM_HEADER + this.getGuid().getDn());
            object = new QualifiedCollection(accessRightObject.getWritableAttributeNames(), false);
            ((ACI)object2).setTargetAttributes((QualifiedCollection)object);
            hashSet = new HashSet<String>();
            hashSet.add(WRITE_PERM_STRING);
            qualifiedCollection = new QualifiedCollection(hashSet, false);
            ((ACI)object2).setPermissions(qualifiedCollection);
            hashSet = new HashSet();
            hashSet.add(this.getGuid().getDn());
            ((ACI)object2).setRoles(hashSet);
            attr = new Attr("aci", ((ACI)object2).toString());
            if (debug.messageEnabled()) {
                debug.message("Write " + this.getGuid().getDn() + "=" + ((ACI)object2).toString());
            }
            this.parentObject.modify(attr, 0);
        }
        this.parentObject.save();
    }

    private AttrSet getAttrSet(COSTemplate cOSTemplate) {
        debug.message("BaseRole.getAttrSet : inside");
        String[] stringArray = cOSTemplate.getAttributeNames();
        AttrSet attrSet = new AttrSet();
        int n = 0;
        while (n < stringArray.length) {
            String string;
            if (debug.messageEnabled()) {
                debug.message("BaseRole.getAttrSet : process " + stringArray[n]);
            }
            if (!((string = stringArray[n].toLowerCase()).equals("cn") || string.equals("objectclass") || string.equals("cospriority"))) {
                if (debug.messageEnabled()) {
                    debug.message("BaseRole.getAttrSet : add " + stringArray[n]);
                }
                attrSet.add(cOSTemplate.getAttribute(stringArray[n]));
            }
            ++n;
        }
        if (debug.messageEnabled()) {
            debug.message("BaseRole.getAttrSet : before return");
        }
        return attrSet;
    }

    private DirectCOSDefinition getRoleDefaultCOSDefinition(String string) throws COSNotFoundException, UMSException {
        if (this.getGuid() == null) {
            throw new UMSException(i18n.getString("ums-badguid"));
        }
        if (_cm == null) {
            _cm = this.getCOSManager();
        }
        return (DirectCOSDefinition)_cm.getDefinition(string);
    }

    private COSManager getCOSManager() throws UMSException {
        return COSManager.getCOSManager(this.getPrincipal(), this.getParentGuid());
    }

    private DirectCOSDefinition createRoleDefaultCOSDefinition(String string, AttrSet attrSet) throws UMSException {
        if (_cm == null) {
            _cm = this.getCOSManager();
        }
        DirectCOSDefinition directCOSDefinition = this.newCOSDefinition(string, attrSet);
        _cm.addDefinition(directCOSDefinition);
        return directCOSDefinition;
    }

    private void appendCOSAttribute(DirectCOSDefinition directCOSDefinition, AttrSet attrSet) throws UMSException {
        boolean bl = false;
        Attr attr = directCOSDefinition.getAttribute("cosAttribute");
        if (attr == null) {
            attr = new Attr("cosAttribute");
        }
        if (debug.messageEnabled()) {
            debug.message("BaseRole.appendCOSAttribute : got " + attr);
        }
        String[] stringArray = attrSet.getAttributeNames();
        int n = 0;
        while (n < stringArray.length) {
            String string;
            String string2;
            if (debug.messageEnabled()) {
                debug.message("BaseRole.appendCOSAttribute : process " + stringArray[n]);
            }
            if (!attr.contains(string2 = (string = stringArray[n] + _COSATTRTYPE).toLowerCase())) {
                attr.addValue(string2);
                if (debug.messageEnabled()) {
                    debug.message("BaseRole.appendCOSAttribute : added value " + string2);
                }
                bl = true;
            }
            ++n;
        }
        if (debug.messageEnabled()) {
            debug.message("BaseRole.appendCOSAttribute : final=" + attr);
        }
        if (bl) {
            directCOSDefinition.modify(attr, 2);
            directCOSDefinition.save();
        }
    }

    private DirectCOSDefinition newCOSDefinition(String string, AttrSet attrSet) throws UMSException {
        AttrSet attrSet2 = new AttrSet();
        Attr attr = new Attr("cn", string);
        attrSet2.add(attr);
        attr = new Attr("cosSpecifier", "nsrole");
        attrSet2.add(attr);
        String[] stringArray = attrSet.getAttributeNames();
        attr = new Attr("cosAttribute");
        int n = 0;
        while (n < stringArray.length) {
            attr.addValue(stringArray[n] + _COSATTRTYPE);
            ++n;
        }
        attrSet2.add(attr);
        return new DirectCOSDefinition(attrSet2);
    }

    private COSTemplate newCOSTemplate(String string, AttrSet attrSet) throws UMSException {
        if (_tempMgr == null) {
            _tempMgr = TemplateManager.getTemplateManager();
            _basicCOSTemplate = _tempMgr.getCreationTemplate("BasicCOSTemplate", null);
        }
        AttrSet attrSet2 = (AttrSet)_basicCOSTemplate.getRequiredAttributeSet().clone();
        AttrSet attrSet3 = null;
        if (_basicCOSTemplate.getOptionalAttributeSet() != null) {
            attrSet3 = (AttrSet)_basicCOSTemplate.getOptionalAttributeSet().clone();
        }
        attrSet2.add(new Attr("objectclass", "extensibleObject"));
        if (debug.messageEnabled()) {
            debug.message("BaseRole.newCOSTemplate: Required " + attrSet2.toString());
            if (attrSet3 != null) {
                debug.message("BaseRole.newCOSTemplate: Optional " + attrSet3.toString());
            }
        }
        CreationTemplate creationTemplate = new CreationTemplate("COSTemplate", attrSet2, attrSet3);
        COSTemplate cOSTemplate = new COSTemplate(creationTemplate, "\"" + this.getGuid().getDn() + "\"");
        if (debug.messageEnabled()) {
            debug.message("BaseRole.newCOSTemplate : after new COSTemplate " + this.getGuid().getDn());
        }
        int n = attrSet.size();
        int n2 = 0;
        while (n2 < n) {
            Attr attr = attrSet.elementAt(n2);
            cOSTemplate.modify(attr, 0);
            if (debug.messageEnabled()) {
                debug.message("BaseRole.newCOSTemplate : adding template attribute : " + attr.getName() + "=" + attr.getValue());
            }
            ++n2;
        }
        debug.message("BaseRole.newCOSTemplate : before return");
        return cOSTemplate;
    }
}

