/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap.aci;

import com.iplanet.services.ldap.aci.ACI;
import com.iplanet.services.ldap.aci.ACIParseException;
import com.iplanet.services.ldap.aci.ACITargetExpression;
import com.iplanet.services.ldap.aci.ACR;
import com.iplanet.services.ldap.aci.ACRParser;
import com.iplanet.services.ldap.aci.QualifiedCollection;
import java.util.ArrayList;
import java.util.Collection;

class ACIParser {
    ACIParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static ACI parseACI(String string) throws ACIParseException {
        ACI aCI = new ACI();
        aCI.setACIText(string);
        if (string == null) {
            throw new ACIParseException("Malformed aci");
        }
        string = string.trim();
        int n = string.length();
        if (string.equals("")) {
            throw new ACIParseException("Malformed aci:aci is blank");
        }
        if (string.charAt(0) != '(' || string.charAt(n - 1) != ')') {
            throw new ACIParseException("Malformed aci: aci not enclosed in parenthesis");
        }
        ArrayList arrayList = ACIParser.getSubExpressions(string);
        if (arrayList.size() > 5) {
            throw new ACIParseException("Malformed aci: more than 5 toplevel subexpressions");
        }
        int n2 = 0;
        while (n2 < arrayList.size()) {
            Object object;
            String string2 = (String)arrayList.get(n2);
            if (string2.length() < 6) {
                throw new ACIParseException("Malformed aci:too short to be valid");
            }
            String string3 = string2.substring(1).toLowerCase().trim();
            if (string3.indexOf("target") == 0) {
                object = ACITargetExpression.valueOf(string2);
                if (((ACITargetExpression)object).getKeyword().equals("target")) {
                    if (!((ACITargetExpression)object).getOperator().equals("=")) throw new ACIParseException("Unsupported operator for : target");
                    aCI.setTarget(((ACITargetExpression)object).getValue());
                } else if (((ACITargetExpression)object).getKeyword().equals("targetfilter")) {
                    if (!((ACITargetExpression)object).getOperator().equals("=")) throw new ACIParseException("Unsupported operator for : targetfilter");
                    aCI.setTargetFilter(((ACITargetExpression)object).getValue());
                } else if (((ACITargetExpression)object).getKeyword().equals("targetattrfilters")) {
                    if (!((ACITargetExpression)object).getOperator().equals("=")) throw new ACIParseException("Unsupported operator for : targetattrfilters");
                    aCI.setTargetAttrFilters(((ACITargetExpression)object).getValue());
                } else {
                    if (!((ACITargetExpression)object).getKeyword().equals("targetattr")) throw new ACIParseException("Unsupported keyword : " + ((ACITargetExpression)object).getKeyword());
                    boolean bl = false;
                    QualifiedCollection qualifiedCollection = null;
                    Collection collection = null;
                    if (((ACITargetExpression)object).getOperator().equals("=")) {
                        bl = false;
                        collection = ACIParser.getTokens(((ACITargetExpression)object).getValue(), "||");
                        qualifiedCollection = new QualifiedCollection(collection, bl);
                        aCI.setTargetAttributes(qualifiedCollection);
                    } else {
                        if (!((ACITargetExpression)object).getOperator().equals("!=")) throw new ACIParseException("Unsupported operator for : targetattr");
                        bl = true;
                        collection = ACIParser.getTokens(((ACITargetExpression)object).getValue(), "||");
                        qualifiedCollection = new QualifiedCollection(collection, bl);
                        aCI.setTargetAttributes(qualifiedCollection);
                    }
                }
            } else {
                if (string3.indexOf("version") != 0) throw new ACIParseException("Malformed aci:invalid toplevel subexpression");
                object = ACRParser.parse(string2);
                aCI.setACR((ACR)object);
            }
            ++n2;
        }
        if (aCI.getPermissions() != null) return aCI;
        throw new ACIParseException("permissions not defined");
    }

    static ArrayList getSubExpressions(String string) throws ACIParseException {
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = (string = string.trim()).length();
        if (n <= 0) {
            return arrayList;
        }
        if (string.charAt(0) != '(' || string.charAt(n - 1) != ')') {
            throw new ACIParseException("Unmatched parenthesis");
        }
        boolean bl = false;
        int n2 = 0;
        boolean bl2 = false;
        int n3 = 0;
        while (n3 < n) {
            if (string.charAt(n3) == '\"') {
                bl = !bl;
            } else if (!bl && string.charAt(n3) == '(') {
                ++n2;
            } else if (!bl && string.charAt(n3) == ')') {
                --n2;
            }
            if (n2 == 0) break;
            ++n3;
        }
        if (n2 != 0) {
            throw new ACIParseException("Unmatched \" or parenthesis ");
        }
        arrayList.add(string.substring(0, n3 + 1));
        if (n3 + 1 < n) {
            arrayList.addAll(ACIParser.getSubExpressions(string.substring(n3 + 1)));
        }
        return arrayList;
    }

    static Collection getTokens(String string, String string2) {
        int n = 0;
        int n2 = 0;
        int n3 = string2.length();
        ArrayList<String> arrayList = new ArrayList<String>();
        while ((n = string.indexOf(string2, n2)) != -1) {
            arrayList.add(string.substring(n2, n).trim());
            n2 = n + n3;
        }
        arrayList.add(string.substring(n2));
        return arrayList;
    }
}

