/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.services.ldap;

import com.iplanet.services.ldap.DSConfigMgr;
import com.iplanet.services.util.ParseOutput;
import com.iplanet.services.util.XMLException;
import java.util.Hashtable;
import java.util.Vector;

public class Server
implements ParseOutput {
    int serverPort;
    String serverName;
    String serverID;
    Type connType;
    boolean serverStatus = true;

    public int getPort() {
        return this.serverPort;
    }

    public String getServerName() {
        return this.serverName;
    }

    public Type getConnectionType() {
        return this.connType;
    }

    public String getServerID() {
        return this.serverID;
    }

    public void process(String string, Vector vector, Hashtable hashtable, String string2) throws XMLException {
        if (DSConfigMgr.debugger.messageEnabled()) {
            DSConfigMgr.debugger.message("in Server.process()");
        }
        if (string.equals("Server")) {
            this.serverID = (String)hashtable.get("name");
            this.serverName = (String)hashtable.get("host");
            String string3 = (String)hashtable.get("type");
            String string4 = (String)hashtable.get("port");
            if (string3 == null) {
                string3 = "SIMPLE";
            }
            this.connType = string3.equalsIgnoreCase("SSL") ? Type.CONN_SSL : Type.CONN_SIMPLE;
            try {
                this.serverPort = Integer.parseInt(string4);
            }
            catch (NumberFormatException numberFormatException) {
                this.serverPort = 389;
            }
        } else {
            throw new XMLException(DSConfigMgr.getString("dscfg-dirserver_node_expected"));
        }
    }

    void setActiveStatus(boolean bl) {
        this.serverStatus = bl;
    }

    public boolean getActiveStatus() {
        return this.serverStatus;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Server Name=").append(this.serverName);
        stringBuffer.append(" Server Port=").append(this.serverPort);
        stringBuffer.append(" Status=").append(this.serverStatus);
        return new String(stringBuffer);
    }

    public static class Type {
        int type = -1;
        public static final Type CONN_SIMPLE = new Type(0);
        public static final Type CONN_SSL = new Type(1);

        private Type(int n) {
            this.type = n;
        }

        public boolean equals(Type type) {
            return this.type == type.type;
        }

        public String toString() {
            if (this.equals(CONN_SIMPLE)) {
                return "SIMPLE";
            }
            if (this.equals(CONN_SSL)) {
                return "SSL";
            }
            return "SIMPLE";
        }
    }
}

